/*
 * Decompiled with CFR 0.152.
 */
package Localisation;

import Localisation.DrawGText;
import Project.JDisplay;
import Project.JImage;
import java.io.InputStream;
import java.util.Vector;

public class TextComponent {
    private static final int NORMAL_CHARS_UNICODE_LIMIT = 126;
    private static final int SPACE_CHAR_UNICODE = 32;
    private static final int UNKNOWN_CHAR_UNICODE = 127;
    private static final int MAX_CHAR_UNICODE = 255;
    public static final int[][] FontNormalArray_X = new int[3][];
    public static final int[][] FontNormalArray_WIDTH = new int[3][];
    public static final int[] FontNormalArray_HEIGHT = new int[3];
    public static final int[][] FontSpecialArray_X = new int[3][];
    public static final int[][] FontSpecialArray_WIDTH = new int[3][];
    public static final int[] FontSpecialArray_HEIGHT = new int[3];
    public static final int[] FontLine_SPACE = new int[3];
    public static JImage[] pJFontStripNormal = null;
    public static JImage[] pJFontStripSpecial = null;
    public DrawGText Defaultvalue;
    public static final int LEFT_ALIGNED = 1;
    public static final int RIGHT_ALIGNED = 2;
    public static final int CENTER_ALIGNED = 4;
    public static final int MIDDLE_ALIGNED = 8;
    public static final int LINE_SCROLLING = 0;
    public static final int PAGE_SCROLLING = 1;
    public static final int SCROLLING_OFF = 2;
    public int Scrolling = 2;
    public int FontIndex = 0;
    public int mActivePalleteIndex;
    public static final byte FIRST_PALLETE_INDEX = 0;
    public static final byte SECOND_PALLETE_INDEX = 1;
    public static final byte THIRD_PALLETE_INDEX = 2;
    public boolean TextUpKeyPressed = false;
    public boolean TextDownKeyPressed = false;
    public int Char_Space = 0;
    private int StartPos = 0;
    private int EndPos = 0;
    private int nRectLine = 0;
    private int lineScroll = 0;
    public int nTextLines = 0;
    public int NoOfPages = 0;
    public int CurrentLineNo = 0;
    public int CurrentPageNo = 0;
    public int SPACE = 5;
    public Vector StringTextArray = new Vector();
    public static String[] TextDisplay;
    public boolean Fill_BorderBoxRect;
    public static char ascii1;
    public static char ascii2;

    public TextComponent() {
        TextComponent.FontNormalArray_X[0] = new int[]{0, 2, 8, 14, 19, 26, 33, 36, 40, 44, 50, 56, 59, 64, 66, 72, 77, 79, 84, 89, 94, 99, 104, 109, 114, 119, 122, 124, 129, 134, 139, 144, 151, 157, 163, 169, 175, 181, 187, 193, 199, 205, 210, 215, 220, 228, 234, 246, 240, 252, 258, 264, 270, 276, 282, 290, 296, 302, 308, 312, 318, 322, 326, 331, 334, 339, 344, 349, 354, 359, 364, 369, 374, 376, 381, 386, 388, 396, 401, 406, 411, 416, 420, 425, 429, 434, 440, 448, 454, 460, 466, 471, 473, 478, 485};
        TextComponent.FontNormalArray_WIDTH[0] = new int[]{2, 6, 6, 5, 7, 7, 3, 4, 4, 6, 6, 3, 5, 2, 6, 5, 2, 5, 5, 5, 5, 5, 5, 5, 5, 3, 2, 5, 5, 5, 5, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 6, 6, 6, 4, 6, 4, 4, 5, 3, 5, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 2, 8, 5, 5, 5, 5, 4, 5, 4, 5, 6, 8, 6, 6, 6, 5, 2, 5, 7, 8};
        TextComponent.FontNormalArray_HEIGHT[0] = 12;
        TextComponent.FontSpecialArray_X[0] = new int[]{0, 15, 0, 0, 0, 24, 0, 567, 572, 577, 582, 587, 0, 495, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 506, 0, 0, 0, 0, 33, 0, 36, 0, 0, 0, 0, 0, 7, 0, 43, 516, 521, 526, 534, 51, 0, 0, 0, 0, 542, 547, 552, 557, 562, 0, 0, 0, 0, 55, 63, 70, 77, 84, 91, 98, 105, 112, 123, 130, 137, 144, 151, 158, 165, 172, 179, 186, 194, 201, 208, 215, 222, 229, 236, 243, 250, 257, 264, 271, 278, 285, 292, 299, 306, 313, 320, 327, 334, 341, 352, 359, 366, 373, 380, 387, 391, 395, 400, 405, 412, 419, 426, 433, 440, 447, 454, 460, 467, 474, 481, 488, 0, 0, 0};
        TextComponent.FontSpecialArray_WIDTH[0] = new int[]{6, 9, 6, 6, 6, 9, 6, 4, 4, 4, 4, 4, 6, 11, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 10, 6, 6, 6, 6, 3, 6, 7, 6, 6, 6, 6, 6, 8, 6, 8, 5, 5, 8, 8, 4, 6, 6, 6, 6, 4, 4, 4, 4, 4, 6, 6, 6, 6, 8, 7, 7, 7, 7, 7, 7, 7, 11, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 11, 7, 7, 7, 7, 7, 4, 4, 5, 5, 7, 7, 7, 7, 7, 7, 7, 6, 7, 7, 7, 7, 7, 6, 6, 7};
        TextComponent.FontSpecialArray_HEIGHT[0] = 12;
        TextComponent.FontLine_SPACE[0] = FontNormalArray_HEIGHT[0] + 1;
        TextComponent.FontNormalArray_X[1] = new int[]{0, 4, 11, 20, 28, 36, 45, 49, 55, 61, 69, 77, 81, 87, 91, 99, 107, 111, 119, 127, 135, 143, 151, 159, 167, 175, 179, 183, 190, 196, 203, 211, 220, 228, 236, 244, 252, 260, 268, 276, 284, 288, 296, 304, 312, 321, 330, 339, 347, 356, 364, 372, 380, 388, 397, 406, 415, 423, 432, 438, 446, 452, 457, 463, 467, 475, 483, 491, 499, 507, 515, 523, 531, 535, 543, 551, 559, 569, 577, 585, 593, 601, 608, 616, 622, 630, 638, 648, 656, 664, 672, 679, 683, 690, 698};
        TextComponent.FontNormalArray_WIDTH[1] = new int[]{4, 7, 9, 8, 8, 9, 4, 6, 6, 8, 8, 4, 6, 4, 8, 8, 4, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 7, 6, 7, 8, 9, 8, 8, 8, 8, 8, 8, 8, 8, 4, 8, 8, 8, 9, 9, 9, 8, 9, 8, 8, 8, 8, 9, 9, 9, 8, 9, 6, 8, 6, 5, 6, 4, 8, 8, 8, 8, 8, 8, 8, 8, 4, 8, 8, 8, 10, 8, 8, 8, 8, 7, 8, 6, 8, 8, 10, 8, 8, 8, 7, 4, 7, 8, 9};
        TextComponent.FontNormalArray_HEIGHT[1] = 12;
        TextComponent.FontSpecialArray_X[1] = new int[]{0, 17, 0, 0, 0, 27, 0, 639, 643, 647, 651, 655, 0, 566, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 578, 0, 0, 0, 0, 37, 0, 41, 0, 0, 0, 0, 0, 8, 0, 49, 589, 595, 601, 610, 58, 0, 0, 0, 0, 619, 623, 627, 631, 635, 0, 0, 0, 0, 63, 72, 80, 88, 96, 104, 112, 120, 128, 140, 148, 156, 164, 172, 180, 188, 196, 204, 212, 221, 229, 237, 245, 253, 261, 269, 277, 285, 293, 301, 309, 317, 325, 333, 341, 349, 357, 365, 373, 381, 389, 401, 409, 417, 425, 433, 441, 446, 451, 457, 463, 471, 479, 487, 495, 503, 511, 519, 526, 534, 542, 550, 558, 0, 0, 0};
        TextComponent.FontSpecialArray_WIDTH[1] = new int[]{8, 10, 8, 8, 8, 10, 8, 4, 4, 4, 4, 4, 8, 12, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 11, 8, 8, 8, 8, 4, 8, 8, 8, 8, 8, 8, 8, 9, 8, 9, 6, 6, 9, 9, 5, 8, 8, 8, 8, 4, 4, 4, 4, 4, 8, 8, 8, 8, 9, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 5, 5, 6, 6, 8, 8, 8, 8, 8, 8, 8, 7, 8, 8, 8, 8, 8, 8, 8, 8};
        TextComponent.FontSpecialArray_HEIGHT[1] = 12;
        TextComponent.FontLine_SPACE[1] = FontNormalArray_HEIGHT[1] + 1;
        this.reset();
    }

    public void loadFontImages() {
        this.Defaultvalue = new DrawGText();
        pJFontStripNormal = new JImage[4];
        TextComponent.pJFontStripNormal[0] = new JImage();
        pJFontStripNormal[0].load("/small_font.png", null);
        TextComponent.pJFontStripNormal[1] = new JImage();
        pJFontStripNormal[1].load("/big_font_white.png", null);
        TextComponent.pJFontStripNormal[2] = new JImage();
        pJFontStripNormal[2].load("/big_font_green.png", null);
        TextComponent.pJFontStripNormal[3] = new JImage();
        pJFontStripNormal[3].load("/big_font_gray.png", null);
        pJFontStripSpecial = new JImage[4];
        TextComponent.pJFontStripSpecial[0] = new JImage();
        pJFontStripSpecial[0].load("/small_sym.png", null);
        TextComponent.pJFontStripSpecial[1] = new JImage();
        pJFontStripSpecial[1].load("/big_sym_white.png", null);
        TextComponent.pJFontStripSpecial[2] = new JImage();
        pJFontStripSpecial[2].load("/big_sym_green.png", null);
        TextComponent.pJFontStripSpecial[3] = new JImage();
        pJFontStripSpecial[3].load("/big_sym_gray.png", null);
    }

    public int GetNoOfLinesFit(int height, int font) {
        return height / FontLine_SPACE[font];
    }

    public int GetNormalFontHeight(int Font) {
        return FontNormalArray_HEIGHT[Font];
    }

    public int SpaceBetweenMenuOptions() {
        return 0;
    }

    public int GetHeightOffset() {
        return 1;
    }

    public int GetFontWidth(int fontType) {
        return this.GetTextWidth("W<".toCharArray(), fontType);
    }

    public int GetTextWidth(char[] text_array, int font_type) {
        int text_width = 0;
        for (int i = 0; i < text_array.length; ++i) {
            if (text_array[i] == ' ') {
                text_width += this.SPACE;
                continue;
            }
            int CharPos = this.GetCharPos(text_array[i]);
            if (CharPos + 33 <= 126) {
                text_width += FontNormalArray_WIDTH[font_type][CharPos] + this.Char_Space;
                continue;
            }
            text_width += FontSpecialArray_WIDTH[font_type][CharPos - 94] + this.Char_Space;
        }
        return text_width - this.Char_Space;
    }

    public int GetCharPos(int unicode) {
        int CPos = 0;
        CPos = unicode >= 33 && unicode <= 255 ? unicode - 33 : 127;
        return CPos;
    }

    public void DisplayString(String StrBuf, int xPosition, int yPosition, JDisplay g) {
        char unicode = '\u0000';
        int CharPos = 0;
        for (int i = 0; i < StrBuf.length(); ++i) {
            unicode = StrBuf.charAt(i);
            if (unicode == ' ') {
                xPosition += this.SPACE;
                continue;
            }
            CharPos = this.GetCharPos(unicode);
            if (CharPos + 33 <= 126) {
                pJFontStripNormal[this.FontIndex].setActivePalette(this.mActivePalleteIndex);
                g.drawImage(pJFontStripNormal[this.FontIndex + this.mActivePalleteIndex], xPosition, yPosition, FontNormalArray_X[this.FontIndex][CharPos], 0, FontNormalArray_WIDTH[this.FontIndex][CharPos], FontNormalArray_HEIGHT[this.FontIndex], 0, 1);
                xPosition += FontNormalArray_WIDTH[this.FontIndex][CharPos] + this.Char_Space;
                continue;
            }
            pJFontStripSpecial[this.FontIndex].setActivePalette(this.mActivePalleteIndex);
            g.drawImage(pJFontStripSpecial[this.FontIndex + this.mActivePalleteIndex], xPosition, yPosition, FontSpecialArray_X[this.FontIndex][CharPos -= 94], 0, FontSpecialArray_WIDTH[this.FontIndex][CharPos], FontSpecialArray_HEIGHT[this.FontIndex], 0, 1);
            xPosition += FontSpecialArray_WIDTH[this.FontIndex][CharPos] + this.Char_Space;
        }
    }

    public void DrawString(String StrBuf, int xPos, int yPos, int FontType, int alignment, DrawGText TextVariable, JDisplay g, byte aActivePalleteIndex) {
        this.FontIndex = FontType;
        this.mActivePalleteIndex = aActivePalleteIndex;
        this.Scrolling = TextVariable.Scrolling;
        xPos += TextVariable.TextBox_X;
        yPos += TextVariable.TextBox_Y;
        this.GetPos(StrBuf, TextVariable);
        if ((alignment & 8) > 0 && (yPos += TextVariable.TextBox_H - this.nTextLines * FontLine_SPACE[this.FontIndex] >> 1) < TextVariable.TextBox_Y) {
            yPos = TextVariable.TextBox_Y;
        }
        if ((alignment & 1) > 0) {
            this.LeftAligned(StrBuf, xPos, yPos, TextVariable, g);
        } else if ((alignment & 2) > 0) {
            this.RightAligned(StrBuf, xPos, yPos, TextVariable, g);
        } else if ((alignment & 4) > 0) {
            this.CenterAligned(StrBuf, xPos, yPos, TextVariable, g);
        }
    }

    public void CenterAligned(String StrBuf, int xPos, int yPos, DrawGText TextVariable, JDisplay g) {
        for (int i = this.StartPos; i < this.EndPos; ++i) {
            String StrTemp = (String)this.StringTextArray.elementAt(i);
            int SizeOfStr = 0;
            SizeOfStr = this.GetTextWidth(StrTemp.toCharArray(), this.FontIndex);
            int XPOS = TextVariable.TextBox_W - SizeOfStr >> 1;
            this.DisplayString(StrTemp, XPOS += xPos, yPos, g);
            yPos += FontLine_SPACE[this.FontIndex];
        }
        this.ScrollingTraingle(xPos, yPos - 5, TextVariable, g);
        this.StringTextArray.removeAllElements();
    }

    public void RightAligned(String StrBuf, int xPos, int yPos, DrawGText TextVariable, JDisplay g) {
        for (int i = this.StartPos; i < this.EndPos; ++i) {
            String StrTemp = (String)this.StringTextArray.elementAt(i);
            int SizeOfStr = 0;
            SizeOfStr = this.GetTextWidth(StrTemp.toCharArray(), this.FontIndex);
            int XPOS = TextVariable.TextBox_W - SizeOfStr + xPos;
            this.DisplayString(StrTemp, XPOS, yPos, g);
            yPos += FontLine_SPACE[this.FontIndex];
        }
        this.ScrollingTraingle(xPos, yPos, TextVariable, g);
        this.StringTextArray.removeAllElements();
    }

    public void LeftAligned(String StrBuf, int xPos, int yPos, DrawGText TextVariable, JDisplay g) {
        for (int i = this.StartPos; i < this.EndPos; ++i) {
            String StrTemp = (String)this.StringTextArray.elementAt(i);
            this.DisplayString(StrTemp, xPos, yPos, g);
            yPos += FontLine_SPACE[this.FontIndex];
        }
        this.ScrollingTraingle(xPos, yPos, TextVariable, g);
        this.StringTextArray.removeAllElements();
    }

    public void GetPos(String StrBuf, DrawGText TextVariable) {
        this.nTextLines = this.GetNoOfLinesInString(StrBuf, TextVariable);
        this.nRectLine = TextVariable.TextBox_H / FontLine_SPACE[this.FontIndex];
        if (this.Scrolling != 2 && this.nTextLines > this.nRectLine) {
            if (this.TextDownKeyPressed) {
                if (this.Scrolling == 0) {
                    this.lineScroll = this.lineScroll + this.nRectLine >= this.nTextLines ? this.nTextLines - this.nRectLine : ++this.lineScroll;
                } else if (this.Scrolling == 1 && this.EndPos != this.nTextLines) {
                    if (this.EndPos + this.nRectLine >= this.nTextLines) {
                        this.StartPos = this.EndPos - 1;
                        this.EndPos = this.nTextLines;
                    } else {
                        this.StartPos = this.EndPos + this.nRectLine;
                        this.EndPos = this.StartPos + this.nRectLine;
                    }
                }
                this.TextDownKeyPressed = false;
            } else if (this.TextUpKeyPressed) {
                if (this.Scrolling == 0) {
                    this.lineScroll = this.lineScroll <= 0 ? 0 : --this.lineScroll;
                } else if (this.Scrolling == 1 && this.StartPos != 0) {
                    if (this.StartPos - this.nRectLine <= 0) {
                        this.StartPos = 0;
                        this.EndPos = this.StartPos + this.nRectLine;
                    } else {
                        this.EndPos = this.StartPos - 1;
                        this.StartPos = this.EndPos - this.nRectLine;
                    }
                }
                this.TextUpKeyPressed = false;
            }
            if (this.Scrolling == 0) {
                this.StartPos = this.lineScroll;
                this.EndPos = this.StartPos + this.nRectLine;
            } else if (this.StartPos == 0) {
                this.EndPos = this.StartPos + this.nRectLine;
            }
        } else {
            this.StartPos = 0;
            this.EndPos = this.nTextLines;
        }
    }

    public void reset() {
        this.StartPos = 0;
        this.EndPos = 0;
        this.lineScroll = 0;
        this.TextDownKeyPressed = false;
        this.StringTextArray.removeAllElements();
    }

    public int GetNoOfLinesInString(String StrBuf, DrawGText TextVariable) {
        int SizeOfStr = 0;
        char unicode = '\u0000';
        int CharPos = 0;
        int SpacePos = 0;
        char tempChar = '\u0000';
        String strTempBuf = "";
        String strDisplayBuf = "";
        boolean StringComplete = false;
        boolean StringSplit = false;
        int NoLines = 0;
        for (int i = 0; i < StrBuf.length(); ++i) {
            unicode = StrBuf.charAt(i);
            tempChar = unicode;
            if (unicode == ' ') {
                if (SizeOfStr <= TextVariable.TextBox_W) {
                    SpacePos = i;
                    strDisplayBuf = strDisplayBuf + strTempBuf;
                }
                SizeOfStr += this.SPACE;
                strTempBuf = "";
                StringSplit = true;
            } else {
                CharPos = this.GetCharPos(unicode);
                SizeOfStr = CharPos + 33 <= 126 ? (SizeOfStr += FontNormalArray_WIDTH[this.FontIndex][CharPos] + this.Char_Space) : (SizeOfStr += FontSpecialArray_WIDTH[this.FontIndex][CharPos - 94] + this.Char_Space);
            }
            if (tempChar != '\n' && SizeOfStr <= TextVariable.TextBox_W) {
                strTempBuf = strTempBuf + tempChar;
                StringComplete = true;
                continue;
            }
            if (tempChar == '\n' || !StringSplit) {
                strDisplayBuf = strDisplayBuf + strTempBuf;
            } else {
                i = SpacePos;
            }
            this.StringTextArray.addElement(strDisplayBuf);
            strDisplayBuf = "";
            strTempBuf = "";
            StringComplete = false;
            StringSplit = false;
            SizeOfStr = 0;
            ++NoLines;
        }
        strDisplayBuf = strDisplayBuf + strTempBuf;
        if (StringComplete) {
            this.StringTextArray.addElement(strDisplayBuf);
            ++NoLines;
        }
        return NoLines;
    }

    public void ScrollDown() {
        this.TextDownKeyPressed = true;
        this.TextUpKeyPressed = false;
    }

    public void ScrollUp() {
        this.TextDownKeyPressed = false;
        this.TextUpKeyPressed = true;
    }

    public int GetNoOfLines(String fileName) {
        int noOfLines = 0;
        int readChar = 0;
        InputStream iInputStream = this.getClass().getResourceAsStream(fileName);
        try {
            readChar = iInputStream.read();
            while ((char)readChar != '#') {
                if ((char)readChar == '\n' || (char)readChar == '~') {
                    ++noOfLines;
                }
                readChar = iInputStream.read();
            }
            iInputStream.close();
            iInputStream = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return noOfLines;
    }

    public void ReadStringArray(String fileName, String[] string_Array) {
        char readChar = '\u0000';
        int j = 0;
        InputStream iInputStream = this.getClass().getResourceAsStream(fileName);
        try {
            readChar = (char)iInputStream.read();
            while (readChar != '#') {
                string_Array[j] = "";
                while (readChar != '\n' && readChar != '\r') {
                    if (readChar == '~') {
                        int n = j;
                        string_Array[n] = string_Array[n] + '\n';
                    } else {
                        int n = j;
                        string_Array[n] = string_Array[n] + readChar;
                    }
                    readChar = (char)iInputStream.read();
                }
                readChar = (char)iInputStream.read();
                if (readChar == '\n' || readChar == '\r') {
                    readChar = (char)iInputStream.read();
                }
                ++j;
            }
            iInputStream.close();
            iInputStream = null;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void ScrollingTraingle(int xPos, int yPos, DrawGText TextVariable, JDisplay g) {
        if (TextVariable.bShowArrows) {
            String str = new String();
            if (this.StartPos != 0) {
                str = str + ascii1;
            }
            if (this.EndPos != this.nTextLines) {
                str = str + ascii2;
            }
            this.DisplayString(str, xPos += TextVariable.TextBox_W - this.GetTextWidth(str.toCharArray(), this.FontIndex) >> 1, yPos, g);
        }
    }

    public String getArrowString(char i) {
        String str = new String();
        str = str + i;
        return str;
    }

    static {
        ascii1 = (char)175;
        ascii2 = (char)174;
    }

    public static interface FONTTYPE {
        public static final int FONT_0 = 0;
        public static final int FONT_1 = 1;
        public static final int FONT_2 = 2;
        public static final int FONT_3 = 3;
        public static final int MAX_FONTS = 4;
    }
}

