/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.BenGame;
import Game.DPSInterface;
import Game.JavaReader;
import Game.Player;
import java.io.DataInputStream;
import java.io.InputStream;

public class DPSInfo
implements DPSInterface {
    DPSInterface.struct_DPSInfo[] struct_DPSInfo;
    BenGame game;
    JavaReader dpsFile;
    InputStream in;
    DataInputStream dis;
    short mAttackPower;
    boolean mIsDied;
    public short mPlayerMaxHealth;
    public short mPlayerMinHealth;

    public DPSInfo(BenGame game) {
        this.game = game;
        this.dpsFile = new JavaReader();
        InputStream in = this.getClass().getResourceAsStream("/dpsChartData.dps");
        this.dis = new DataInputStream(in);
        this.struct_DPSInfo = new DPSInterface.struct_DPSInfo[14];
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            this.struct_DPSInfo[i] = new DPSInterface.struct_DPSInfo();
        }
    }

    public void unloadDpsData() {
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            if (this.struct_DPSInfo[i] == null) continue;
            this.struct_DPSInfo[i] = null;
        }
        if (this.struct_DPSInfo != null) {
            this.struct_DPSInfo = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.dis != null) {
            this.dis = null;
        }
        if (this.dpsFile != null) {
            this.dpsFile = null;
        }
    }

    public void readDPSInfo() {
        for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
            this.struct_DPSInfo[i].iHp = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iEnergy = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iArmour = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iStrength = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iAgility = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iBlock = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iMeleeAttpower = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iRangeAttpower = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iReflectAttpower = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iComboAttpower1 = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iComboAttpower2 = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iCritpts = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iperCritPoints = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iperMultiplicationFactor = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].imaxDmg = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].ihitTaken = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iAvgDmg = this.dpsFile.readShort(this.dis);
            this.struct_DPSInfo[i].iSpecialAvgDmg = this.dpsFile.readShort(this.dis);
        }
        this.mPlayerMaxHealth = this.struct_DPSInfo[Player.mHeroType].iHp;
        this.mPlayerMinHealth = (short)(1 * this.mPlayerMaxHealth / 70 + 1);
    }

    public void updateHealth(byte aAttacker, byte aDefender, short aAttackMode, byte aDefenderCount) {
        switch (aAttackMode) {
            case 0: {
                this.mAttackPower = this.struct_DPSInfo[aAttacker].iMeleeAttpower;
                break;
            }
            case 1: {
                this.mAttackPower = this.struct_DPSInfo[aAttacker].iRangeAttpower;
                break;
            }
            case 2: {
                this.mAttackPower = this.struct_DPSInfo[aDefender].iReflectAttpower;
                break;
            }
            case 3: {
                this.mAttackPower = this.struct_DPSInfo[aAttacker].iComboAttpower1;
                break;
            }
            case 4: {
                this.mAttackPower = this.struct_DPSInfo[aAttacker].iComboAttpower2;
                break;
            }
            case 5: {
                this.mAttackPower = this.struct_DPSInfo[aAttacker].iSpecialAvgDmg;
            }
        }
        if (this.game.mBen.mPlayerScriptIndex != 9) {
            if (aAttackMode != 2) {
                if (aDefender >= 4 && aDefender <= 11) {
                    this.game.mEnemy.struct_enemy[aDefenderCount].Health = (byte)(this.game.mEnemy.struct_enemy[aDefenderCount].Health - Math.abs(this.mAttackPower - this.struct_DPSInfo[aDefender].iBlock));
                } else {
                    this.struct_DPSInfo[aDefender].iHp = (short)(this.struct_DPSInfo[aDefender].iHp - Math.abs(this.mAttackPower - this.struct_DPSInfo[aDefender].iBlock));
                }
            } else {
                this.struct_DPSInfo[aAttacker].iHp = (short)(this.struct_DPSInfo[aAttacker].iHp - Math.abs(this.mAttackPower - this.struct_DPSInfo[aAttacker].iBlock));
            }
        }
    }

    public short getPlayerHealth() {
        if (this.struct_DPSInfo[Player.mHeroType].iHp > this.mPlayerMaxHealth) {
            this.struct_DPSInfo[Player.mHeroType].iHp = this.mPlayerMaxHealth;
        }
        return this.struct_DPSInfo[Player.mHeroType].iHp;
    }

    public boolean isCharacterDied(byte aDefender) {
        return this.struct_DPSInfo[aDefender].iHp <= 0;
    }
}

