/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.AniInterface;
import Game.JavaReader;
import Game.Rectangle;
import Project.JDisplay;
import Project.JImage;
import java.io.DataInputStream;
import java.io.InputStream;

public class Animation
implements AniInterface {
    byte mNOFBitmaps;
    int mObjAnimationsArraySize;
    JImage[] mAnimImg;
    AniInterface.struct_LayerInfo[][] mBitmapLayers;
    public AniInterface.struct_cAnimation[] mObjAnimationsArray;
    JavaReader mJavaReader = new JavaReader();
    Rectangle mFrameRect = new Rectangle(0, 0, 0, 0);
    Rectangle mLayerRect = new Rectangle(0, 0, 0, 0);

    public void loadAnimImages(String aImageName) {
        this.mAnimImg = new JImage[1];
        for (int i = 0; i < this.mAnimImg.length; ++i) {
            this.mAnimImg[i] = new JImage();
        }
        this.mAnimImg[0].load(aImageName, null);
    }

    public void loadAnimImages(String[] aImageName) {
        this.mAnimImg = new JImage[aImageName.length];
        for (int i = 0; i < aImageName.length; ++i) {
            this.mAnimImg[i] = new JImage();
            this.mAnimImg[i].load(aImageName[i], null);
        }
    }

    public void releaseAnimationImages() {
        for (int i = 0; i < this.mAnimImg.length; i = (int)((byte)(i + 1))) {
            if (this.mAnimImg[i] == null) continue;
            this.mAnimImg[i].destroy();
            this.mAnimImg[i] = null;
        }
        if (this.mAnimImg != null) {
            this.mAnimImg = null;
        }
    }

    public void releaseAnimationData() {
        int vArraySize = this.mObjAnimationsArraySize;
        int vNOFFrames = 0;
        if (this.mObjAnimationsArray != null) {
            for (int i = 0; i < vArraySize; ++i) {
                vNOFFrames = this.mObjAnimationsArray[i].NOFFrames;
                for (int j = 0; j < vNOFFrames; ++j) {
                    if (this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers == null) continue;
                    this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers = null;
                }
                this.mObjAnimationsArray[i].NOFFrames = 0;
                if (this.mObjAnimationsArray[i].AnimationFrames == null) continue;
                this.mObjAnimationsArray[i].AnimationFrames = null;
            }
            this.mObjAnimationsArray = null;
        }
        if (this.mBitmapLayers != null) {
            for (int k = 0; k < this.mBitmapLayers.length; ++k) {
                if (this.mBitmapLayers[k] == null) continue;
                this.mBitmapLayers[k] = null;
            }
            this.mBitmapLayers = null;
        }
        this.mObjAnimationsArraySize = 0;
    }

    public int GetAnimationHeight(int aAnimationIndex) {
        int vValue = 0;
        int i = aAnimationIndex;
        if (i < this.mObjAnimationsArraySize && i >= 0) {
            vValue = this.mObjAnimationsArray[i].AnimationHeight;
        }
        return vValue;
    }

    public int GetAnimationWidth(int aAnimationIndex) {
        int vValue = 0;
        byte i = (byte)aAnimationIndex;
        if (i < this.mObjAnimationsArraySize && i >= 0) {
            vValue = this.mObjAnimationsArray[i].AnimationWidth;
        }
        return vValue;
    }

    public void LoadAnimation(String aAniFile) {
        try {
            int i;
            InputStream in = this.getClass().getResourceAsStream(aAniFile);
            DataInputStream dis = new DataInputStream(in);
            this.mNOFBitmaps = this.mJavaReader.readByte(dis);
            this.mBitmapLayers = new AniInterface.struct_LayerInfo[this.mNOFBitmaps][];
            for (i = 0; i < this.mNOFBitmaps; ++i) {
                short vFileSize = this.mJavaReader.readShort(dis);
                this.mBitmapLayers[i] = new AniInterface.struct_LayerInfo[vFileSize];
                short[] shArray = new short[4];
                for (int j = 0; j < vFileSize >> 3; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        shArray[k] = this.mJavaReader.readShort(dis);
                    }
                    this.mBitmapLayers[i][j] = new AniInterface.struct_LayerInfo(shArray[0], shArray[1], shArray[2], shArray[3]);
                }
            }
            short vNofAnimations = this.mJavaReader.readShort(dis);
            this.mObjAnimationsArraySize = vNofAnimations;
            this.mObjAnimationsArray = new AniInterface.struct_cAnimation[vNofAnimations];
            for (i = 0; i < vNofAnimations; ++i) {
                int vNofFrames = this.mJavaReader.readShort(dis);
                short vAnimationWidth = this.mJavaReader.readShort(dis);
                short vAnimationHeight = this.mJavaReader.readShort(dis);
                this.mObjAnimationsArray[i] = new AniInterface.struct_cAnimation();
                this.mObjAnimationsArray[i].NOFFrames = vNofFrames;
                this.mObjAnimationsArray[i].AnimationWidth = vAnimationWidth;
                this.mObjAnimationsArray[i].AnimationHeight = vAnimationHeight;
                this.mObjAnimationsArray[i].AnimationFrames = new AniInterface.struct_AnimationFrame[vNofFrames];
                for (int j = 0; j < vNofFrames; ++j) {
                    int vNofLayers = this.mJavaReader.readShort(dis);
                    short vFrameWidth = this.mJavaReader.readShort(dis);
                    short vFrameHeight = this.mJavaReader.readShort(dis);
                    short vFramex = this.mJavaReader.readShort(dis);
                    short vFramey = this.mJavaReader.readShort(dis);
                    this.mObjAnimationsArray[i].AnimationFrames[j] = new AniInterface.struct_AnimationFrame();
                    this.mObjAnimationsArray[i].AnimationFrames[j].NOFLayers = vNofLayers;
                    this.mObjAnimationsArray[i].AnimationFrames[j].FrameWidth = vFrameWidth;
                    this.mObjAnimationsArray[i].AnimationFrames[j].FrameHeight = vFrameHeight;
                    this.mObjAnimationsArray[i].AnimationFrames[j].FrameX = vFramex;
                    this.mObjAnimationsArray[i].AnimationFrames[j].FrameY = vFramey;
                    this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers = new AniInterface.struct_AnimationLayer[vNofLayers];
                    for (int k = 0; k < vNofLayers; ++k) {
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k] = new AniInterface.struct_AnimationLayer();
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].LayerX = this.mJavaReader.readShort(dis);
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].LayerY = this.mJavaReader.readShort(dis);
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].IndexOfSpriteArray = this.mJavaReader.readShort(dis);
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].IsFlipped = this.mJavaReader.readBoolean(dis);
                        this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].BitmapIndex = this.mJavaReader.readByte(dis);
                    }
                }
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("ERROR in LOADING.." + e);
        }
    }

    public void Play(JDisplay aGraphics, boolean aFlipped, int aAnimationIndex, int aFrameNumber, int aCharacterX, int aCharacterY, int aTransperancy) {
        short vClipX = 0;
        int vImgeIndex = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        boolean bLayerFlipped = false;
        i = aAnimationIndex;
        j = aFrameNumber;
        if (this.mObjAnimationsArray == null) {
            return;
        }
        if (i < 0 || j > this.mObjAnimationsArray[i].NOFFrames) {
            return;
        }
        int vNofLayers = this.mObjAnimationsArray[i].AnimationFrames[j].NOFLayers;
        for (k = 0; k < vNofLayers; ++k) {
            int vRenderX;
            int vLayerX = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].LayerX;
            int vLayerY = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].LayerY;
            int vLayerIndexToBitmap = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].IndexOfSpriteArray;
            byte vBitmapIndex = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].BitmapIndex;
            int vFrameWid = this.mObjAnimationsArray[i].AnimationFrames[j].FrameWidth;
            short vLayerWidth = this.mBitmapLayers[vBitmapIndex][vLayerIndexToBitmap].dx;
            short vLayerHeight = this.mBitmapLayers[vBitmapIndex][vLayerIndexToBitmap].dy;
            short vClipY = this.mBitmapLayers[vBitmapIndex][vLayerIndexToBitmap].y;
            int vRenderY = vLayerY + aCharacterY;
            bLayerFlipped = aFlipped;
            if (aFlipped) {
                vRenderX = aCharacterX + (vFrameWid - vLayerX - vLayerWidth);
                vClipX = this.mBitmapLayers[vBitmapIndex][vLayerIndexToBitmap].x;
            } else {
                vRenderX = vLayerX + aCharacterX;
                vClipX = this.mBitmapLayers[vBitmapIndex][vLayerIndexToBitmap].x;
            }
            if (this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[k].IsFlipped) {
                bLayerFlipped = !aFlipped;
            }
            vImgeIndex = 0 + vBitmapIndex;
            this.DrawImage(aGraphics, this.mAnimImg[vImgeIndex], bLayerFlipped, vRenderX, vRenderY, vClipX, vClipY, vLayerWidth, vLayerHeight, aTransperancy);
        }
    }

    public void DrawImage(JDisplay aGraphics, JImage aAniImage, boolean aFlipped, int aWhereX, int aWhereY, int aClipX, int aClipY, int aWidth, int aHeight, int aTransperancy) {
        if (!aFlipped) {
            aGraphics.drawImage(aAniImage, aWhereX, aWhereY, aClipX, aClipY, aWidth, aHeight, 0, aTransperancy);
        } else if (aFlipped) {
            aGraphics.drawImage(aAniImage, aWhereX, aWhereY, aClipX, aClipY, aWidth, aHeight, 2, aTransperancy);
        }
    }

    Rectangle GetLayerDisp(int aAnimationIndex, int aFrameNumber, int aLayerNumber) {
        int i = aAnimationIndex;
        int j = aFrameNumber;
        int lr = aLayerNumber;
        if (i < this.mObjAnimationsArraySize && j < this.mObjAnimationsArray[i].NOFFrames && lr < this.mObjAnimationsArray[i].AnimationFrames[j].NOFLayers && j != 0) {
            Rectangle vPrevLayer = this.GetLayer(i, j - 1, lr);
            Rectangle vCurrFrame = this.GetNextFrame(i, j);
            Rectangle vCurrLayer = this.GetLayer(i, j, lr);
            this.mLayerRect.x = vCurrLayer.x - vPrevLayer.x + vCurrFrame.x - (vPrevLayer.dx - vCurrLayer.dx);
            this.mLayerRect.y = vPrevLayer.y - vCurrLayer.y - vCurrFrame.y - (vPrevLayer.dy - vCurrLayer.dy);
        }
        return this.mLayerRect;
    }

    public Rectangle GetNextFrame(int aAnimationIndex, int aFrameNumber) {
        int i = aAnimationIndex;
        int j = aFrameNumber;
        if (i < this.mObjAnimationsArraySize && j < this.mObjAnimationsArray[i].NOFFrames && i >= 0 && j >= 0) {
            this.mFrameRect.x = this.mObjAnimationsArray[i].AnimationFrames[j].FrameX;
            this.mFrameRect.y = this.mObjAnimationsArray[i].AnimationFrames[j].FrameY;
            this.mFrameRect.dx = this.mObjAnimationsArray[i].AnimationFrames[j].FrameWidth;
            this.mFrameRect.dy = this.mObjAnimationsArray[i].AnimationFrames[j].FrameHeight;
        }
        return this.mFrameRect;
    }

    public Rectangle GetLayer(int aAnimationIndex, int aFrameNumber, int aLayerNumber) {
        int i = aAnimationIndex;
        int j = aFrameNumber;
        int lr = aLayerNumber;
        if (i < this.mObjAnimationsArraySize && j < this.mObjAnimationsArray[i].NOFFrames && lr < this.mObjAnimationsArray[i].AnimationFrames[j].NOFLayers) {
            int aLayerIndexToBitmap = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[lr].IndexOfSpriteArray;
            byte aBitmapIndex = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[lr].BitmapIndex;
            this.mFrameRect.x = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[lr].LayerX;
            this.mFrameRect.y = this.mObjAnimationsArray[i].AnimationFrames[j].AnimationLayers[lr].LayerY;
            this.mFrameRect.dx = this.mBitmapLayers[aBitmapIndex][aLayerIndexToBitmap].dx;
            this.mFrameRect.dy = this.mBitmapLayers[aBitmapIndex][aLayerIndexToBitmap].dy;
        }
        return this.mFrameRect;
    }
}

