/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Animation;
import Game.BenGame;
import Game.Rectangle;
import Project.JDisplay;

public class Character {
    public Animation charAnimation;

    public void releaseAniReasourse() {
        if (this.charAnimation != null) {
            this.charAnimation.releaseAnimationImages();
            this.charAnimation.releaseAnimationData();
            this.charAnimation = null;
        }
    }

    public void releaseAniStructure(Struct_Character aStructCharacter) {
        if (aStructCharacter.CurrentAnimFrameRect != null) {
            aStructCharacter.CurrentAnimFrameRect = null;
        }
        if (aStructCharacter.NextAnimFrameRect != null) {
            aStructCharacter.NextAnimFrameRect = null;
        }
        if (aStructCharacter != null) {
            aStructCharacter = null;
        }
    }

    public int getCharacterXOnScreen(Struct_Character aStructCharacter) {
        int mapX = BenGame.getMapXPosition();
        if (mapX < 0) {
            mapX = 0;
        }
        return aStructCharacter.mCharacterX - mapX;
    }

    public int getCharacterYOnScreen(Struct_Character aStructCharacter) {
        int mapY = BenGame.getMapYPosition();
        if (mapY < 0) {
            mapY = 0;
        }
        return aStructCharacter.mCharacterY - mapY;
    }

    public int getCharacterXOnCanvas(Struct_Character aStructCharacter) {
        return aStructCharacter.mCharacterX;
    }

    public int getCharacterYOnCanvas(Struct_Character aStructCharacter) {
        return aStructCharacter.mCharacterY;
    }

    public void setCharacterXOnCanvas(int aX, Struct_Character aStructCharacter) {
        aStructCharacter.mCharacterX = aX;
    }

    public void setCharacterYOnCanvas(int aY, Struct_Character aStructCharacter) {
        aStructCharacter.mCharacterY = aY;
    }

    public int getCharacterWidth(byte aState, int aFrameNumber) {
        int vFrameWidth = 0;
        vFrameWidth = this.charAnimation.mObjAnimationsArray[aState].AnimationFrames[aFrameNumber].FrameWidth;
        return vFrameWidth;
    }

    public int getCharacterHeight(byte aState, int aFrameNumber) {
        int vFrameHeight = 0;
        vFrameHeight = this.charAnimation.mObjAnimationsArray[aState].AnimationFrames[aFrameNumber].FrameHeight;
        return vFrameHeight;
    }

    public int getCharacterWidth(Struct_Character aStructCharacter) {
        return aStructCharacter.mWidth;
    }

    public int getCharacterHeight(Struct_Character aStructCharacter) {
        return aStructCharacter.mHeight;
    }

    public void setCharacterWidth(int aWidth, Struct_Character aStructCharacter) {
        aStructCharacter.mWidth = aWidth;
    }

    public void setCharacterHeight(int aHeight, Struct_Character aStructCharacter) {
        aStructCharacter.mHeight = aHeight;
    }

    public void updateAnimPosition(Struct_Character aStructCharacter) {
        if (!aStructCharacter.mIsAnimPosUpdated) {
            aStructCharacter.mIsAnimPosUpdated = true;
            if (aStructCharacter.mIsCharacterFlipped) {
                int vWidthDifference = this.charAnimation.mObjAnimationsArray[aStructCharacter.state].AnimationFrames[aStructCharacter.iCharFrameNumber].FrameWidth - aStructCharacter.CurrentAnimFrameRect.dx;
                aStructCharacter.CurrentAnimFrameRect.x -= vWidthDifference - aStructCharacter.NextAnimFrameRect.x;
            } else {
                aStructCharacter.CurrentAnimFrameRect.x += aStructCharacter.NextAnimFrameRect.x;
            }
            aStructCharacter.CurrentAnimFrameRect.y += aStructCharacter.NextAnimFrameRect.y;
            aStructCharacter.CurrentAnimFrameRect.dx = this.charAnimation.mObjAnimationsArray[aStructCharacter.state].AnimationFrames[aStructCharacter.iCharFrameNumber].FrameWidth;
            aStructCharacter.CurrentAnimFrameRect.dy = this.charAnimation.mObjAnimationsArray[aStructCharacter.state].AnimationFrames[aStructCharacter.iCharFrameNumber].FrameHeight;
        }
    }

    public void drawCharacter(JDisplay g, int aTransperancy, Struct_Character aStructCharacter) {
        int vCharacterXonMap = this.getCharacterXOnScreen(aStructCharacter);
        int vCharacterYonMap = this.getCharacterYOnScreen(aStructCharacter);
        this.charAnimation.Play(g, aStructCharacter.mIsCharacterFlipped, aStructCharacter.state, aStructCharacter.iCharFrameNumber, vCharacterXonMap, vCharacterYonMap, aTransperancy);
    }

    public void drawCharacter(JDisplay g, int aTransperancy, Struct_Character aStructCharacter, boolean WithRespectScreen) {
        int vCharacterXonMap = aStructCharacter.mCharacterX;
        int vCharacterYonMap = aStructCharacter.mCharacterY;
        this.charAnimation.Play(g, aStructCharacter.mIsCharacterFlipped, aStructCharacter.state, aStructCharacter.iCharFrameNumber, vCharacterXonMap, vCharacterYonMap, aTransperancy);
    }

    public class Struct_Character {
        private int mWidth;
        private int mHeight;
        private int mCharacterX;
        private int mCharacterY;
        public boolean mIsCharacterFlipped;
        public byte state;
        public byte nextState;
        public byte jumpState;
        public int iCharFrameNumber;
        public boolean b_KEYPRESSED;
        public boolean collided;
        public boolean mIsActive;
        public Rectangle CurrentAnimFrameRect = new Rectangle();
        public Rectangle NextAnimFrameRect = new Rectangle();
        public boolean prevAttack;
        public boolean mIsAnimPosUpdated;
    }
}

