/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.CAnim;
import Game.DPSInfo;
import Game.DeviceConstants;
import Game.Enemy;
import Game.GameConstants;
import Game.Map;
import Game.MapObject;
import Game.Player;
import Game.Rectangle;
import Game.SoundPlayer;
import Localisation.DrawGText;
import Localisation.TextComponent;
import Project.JDisplay;
import Project.JImage;
import Project.JTimer;
import StateManager.CState;
import StateManager.StateCommonData;

public class BenGame
extends CState
implements GameConstants {
    public static boolean toCallKeyPressBen;
    StateCommonData pCommonData;
    public static String mEmptyString;
    public int mFrameDisplayTime = 0;
    public MapObject mMapObjects;
    public static int mMap_X_off;
    public static int mMap_Y_off;
    public static JImage sTileImage;
    public JImage sBgImage;
    private JImage mHudImage;
    private JImage mHudTimeModePartImage;
    public Map mMap;
    public Player mBen;
    public Enemy mEnemy;
    public boolean mIskeyReapeated;
    public boolean mIskeyReleased;
    public boolean mIskeyPressedOnce;
    public DrawGText mPopupRect;
    public DrawGText mCutSceneRect;
    public DrawGText mCutSceneTextRect;
    public int mCollisionIndex;
    public DPSInfo mDpsInfo;
    public short toshowCollisionEffect = 0;
    public boolean mCollisionEffect;
    public short mOriginalPanningBoundBottomY;
    public static short mCurrentPanningSpeed;
    public static byte mPlayerLifes;
    public static byte mCurrentLevel;
    public static boolean mIsInvisible;
    public static boolean mPause;
    public static byte gameState;
    public boolean mIsPopupOn;
    public static boolean mIsShowSubMenu;
    public static byte mStatusOfLevel;
    public byte mNaratorType;
    public static byte mAnimationType;
    short mLoadCounter;
    boolean mIsDestReched;
    boolean mIsValueAssigned;
    boolean mDynPanActivated;
    boolean mIsDynPanPaused;
    short mDestMapObjectId;
    int mForwardStartX;
    int mForwardStartY;
    int mForwardDestX;
    int mForwardDestY;
    int mDynamicStartPosX;
    int mDynamicStartPosY;
    int mDynamicDestPosX;
    int mDynamicDestPosY;
    int mDynTileCol;
    int mDynTileRow;
    boolean mIsBlink;
    public boolean mKeyControl;
    short mPanLeftX;
    short mPanRightX;
    short mPanTopY;
    short mPanBottomY;
    public boolean mIsGameOver;
    public static boolean mIsScoreBoardDisplayed;
    public boolean mIsLevelOver;
    public static boolean mIsAlertOn;
    public boolean mIsHighScoreAchieved;
    public boolean mIsGameWin;
    short mAlertIncCounter;
    boolean mIsShutterDown;
    boolean mIsShutterUp;
    boolean mIsMorphed;
    long mPlayerRelaxTimer;
    boolean mIsDrawcheatRect;
    boolean mIsExitScriptCaught;
    public byte[] mScoreTableStringsIndexArray = new byte[]{60, 61, 62};
    public short[] mScoreTableScoreArray;
    JTimer mTimerModeTimer;
    int mPointX;
    int mPointY;
    int mYDiff;
    int mXDiff;
    int mDynamicPanOffset = 4;
    boolean mMoveForword = true;
    CAnim pAnim;
    byte mTempTextIndex;
    int mTextRectHeight;
    boolean mIsTimerModeUnlockAlertOn;
    boolean mIsMorphOn;
    boolean mIsSubMenuActive;
    boolean mIsLevelIntroSoundOn;
    boolean mIsLevelIntroSoundPlayed;
    boolean mIsLevelComplete;
    public static boolean bPauseGameonAlert;
    JImage imgCutScence;
    int mInBetweenCutScenceNumber;
    int mMaxCutScenceinOneLevel;

    public BenGame() {
        this.pCommonData = (StateCommonData)this.getCommonData();
        this.config.bLoopTimer = true;
        gameState = (byte)2;
        mStatusOfLevel = 0;
        StateCommonData.mGameMode = 1;
        this.mScoreTableScoreArray = new short[this.mScoreTableStringsIndexArray.length];
        this.mTimerModeTimer = new JTimer();
    }

    public void resetLevelVariables() {
        int i;
        toCallKeyPressBen = false;
        bPauseGameonAlert = false;
        this.mIsLevelComplete = false;
        this.mIsSubMenuActive = false;
        this.mBen.struct_Player.mIsAnimPosUpdated = false;
        Player.sIsPlayerAnimationStopped = false;
        this.mIsLevelIntroSoundOn = false;
        this.mIsLevelIntroSoundPlayed = false;
        this.mIsTimerModeUnlockAlertOn = false;
        this.mCollisionEffect = false;
        this.toshowCollisionEffect = 0;
        this.mFrameDisplayTime = 0;
        this.mIsPopupOn = false;
        this.mIsGameOver = false;
        this.mIsGameWin = false;
        this.mIsLevelOver = false;
        this.mIsDrawcheatRect = false;
        this.mPlayerRelaxTimer = 200L;
        this.mIsExitScriptCaught = false;
        this.mIsGameOver = false;
        MapObject.mLeverPressed = false;
        this.mIsMorphed = false;
        this.mIsMorphOn = false;
        mIsScoreBoardDisplayed = false;
        this.pCommonData.mTextComponent.reset();
        mStatusOfLevel = 0;
        if (StateCommonData.mGameMode == 0) {
            this.mTimerModeTimer.reset();
            for (i = (byte)(DeviceConstants.gameMsgsDecisionArray.length - 1); i >= 0; i = (int)((byte)(i - 1))) {
                DeviceConstants.gameMsgsDecisionArray[i][4] = 0;
            }
            DeviceConstants.gameMsgsDecisionArray[24][4] = 1;
            this.mIsSubMenuActive = true;
        } else {
            for (i = (int)(DeviceConstants.gameMsgsDecisionArray.length - 1); i >= 0; i = (int)((byte)(i - 1))) {
                if (DeviceConstants.gameMsgsDecisionArray[i][0] != mCurrentLevel || DeviceConstants.gameMsgsDecisionArray[i][1] != 1) continue;
                DeviceConstants.gameMsgsDecisionArray[i][4] = 1;
            }
            this.mIsSubMenuActive = false;
        }
        for (i = 3; i >= 0; i = (int)((byte)(i - 1))) {
            this.mMapObjects.mapObjectXYforScoreTable[i][2] = 0;
            this.mMapObjects.mapObjectXYforScoreTable[i][0] = 0;
        }
        for (i = this.mScoreTableScoreArray.length - 1; i >= 0; --i) {
            this.mScoreTableScoreArray[i] = 0;
        }
        for (i = 0; i < 3; ++i) {
            if (this.mBen.pWeapon == null || this.mBen.pWeapon.struct_Weapon[i] == null) continue;
            this.mBen.pWeapon.struct_Weapon[i].mIsActive = false;
        }
        if (this.mEnemy != null) {
            for (i = 0; i < this.mEnemy.noOfEnemies; ++i) {
                if (this.mEnemy.eWeapons == null || this.mEnemy.eWeapons.struct_Weapon[i] == null) continue;
                this.mEnemy.eWeapons.struct_Weapon[i].mIsActive = false;
            }
        }
        this.mAlertIncCounter = 0;
        MapObject.levelScore = 0;
        this.mIsHighScoreAchieved = false;
        mIsAlertOn = false;
        this.resetDynamicPanVariable();
        this.mEnemy.resetEnemy();
        this.mTempTextIndex = (byte)10;
    }

    public void resetMapVariables() {
        mMap_X_off = 0;
        mMap_Y_off = 0;
    }

    public void resetGameVariables() {
        toCallKeyPressBen = false;
        bPauseGameonAlert = false;
        this.mIsLevelComplete = false;
        this.mKeyControl = false;
        this.mIsSubMenuActive = false;
        this.mIsLevelIntroSoundOn = false;
        this.mIsLevelIntroSoundPlayed = false;
        this.mIsTimerModeUnlockAlertOn = false;
        this.mCollisionEffect = false;
        this.toshowCollisionEffect = 0;
        this.mIsGameOver = false;
        this.mIsGameWin = false;
        this.mIsDrawcheatRect = true;
        gameState = (byte)2;
        mStatusOfLevel = 0;
        this.mIsBlink = false;
        this.resetDynamicPanVariable();
        mIsShowSubMenu = false;
        this.mIskeyReapeated = false;
        this.mIskeyReleased = false;
        this.mIskeyPressedOnce = false;
        mIsInvisible = false;
        mPause = false;
        this.mIsPopupOn = false;
        mIsScoreBoardDisplayed = false;
        this.mIsGameOver = false;
        this.mIsHighScoreAchieved = false;
        mIsAlertOn = false;
        this.mIsMorphed = false;
        this.mPlayerRelaxTimer = 200L;
        this.mIsExitScriptCaught = false;
        if (StateCommonData.mGameMode == 0) {
            this.mTimerModeTimer.bIsTimerExceeded = false;
        }
        for (byte i = (byte)(DeviceConstants.gameMsgsDecisionArray.length - 1); i >= 0; i = (byte)(i - 1)) {
            DeviceConstants.gameMsgsDecisionArray[i][4] = 1;
        }
        this.mTempTextIndex = (byte)10;
    }

    public static void setLevel(byte aLevel) {
        mCurrentLevel = aLevel;
    }

    public void switchLevel() {
        this.mKeyControl = false;
        this.unLoadLevelResource();
        Player.sIsPlayerAnimationStopped = false;
        this.resetLevelVariables();
        this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
        BenGame.setLevel((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.loadLevelResourse((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.mBen.loadBenResources((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.mBen.initPlayer((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.mEnemy.loadEnemyWeapons((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.mEnemy.loadEnemyResources((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        this.loadCutsceneResource();
        this.mIsDrawcheatRect = true;
        mPause = false;
        this.checkForEventTexts();
        if (StateCommonData.mGameMode == 0) {
            StateCommonData.mTextIndex = (byte)(66 + (mCurrentLevel - 1));
            StateCommonData.mLeftSoftKey = (byte)9;
            StateCommonData.mRightSoftKey = (byte)10;
            mIsAlertOn = true;
            gameState = 0;
            mStatusOfLevel = 0;
            this.mIsSubMenuActive = true;
        } else if (mCurrentLevel != 1 && gameState != 3) {
            gameState = 0;
            mStatusOfLevel = 0;
        }
        this.mKeyControl = true;
        StateCommonData.mPaintLoadingScreen = false;
        this.pCommonData.mloadingCounter = 0;
        this.pCommonData.mStateCounter = 0;
    }

    public void loadNaratorResource() {
        this.mPopupRect.Scrolling = 0;
        this.mPopupRect.TextBox_W = StateCommonData.screen_Width;
        this.mPopupRect.TextBox_H = 44;
        this.mPopupRect.TextBox_X = 0;
        this.mPopupRect.TextBox_Y = StateCommonData.screen_Height - this.mPopupRect.TextBox_H - 4 - this.pCommonData.mTextComponent.GetNormalFontHeight(0);
    }

    public void initValues() {
        this.mKeyControl = false;
        this.loadGameResources();
        if (sTileImage == null) {
            sTileImage = new JImage();
        }
        if (this.mMap == null) {
            this.mMap = new Map(this);
        }
        if (this.mBen == null) {
            this.mBen = new Player(this, this.pCommonData);
        }
        if (this.mEnemy == null) {
            this.mEnemy = new Enemy(this, this.pCommonData);
        }
        if (this.pAnim == null) {
            this.pAnim = new CAnim(this.pCommonData);
        }
        if (this.mMapObjects == null) {
            this.mMapObjects = new MapObject(this, this.pCommonData, this.pAnim);
        }
        if (this.mMapObjects != null) {
            String[] vMapObjectsStringArray = new String[]{"/mapobjectsprite.png", "/arrowsSprite.png"};
            this.mMapObjects.loadImages(vMapObjectsStringArray);
        }
        if (this.mPopupRect == null) {
            this.mPopupRect = new DrawGText();
        }
        if (this.mCutSceneRect == null) {
            this.mCutSceneRect = new DrawGText();
        }
        if (this.mCutSceneTextRect == null) {
            this.mCutSceneTextRect = new DrawGText();
        }
        if (this.mDpsInfo == null) {
            this.mDpsInfo = new DPSInfo(this);
        }
        this.resetLevelVariables();
        this.mDpsInfo.readDPSInfo();
        this.setPanningRect();
        this.loadLevelResourse(mCurrentLevel);
        this.mBen.loadBenResources(mCurrentLevel);
        this.mBen.initPlayer(mCurrentLevel);
        this.mEnemy.loadEnemyWeapons(mCurrentLevel);
        this.mEnemy.loadEnemyResources(mCurrentLevel);
        this.loadCutsceneResource();
        this.loadNaratorResource();
        mIsShowSubMenu = false;
    }

    public static void setPlayerLifes(byte index) {
        mPlayerLifes = index;
    }

    public static byte getPlayerLifes() {
        return mPlayerLifes;
    }

    protected void resume(boolean aBTAPI) {
        this.pCommonData.mTimer.reset();
        this.pCommonData.TimeDuration = 0L;
        if (!aBTAPI) {
            this.initValues();
            this.mTimerModeTimer.reset();
            this.pCommonData.TimeDuration1 = 0L;
        } else if (gameState == 6) {
            if (SoundPlayer.mIsSoundActive) {
                this.pCommonData.mSoundPlayer.playSound(0);
            }
        } else if (gameState == 2 || gameState == 3) {
            if (!SoundPlayer.mIsSoundActive || !this.mIsLevelIntroSoundOn || this.mIsLevelIntroSoundPlayed) {
                this.pCommonData.mSoundPlayer.stopSound();
            }
        } else if (gameState == 0) {
            if (SoundPlayer.mIsSoundActive) {
                // empty if block
            }
            if (!(mPause && !this.mIsPopupOn || mIsAlertOn || mIsScoreBoardDisplayed)) {
                if (!this.pCommonData.mIsLoadingOn && this.mIsSubMenuActive) {
                    if (!mIsShowSubMenu) {
                        StateCommonData.mPreviousLeftSoftkey = StateCommonData.mLeftSoftKey;
                        StateCommonData.mPreviousRightSoftkey = StateCommonData.mRightSoftKey;
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = (byte)10;
                    }
                    this.pCommonData.mSelectedMeuIndex = 0;
                    mIsShowSubMenu = true;
                    mPause = true;
                    if (SoundPlayer.mIsSoundActive) {
                        this.pCommonData.mSoundPlayer.stopSound();
                    }
                }
            } else if (mCurrentLevel == 7 && mStatusOfLevel != 1 || mCurrentLevel < 7) {
                this.checkForEventTexts();
            }
            if (mIsAlertOn) {
                bPauseGameonAlert = true;
            }
        }
    }

    public void loadLevelResourse(byte aLevel) {
        this.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = this.mDpsInfo.mPlayerMaxHealth;
        switch (aLevel) {
            case 1: {
                sTileImage.load("/level_01.png", null);
                this.mMap.ReadMap("/level_01_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level1.imp");
                this.mEnemy.readEnemyData("/Level_1_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(85);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 2: {
                sTileImage.load("/level_01.png", null);
                this.mMap.ReadMap("/level_02_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level2.imp");
                this.mEnemy.readEnemyData("/Level_2_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(160);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 4: {
                sTileImage.load("/level_01.png", null);
                this.mMap.ReadMap("/level_04_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level4.imp");
                this.mEnemy.readEnemyData("/Level_4_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(130);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 3: {
                sTileImage.load("/level_01.png", null);
                this.mMap.ReadMap("/level_03_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level3.imp");
                this.mEnemy.readEnemyData("/Level_3_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(170);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 5: {
                sTileImage.load("/level_03.png", null);
                this.mMap.ReadMap("/level_05_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level5.imp");
                this.mEnemy.readEnemyData("/Level_5_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(180);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 6: {
                sTileImage.load("/level_03.png", null);
                this.mMap.ReadMap("/level_06_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level6.imp");
                this.mEnemy.readEnemyData("/Level_6_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(200);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
                break;
            }
            case 7: {
                sTileImage.load("/level_03.png", null);
                this.mMap.ReadMap("/level_08_mapdata.dat");
                this.pAnim.readData("/mapobjects.ani");
                this.mMapObjects.readMap("/mapobjectpos_level7.imp");
                this.mEnemy.readEnemyData("/Level_8_Enemy_pos.dat");
                if (StateCommonData.mGameMode == 0) {
                    this.mTimerModeTimer.setInterval(200);
                    BenGame.setPlayerLifes(GameConstants.TimeModeLevelLifes[mCurrentLevel - 1]);
                    break;
                }
                BenGame.setPlayerLifes((byte)2);
            }
        }
    }

    public void setPanningRect() {
        this.mPanLeftX = (short)36;
        this.mPanRightX = (short)(StateCommonData.screen_Width - 36);
        this.mPanTopY = (short)36;
        this.mOriginalPanningBoundBottomY = this.mPanBottomY = (short)(StateCommonData.screen_Height - 12);
    }

    public static void updateMapXPosition(int aUpDateX) {
        mMap_X_off = -aUpDateX;
        if (Math.abs(mMap_X_off) > Map.MAP_WID - StateCommonData.screen_Width) {
            mMap_X_off = -(Map.MAP_WID - StateCommonData.screen_Width);
            mCurrentPanningSpeed = (short)10;
        }
        if (mMap_X_off > 0) {
            mMap_X_off = 0;
            mCurrentPanningSpeed = (short)10;
        }
    }

    public static int getMapXPosition() {
        int vMapX = -mMap_X_off;
        return vMapX;
    }

    public static void updateMapYPosition(int aUpDateY) {
        mMap_Y_off = -aUpDateY;
    }

    public static int getMapYPosition() {
        int vMapY = -mMap_Y_off;
        return vMapY;
    }

    public void setDynPanningParameters(int aStartX, int aStartY, int aDestX, int aDestY, short aDestObjectId) {
        this.mForwardStartX = aStartX;
        this.mForwardStartY = aStartY;
        this.mForwardDestX = aDestX;
        this.mForwardDestY = aDestY;
        this.mDestMapObjectId = aDestObjectId;
        if (mCurrentLevel == 5 || mCurrentLevel == 6 || mCurrentLevel == 7) {
            this.mDynTileCol = this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].tileX / 12;
            this.mDynTileRow = this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].tileY / 12;
        }
    }

    public void resetDynamicPanVariable() {
        this.mMoveForword = true;
        this.mIsValueAssigned = false;
        this.mDynPanActivated = false;
        this.mIsDestReched = false;
        this.mIsDynPanPaused = false;
    }

    public void getPointsOnDynamicPanningLine() {
        this.mPointY = (short)(this.mYDiff * this.mPointX / this.mXDiff - this.mYDiff * this.mDynamicStartPosX / this.mXDiff + this.mDynamicStartPosY);
    }

    public void dynamicPan() {
        if (!this.mIsValueAssigned && this.mMoveForword) {
            this.mDynamicStartPosX = this.mForwardStartX;
            this.mDynamicStartPosY = this.mForwardStartY;
            this.mDynamicDestPosX = this.mForwardDestX;
            this.mDynamicDestPosY = this.mForwardDestY;
            this.mYDiff = (short)(this.mDynamicDestPosY - this.mDynamicStartPosY);
            this.mXDiff = (short)(this.mDynamicDestPosX - this.mDynamicStartPosX);
            this.mDynamicPanOffset = this.mDynamicDestPosX - this.mDynamicStartPosX < 0 ? -4 : 4;
            this.mPointX = this.mDynamicStartPosX;
            this.mPointY = this.mDynamicStartPosY;
            this.mIsValueAssigned = true;
        }
        this.mPointX += this.mDynamicPanOffset;
        if (!this.mIsDestReched && this.mMoveForword) {
            if (this.mDynamicPanOffset < 0 && this.mPointX < this.mDynamicDestPosX || this.mDynamicPanOffset > 0 && this.mPointX > this.mDynamicDestPosX) {
                this.mMoveForword = false;
                this.mIsDestReched = true;
                this.mIsDynPanPaused = true;
                if (mCurrentLevel == 5 || mCurrentLevel == 7) {
                    this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].animId = (byte)27;
                    this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].current_frame = 0;
                    for (int i = 0; i < 6; ++i) {
                        short[] sArray = Map.MapData.MapBoundArray[this.mDynTileRow + i];
                        int n = this.mDynTileCol;
                        sArray[n] = (short)(sArray[n] & 0xFF00);
                    }
                } else if (mCurrentLevel == 6) {
                    this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].animId = (byte)29;
                    this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].current_frame = 0;
                    for (int i = 0; i < 6; ++i) {
                        short[] sArray = Map.MapData.MapBoundArray[this.mDynTileRow];
                        int n = this.mDynTileCol + i;
                        sArray[n] = (short)(sArray[n] & 0xFF00);
                    }
                }
            }
        } else if (!this.mMoveForword && !this.mIsDynPanPaused && this.mIsDestReched) {
            this.mIsDestReched = false;
            this.mIsValueAssigned = false;
            this.mDynamicStartPosX = this.mDynamicDestPosX;
            this.mDynamicStartPosY = this.mDynamicDestPosY;
            this.mDynamicDestPosX = this.mBen.getCharacterXOnCanvas(this.mBen.struct_Player) - (StateCommonData.screen_Width - this.mBen.getCharacterWidth(this.mBen.struct_Player) >> 1);
            this.mDynamicDestPosY = this.mBen.getCharacterYOnCanvas(this.mBen.struct_Player) - (StateCommonData.screen_Height - this.mBen.getCharacterHeight(this.mBen.struct_Player) >> 1);
            this.mYDiff = (short)(this.mDynamicDestPosY - this.mDynamicStartPosY);
            this.mXDiff = (short)(this.mDynamicDestPosX - this.mDynamicStartPosX);
            this.mDynamicPanOffset = this.mDynamicDestPosX - this.mDynamicStartPosX < 0 ? -4 : 4;
            this.mPointX = this.mDynamicStartPosX;
            this.mPointY = this.mDynamicStartPosY;
        } else if (!this.mMoveForword && !this.mIsDynPanPaused && !this.mIsDestReched && (this.mDynamicPanOffset < 0 && this.mPointX < this.mDynamicDestPosX || this.mDynamicPanOffset > 0 && this.mPointX > this.mDynamicDestPosX)) {
            this.resetDynamicPanVariable();
        }
        this.getPointsOnDynamicPanningLine();
        if (this.mPointY + StateCommonData.screen_Height >= Map.MAP_HIG) {
            this.mPointY = Map.MAP_HIG - StateCommonData.screen_Height;
        }
        if (!this.mIsDestReched) {
            BenGame.updateMapXPosition(this.mPointX);
            BenGame.updateMapYPosition(this.mPointY);
        }
    }

    public void setMapXY(int aSetX, int aSetY) {
        mMap_X_off = -aSetX;
        mMap_Y_off = -aSetY;
    }

    public void drawParallexBg(JDisplay aGraphics) {
        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
    }

    public void drawPauseIcon(JDisplay aGraphics) {
        if (!this.mIsShutterUp || this.mIsShutterDown) {
            TextComponent cfr_ignored_0 = this.pCommonData.mTextComponent;
            this.pCommonData.mTextComponent.DrawString(this.pCommonData.mTextComponent.getArrowString(TextComponent.ascii2), 2, StateCommonData.screen_Height - this.pCommonData.mTextComponent.GetNormalFontHeight(0), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        }
    }

    public void loadSubMenuRestart() {
        this.resetPlayerProps();
        this.resetLevelVariables();
        this.loadLevelResourse(mCurrentLevel);
        if (StateCommonData.mGameMode == 1) {
            for (byte i = (byte)(DeviceConstants.gameMsgsDecisionArray.length - 1); i >= 0; i = (byte)(i - 1)) {
                if (DeviceConstants.gameMsgsDecisionArray[i][0] != mCurrentLevel || DeviceConstants.gameMsgsDecisionArray[i][1] != 1) continue;
                DeviceConstants.gameMsgsDecisionArray[i][4] = 1;
            }
        }
        gameState = 0;
        if (StateCommonData.mGameMode == 0) {
            this.mTimerModeTimer.reset();
            StateCommonData.mTextIndex = (byte)(66 + (mCurrentLevel - 1));
            StateCommonData.mLeftSoftKey = (byte)9;
            StateCommonData.mRightSoftKey = (byte)10;
            mIsAlertOn = true;
            mStatusOfLevel = 0;
            this.mIsSubMenuActive = true;
        }
        StateCommonData.mPaintLoadingScreen = false;
        this.pCommonData.mloadingCounter = 0;
        this.pCommonData.mStateCounter = 0;
    }

    public void loadSubMenuIngame() {
        this.pCommonData.mTextComponent.reset();
        mPause = false;
        this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
        this.resetPlayerProps();
        this.resetLevelVariables();
        this.loadLevelResourse(mCurrentLevel);
        gameState = 0;
        StateCommonData.mPaintLoadingScreen = false;
        this.pCommonData.mloadingCounter = 0;
        this.pCommonData.mStateCounter = 0;
    }

    public void loadLevelRetry() {
        mPause = false;
        this.resetPlayerProps();
        this.resetLevelVariables();
        this.loadLevelResourse(mCurrentLevel);
        gameState = 0;
        if (StateCommonData.mGameMode == 0) {
            this.mTimerModeTimer.reset();
            StateCommonData.mTextIndex = (byte)(66 + (mCurrentLevel - 1));
            StateCommonData.mLeftSoftKey = (byte)9;
            StateCommonData.mRightSoftKey = (byte)10;
            mIsAlertOn = true;
            mStatusOfLevel = 0;
            this.mIsSubMenuActive = true;
        }
        StateCommonData.mPaintLoadingScreen = false;
        this.pCommonData.mloadingCounter = 0;
        this.pCommonData.mStateCounter = 0;
    }

    public void load() {
        switch (this.pCommonData.mStateCounter) {
            case 101: {
                this.switchLevel();
                break;
            }
            case 102: {
                this.loadSubMenuRestart();
                break;
            }
            case 103: {
                this.loadSubMenuIngame();
                break;
            }
            case 104: {
                this.loadLevelRetry();
            }
        }
        this.mTimerModeTimer.reset();
        this.pCommonData.TimeDuration = 0L;
        this.pCommonData.TimeDuration1 = 0L;
    }

    public void Display(JDisplay aGraphics) {
        if (StateCommonData.mPaintLoadingScreen) {
            this.pCommonData.paintLoadingScreen(aGraphics);
            if (this.pCommonData.mloadingCounter++ > 3) {
                this.load();
            }
            return;
        }
        switch (gameState) {
            case 0: {
                byte FLASH_EFFECT_FRAME_NUMBER;
                switch (mCurrentLevel) {
                    case 1: {
                        int i;
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, BenGame.getMapXPosition(), BenGame.getMapYPosition(), StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        for (i = 0; i < 3; ++i) {
                            if (!this.mBen.pWeapon.struct_Weapon[i].mIsActive) continue;
                            this.mBen.pWeapon.drawCharacter(aGraphics, 1, this.mBen.pWeapon.struct_Weapon[i]);
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        for (i = 0; i < 3; ++i) {
                            if (!this.mBen.pWeapon.struct_Weapon[i].mIsActive) continue;
                            this.mBen.pWeapon.drawCharacter(aGraphics, 1, this.mBen.pWeapon.struct_Weapon[i]);
                        }
                        break;
                    }
                    case 5: {
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        break;
                    }
                    case 6: {
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        break;
                    }
                    case 7: {
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        if (mIsAlertOn) {
                            this.pCommonData.mJDisplay.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        }
                        if (this.mIsShutterUp && !this.mIsShutterDown) {
                            this.pCommonData.mJDisplay.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        } else {
                            this.mMap.DrawMap(aGraphics);
                        }
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        break;
                    }
                    case 3: {
                        int i;
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        for (i = 0; i < 3; ++i) {
                            if (!this.mBen.pWeapon.struct_Weapon[i].mIsActive) continue;
                            this.mBen.pWeapon.drawCharacter(aGraphics, 1, this.mBen.pWeapon.struct_Weapon[i]);
                        }
                        break;
                    }
                    case 4: {
                        int i;
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                        this.mMap.DrawMap(aGraphics);
                        if (mIsScoreBoardDisplayed || mIsAlertOn) break;
                        this.mMapObjects.renderMapObjects(aGraphics, -mMap_X_off, -mMap_Y_off, StateCommonData.screen_Width, StateCommonData.screen_Height);
                        if (this.mCollisionEffect) {
                            this.doPlayerHurtEffect(aGraphics);
                            this.toshowCollisionEffect = (short)(this.toshowCollisionEffect + 1);
                            if (this.toshowCollisionEffect >= 5) {
                                this.toshowCollisionEffect = 0;
                                this.mCollisionEffect = false;
                            }
                        }
                        this.mEnemy.DrawEnemy(aGraphics, (short)(-mMap_X_off), (short)(-mMap_Y_off));
                        this.mBen.drawCharacter(aGraphics, 1, this.mBen.struct_Player);
                        for (i = 0; i < 3; ++i) {
                            if (!this.mBen.pWeapon.struct_Weapon[i].mIsActive) continue;
                            this.mBen.pWeapon.drawCharacter(aGraphics, 1, this.mBen.pWeapon.struct_Weapon[i]);
                        }
                        break;
                    }
                }
                if (this.mBen.struct_Player.state == 0 && this.mBen.struct_Player.iCharFrameNumber == (FLASH_EFFECT_FRAME_NUMBER = (byte)(this.mBen.charAnimation.mObjAnimationsArray[this.mBen.struct_Player.state].NOFFrames - 2))) {
                    aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 65280, true);
                }
                if (!mIsScoreBoardDisplayed && !mIsAlertOn) {
                    this.drawHUD(aGraphics);
                }
                if (this.mIsPopupOn) {
                    if (SoundPlayer.mIsSoundActive && (SoundPlayer.mActiveSoundType == 2 || SoundPlayer.mActiveSoundType == 4)) {
                        this.pCommonData.mSoundPlayer.stopSound();
                    }
                    if (mCurrentLevel == 7 && mStatusOfLevel == 1) {
                        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                    }
                    this.mIsSubMenuActive = true;
                    this.drawPopupMessage(aGraphics);
                }
                if (mIsAlertOn) {
                    this.drawAlertMessage(aGraphics);
                }
                if (mIsScoreBoardDisplayed) {
                    if (SoundPlayer.mIsSoundActive && (SoundPlayer.mActiveSoundType == 2 || SoundPlayer.mActiveSoundType == 4)) {
                        this.pCommonData.mSoundPlayer.stopSound();
                    }
                    this.drawScoreBoard(aGraphics);
                }
                if (!(mIsAlertOn || mIsScoreBoardDisplayed || mIsShowSubMenu || this.mIsPopupOn || this.mDynPanActivated || this.mIsLevelOver || this.mIsGameWin || this.mIsGameOver || this.mTempTextIndex == 59 || this.mTempTextIndex == 52 || this.mIsShutterUp && !this.mIsShutterDown)) {
                    this.drawPauseIcon(aGraphics);
                }
                if (mIsShowSubMenu) {
                    if (SoundPlayer.mIsSoundActive && SoundPlayer.mActiveSoundType == 2) {
                        this.pCommonData.mSoundPlayer.stopSound();
                    }
                    int vDistanceBetweenTwoMenuLables = TextComponent.FontNormalArray_HEIGHT[1] + (TextComponent.FontNormalArray_HEIGHT[1] >> 1);
                    StateCommonData.mStartMenuIndex = (byte)32;
                    StateCommonData.mEndMenuIndex = (byte)36;
                    int vSubMenuH = vDistanceBetweenTwoMenuLables * (StateCommonData.mEndMenuIndex - StateCommonData.mStartMenuIndex + 1) + (vDistanceBetweenTwoMenuLables << 1);
                    short rectY = (short)((StateCommonData.screen_Height >> 1) - (vSubMenuH >> 1) - vDistanceBetweenTwoMenuLables);
                    short rectW = (short)(StateCommonData.screen_Width - 30);
                    short rectX = (short)((StateCommonData.screen_Width >> 1) - (rectW >> 1));
                    short rectH = (short)(vSubMenuH + (vDistanceBetweenTwoMenuLables << 1));
                    aGraphics.drawRect(rectX, rectY, rectW, rectH, 0xACCC00, true);
                    aGraphics.drawRect(rectX + 2, rectY + 2, rectW - 4, rectH - 4, 0, true);
                    StateCommonData.mLeftSoftKey = 0;
                    StateCommonData.mRightSoftKey = (byte)10;
                    this.pCommonData.paintMenuScreens(aGraphics, StateCommonData.mStartMenuIndex, StateCommonData.mEndMenuIndex, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, (byte)1);
                    int mYpos = (StateCommonData.screen_Height >> 1) - (TextComponent.FontNormalArray_HEIGHT[1] * (StateCommonData.mEndMenuIndex - StateCommonData.mStartMenuIndex + 1) >> 1) + vDistanceBetweenTwoMenuLables;
                    this.pCommonData.mTextComponent.DrawString("" + StateCommonData.mHintText[76], 0, mYpos - (vDistanceBetweenTwoMenuLables << 1), 1, 4, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
                }
                if (this.mDynPanActivated && !mIsShowSubMenu) {
                    this.pCommonData.setSoftKeys(this.pCommonData.mJDisplay, 10, 6);
                }
                if (!this.mIsDrawcheatRect) break;
                this.mIsDrawcheatRect = false;
                aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                break;
            }
            case 1: {
                aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                DrawGText vInstructionTextRect = new DrawGText();
                vInstructionTextRect.Scrolling = 0;
                vInstructionTextRect.TextBox_X = 4;
                vInstructionTextRect.TextBox_Y = StateCommonData.screen_Height >> 3;
                vInstructionTextRect.TextBox_W = StateCommonData.screen_Width - 8;
                vInstructionTextRect.TextBox_H = StateCommonData.screen_Height - (StateCommonData.screen_Height >> 3 << 1);
                this.pCommonData.paintTextScreen(aGraphics, StateCommonData.mTitleIndex, StateCommonData.mTextIndex, vInstructionTextRect, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, 1);
                vInstructionTextRect = null;
                break;
            }
            case 6: {
                this.pCommonData.paintLevelSelectionScreen(aGraphics, (byte)7);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                if (SoundPlayer.mIsSoundActive && (SoundPlayer.mActiveSoundType == 2 || SoundPlayer.mActiveSoundType == 4)) {
                    this.pCommonData.mSoundPlayer.stopSound();
                }
                if (this.imgCutScence != null) {
                    this.pCommonData.mJDisplay.drawImage(this.imgCutScence, this.mCutSceneRect.TextBox_X, this.mCutSceneRect.TextBox_Y, 0, 0, this.imgCutScence.getWidth(), this.imgCutScence.getHeight(), 0, 0);
                } else {
                    int vNumberofLines = this.pCommonData.mTextComponent.GetTextWidth(StateCommonData.mHintText[StateCommonData.mTitleIndex].toCharArray(), 1) / (StateCommonData.screen_Width - 20);
                    this.mCutSceneTextRect.TextBox_Y = (StateCommonData.screen_Height - this.pCommonData.mTextComponent.GetNormalFontHeight(1) >> 1) - (vNumberofLines * this.pCommonData.mTextComponent.GetNormalFontHeight(1) >> 1);
                }
                this.pCommonData.paintTextScreen(aGraphics, StateCommonData.mTitleIndex, StateCommonData.mTextIndex, this.mCutSceneTextRect, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, 4);
                mIsShowSubMenu = false;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                this.pCommonData.paintAlertMessageScreen(aGraphics, StateCommonData.mTextIndex, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, (byte)1);
            }
        }
        this.pCommonData.mIsLoadingOn = false;
        this.mIsLevelIntroSoundOn = true;
    }

    public void drawPopupMessage(JDisplay aGraphics) {
        aGraphics.drawRect(0, this.mPopupRect.TextBox_Y - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1) - 2 - 1, StateCommonData.screen_Width, this.mPopupRect.TextBox_H + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1) + 4 + 2, 7588100, true);
        aGraphics.drawRect(0, this.mPopupRect.TextBox_Y - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1) - 1, StateCommonData.screen_Width, this.mPopupRect.TextBox_H + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1) + 2, 0, true);
        this.pCommonData.paintTextScreen(aGraphics, StateCommonData.mTitleIndex, StateCommonData.mTextIndex, this.mPopupRect, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, 12);
    }

    public void drawGameOverMessage(JDisplay aGraphics) {
        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
        this.pCommonData.paintAlertMessageScreen(aGraphics, (byte)38, (byte)9, (byte)10, (byte)1);
    }

    public void drawScoreBoard(JDisplay aGraphics) {
        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
        int vRectHeight = (this.pCommonData.mTextComponent.GetNormalFontHeight(1) << 2) + this.pCommonData.mTextComponent.GetNormalFontHeight(0) * (this.mScoreTableStringsIndexArray.length + 1);
        int vPart1Width = this.pCommonData.mTextComponent.GetTextWidth(StateCommonData.mHintText[62].toCharArray(), 0);
        int vPart2Width = this.pCommonData.mTextComponent.GetTextWidth(" = ".toCharArray(), 0);
        int vPart3Width = this.pCommonData.mTextComponent.GetTextWidth(("" + MapObject.levelScore).toCharArray(), 0);
        int vTotalWidth = vPart1Width + vPart2Width + vPart3Width;
        int offset = (StateCommonData.screen_Width >> 1) - (vTotalWidth >> 1);
        aGraphics.drawRect((StateCommonData.screen_Width - vTotalWidth >> 1) - 2 - 1, StateCommonData.screen_Height - vRectHeight >> 1, vTotalWidth + 4 + 2, vRectHeight, 4847876, true);
        aGraphics.drawRect((StateCommonData.screen_Width - vTotalWidth >> 1) - 2, (StateCommonData.screen_Height - vRectHeight >> 1) + 1, vTotalWidth + 4, vRectHeight - 2, 0, true);
        int vUpperLineRectY = (StateCommonData.screen_Height - vRectHeight >> 1) + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) << 1);
        aGraphics.drawRect((StateCommonData.screen_Width - vTotalWidth >> 1) - 2, vUpperLineRectY, vTotalWidth + 4, 1, 4847876, true);
        int vLowerLineRectY = (StateCommonData.screen_Height - vRectHeight >> 1) + (StateCommonData.screen_Height - (StateCommonData.screen_Height - vRectHeight >> 1 << 1)) - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) << 1);
        aGraphics.drawRect((StateCommonData.screen_Width - vTotalWidth >> 1) - 2, vLowerLineRectY, vTotalWidth + 4, 1, 4847876, true);
        this.pCommonData.mTextComponent.DrawString("" + StateCommonData.mHintText[28], 0, (StateCommonData.screen_Height - vRectHeight >> 1) + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1), 1, 4, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        for (int i = 0; i < this.mScoreTableStringsIndexArray.length; i = (int)((byte)(i + 1))) {
            this.pCommonData.mTextComponent.DrawString(StateCommonData.mHintText[this.mScoreTableStringsIndexArray[i]], offset, vUpperLineRectY + ((vLowerLineRectY - vUpperLineRectY - this.mScoreTableStringsIndexArray.length * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions()) >> 1) + i * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions())), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
            this.pCommonData.mTextComponent.DrawString(" = ", offset + vPart1Width, vUpperLineRectY + ((vLowerLineRectY - vUpperLineRectY - this.mScoreTableStringsIndexArray.length * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions()) >> 1) + i * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions())), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
            this.pCommonData.mTextComponent.DrawString("" + this.mScoreTableScoreArray[i], offset + vPart1Width + vPart2Width, vUpperLineRectY + ((vLowerLineRectY - vUpperLineRectY - this.mScoreTableStringsIndexArray.length * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions()) >> 1) + i * (this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions())), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        }
        this.pCommonData.mTextComponent.DrawString(StateCommonData.mHintText[39], (StateCommonData.screen_Width - vTotalWidth >> 1) + 2 + 1 + this.pCommonData.mTextComponent.GetTextWidth("W".toCharArray(), 0), (StateCommonData.screen_Height - vRectHeight >> 1) + (StateCommonData.screen_Height - (StateCommonData.screen_Height - vRectHeight >> 1 << 1)) - this.pCommonData.mTextComponent.GetNormalFontHeight(0) - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1), 1, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.pCommonData.mTextComponent.DrawString(" = ", offset + vPart1Width, (StateCommonData.screen_Height - vRectHeight >> 1) + (StateCommonData.screen_Height - (StateCommonData.screen_Height - vRectHeight >> 1 << 1)) - this.pCommonData.mTextComponent.GetNormalFontHeight(0) - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.pCommonData.mTextComponent.DrawString("" + MapObject.levelScore, offset + vPart1Width + vPart2Width, (StateCommonData.screen_Height - vRectHeight >> 1) + (StateCommonData.screen_Height - (StateCommonData.screen_Height - vRectHeight >> 1 << 1)) - this.pCommonData.mTextComponent.GetNormalFontHeight(0) - (this.pCommonData.mTextComponent.GetNormalFontHeight(0) >> 1), 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.pCommonData.setSoftKeys(aGraphics, 9, 10);
    }

    public void scorecalculation() {
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            this.mMapObjects.mapObjectXYforScoreTable[i][2] = (short)(this.mMapObjects.mapObjectXYforScoreTable[i][0] * this.mMapObjects.mapObjectXYforScoreTable[i][1]);
        }
        this.mScoreTableScoreArray[1] = (short)(this.mMapObjects.mapObjectXYforScoreTable[2][2] + this.mMapObjects.mapObjectXYforScoreTable[3][2]);
        this.mScoreTableScoreArray[0] = (short)(this.mMapObjects.mapObjectXYforScoreTable[0][2] + this.mMapObjects.mapObjectXYforScoreTable[1][2]);
        this.mScoreTableScoreArray[2] = (short)(MapObject.levelScore - (this.mScoreTableScoreArray[1] + this.mScoreTableScoreArray[0]));
        try {
            byte MAX_UNLOCKED;
            if (this.pCommonData.mPrefs.levelScores[mCurrentLevel - 1] < MapObject.levelScore) {
                this.pCommonData.mPrefs.levelScores[BenGame.mCurrentLevel - 1] = MapObject.levelScore;
                this.mIsHighScoreAchieved = true;
            }
            if (mCurrentLevel < 7) {
                this.pCommonData.mPrefs.currentLevel = (byte)(mCurrentLevel + 1);
            }
            if (this.pCommonData.mPrefs.currentLevel > (MAX_UNLOCKED = this.pCommonData.mPrefs.Max_LevelUnLocked)) {
                this.pCommonData.mPrefs.Max_LevelUnLocked = this.pCommonData.mPrefs.currentLevel;
            }
            this.pCommonData.mPrefs.save(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawAlertMessage(JDisplay aGraphics) {
        String vTempAlertString = StateCommonData.mTextIndex == 63 ? StateCommonData.mHintText[StateCommonData.mTextIndex] + " " + (BenGame.getPlayerLifes() + 1) : StateCommonData.mHintText[StateCommonData.mTextIndex];
        if (StateCommonData.mTextIndex == 59) {
            if (StateCommonData.mGameMode == 1) {
                if (this.mIsTimerModeUnlockAlertOn) {
                    vTempAlertString = StateCommonData.mHintText[StateCommonData.mTextIndex] + StateCommonData.mHintText[79] + " " + StateCommonData.mHintText[81 + (mCurrentLevel - 1)] + " " + StateCommonData.mHintText[80];
                }
            } else if (StateCommonData.mGameMode == 0 && mCurrentLevel == this.pCommonData.mPrefs.Max_AttackLevelUnLocked) {
                vTempAlertString = StateCommonData.mHintText[StateCommonData.mTextIndex] + StateCommonData.mHintText[88];
            }
        }
        int vNoOfLinesInMessage = this.pCommonData.mTextComponent.GetNoOfLinesInString(vTempAlertString, this.pCommonData.mTextComponent.Defaultvalue);
        this.mTextRectHeight = vNoOfLinesInMessage * this.pCommonData.mTextComponent.GetNormalFontHeight(0) + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions();
        if (!mPause) {
            if (this.mIsShutterDown && !this.mIsShutterUp) {
                this.mAlertIncCounter = (short)(this.mAlertIncCounter + 24);
                if (this.mAlertIncCounter > StateCommonData.screen_Height >> 1) {
                    this.mTempTextIndex = StateCommonData.mTextIndex;
                    StateCommonData.mTextIndex = (byte)10;
                    this.mIsShutterUp = true;
                    this.mIsShutterDown = false;
                    this.mAlertIncCounter = (short)(StateCommonData.screen_Height >> 1);
                }
            } else if (this.mIsShutterUp && !this.mIsShutterDown) {
                if (this.mTempTextIndex == 59) {
                    aGraphics.drawRect(0, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0, true);
                }
                this.mAlertIncCounter = (short)(this.mAlertIncCounter - 24);
                if (this.mAlertIncCounter < 0) {
                    mIsAlertOn = false;
                    this.mAlertIncCounter = 0;
                    this.mIsShutterUp = false;
                    if (StateCommonData.mTextIndex == 10) {
                        if (StateCommonData.mGameMode == 1) {
                            if (mCurrentLevel < 7) {
                                if (mStatusOfLevel != 1) {
                                    if (this.mTempTextIndex == 59) {
                                        mStatusOfLevel = 1;
                                        this.mIsLevelOver = true;
                                    } else if (this.mTempTextIndex == 50) {
                                        this.mIsGameOver = false;
                                        if (this.mIsPopupOn || mIsAlertOn) {
                                            StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                                        }
                                        gameState = (byte)5;
                                        StateCommonData.mTextIndex = (byte)14;
                                        StateCommonData.mLeftSoftKey = (byte)2;
                                        StateCommonData.mRightSoftKey = (byte)3;
                                    } else if (bPauseGameonAlert) {
                                        if (!mIsShowSubMenu) {
                                            StateCommonData.mPreviousLeftSoftkey = StateCommonData.mLeftSoftKey;
                                            StateCommonData.mPreviousRightSoftkey = StateCommonData.mRightSoftKey;
                                            StateCommonData.mLeftSoftKey = 0;
                                            StateCommonData.mRightSoftKey = (byte)10;
                                        }
                                        this.pCommonData.mSelectedMeuIndex = 0;
                                        mIsShowSubMenu = true;
                                        mPause = true;
                                        if (SoundPlayer.mIsSoundActive) {
                                            this.pCommonData.mSoundPlayer.stopSound();
                                        }
                                        bPauseGameonAlert = false;
                                    } else {
                                        StateCommonData.mLeftSoftKey = (byte)10;
                                        StateCommonData.mRightSoftKey = (byte)10;
                                    }
                                } else if (mStatusOfLevel == 1) {
                                    this.pCommonData.mSelectedMeuIndex = mCurrentLevel;
                                    gameState = (byte)6;
                                    StateCommonData.mLeftSoftKey = 0;
                                    StateCommonData.mRightSoftKey = (byte)49;
                                    if (SoundPlayer.mIsSoundActive) {
                                        this.pCommonData.mSoundPlayer.playSound(0);
                                    }
                                }
                            } else if (this.mTempTextIndex == 50) {
                                this.mIsGameOver = false;
                                if (this.mIsPopupOn || mIsAlertOn) {
                                    StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                                }
                                gameState = (byte)5;
                                StateCommonData.mTextIndex = (byte)14;
                                StateCommonData.mLeftSoftKey = (byte)2;
                                StateCommonData.mRightSoftKey = (byte)3;
                            } else if (this.mTempTextIndex == 51) {
                                this.resetLevelVariables();
                                this.resetMapVariables();
                                this.switchToState(6, true);
                                this.pCommonData.mMenuState = 1;
                                this.pCommonData.mSelectedMeuIndex = 0;
                                StateCommonData.mLeftSoftKey = (byte)10;
                                StateCommonData.mRightSoftKey = (byte)49;
                            } else if (mStatusOfLevel == 1) {
                                StateCommonData.mTextIndex = (byte)51;
                                StateCommonData.mLeftSoftKey = (byte)9;
                                StateCommonData.mRightSoftKey = (byte)10;
                                mIsAlertOn = true;
                            }
                        } else if (StateCommonData.mGameMode == 0) {
                            if (this.mIsGameOver) {
                                this.mIsGameOver = false;
                                if (this.mIsPopupOn || mIsAlertOn) {
                                    StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                                }
                                gameState = (byte)5;
                                StateCommonData.mTextIndex = (byte)14;
                                StateCommonData.mLeftSoftKey = (byte)2;
                                StateCommonData.mRightSoftKey = (byte)3;
                            } else if (this.mTempTextIndex == 59) {
                                mStatusOfLevel = 1;
                                this.mIsLevelOver = true;
                                if (mCurrentLevel < 7) {
                                    if (this.pCommonData.mPrefs.currentLevel < this.pCommonData.mPrefs.Max_AttackLevelUnLocked) {
                                        this.pCommonData.mPrefs.currentLevel = (byte)(mCurrentLevel + 1);
                                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mPrefs.currentLevel - 1);
                                        try {
                                            this.pCommonData.mPrefs.save(false);
                                        }
                                        catch (Exception e) {}
                                    } else if (this.pCommonData.mPrefs.currentLevel == this.pCommonData.mPrefs.Max_AttackLevelUnLocked) {
                                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mPrefs.currentLevel - 1);
                                    }
                                } else {
                                    this.pCommonData.mSelectedMeuIndex = (byte)6;
                                }
                                gameState = (byte)6;
                                StateCommonData.mLeftSoftKey = 0;
                                StateCommonData.mRightSoftKey = (byte)49;
                                if (SoundPlayer.mIsSoundActive) {
                                    this.pCommonData.mSoundPlayer.playSound(0);
                                }
                            } else if (this.mTempTextIndex == 77) {
                                mPause = false;
                                gameState = 0;
                                this.resetMapVariables();
                                this.switchToState(6, true);
                                this.pCommonData.mMenuState = 0;
                                StateCommonData.mStartMenuIndex = (byte)17;
                                StateCommonData.mEndMenuIndex = (byte)22;
                                StateCommonData.mLeftSoftKey = 0;
                                StateCommonData.mRightSoftKey = (byte)10;
                                this.pCommonData.mSelectedMeuIndex = 0;
                                if (SoundPlayer.mIsSoundActive) {
                                    this.pCommonData.mSoundPlayer.playSound(0);
                                }
                            } else if (bPauseGameonAlert) {
                                if (!mIsShowSubMenu) {
                                    StateCommonData.mPreviousLeftSoftkey = StateCommonData.mLeftSoftKey;
                                    StateCommonData.mPreviousRightSoftkey = StateCommonData.mRightSoftKey;
                                    StateCommonData.mLeftSoftKey = 0;
                                    StateCommonData.mRightSoftKey = (byte)10;
                                }
                                this.pCommonData.mSelectedMeuIndex = 0;
                                mIsShowSubMenu = true;
                                mPause = true;
                                if (SoundPlayer.mIsSoundActive) {
                                    this.pCommonData.mSoundPlayer.stopSound();
                                }
                                bPauseGameonAlert = false;
                            } else {
                                this.pCommonData.TimeDuration = 0L;
                                StateCommonData.mLeftSoftKey = (byte)10;
                                StateCommonData.mRightSoftKey = (byte)10;
                            }
                        }
                    }
                }
            } else {
                this.mAlertIncCounter = (short)(this.mAlertIncCounter + 24);
                if (this.mAlertIncCounter > (StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1) - this.pCommonData.mTextComponent.GetNormalFontHeight(0)) {
                    this.mAlertIncCounter = (short)((StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1) - this.pCommonData.mTextComponent.GetNormalFontHeight(0));
                }
            }
        }
        if (this.mAlertIncCounter >= (short)((StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1) - this.pCommonData.mTextComponent.GetNormalFontHeight(0))) {
            aGraphics.drawRect(0, (StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1) - this.pCommonData.mTextComponent.GetNormalFontHeight(0), StateCommonData.screen_Width, this.mTextRectHeight + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) << 1), 0, true);
        }
        aGraphics.drawRect(0, 0, StateCommonData.screen_Width, this.mAlertIncCounter, 0, true);
        aGraphics.drawRect(0, StateCommonData.screen_Height - this.mAlertIncCounter, StateCommonData.screen_Width, this.mAlertIncCounter, 0, true);
        aGraphics.drawRect(0, this.mAlertIncCounter, StateCommonData.screen_Width, 1, 39168, true);
        aGraphics.drawRect(0, StateCommonData.screen_Height - this.mAlertIncCounter, StateCommonData.screen_Width, 1, 39168, true);
        this.pCommonData.mTextComponent.DrawString(vTempAlertString, 0, (StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1), 0, 4, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        if (!this.mIsShutterUp || this.mIsShutterDown) {
            if (StateCommonData.mTextIndex == 52) {
                this.pCommonData.setSoftKeys(aGraphics, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey);
            } else if (this.mTempTextIndex != 59 && this.mTempTextIndex != 52) {
                this.pCommonData.setSoftKeys(aGraphics, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey);
            } else if (this.mTempTextIndex == 52 && mIsAlertOn) {
                this.pCommonData.setSoftKeys(aGraphics, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey);
            }
        }
    }

    public void drawHUD(JDisplay aGraphics) {
        byte minutes = (byte)(this.pCommonData.TimeElapsed / 1000L / 60L);
        byte seconds = (byte)(this.pCommonData.TimeElapsed / 1000L % 60L);
        short Player_health = this.mDpsInfo.getPlayerHealth();
        if (Player_health > 0 && Player_health * 70 / this.mDpsInfo.mPlayerMaxHealth == 0) {
            Player_health = this.mDpsInfo.mPlayerMinHealth;
            this.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = this.mDpsInfo.mPlayerMinHealth;
        }
        short vBarW = (short)(Player_health * 70 / this.mDpsInfo.mPlayerMaxHealth);
        aGraphics.drawImage(this.mHudImage, 0, 0, 0, 0, 213, 27, 0, 1);
        for (byte i = 0; i <= BenGame.getPlayerLifes(); i = (byte)(i + 1)) {
            aGraphics.drawImage(this.mHudImage, 31 + i * 7, 10, 213, 6, 6, 6, 0, 1);
        }
        aGraphics.drawRect(72, 4, vBarW, 1, 0xFF5555, true);
        aGraphics.drawRect(72, 5, vBarW, 1, 0xFF0000, true);
        aGraphics.drawRect(72, 6, vBarW, 1, 0xEE0909, true);
        this.pCommonData.mTextComponent.DrawString("" + MapObject.levelScore, 154, 5, 0, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        if (StateCommonData.mGameMode == 0) {
            aGraphics.drawImage(this.mHudTimeModePartImage, 51, 13, 0, 0, this.mHudTimeModePartImage.getWidth(), this.mHudTimeModePartImage.getHeight(), 0, 1);
            this.pCommonData.mTextComponent.DrawString("" + StateCommonData.mHintText[75] + "-", 59, 10, 1, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)1);
            String vSecondsString = "";
            vSecondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            this.pCommonData.mTextComponent.DrawString("" + minutes + ":" + vSecondsString, 59 + this.pCommonData.mTextComponent.GetTextWidth((StateCommonData.mHintText[75] + "-").toCharArray(), 1), 10, 1, 1, this.pCommonData.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        }
    }

    public void doPlayerHurtEffect(JDisplay aGraphics) {
        if (this.mIsBlink) {
            this.mIsBlink = false;
        } else if (!this.mIsBlink) {
            this.mIsBlink = true;
        }
        if (this.mIsBlink) {
            aGraphics.drawRect(0, 0, StateCommonData.screen_Width, 2, 0xFF0000, true);
            aGraphics.drawRect(0, StateCommonData.screen_Height - 2, StateCommonData.screen_Width, StateCommonData.screen_Height, 0xFF0000, true);
            aGraphics.drawRect(0, 0, 2, StateCommonData.screen_Height, 0xFF0000, true);
            aGraphics.drawRect(StateCommonData.screen_Width - 2, 0, StateCommonData.screen_Width, StateCommonData.screen_Height, 0xFF0000, true);
        }
    }

    public void platformCollisionChk() {
        int col;
        int row;
        byte bounds;
        this.mCollisionIndex = 0;
        this.mCollisionIndex = this.mMap.CheckCollision(this.mBen.struct_Player.CurrentAnimFrameRect, this.mBen.struct_Player.NextAnimFrameRect, this.mBen.struct_Player.mIsCharacterFlipped, (byte)0);
        this.mBen.mPlayerScriptIndex = this.mMap.getScriptIndex();
        this.mBen.updateAnimPosition(this.mBen.struct_Player);
        boolean tocheckScript = false;
        if (this.mBen.struct_Player.state != 7 && this.mBen.struct_Player.state != 16 && this.mBen.struct_Player.state != 18 && this.mBen.struct_Player.state != 19 && this.mBen.struct_Player.state != 28 && this.mBen.struct_Player.state != 29 && this.mBen.struct_Player.state != 22 && this.mBen.struct_Player.state != 20) {
            tocheckScript = true;
        }
        if ((this.mBen.struct_Player.state == 1 || this.mBen.struct_Player.state == 2 || this.mBen.struct_Player.state == 24 || this.mBen.struct_Player.state == 25 || this.mBen.struct_Player.state == 26) && Player.mHeroType != 2) {
            tocheckScript = false;
        }
        int vTileRow = (this.mBen.struct_Player.CurrentAnimFrameRect.y + this.mBen.struct_Player.CurrentAnimFrameRect.dy) / 12;
        int vTileCol = this.mBen.struct_Player.CurrentAnimFrameRect.x / 12;
        if ((this.mBen.mPlayerScriptIndex == 5 || this.mBen.mPlayerScriptIndex == 10 || this.mBen.mPlayerScriptIndex == 3 && MapObject.mLeverPressed) && tocheckScript && this.mMap.Tile_Scipt_Rect.y > this.mBen.struct_Player.CurrentAnimFrameRect.y + this.mBen.struct_Player.CurrentAnimFrameRect.dy - this.mBen.struct_Player.CurrentAnimFrameRect.dy / 4 && ((Player.mHeroType == 3 || Player.mHeroType == 0 || Player.mHeroType == 2) && this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx > this.mBen.struct_Player.CurrentAnimFrameRect.x + (this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber) >> 1) || Player.mHeroType == 1 && this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx > this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber) / 3)) {
            this.mBen.struct_Player.state = (byte)20;
            this.mBen.struct_Player.iCharFrameNumber = 0;
            this.mBen.updateNextFrame();
            this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
            this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
            this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
            if (this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.CurrentAnimFrameRect.dx > this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx) {
                this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx - this.mBen.struct_Player.CurrentAnimFrameRect.dx;
            }
        } else if ((this.mBen.mPlayerScriptIndex == 6 || this.mBen.mPlayerScriptIndex == 1 && Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][vTileCol + 1]) == 6 || this.mBen.mPlayerScriptIndex == 11 || this.mBen.mPlayerScriptIndex == 4 && MapObject.mLeverPressed) && tocheckScript && this.mMap.Tile_Scipt_Rect.y > this.mBen.struct_Player.CurrentAnimFrameRect.y + this.mBen.struct_Player.CurrentAnimFrameRect.dy - (this.mBen.struct_Player.CurrentAnimFrameRect.dy >> 2) && ((Player.mHeroType == 3 || Player.mHeroType == 0 || Player.mHeroType == 2) && this.mMap.Tile_Scipt_Rect.x < this.mBen.struct_Player.CurrentAnimFrameRect.x + (this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber) >> 1) || Player.mHeroType == 1 && this.mMap.Tile_Scipt_Rect.x < this.mBen.struct_Player.CurrentAnimFrameRect.x + (this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber) << 1) / 3)) {
            this.mBen.struct_Player.state = (byte)20;
            this.mBen.struct_Player.iCharFrameNumber = 0;
            this.mBen.updateNextFrame();
            this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
            this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
            this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
            if (this.mBen.struct_Player.CurrentAnimFrameRect.x < this.mMap.Tile_Scipt_Rect.x) {
                this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x;
            }
        } else {
            if ((this.mCollisionIndex & 1) == 1) {
                if (this.mBen.struct_Player.state == 20 || this.mBen.struct_Player.state == 8 || this.mBen.struct_Player.state == 19 || this.mBen.struct_Player.state == 29) {
                    if (this.mBen.struct_Player.state == 8) {
                        this.mBen.struct_Player.CurrentAnimFrameRect.x = !this.mBen.struct_Player.mIsCharacterFlipped ? this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.NextAnimFrameRect.dx - this.mBen.charAnimation.mObjAnimationsArray[6].AnimationFrames[0].FrameWidth : this.mBen.struct_Player.CurrentAnimFrameRect.x;
                    } else if (this.mBen.struct_Player.state == 19 || this.mBen.struct_Player.state == 29) {
                        int vNextFrameNumber;
                        for (int i = vNextFrameNumber = this.mBen.struct_Player.iCharFrameNumber + 1; i < this.mBen.charAnimation.mObjAnimationsArray[this.mBen.struct_Player.state].NOFFrames; ++i) {
                            ++this.mBen.struct_Player.iCharFrameNumber;
                            this.mBen.struct_Player.mIsAnimPosUpdated = false;
                            this.mBen.updateAnimPosition(this.mBen.struct_Player);
                        }
                    }
                    this.mBen.struct_Player.iCharFrameNumber = 1;
                    if (Player.mHeroType == 1) {
                        if (this.mBen.struct_Player.state == 19 || this.mBen.struct_Player.state == 29) {
                            this.mBen.struct_Player.iCharFrameNumber = 0;
                            this.mBen.struct_Player.state = (byte)21;
                        } else {
                            this.mBen.struct_Player.state = (byte)17;
                        }
                    } else {
                        this.mBen.struct_Player.state = this.mBen.struct_Player.state == 19 ? (byte)21 : (byte)17;
                    }
                    this.mBen.updateNextFrame();
                    this.mBen.struct_Player.mIsAnimPosUpdated = false;
                    this.mBen.updateAnimPosition(this.mBen.struct_Player);
                    this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Y_Cordinate.y - this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                }
            } else if ((this.mCollisionIndex & 1) != 1) {
                if (Player.mHeroType == 3) {
                    if (this.mBen.struct_Player.state == 6) {
                        this.mBen.struct_Player.state = (byte)20;
                        this.mBen.struct_Player.iCharFrameNumber = 1;
                    }
                } else if (this.mBen.struct_Player.state == 17 || this.mBen.struct_Player.state == 6) {
                    this.mBen.struct_Player.state = (byte)20;
                    this.mBen.struct_Player.iCharFrameNumber = 1;
                }
            }
            if ((this.mCollisionIndex & 4) == 4 && (this.mBen.struct_Player.state == 7 || this.mBen.struct_Player.state == 28 || this.mBen.struct_Player.state == 18) && this.mBen.struct_Player.CurrentAnimFrameRect.y < this.mMap.Tile_Y_Cordinate.y) {
                this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Y_Cordinate.y;
            }
        }
        if (!((this.mCollisionIndex & 2) != 2 || this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.state == 16 || this.mBen.struct_Player.state == 18 || this.mBen.struct_Player.state == 19 || (this.mBen.struct_Player.state == 22 || Player.mHeroType != 3) && Player.mHeroType == 3 || (this.mBen.struct_Player.state == 26 || Player.mHeroType == 2) && Player.mHeroType != 2 || (bounds = Map.getSecondByte(Map.MapData.MapBoundArray[(row = this.mMap.Tile_X_Cordinate.y / 12) + 1][col = this.mMap.Tile_X_Cordinate.x / 12])) >= 15 || (bounds & 2) != 2 && this.mBen.struct_Player.CurrentAnimFrameRect.y >= this.mMap.Tile_X_Cordinate.y + 12 || this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.NextAnimFrameRect.dx <= this.mMap.Tile_X_Cordinate.x)) {
            this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_X_Cordinate.x - this.mBen.struct_Player.NextAnimFrameRect.dx;
        }
        if ((this.mCollisionIndex & 8) == 8 && this.mBen.struct_Player.mIsCharacterFlipped && this.mBen.struct_Player.state != 16 && this.mBen.struct_Player.state != 18 && this.mBen.struct_Player.state != 19 && (this.mBen.struct_Player.state != 22 && Player.mHeroType == 3 || Player.mHeroType != 3) && (this.mBen.struct_Player.state != 26 && Player.mHeroType != 2 || Player.mHeroType == 2)) {
            row = this.mMap.Tile_X_Cordinate.y / 12;
            col = this.mMap.Tile_X_Cordinate.x / 12;
            bounds = 0;
            bounds = Map.getSecondByte(Map.MapData.MapBoundArray[row + 1][col]);
            if (bounds < 15 && ((bounds & 8) == 8 || this.mBen.struct_Player.CurrentAnimFrameRect.y < this.mMap.Tile_X_Cordinate.y + 12) && this.mBen.struct_Player.CurrentAnimFrameRect.x < this.mMap.Tile_X_Cordinate.x) {
                this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_X_Cordinate.x;
            }
        }
    }

    public void resetPlayerProps() {
        this.mCollisionEffect = false;
        this.toshowCollisionEffect = 0;
        Player.sIsPlayerAnimationStopped = false;
        this.mBen.struct_Player.mIsCharacterFlipped = false;
        this.mBen.initPlayer(mCurrentLevel);
        BenGame.setPlayerLifes((byte)(BenGame.getPlayerLifes() - 1));
        this.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = this.mDpsInfo.mPlayerMaxHealth;
    }

    protected void keyHit(int keyCode) {
        if (this.mKeyControl) {
            if (!(gameState != 0 || mPause || mIsAlertOn || this.mIsPopupOn || mIsShowSubMenu || mIsScoreBoardDisplayed || this.mDpsInfo.getPlayerHealth() <= 0 || this.mBen.mPlayerScriptIndex == 9)) {
                this.mIskeyPressedOnce = true;
                this.mIskeyReleased = false;
                this.mBen.KEYPRESS_Ben(keyCode);
            }
            switch (keyCode) {
                case -6: 
                case -5: 
                case 53: {
                    switch (gameState) {
                        case 3: {
                            this.pCommonData.mTextComponent.reset();
                            for (int i = 0; i < DeviceConstants.gameMsgsDecisionArray.length; ++i) {
                                if (DeviceConstants.gameMsgsDecisionArray[i][2] == mStatusOfLevel && DeviceConstants.gameMsgsDecisionArray[i][0] == mCurrentLevel && DeviceConstants.gameMsgsDecisionArray[i][1] == 0) {
                                    if (DeviceConstants.gameMsgsDecisionArray[i][4] != 1) continue;
                                    ++this.mInBetweenCutScenceNumber;
                                    DeviceConstants.gameMsgsDecisionArray[i][4] = 0;
                                    mAnimationType = DeviceConstants.gameMsgsDecisionArray[i][6];
                                    StateCommonData.mTitleIndex = (byte)10;
                                    StateCommonData.mTextIndex = DeviceConstants.gameMsgsDecisionArray[i][3];
                                    StateCommonData.mLeftSoftKey = (byte)9;
                                    StateCommonData.mRightSoftKey = 1;
                                    break;
                                }
                                if (i > DeviceConstants.gameMsgsDecisionArray.length - 1) continue;
                                if (DeviceConstants.gameMsgsDecisionArray[i][0] == mCurrentLevel && DeviceConstants.gameMsgsDecisionArray[i][2] != mStatusOfLevel && DeviceConstants.gameMsgsDecisionArray[i][1] == 0) {
                                    if (this.mInBetweenCutScenceNumber >= this.mMaxCutScenceinOneLevel - 1) continue;
                                    ++this.mInBetweenCutScenceNumber;
                                    if (!DeviceConstants.CutsceneImages[DeviceConstants.gameMsgsDecisionArray[i][0] - 1][this.mInBetweenCutScenceNumber].equals(mEmptyString)) {
                                        this.imgCutScence = new JImage();
                                        this.imgCutScence.load(DeviceConstants.CutsceneImages[DeviceConstants.gameMsgsDecisionArray[i][0] - 1][this.mInBetweenCutScenceNumber], null);
                                    } else {
                                        this.imgCutScence = null;
                                    }
                                    gameState = 0;
                                    mPause = false;
                                    if (!SoundPlayer.mIsSoundActive) break;
                                    this.pCommonData.mSoundPlayer.stopSound();
                                    break;
                                }
                                if (this.mInBetweenCutScenceNumber < this.mMaxCutScenceinOneLevel - 1) continue;
                                gameState = 0;
                                mPause = false;
                                if (SoundPlayer.mIsSoundActive) {
                                    this.pCommonData.mSoundPlayer.stopSound();
                                }
                                this.unloadCutsceneResource();
                                break;
                            }
                            mIsShowSubMenu = false;
                            this.mIsSubMenuActive = true;
                            break;
                        }
                        case 6: {
                            if (StateCommonData.mGameMode == 1) {
                                for (byte i = (byte)(DeviceConstants.gameMsgsDecisionArray.length - 1); i >= 0; i = (byte)(i - 1)) {
                                    DeviceConstants.gameMsgsDecisionArray[i][4] = 1;
                                }
                            }
                            gameState = (byte)2;
                            break;
                        }
                        case 0: {
                            if (this.mIsPopupOn && !mIsShowSubMenu) {
                                this.pCommonData.mTextComponent.reset();
                                this.mIsPopupOn = false;
                                mPause = false;
                                this.mIsSubMenuActive = true;
                                break;
                            }
                            if (mIsScoreBoardDisplayed) {
                                mIsScoreBoardDisplayed = false;
                                if (this.mIsHighScoreAchieved) {
                                    this.mIsHighScoreAchieved = false;
                                    mIsAlertOn = true;
                                    StateCommonData.mTextIndex = (byte)52;
                                    StateCommonData.mLeftSoftKey = (byte)9;
                                    StateCommonData.mRightSoftKey = (byte)10;
                                    break;
                                }
                                if (mCurrentLevel < 7) {
                                    this.pCommonData.mSelectedMeuIndex = mCurrentLevel;
                                    gameState = (byte)6;
                                    StateCommonData.mLeftSoftKey = 0;
                                    StateCommonData.mRightSoftKey = (byte)49;
                                    if (!SoundPlayer.mIsSoundActive) break;
                                    this.pCommonData.mSoundPlayer.playSound(0);
                                    break;
                                }
                                mIsAlertOn = true;
                                StateCommonData.mTextIndex = (byte)51;
                                StateCommonData.mLeftSoftKey = (byte)9;
                                StateCommonData.mRightSoftKey = (byte)10;
                                break;
                            }
                            if (mIsAlertOn && !mIsShowSubMenu && !this.mIsShutterUp && this.mAlertIncCounter >= (StateCommonData.screen_Height >> 1) - (this.mTextRectHeight >> 1) - this.pCommonData.mTextComponent.GetNormalFontHeight(0)) {
                                this.mIsShutterDown = true;
                                bPauseGameonAlert = false;
                                break;
                            }
                            if (!(mIsShowSubMenu || mIsAlertOn || mPause || this.mDynPanActivated || this.mIsExitScriptCaught)) {
                                if (keyCode == 53 || keyCode == -5) {
                                    return;
                                }
                                mPause = true;
                                this.pCommonData.mSelectedMeuIndex = 0;
                                StateCommonData.mLeftSoftKey = 0;
                                StateCommonData.mRightSoftKey = (byte)10;
                                mIsShowSubMenu = true;
                                if (!SoundPlayer.mIsSoundActive) break;
                                this.pCommonData.mSoundPlayer.stopSound();
                                break;
                            }
                            if (!mIsShowSubMenu) break;
                            this.handleSubMenu();
                            break;
                        }
                        case 5: {
                            if (keyCode == 53 || keyCode == -5) {
                                return;
                            }
                            if (mIsShowSubMenu) {
                                if (this.pCommonData.mSelectedMeuIndex == 1) {
                                    StateCommonData.mPaintLoadingScreen = true;
                                    this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
                                    this.pCommonData.mloadingCounter = 0;
                                    this.pCommonData.mStateCounter = (byte)102;
                                    mIsShowSubMenu = false;
                                    mPause = false;
                                    break;
                                }
                                if (this.pCommonData.mSelectedMeuIndex == 4) {
                                    mPause = false;
                                    gameState = 0;
                                    this.resetMapVariables();
                                    this.switchToState(6, true);
                                    this.pCommonData.mMenuState = 0;
                                    StateCommonData.mStartMenuIndex = (byte)17;
                                    StateCommonData.mEndMenuIndex = (byte)22;
                                    StateCommonData.mLeftSoftKey = 0;
                                    StateCommonData.mRightSoftKey = (byte)10;
                                    this.pCommonData.mSelectedMeuIndex = 0;
                                    if (!SoundPlayer.mIsSoundActive) break;
                                    this.pCommonData.mSoundPlayer.playSound(0);
                                    break;
                                }
                                StateCommonData.mPaintLoadingScreen = true;
                                this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
                                this.pCommonData.mloadingCounter = 0;
                                this.pCommonData.mStateCounter = (byte)103;
                                break;
                            }
                            this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
                            StateCommonData.mPaintLoadingScreen = true;
                            this.pCommonData.mloadingCounter = 0;
                            this.pCommonData.mStateCounter = (byte)104;
                        }
                    }
                    break;
                }
                case -7: {
                    if (gameState == 0) {
                        if (this.mDynPanActivated && !mIsShowSubMenu) {
                            int i;
                            int vPanDiffY;
                            int vPanDiffX;
                            if (keyCode == 53 || keyCode == -5) {
                                return;
                            }
                            this.resetDynamicPanVariable();
                            if (this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].isActive) {
                                this.setMapXY(this.mDynamicStartPosX, this.mDynamicStartPosY);
                                vPanDiffX = this.mBen.getCharacterXOnCanvas(this.mBen.struct_Player) - this.mDynamicStartPosX;
                                vPanDiffY = this.mBen.getCharacterYOnCanvas(this.mBen.struct_Player) - this.mDynamicStartPosY;
                                this.mBen.setCharacterXOnCanvas(this.mBen.getCharacterXOnCanvas(this.mBen.struct_Player) + vPanDiffX, this.mBen.struct_Player);
                                this.mBen.setCharacterYOnCanvas(this.mBen.getCharacterYOnCanvas(this.mBen.struct_Player) + vPanDiffY, this.mBen.struct_Player);
                            } else {
                                if (this.mDynamicDestPosY + StateCommonData.screen_Height >= Map.MAP_HIG) {
                                    this.mDynamicDestPosY = Map.MAP_HIG - StateCommonData.screen_Height;
                                }
                                this.setMapXY(this.mDynamicDestPosX, this.mDynamicDestPosY);
                                vPanDiffX = this.mBen.getCharacterXOnCanvas(this.mBen.struct_Player) - this.mDynamicDestPosX;
                                vPanDiffY = this.mBen.getCharacterYOnCanvas(this.mBen.struct_Player) - this.mDynamicDestPosY;
                                this.mBen.setCharacterXOnCanvas(this.mBen.getCharacterXOnCanvas(this.mBen.struct_Player) + vPanDiffX, this.mBen.struct_Player);
                                this.mBen.setCharacterYOnCanvas(this.mBen.getCharacterYOnCanvas(this.mBen.struct_Player) + vPanDiffY, this.mBen.struct_Player);
                            }
                            if (mCurrentLevel == 5 || mCurrentLevel == 7) {
                                this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].animId = (byte)27;
                                this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].current_frame = 0;
                                for (i = 0; i < 6; ++i) {
                                    short[] sArray = Map.MapData.MapBoundArray[this.mDynTileRow + i];
                                    int n = this.mDynTileCol;
                                    sArray[n] = (short)(sArray[n] & 0xFF00);
                                }
                            } else {
                                if (mCurrentLevel != 6) break;
                                this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].animId = (byte)29;
                                this.mMapObjects.pMapLayerInfo[0][this.mDestMapObjectId].current_frame = 0;
                                for (i = 0; i < 6; ++i) {
                                    short[] sArray = Map.MapData.MapBoundArray[this.mDynTileRow];
                                    int n = this.mDynTileCol + i;
                                    sArray[n] = (short)(sArray[n] & 0xFF00);
                                }
                            }
                        } else {
                            if (!this.mIsPopupOn || StateCommonData.mRightSoftKey != 6 || mIsShowSubMenu) break;
                            this.mIsPopupOn = false;
                            mPause = false;
                            for (int i = DeviceConstants.gameMsgsDecisionArray.length - 1; i > 0; --i) {
                                if (DeviceConstants.gameMsgsDecisionArray[i][0] != mCurrentLevel || DeviceConstants.gameMsgsDecisionArray[i][2] != mStatusOfLevel || DeviceConstants.gameMsgsDecisionArray[i][1] != 1) continue;
                                DeviceConstants.gameMsgsDecisionArray[i][4] = 0;
                            }
                        }
                        break;
                    }
                    if (gameState == 1) {
                        if (this.mIsPopupOn || mIsAlertOn) {
                            StateCommonData.mTextIndex = StateCommonData.mPreviousTextIndex;
                        }
                        gameState = 0;
                        StateCommonData.mTitleIndex = (byte)10;
                        this.pCommonData.mTextComponent.reset();
                        break;
                    }
                    if (gameState == 5) {
                        if (StateCommonData.mTextIndex == 14) {
                            StateCommonData.mTitleIndex = (byte)10;
                            mPause = false;
                            gameState = 0;
                            this.resetMapVariables();
                            this.switchToState(6, true);
                            this.pCommonData.mMenuState = 0;
                            StateCommonData.mStartMenuIndex = (byte)17;
                            StateCommonData.mEndMenuIndex = (byte)22;
                            StateCommonData.mLeftSoftKey = 0;
                            StateCommonData.mRightSoftKey = (byte)10;
                            this.pCommonData.mSelectedMeuIndex = 0;
                            if (!SoundPlayer.mIsSoundActive) break;
                            this.pCommonData.mSoundPlayer.playSound(0);
                            break;
                        }
                        if (this.mIsPopupOn || mIsAlertOn) {
                            StateCommonData.mTextIndex = StateCommonData.mPreviousTextIndex;
                        }
                        gameState = 0;
                        break;
                    }
                    if (gameState != 6) break;
                    mPause = false;
                    gameState = 0;
                    this.resetMapVariables();
                    this.switchToState(6, true);
                    this.pCommonData.mMenuState = 0;
                    StateCommonData.mStartMenuIndex = (byte)17;
                    StateCommonData.mEndMenuIndex = (byte)22;
                    StateCommonData.mLeftSoftKey = 0;
                    StateCommonData.mRightSoftKey = (byte)10;
                    this.pCommonData.mSelectedMeuIndex = 0;
                    if (!SoundPlayer.mIsSoundActive) break;
                    this.pCommonData.mSoundPlayer.playSound(0);
                    break;
                }
                case 49: {
                    break;
                }
                case 51: {
                    break;
                }
                case 55: {
                    break;
                }
                case 57: {
                    break;
                }
                case -4: 
                case 54: {
                    if (gameState != 6) break;
                    this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                    byte MAX_UNLOCKED = this.pCommonData.mPrefs.Max_LevelUnLocked;
                    if (StateCommonData.mGameMode == 0) {
                        MAX_UNLOCKED = this.pCommonData.mPrefs.Max_AttackLevelUnLocked;
                    }
                    if (MAX_UNLOCKED - 1 >= this.pCommonData.mSelectedMeuIndex) break;
                    this.pCommonData.mSelectedMeuIndex = (byte)(MAX_UNLOCKED - 1);
                    break;
                }
                case -3: 
                case 52: {
                    if (gameState != 6) break;
                    this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                    if (0 <= this.pCommonData.mSelectedMeuIndex) break;
                    this.pCommonData.mSelectedMeuIndex = 0;
                    break;
                }
                case -1: 
                case 50: {
                    if (gameState == 0) {
                        if (mPause && mIsShowSubMenu) {
                            this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                            if (0 > this.pCommonData.mSelectedMeuIndex) {
                                this.pCommonData.mSelectedMeuIndex = (byte)4;
                            }
                        }
                        if (!this.mIsPopupOn || mIsShowSubMenu) break;
                        this.pCommonData.mTextComponent.ScrollUp();
                        break;
                    }
                    if (gameState != 1 && gameState != 3) break;
                    this.pCommonData.mTextComponent.ScrollUp();
                    break;
                }
                case -2: 
                case 56: {
                    if (gameState == 0) {
                        if (mPause && mIsShowSubMenu) {
                            this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                            if (4 < this.pCommonData.mSelectedMeuIndex) {
                                this.pCommonData.mSelectedMeuIndex = 0;
                            }
                        }
                        if (!this.mIsPopupOn || mIsShowSubMenu) break;
                        this.pCommonData.mTextComponent.ScrollDown();
                        break;
                    }
                    if (gameState != 1 && gameState != 3) break;
                    this.pCommonData.mTextComponent.ScrollDown();
                    break;
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -4: 
            case 54: {
                break;
            }
            case -3: 
            case 52: {
                break;
            }
            case -1: 
            case 50: {
                break;
            }
        }
        if (!(gameState != 0 || mPause || mIsAlertOn || this.mIsPopupOn || mIsShowSubMenu || mIsScoreBoardDisplayed || this.mDpsInfo.getPlayerHealth() <= 0 || this.mBen.mPlayerScriptIndex == 9)) {
            this.mIskeyPressedOnce = false;
            this.mIskeyReapeated = true;
            this.mIskeyReleased = false;
            this.ActivatekeyBen();
            if (toCallKeyPressBen) {
                this.mBen.KEYPRESS_Ben(keyCode);
            }
        }
    }

    public void ActivatekeyBen() {
        if (!toCallKeyPressBen) {
            boolean activateKeys = true;
            for (int i = 0; i < DeviceConstants.gameMsgsDecisionArray.length; ++i) {
                if (DeviceConstants.gameMsgsDecisionArray[i][0] != mCurrentLevel || DeviceConstants.gameMsgsDecisionArray[i][2] != 0 || DeviceConstants.gameMsgsDecisionArray[i][4] != 1) continue;
                activateKeys = false;
                break;
            }
            if (activateKeys) {
                toCallKeyPressBen = true;
            }
        }
    }

    protected void keyReleased(int aKeyCode) {
        if (this.mKeyControl) {
            this.mIskeyPressedOnce = false;
            this.mIskeyReapeated = false;
            this.mIskeyReleased = true;
        }
    }

    public void handleSubMenu() {
        switch (this.pCommonData.mSelectedMeuIndex) {
            case 0: {
                if (this.mIsPopupOn) {
                    StateCommonData.mLeftSoftKey = StateCommonData.mPreviousLeftSoftkey;
                    StateCommonData.mRightSoftKey = StateCommonData.mPreviousRightSoftkey;
                }
                mIsShowSubMenu = false;
                if (this.mIsPopupOn || mIsAlertOn) break;
                mPause = false;
                break;
            }
            case 1: {
                if (this.mIsPopupOn || mIsAlertOn) {
                    StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                }
                gameState = (byte)5;
                StateCommonData.mTextIndex = (byte)64;
                StateCommonData.mLeftSoftKey = (byte)2;
                StateCommonData.mRightSoftKey = (byte)3;
                break;
            }
            case 2: {
                boolean bl = SoundPlayer.mIsSoundActive = !SoundPlayer.mIsSoundActive;
                if (SoundPlayer.mIsSoundActive) {
                    this.pCommonData.mSoundPlayer.playSound(1);
                    break;
                }
                this.pCommonData.mSoundPlayer.stopSound();
                break;
            }
            case 3: {
                if (this.mIsPopupOn || mIsAlertOn) {
                    StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                }
                gameState = 1;
                StateCommonData.mTitleIndex = (byte)23;
                StateCommonData.mTextIndex = (byte)30;
                StateCommonData.mLeftSoftKey = (byte)10;
                StateCommonData.mRightSoftKey = 1;
                this.pCommonData.mTextComponent.reset();
                break;
            }
            case 4: {
                if (this.mIsPopupOn || mIsAlertOn) {
                    StateCommonData.mPreviousTextIndex = StateCommonData.mTextIndex;
                }
                gameState = (byte)5;
                StateCommonData.mTextIndex = (byte)16;
                StateCommonData.mLeftSoftKey = (byte)2;
                StateCommonData.mRightSoftKey = (byte)3;
            }
        }
    }

    public void setkeyControl(boolean aControl) {
        this.mKeyControl = aControl;
    }

    public boolean getkeyControl() {
        return this.mKeyControl;
    }

    public void loadGameResources() {
        if (this.mHudImage == null) {
            this.mHudImage = new JImage();
            this.mHudImage.load("/hud.png", null);
        }
        if (this.mHudTimeModePartImage == null) {
            this.mHudTimeModePartImage = new JImage();
            this.mHudTimeModePartImage.load("/hud_timemode_part.png", null);
        }
    }

    public void loadCutsceneResource() {
        for (int i = 0; i < DeviceConstants.gameMsgsDecisionArray.length; ++i) {
            if (DeviceConstants.gameMsgsDecisionArray[i][0] != mCurrentLevel || DeviceConstants.gameMsgsDecisionArray[i][1] != 0 || DeviceConstants.gameMsgsDecisionArray[i][5] == 0) continue;
            this.mInBetweenCutScenceNumber = 0;
            this.mMaxCutScenceinOneLevel = DeviceConstants.CutsceneImages[DeviceConstants.gameMsgsDecisionArray[i][5] - 1].length;
            if (!DeviceConstants.CutsceneImages[DeviceConstants.gameMsgsDecisionArray[i][5] - 1][this.mInBetweenCutScenceNumber].equals(mEmptyString)) {
                this.imgCutScence = new JImage();
                this.imgCutScence.load(DeviceConstants.CutsceneImages[DeviceConstants.gameMsgsDecisionArray[i][5] - 1][this.mInBetweenCutScenceNumber], null);
            } else {
                this.imgCutScence = null;
            }
            int vHeight = 0;
            if (this.imgCutScence != null) {
                this.mCutSceneRect.TextBox_W = this.imgCutScence.getWidth();
                this.mCutSceneRect.TextBox_H = this.imgCutScence.getHeight();
                this.mCutSceneRect.TextBox_X = (StateCommonData.screen_Width >> 1) - (this.mCutSceneRect.TextBox_W >> 1);
                this.mCutSceneRect.TextBox_Y = 35;
                vHeight = StateCommonData.screen_Height - (this.mCutSceneRect.TextBox_Y + this.mCutSceneRect.TextBox_H + (this.pCommonData.mTextComponent.GetNormalFontHeight(0) << 1) + 35);
                this.mCutSceneTextRect.TextBox_W = StateCommonData.screen_Width - 8;
                this.mCutSceneTextRect.TextBox_H = vHeight;
                this.mCutSceneTextRect.TextBox_X = 4;
                this.mCutSceneTextRect.TextBox_Y = this.mCutSceneRect.TextBox_Y + this.mCutSceneRect.TextBox_H + 35;
                this.mCutSceneTextRect.Scrolling = 0;
                continue;
            }
            vHeight = StateCommonData.screen_Height - ((this.pCommonData.mTextComponent.GetNormalFontHeight(0) << 1) + 35);
            this.mCutSceneTextRect.TextBox_W = StateCommonData.screen_Width - 8;
            this.mCutSceneTextRect.TextBox_H = vHeight;
            this.mCutSceneTextRect.TextBox_X = 4;
            this.mCutSceneTextRect.TextBox_Y = 35;
            if (mCurrentLevel == 3) {
                this.mCutSceneTextRect.TextBox_Y += 100;
            }
            this.mCutSceneTextRect.Scrolling = 0;
        }
    }

    public void updateMap() {
        int vMapX = -mMap_X_off;
        int vMapY = -mMap_Y_off;
        int vCharacterScreenX = this.mBen.getCharacterXOnScreen(this.mBen.struct_Player);
        int vCharacterScreenY = this.mBen.getCharacterYOnScreen(this.mBen.struct_Player);
        int vCharacterWidth = this.mBen.getCharacterWidth(this.mBen.struct_Player);
        int vCharacterHeight = this.mBen.getCharacterHeight(this.mBen.struct_Player);
        int vRightXCharacter = 0;
        int vXDisplacement = 0;
        int vYDisplacement = 0;
        int vDifferenceInYPanLimit = 0;
        int vPanningBufferLimit = 5;
        short v75PercentBottomViewLimit = 100;
        int diff_for_moonwalk = 12;
        if (mCurrentPanningSpeed > 10) {
            mCurrentPanningSpeed = (short)(mCurrentPanningSpeed - 1);
        }
        if (mCurrentPanningSpeed > 20) {
            mCurrentPanningSpeed = (short)20;
        }
        if (!this.mBen.struct_Player.mIsCharacterFlipped) {
            if (vCharacterScreenX > this.mPanLeftX || vCharacterScreenX < diff_for_moonwalk) {
                if (vCharacterScreenX < diff_for_moonwalk) {
                    vXDisplacement = Math.abs(vCharacterScreenX);
                } else if (vCharacterScreenX > this.mPanLeftX) {
                    vXDisplacement = Math.abs(vCharacterScreenX - this.mPanLeftX);
                }
                if (vXDisplacement >= 10) {
                    if (vXDisplacement - 10 > vPanningBufferLimit) {
                        mCurrentPanningSpeed = (short)(mCurrentPanningSpeed + 2);
                    }
                    vXDisplacement = mCurrentPanningSpeed;
                }
                if (vCharacterScreenX > this.mPanLeftX) {
                    BenGame.updateMapXPosition(vMapX + vXDisplacement);
                } else if (vCharacterScreenX < 12) {
                    BenGame.updateMapXPosition(vMapX - vXDisplacement - diff_for_moonwalk);
                }
            }
        } else {
            vRightXCharacter = vCharacterScreenX + vCharacterWidth;
            if (vRightXCharacter < this.mPanRightX || vRightXCharacter > StateCommonData.screen_Width - vCharacterWidth - diff_for_moonwalk) {
                if (vRightXCharacter > StateCommonData.screen_Width - diff_for_moonwalk) {
                    vXDisplacement = Math.abs(vRightXCharacter - StateCommonData.screen_Width);
                } else if (vRightXCharacter < this.mPanRightX) {
                    vXDisplacement = Math.abs(vRightXCharacter - this.mPanRightX);
                }
                if (vXDisplacement >= 10) {
                    if (vXDisplacement - 10 > vPanningBufferLimit) {
                        mCurrentPanningSpeed = (short)(mCurrentPanningSpeed + 2);
                    }
                    vXDisplacement = mCurrentPanningSpeed;
                }
                if (vRightXCharacter < this.mPanRightX) {
                    BenGame.updateMapXPosition(vMapX - vXDisplacement);
                } else if (vRightXCharacter > StateCommonData.screen_Width - diff_for_moonwalk) {
                    BenGame.updateMapXPosition(vMapX + vXDisplacement + diff_for_moonwalk);
                }
            }
        }
        if (vCharacterScreenY < this.mPanTopY) {
            vYDisplacement = vCharacterScreenY - this.mPanTopY;
            if (vMapY > 0) {
                if (vYDisplacement >= 10) {
                    if (vYDisplacement - 10 > vPanningBufferLimit) {
                        mCurrentPanningSpeed = (short)(mCurrentPanningSpeed + 2);
                    }
                    vYDisplacement = mCurrentPanningSpeed;
                }
                if (vMapY + vYDisplacement >= 0) {
                    BenGame.updateMapYPosition(vMapY + vYDisplacement);
                }
            }
        }
        vMapY = BenGame.getMapYPosition();
        vCharacterScreenY = this.mBen.getCharacterYOnScreen(this.mBen.struct_Player);
        if (this.mBen.struct_Player.state == 20) {
            if (this.mPanBottomY > v75PercentBottomViewLimit) {
                this.mPanBottomY = (short)(this.mPanBottomY - 10);
            }
        } else {
            vDifferenceInYPanLimit = Math.abs(this.mPanBottomY - this.mOriginalPanningBoundBottomY);
            this.mPanBottomY = vDifferenceInYPanLimit >= 10 ? (short)(this.mPanBottomY + 10) : this.mOriginalPanningBoundBottomY;
        }
        if (vCharacterScreenY + vCharacterHeight > this.mPanBottomY) {
            vYDisplacement = vCharacterScreenY + vCharacterHeight - this.mPanBottomY;
            if (vMapY + StateCommonData.screen_Height + vYDisplacement >= Map.MAP_HIG) {
                vYDisplacement = Map.MAP_HIG - vMapY - StateCommonData.screen_Height;
            }
            BenGame.updateMapYPosition(vMapY + vYDisplacement);
        } else if (vCharacterScreenY + vCharacterHeight < this.mPanBottomY && this.mBen.struct_Player.state == 6) {
            vYDisplacement = this.mPanBottomY - (vCharacterScreenY + vCharacterHeight);
            int vDynamicPanSpeed = 5;
            if (vYDisplacement >= vDynamicPanSpeed) {
                vYDisplacement = vDynamicPanSpeed;
            }
            if (vMapY > 0) {
                BenGame.updateMapYPosition(vMapY - vYDisplacement);
            }
        }
    }

    public void updatePlayer() {
        if (!Player.sIsPlayerAnimationStopped) {
            this.mBen.UpdateBen();
        }
        if (Player.mHeroType == 0 || Player.mHeroType == 3) {
            for (int i = 2; i >= 0; i = (int)((byte)(i - 1))) {
                if (!this.mBen.pWeapon.struct_Weapon[i].mIsActive) continue;
                this.mBen.pWeapon.updateWeaponState(i);
                byte attackedEnemy = this.mBen.pWeapon.checkHeroWeaponCollisionWdEnemy(i);
                if (attackedEnemy < 0 || (this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.CurrentAnimFrameRect.x >= this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.x + (this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.dx >> 1)) && (!this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.CurrentAnimFrameRect.dx <= this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.x + (this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.dx >> 1))) continue;
                this.mDpsInfo.updateHealth(Player.mHeroType, (byte)(4 + this.mEnemy.struct_enemy[attackedEnemy].bType), (short)1, attackedEnemy);
            }
        } else if (Player.mHeroType == 1) {
            for (byte i = (byte)(this.mEnemy.noOfEnemies - 1); i >= 0; i = (byte)(i - 1)) {
                byte attackedEnemy;
                if ((this.mBen.struct_Player.state != 1 && this.mBen.struct_Player.state != 24 || this.mBen.struct_Player.iCharFrameNumber != 3) && (this.mBen.struct_Player.state != 26 || this.mBen.struct_Player.iCharFrameNumber != 1) || (attackedEnemy = this.mEnemy.checkCollisionWithHero(i)) < 0 || (this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.CurrentAnimFrameRect.x >= this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.x + (this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.dx >> 1)) && (!this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.CurrentAnimFrameRect.dx <= this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.x + (this.mEnemy.struct_enemy[attackedEnemy].eCurrentFrameRect.dx >> 1))) continue;
                this.mDpsInfo.updateHealth(Player.mHeroType, (byte)(4 + this.mEnemy.struct_enemy[attackedEnemy].bType), (short)0, attackedEnemy);
            }
        }
        if (this.mDpsInfo.isCharacterDied(Player.mHeroType)) {
            this.mIskeyPressedOnce = false;
            this.mIskeyReapeated = false;
            this.mIskeyReleased = true;
            if (this.mBen.struct_Player.state == 7 && this.mBen.struct_Player.iCharFrameNumber > 0 || this.mBen.struct_Player.state == 18 && this.mBen.struct_Player.iCharFrameNumber > 0 || this.mBen.struct_Player.state == 28 && this.mBen.struct_Player.iCharFrameNumber > 0) {
                this.mBen.struct_Player.state = (byte)20;
                this.mBen.struct_Player.iCharFrameNumber = 1;
            }
            if (this.mBen.struct_Player.state == 6 && this.mBen.struct_Player.iCharFrameNumber == 0) {
                this.mBen.struct_Player.state = (byte)4;
                if (SoundPlayer.mIsSoundActive) {
                    this.mCollisionEffect = false;
                    this.pCommonData.mSoundPlayer.playSound(4);
                }
                if (SoundPlayer.mIsSoundActive) {
                    this.mCollisionEffect = false;
                    this.pCommonData.mSoundPlayer.playSound(4);
                }
            }
        }
    }

    public void update() {
        switch (gameState) {
            case 0: {
                if (this.mKeyControl && !mPause) {
                    if (!(mIsScoreBoardDisplayed || mIsAlertOn || this.mDynPanActivated)) {
                        if (StateCommonData.mGameMode == 0) {
                            if (this.mTimerModeTimer.bIsTimerExceeded && !mIsScoreBoardDisplayed && !mIsAlertOn) {
                                this.mIsGameOver = true;
                                mIsAlertOn = true;
                                StateCommonData.mTextIndex = (byte)65;
                                StateCommonData.mLeftSoftKey = (byte)9;
                                StateCommonData.mRightSoftKey = (byte)10;
                            }
                            if (this.mBen.mPlayerScriptIndex != 9) {
                                this.mTimerModeTimer.update();
                                this.pCommonData.TimeElapsed = this.mTimerModeTimer.getInterval() * 1000L - this.pCommonData.TimeDuration1;
                                this.pCommonData.TimeDuration1 += this.pCommonData.TimeDuration;
                                if (this.pCommonData.TimeElapsed <= 0L) {
                                    this.mTimerModeTimer.bIsTimerExceeded = true;
                                    this.pCommonData.TimeElapsed = 0L;
                                }
                            }
                        }
                        this.updatePlayer();
                        this.mMapObjects.setRectangleforPlayer(this.mBen.struct_Player.CurrentAnimFrameRect);
                        this.platformCollisionChk();
                        if (!this.mIsLevelOver && this.mBen.mPlayerScriptIndex == 9 && this.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp > 0) {
                            this.mPlayerRelaxTimer -= (long)this.pCommonData.mTimer.getDtMSeconds();
                            if (mCurrentLevel == 6 && this.mBen.struct_Player.CurrentAnimFrameRect.y < 0) {
                                this.mPlayerRelaxTimer = -1L;
                            }
                            if (this.mPlayerRelaxTimer < 0L) {
                                this.mIsLevelComplete = true;
                                if (StateCommonData.mGameMode == 0) {
                                    if (GameConstants.TimeModeScores[mCurrentLevel - 1] != -1) {
                                        if (MapObject.levelScore >= GameConstants.TimeModeScores[mCurrentLevel - 1]) {
                                            if (mCurrentLevel == 7) {
                                                mStatusOfLevel = 1;
                                                this.mIsExitScriptCaught = false;
                                                this.mIsLevelOver = true;
                                            } else {
                                                this.mIsExitScriptCaught = true;
                                                mStatusOfLevel = (byte)2;
                                            }
                                        } else {
                                            this.mIsGameOver = true;
                                            mIsAlertOn = true;
                                            StateCommonData.mTextIndex = (byte)65;
                                            StateCommonData.mLeftSoftKey = (byte)9;
                                            StateCommonData.mRightSoftKey = (byte)10;
                                        }
                                    }
                                } else {
                                    System.out.println("in the end of level " + mCurrentLevel + "  mIsLevelOver : " + this.mIsLevelOver);
                                    if (mCurrentLevel == 7) {
                                        mStatusOfLevel = 1;
                                        this.mIsExitScriptCaught = false;
                                        this.mIsLevelOver = true;
                                    } else {
                                        this.mIsExitScriptCaught = true;
                                        mStatusOfLevel = (byte)2;
                                    }
                                }
                            }
                        }
                        if (Player.mHeroType == 0 || Player.mHeroType == 3) {
                            for (int i = 0; i < 3; ++i) {
                                if (this.mBen.pWeapon.struct_Weapon[i].mIsActive) {
                                    this.mBen.pWeapon.updateWeaponPosition(i);
                                    continue;
                                }
                                this.mBen.pWeapon.struct_Weapon[i].mIsCharacterFlipped = this.mBen.struct_Player.mIsCharacterFlipped;
                            }
                        }
                        if (DeviceConstants.gameMsgsDecisionArray[1][4] == 0) {
                            this.mMapObjects.TutorialPointsAppear();
                            this.mMapObjects.TutorialPointsDisappear();
                        }
                        if (this.mBen.struct_Player.state != 0) {
                            this.mMapObjects.mapObjectCollision();
                        }
                        this.doReflexActionOnScripts();
                        this.mEnemy.update();
                        if (!Player.sIsPlayerAnimationStopped) {
                            this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                            this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                            this.mBen.setCharacterXOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.x, this.mBen.struct_Player);
                            this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
                            this.mBen.setCharacterWidth(this.mBen.struct_Player.CurrentAnimFrameRect.dx, this.mBen.struct_Player);
                            this.mBen.setCharacterHeight(this.mBen.struct_Player.CurrentAnimFrameRect.dy, this.mBen.struct_Player);
                            this.mBen.struct_Player.mIsAnimPosUpdated = false;
                        }
                        if (!Player.sIsPlayerAnimationStopped && !this.mDynPanActivated && this.mBen.struct_Player.state != 0) {
                            this.updateMap();
                        }
                        this.checkForEventTexts();
                        if (gameState == 0 && this.mIsExitScriptCaught && !this.mIsPopupOn && !mPause) {
                            this.mPlayerRelaxTimer -= (long)this.pCommonData.mTimer.getDtMSeconds();
                            if (this.mPlayerRelaxTimer < 0L) {
                                if (StateCommonData.mGameMode == 0) {
                                    if (GameConstants.TimeModeScores[mCurrentLevel - 1] != -1) {
                                        if (MapObject.levelScore >= GameConstants.TimeModeScores[mCurrentLevel - 1]) {
                                            this.mIsExitScriptCaught = false;
                                            StateCommonData.mTextIndex = (byte)59;
                                            StateCommonData.mLeftSoftKey = (byte)9;
                                            StateCommonData.mRightSoftKey = (byte)10;
                                            mIsAlertOn = true;
                                        } else {
                                            this.mIsGameOver = true;
                                            mIsAlertOn = true;
                                            StateCommonData.mTextIndex = (byte)65;
                                            StateCommonData.mLeftSoftKey = (byte)9;
                                            StateCommonData.mRightSoftKey = (byte)10;
                                        }
                                    } else {
                                        this.mIsExitScriptCaught = false;
                                        StateCommonData.mTextIndex = (byte)59;
                                        StateCommonData.mLeftSoftKey = (byte)9;
                                        StateCommonData.mRightSoftKey = (byte)10;
                                        mIsAlertOn = true;
                                    }
                                } else {
                                    this.mIsExitScriptCaught = false;
                                    StateCommonData.mTextIndex = (byte)59;
                                    StateCommonData.mLeftSoftKey = (byte)9;
                                    StateCommonData.mRightSoftKey = (byte)10;
                                    mIsAlertOn = true;
                                    this.pCommonData.mPrefs.AttackmodeUnLocked = true;
                                    if (mCurrentLevel > this.pCommonData.mPrefs.Max_AttackLevelUnLocked) {
                                        this.mIsTimerModeUnlockAlertOn = true;
                                        this.pCommonData.mPrefs.Max_AttackLevelUnLocked = this.pCommonData.mPrefs.Max_LevelUnLocked;
                                    }
                                    this.scorecalculation();
                                    try {
                                        this.pCommonData.mPrefs.save(false);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                    if (!mIsScoreBoardDisplayed && !mIsAlertOn && this.mDynPanActivated && this.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp > 0) {
                        this.dynamicPan();
                    }
                } else if (!(mPause && this.mIsPopupOn && mIsShowSubMenu)) {
                    // empty if block
                }
                if (StateCommonData.mGameMode != 0 || !this.mIsDrawcheatRect && !mIsAlertOn && !this.mDynPanActivated && !this.mIsDynPanPaused && !mPause && this.mPlayerRelaxTimer <= 0L) break;
                this.mTimerModeTimer.setStartTimerValue(this.mTimerModeTimer.adjustStartTimerOnPause());
                break;
            }
            case 2: {
                if (mStatusOfLevel == 1) {
                    StateCommonData.mPaintLoadingScreen = true;
                    this.pCommonData.mStateCounter = (byte)101;
                    this.pCommonData.mloadingCounter = 0;
                    break;
                }
                this.mIsDrawcheatRect = true;
                mPause = false;
                this.checkForEventTexts();
                if (StateCommonData.mGameMode == 0) {
                    StateCommonData.mTextIndex = (byte)(66 + (mCurrentLevel - 1));
                    StateCommonData.mLeftSoftKey = (byte)9;
                    StateCommonData.mRightSoftKey = (byte)10;
                    mIsAlertOn = true;
                    gameState = 0;
                    mStatusOfLevel = 0;
                    this.mIsSubMenuActive = true;
                } else if (mCurrentLevel != 1 && gameState != 3) {
                    gameState = 0;
                    mStatusOfLevel = 0;
                }
                this.mKeyControl = true;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void checkForEventTexts() {
        if (mCurrentLevel == 1 || mCurrentLevel == 5) {
            this.mIsMorphOn = true;
        }
        if (this.mIsMorphOn && !this.mIsMorphed && (mCurrentLevel == 1 || mCurrentLevel == 5)) {
            this.mIsMorphed = true;
            this.mBen.struct_Player.state = 0;
            this.mBen.struct_Player.iCharFrameNumber = 0;
            this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.charAnimation.mObjAnimationsArray[0].AnimationFrames[0].FrameWidth;
            this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.charAnimation.mObjAnimationsArray[0].AnimationFrames[0].FrameHeight;
            this.mBen.struct_Player.CurrentAnimFrameRect.y += this.mBen.charAnimation.mObjAnimationsArray[6].AnimationFrames[0].FrameHeight - this.mBen.struct_Player.CurrentAnimFrameRect.dy;
            this.mBen.setCharacterWidth(this.mBen.struct_Player.CurrentAnimFrameRect.dx, this.mBen.struct_Player);
            this.mBen.setCharacterHeight(this.mBen.struct_Player.CurrentAnimFrameRect.dy, this.mBen.struct_Player);
            this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
        } else {
            for (int i = 0; i < DeviceConstants.gameMsgsDecisionArray.length; ++i) {
                if (DeviceConstants.gameMsgsDecisionArray[i][0] == mCurrentLevel && DeviceConstants.gameMsgsDecisionArray[i][1] == 0 && DeviceConstants.gameMsgsDecisionArray[i][4] == 1 && DeviceConstants.gameMsgsDecisionArray[i][2] == mStatusOfLevel) {
                    gameState = (byte)3;
                    this.mCutSceneRect.TextBox_X = (StateCommonData.screen_Width >> 1) - (this.mCutSceneRect.TextBox_W >> 1);
                    DeviceConstants.gameMsgsDecisionArray[i][4] = 0;
                    StateCommonData.mTitleIndex = (byte)10;
                    StateCommonData.mTextIndex = DeviceConstants.gameMsgsDecisionArray[i][3];
                    mAnimationType = DeviceConstants.gameMsgsDecisionArray[i][6];
                    StateCommonData.mLeftSoftKey = (byte)9;
                    StateCommonData.mRightSoftKey = (byte)10;
                    mIsShowSubMenu = false;
                    break;
                }
                if (DeviceConstants.gameMsgsDecisionArray[i][0] == mCurrentLevel && DeviceConstants.gameMsgsDecisionArray[i][1] == 1 && DeviceConstants.gameMsgsDecisionArray[i][4] == 1 && mStatusOfLevel == DeviceConstants.gameMsgsDecisionArray[i][2] && this.mBen.struct_Player.state != 0 && !this.mIsPopupOn) {
                    DeviceConstants.gameMsgsDecisionArray[i][4] = 0;
                    this.mIsPopupOn = true;
                    mPause = true;
                    StateCommonData.mLeftSoftKey = (byte)9;
                    if (i < DeviceConstants.gameMsgsDecisionArray.length - 2) {
                        StateCommonData.mRightSoftKey = DeviceConstants.gameMsgsDecisionArray[i + 1][1] == 1 && DeviceConstants.gameMsgsDecisionArray[i + 1][4] == 1 && DeviceConstants.gameMsgsDecisionArray[i + 1][0] == mCurrentLevel && DeviceConstants.gameMsgsDecisionArray[i + 1][2] == mStatusOfLevel ? (byte)6 : (byte)10;
                    }
                    if (i == DeviceConstants.gameMsgsDecisionArray.length - 1) {
                        StateCommonData.mRightSoftKey = (byte)10;
                    }
                    StateCommonData.mTitleIndex = (byte)10;
                    StateCommonData.mTextIndex = DeviceConstants.gameMsgsDecisionArray[i][3];
                    break;
                }
                if (DeviceConstants.gameMsgsDecisionArray[i][0] > mCurrentLevel && this.mIsLevelOver || this.mIsGameWin) {
                    if (StateCommonData.mGameMode == 0) {
                        if (this.mIsGameWin) {
                            StateCommonData.mTextIndex = (byte)77;
                            StateCommonData.mLeftSoftKey = (byte)9;
                            StateCommonData.mRightSoftKey = (byte)10;
                            mIsAlertOn = true;
                        } else {
                            mIsScoreBoardDisplayed = true;
                        }
                    } else {
                        mIsScoreBoardDisplayed = true;
                    }
                    this.mIsGameWin = false;
                    this.mIsLevelOver = false;
                    if (mCurrentLevel == 7) {
                        this.scorecalculation();
                    }
                    for (int j = 0; j < 4; j = (int)((byte)(j + 1))) {
                        this.mMapObjects.mapObjectXYforScoreTable[j][2] = (short)(this.mMapObjects.mapObjectXYforScoreTable[j][0] * this.mMapObjects.mapObjectXYforScoreTable[j][1]);
                    }
                    try {
                        if (this.pCommonData.mPrefs.levelScores[mCurrentLevel - 1] < MapObject.levelScore) {
                            this.pCommonData.mPrefs.levelScores[BenGame.mCurrentLevel - 1] = MapObject.levelScore;
                        }
                        this.pCommonData.mPrefs.save(true);
                    }
                    catch (Exception e) {}
                    break;
                }
                if (mStatusOfLevel != 1 || DeviceConstants.gameMsgsDecisionArray[DeviceConstants.gameMsgsDecisionArray.length - 1][4] != 0 || StateCommonData.mGameMode != 1 && (StateCommonData.mGameMode != 0 || DeviceConstants.gameMsgsDecisionArray[24][4] != 0)) continue;
                this.mIsGameWin = true;
                this.pCommonData.mPrefs.Max_AttackLevelUnLocked = (byte)7;
                try {
                    this.pCommonData.mPrefs.save(true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void doReflexActionOnScripts() {
        if ((this.mBen.mAnimStartY - this.mMap.Tile_Scipt_Rect.y < this.mBen.mClingClimbRestrictOffset || this.mBen.struct_Player.state == 28) && this.mBen.struct_Player.state != 22 && this.mBen.struct_Player.state != 3 && this.mBen.struct_Player.state != 21 && this.mBen.struct_Player.state != 17 && this.mBen.struct_Player.state != 16 && this.mBen.struct_Player.state != 6 && this.mBen.struct_Player.state != 29 && this.mBen.struct_Player.state != 26 && this.mBen.struct_Player.state != 19) {
            if (!(this.mBen.mPlayerScriptIndex != 5 && this.mBen.mPlayerScriptIndex != 3 || this.mBen.struct_Player.mIsCharacterFlipped)) {
                if (this.mBen.struct_Player.state == 18 || this.mBen.struct_Player.state == 7 || this.mBen.struct_Player.state == 20 || this.mBen.struct_Player.state == 8) {
                    this.mBen.struct_Player.state = (byte)22;
                    this.mBen.struct_Player.iCharFrameNumber = 0;
                    this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                    this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                    this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
                    this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
                    this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx - this.mBen.struct_Player.CurrentAnimFrameRect.dx;
                    this.mBen.setCharacterXOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.x, this.mBen.struct_Player);
                }
            } else if (!(this.mBen.mPlayerScriptIndex != 6 && this.mBen.mPlayerScriptIndex != 4 || !this.mBen.struct_Player.mIsCharacterFlipped || this.mBen.struct_Player.state != 18 && this.mBen.struct_Player.state != 7 && this.mBen.struct_Player.state != 20 && this.mBen.struct_Player.state != 8)) {
                this.mBen.struct_Player.state = (byte)22;
                this.mBen.struct_Player.iCharFrameNumber = 0;
                this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
                this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
                this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x;
                this.mBen.setCharacterXOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.x, this.mBen.struct_Player);
            }
            if (this.mBen.mPlayerScriptIndex == 10 && !this.mBen.struct_Player.mIsCharacterFlipped) {
                if (this.mBen.struct_Player.state == 28) {
                    this.mBen.struct_Player.state = (byte)22;
                    this.mBen.struct_Player.iCharFrameNumber = 0;
                    this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                    this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                    this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
                    this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
                    if (this.mBen.struct_Player.CurrentAnimFrameRect.x < this.mMap.Tile_Scipt_Rect.x) {
                        this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x + this.mMap.Tile_Scipt_Rect.dx - this.mBen.struct_Player.CurrentAnimFrameRect.dx;
                        this.mBen.setCharacterXOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.x, this.mBen.struct_Player);
                    }
                }
            } else if (this.mBen.mPlayerScriptIndex == 11 && this.mBen.struct_Player.mIsCharacterFlipped && this.mBen.struct_Player.state == 28) {
                this.mBen.struct_Player.state = (byte)22;
                this.mBen.struct_Player.iCharFrameNumber = 0;
                this.mBen.struct_Player.CurrentAnimFrameRect.dx = this.mBen.getCharacterWidth(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                this.mBen.struct_Player.CurrentAnimFrameRect.dy = this.mBen.getCharacterHeight(this.mBen.struct_Player.state, this.mBen.struct_Player.iCharFrameNumber);
                this.mBen.struct_Player.CurrentAnimFrameRect.y = this.mMap.Tile_Scipt_Rect.y;
                this.mBen.setCharacterYOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.y, this.mBen.struct_Player);
                if (this.mBen.struct_Player.CurrentAnimFrameRect.x + this.mBen.struct_Player.CurrentAnimFrameRect.dx > this.mMap.Tile_Scipt_Rect.x + 12) {
                    this.mBen.struct_Player.CurrentAnimFrameRect.x = this.mMap.Tile_Scipt_Rect.x;
                    this.mBen.setCharacterXOnCanvas(this.mBen.struct_Player.CurrentAnimFrameRect.x, this.mBen.struct_Player);
                }
            }
        }
    }

    public void unloadCutsceneResource() {
        if (this.imgCutScence != null) {
            this.imgCutScence.destroy();
            this.imgCutScence = null;
        }
    }

    public void unloadNaratorResource() {
    }

    public void unLoadLevelResource() {
        this.mMap.realeaseLevelMapData();
        this.mMapObjects.realeaseMapObjectsData();
        this.mBen.releaseAniReasourse();
        if (this.mBen.pWeapon != null) {
            this.mBen.pWeapon.unloadWeaponReasource();
        }
        if (this.mEnemy != null) {
            this.mEnemy.releaseAniReasourse();
        }
        this.mEnemy.releaseEnemyStructure();
        if (this.mEnemy.eWeapons != null) {
            this.mEnemy.eWeapons.unloadWeaponReasource();
            this.mEnemy.eWeapons = null;
        }
    }

    public void unloadGameResource() {
        this.mBen.unloadPlayerResource();
        this.mEnemy.unloadEnemyresourse();
        this.mMap.realeaseMapResource();
        this.mMapObjects.unloadMapObjectResourse();
        this.mDpsInfo.unloadDpsData();
        this.unloadCutsceneResource();
        this.unloadNaratorResource();
        if (sTileImage != null) {
            sTileImage.destroy();
            sTileImage = null;
        }
        if (this.mMap != null) {
            this.mMap = null;
        }
        if (this.mBen != null) {
            this.mBen = null;
        }
        if (this.mEnemy != null) {
            this.mEnemy = null;
        }
        if (this.mMapObjects != null) {
            this.mMapObjects = null;
        }
        if (this.mPopupRect != null) {
            this.mPopupRect = null;
        }
        if (this.mDpsInfo != null) {
            this.mDpsInfo = null;
        }
        if (this.mHudImage != null) {
            this.mHudImage.destroy();
            this.mHudImage = null;
        }
    }

    protected void handleKeys() {
    }

    protected void suspend(boolean aBTAPI) {
        if (!aBTAPI) {
            this.unloadGameResource();
            this.resetGameVariables();
        }
    }

    protected void onTimerStart() {
        if (!StateCommonData.mPaintLoadingScreen) {
            this.update();
        }
        this.Display(this.pCommonData.mJDisplay);
    }

    protected void onTimerEnd() {
    }

    byte IsVisible(Rectangle ObjRect, int Map_X_off, int Map_Y_off) {
        if ((Math.abs(Map_X_off) <= ObjRect.x && Math.abs(Map_X_off) + StateCommonData.screen_Width >= ObjRect.x || Math.abs(Map_X_off) <= ObjRect.x + ObjRect.dx && Math.abs(Map_X_off) + StateCommonData.screen_Width >= ObjRect.x + ObjRect.dx || ObjRect.x <= Math.abs(Map_X_off) && ObjRect.x + ObjRect.dx >= Math.abs(Map_X_off)) && (Math.abs(Map_Y_off) <= ObjRect.y && Math.abs(Map_Y_off) + StateCommonData.screen_Height >= ObjRect.y || Math.abs(Map_Y_off) <= ObjRect.y + ObjRect.dy && Math.abs(Map_Y_off) + StateCommonData.screen_Height >= ObjRect.y + ObjRect.dy || ObjRect.y <= Math.abs(Map_Y_off) && ObjRect.y + ObjRect.dy >= Math.abs(Map_Y_off))) {
            return 1;
        }
        return 0;
    }

    static {
        mEmptyString = "";
    }
}

