/*
 * Decompiled with CFR 0.152.
 */
package Menu;

import Game.BenGame;
import Game.DeviceConstants;
import Game.SoundPlayer;
import Localisation.DrawGText;
import Localisation.TextComponent;
import Project.BenMIDlet;
import Project.JDisplay;
import Project.JImage;
import Resources.Resources;
import StateManager.CState;
import StateManager.StateCommonData;

public class CMenu
extends CState
implements Resources,
DeviceConstants {
    StateCommonData pCommonData = (StateCommonData)this.getCommonData();
    private DrawGText mAboutTextRect;
    String aboutString;
    int mStartLineNumber;
    int mEndLineNumber;
    int mDisplayFormLine;
    int mMaxLines;
    int mCurrentlyDisplayLines;
    boolean bDownKeyPress;
    boolean bUpKeyPress;
    public static JImage menuBG;

    public CMenu() {
        this.config.bLoopTimer = true;
        this.config.timerVal = 80L;
        this.config.bSuspendActive = true;
        int MAX_SUBMENU_LENGTH = 5;
        this.pCommonData.mPreviousMenuIndex = new byte[MAX_SUBMENU_LENGTH];
        for (int i = 0; i < this.pCommonData.mPreviousMenuIndex.length; ++i) {
            this.pCommonData.mPreviousMenuIndex[i] = -1;
        }
        this.mAboutTextRect = new DrawGText();
        this.mAboutTextRect.Scrolling = 0;
        this.pCommonData.mMenuState = 0;
        this.initVariables();
    }

    public void initVariables() {
        this.pCommonData.mSelectedMeuIndex = 0;
        StateCommonData.mStartMenuIndex = (byte)17;
        StateCommonData.mEndMenuIndex = (byte)22;
        StateCommonData.mLeftSoftKey = 0;
        StateCommonData.mRightSoftKey = (byte)10;
    }

    protected void keyPressed(int aKeyCode) {
        this.bUpKeyPress = false;
        this.bDownKeyPress = false;
    }

    protected void keyHit(int aParam) {
        switch (aParam) {
            case 42: {
                break;
            }
            case -1: 
            case 50: {
                this.bUpKeyPress = true;
                switch (this.pCommonData.mMenuState) {
                    case 0: {
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                        if (0 <= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = (byte)5;
                        break;
                    }
                    case 6: {
                        if (this.pCommonData.mPrefs.Max_LevelUnLocked <= 1) break;
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                        if (0 <= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = 1;
                        break;
                    }
                    case 7: {
                        if (!this.pCommonData.mPrefs.AttackmodeUnLocked) break;
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                        if (0 <= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.pCommonData.mTextComponent.ScrollUp();
                    }
                }
                break;
            }
            case -2: 
            case 56: {
                this.bDownKeyPress = true;
                switch (this.pCommonData.mMenuState) {
                    case 0: {
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                        if (5 >= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = 0;
                        break;
                    }
                    case 6: {
                        if (this.pCommonData.mPrefs.Max_LevelUnLocked <= 1) break;
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                        if (1 >= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = 0;
                        break;
                    }
                    case 7: {
                        if (!this.pCommonData.mPrefs.AttackmodeUnLocked) break;
                        this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                        if (1 >= this.pCommonData.mSelectedMeuIndex) break;
                        this.pCommonData.mSelectedMeuIndex = 0;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.pCommonData.mTextComponent.ScrollDown();
                    }
                }
                break;
            }
            case -6: 
            case -5: 
            case 53: {
                switch (this.pCommonData.mMenuState) {
                    case 5: {
                        if (aParam == 53 || aParam == -5) {
                            return;
                        }
                        BenMIDlet.get_myMidlet().iTestCanvas.destroy();
                        break;
                    }
                    case 8: {
                        StateCommonData.mPaintLoadingScreen = true;
                        this.pCommonData.mStateCounter = (byte)100;
                        this.pCommonData.mloadingCounter = 0;
                        this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
                        break;
                    }
                    case 0: {
                        this.pCommonData.storePreviousMenuIndex();
                        if (SoundPlayer.mIsSoundActive) {
                            this.pCommonData.mSoundPlayer.stopSound();
                        }
                        switch (this.pCommonData.mSelectedMeuIndex) {
                            case 5: {
                                this.pCommonData.mMenuState = (byte)5;
                                StateCommonData.mTextIndex = (byte)12;
                                StateCommonData.mLeftSoftKey = (byte)2;
                                StateCommonData.mRightSoftKey = (byte)3;
                                break;
                            }
                            case 4: {
                                this.pCommonData.mMenuState = (byte)3;
                                StateCommonData.mTitleIndex = (byte)21;
                                StateCommonData.mTextIndex = (byte)10;
                                StateCommonData.mLeftSoftKey = (byte)10;
                                StateCommonData.mRightSoftKey = 1;
                                this.pCommonData.mTextComponent.reset();
                                this.aboutString = StateCommonData.mHintText[55] + this.pCommonData.midletName + StateCommonData.mHintText[56] + this.pCommonData.midletVersion + StateCommonData.mHintText[57] + this.pCommonData.midletVender + StateCommonData.mHintText[58];
                                break;
                            }
                            case 3: {
                                this.pCommonData.mMenuState = (byte)4;
                                StateCommonData.mTitleIndex = (byte)23;
                                StateCommonData.mTextIndex = (byte)30;
                                StateCommonData.mLeftSoftKey = (byte)10;
                                StateCommonData.mRightSoftKey = 1;
                                this.pCommonData.mTextComponent.reset();
                                break;
                            }
                            case 1: {
                                this.pCommonData.mSelectedMeuIndex = 0;
                                this.pCommonData.mMenuState = (byte)6;
                                StateCommonData.mStartMenuIndex = (byte)24;
                                StateCommonData.mEndMenuIndex = (byte)25;
                                StateCommonData.mLeftSoftKey = 0;
                                StateCommonData.mRightSoftKey = 1;
                                break;
                            }
                            case 2: {
                                this.resetHighScoreScrollingData();
                                StateCommonData.mLeftSoftKey = (byte)10;
                                StateCommonData.mRightSoftKey = 1;
                                this.pCommonData.mMenuState = 1;
                                break;
                            }
                            case 0: {
                                this.pCommonData.mSelectedMeuIndex = 0;
                                this.pCommonData.mMenuState = (byte)7;
                                StateCommonData.mStartMenuIndex = (byte)40;
                                StateCommonData.mEndMenuIndex = (byte)41;
                                StateCommonData.mLeftSoftKey = 0;
                                StateCommonData.mRightSoftKey = 1;
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (this.pCommonData.mSelectedMeuIndex + 0) {
                            case 0: {
                                if (!SoundPlayer.mIsSoundActive) {
                                    SoundPlayer.mIsSoundActive = true;
                                    this.pCommonData.mSoundPlayer.playSound(1);
                                    break;
                                }
                                SoundPlayer.mIsSoundActive = false;
                                this.pCommonData.mSoundPlayer.stopSound();
                                break;
                            }
                            case 1: {
                                this.pCommonData.mMenuState = (byte)9;
                                StateCommonData.mTextIndex = (byte)29;
                                StateCommonData.mLeftSoftKey = (byte)2;
                                StateCommonData.mRightSoftKey = (byte)3;
                            }
                        }
                        break;
                    }
                    case 7: {
                        this.pCommonData.storePreviousMenuIndex();
                        switch (this.pCommonData.mSelectedMeuIndex + 0) {
                            case 1: {
                                StateCommonData.mGameMode = 0;
                                break;
                            }
                            case 0: {
                                StateCommonData.mGameMode = 1;
                            }
                        }
                        this.pCommonData.mMenuState = (byte)8;
                        if (SoundPlayer.mIsSoundActive) {
                            this.pCommonData.mSoundPlayer.playSound(0);
                        }
                        byte MAX_UNLOCKED = this.pCommonData.mPrefs.Max_LevelUnLocked;
                        if (StateCommonData.mGameMode == 0) {
                            MAX_UNLOCKED = this.pCommonData.mPrefs.Max_AttackLevelUnLocked;
                        }
                        this.pCommonData.mSelectedMeuIndex = (byte)(MAX_UNLOCKED - 1);
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = 1;
                        break;
                    }
                    case 9: {
                        if (aParam == 53 || aParam == -5) {
                            return;
                        }
                        this.pCommonData.mSelectedMeuIndex = 0;
                        this.pCommonData.mMenuState = (byte)6;
                        StateCommonData.mStartMenuIndex = (byte)24;
                        StateCommonData.mEndMenuIndex = (byte)25;
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = 1;
                        this.pCommonData.mPrefs.reset();
                        try {
                            this.pCommonData.mPrefs.save(false);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case -7: {
                for (int i = this.pCommonData.mPreviousMenuIndex.length - 1; i >= 0; --i) {
                    if (this.pCommonData.mPreviousMenuIndex[i] == -1) continue;
                    this.pCommonData.mSelectedMeuIndex = this.pCommonData.mPreviousMenuIndex[i];
                    this.pCommonData.mPreviousMenuIndex[i] = -1;
                    break;
                }
                switch (this.pCommonData.mMenuState) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.pCommonData.mTextComponent.reset();
                        this.resetHighScoreScrollingData();
                        if (SoundPlayer.mIsSoundActive) {
                            this.pCommonData.mSoundPlayer.playSound(0);
                        }
                        this.pCommonData.mMenuState = 0;
                        StateCommonData.mStartMenuIndex = (byte)17;
                        StateCommonData.mEndMenuIndex = (byte)22;
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = (byte)10;
                        break;
                    }
                    case 9: {
                        this.pCommonData.mMenuState = (byte)6;
                        StateCommonData.mStartMenuIndex = (byte)24;
                        StateCommonData.mEndMenuIndex = (byte)25;
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = 1;
                        break;
                    }
                    case 8: {
                        this.pCommonData.mMenuState = (byte)7;
                        StateCommonData.mStartMenuIndex = (byte)40;
                        StateCommonData.mEndMenuIndex = (byte)41;
                        StateCommonData.mLeftSoftKey = 0;
                        StateCommonData.mRightSoftKey = 1;
                        if (!SoundPlayer.mIsSoundActive) break;
                        this.pCommonData.mSoundPlayer.stopSound();
                    }
                }
                break;
            }
            case -3: 
            case 52: {
                if (this.pCommonData.mMenuState != 8) break;
                this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex - 1);
                if (0 <= this.pCommonData.mSelectedMeuIndex) break;
                this.pCommonData.mSelectedMeuIndex = 0;
                break;
            }
            case -4: 
            case 54: {
                if (this.pCommonData.mMenuState != 8) break;
                this.pCommonData.mSelectedMeuIndex = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
                byte MAX_UNLOCKED = this.pCommonData.mPrefs.Max_LevelUnLocked;
                if (StateCommonData.mGameMode == 0) {
                    MAX_UNLOCKED = this.pCommonData.mPrefs.Max_AttackLevelUnLocked;
                }
                if (MAX_UNLOCKED - 1 >= this.pCommonData.mSelectedMeuIndex) break;
                this.pCommonData.mSelectedMeuIndex = (byte)(MAX_UNLOCKED - 1);
                break;
            }
        }
    }

    protected void onTimerEnd() {
    }

    protected void onTimerStart() {
        this.pCommonData.mJDisplay.clearScreen(0);
        this.pCommonData.mJDisplay.drawImage(menuBG, 0, 0, 0, 0, menuBG.getWidth(), menuBG.getHeight(), 0, 1);
        this.Display(this.pCommonData.mJDisplay);
    }

    public void loadIngameFromMenu() {
        this.pCommonData.mTextComponent.reset();
        this.switchToState(7, true);
        if (this.pCommonData.mSelectedMeuIndex == this.pCommonData.mPrefs.currentLevel - 1) {
            BenGame.setLevel((byte)(this.pCommonData.mSelectedMeuIndex + 1));
        } else {
            this.pCommonData.mPrefs.currentLevel = (byte)(this.pCommonData.mSelectedMeuIndex + 1);
            BenGame.setLevel(this.pCommonData.mPrefs.currentLevel);
        }
        for (int i = 0; i < this.pCommonData.mPreviousMenuIndex.length; ++i) {
            this.pCommonData.mPreviousMenuIndex[i] = -1;
        }
        StateCommonData.mTitleIndex = (byte)10;
        StateCommonData.mTextIndex = (byte)10;
        StateCommonData.mLeftSoftKey = (byte)10;
        StateCommonData.mRightSoftKey = (byte)10;
        StateCommonData.mPaintLoadingScreen = false;
        this.pCommonData.mloadingCounter = 0;
        this.pCommonData.mStateCounter = 0;
    }

    public void Display(JDisplay g) {
        if (StateCommonData.mPaintLoadingScreen || this.pCommonData.mIsLoadingOn) {
            this.pCommonData.paintLoadingScreen(this.pCommonData.mJDisplay);
            if (this.pCommonData.mloadingCounter++ > 3 && this.pCommonData.mStateCounter == 100) {
                this.loadIngameFromMenu();
                this.pCommonData.mIsLoadingOn = true;
            }
            return;
        }
        switch (this.pCommonData.mMenuState) {
            case 8: {
                this.pCommonData.paintLevelSelectionScreen(g, (byte)6);
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                String vTitleText = "";
                int yDisp = 0;
                this.pCommonData.paintMenuScreens(g, StateCommonData.mStartMenuIndex, StateCommonData.mEndMenuIndex, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, (byte)0);
                if (this.pCommonData.mMenuState == 6) {
                    vTitleText = StateCommonData.mHintText[18];
                    if (menuBG == null) {
                        menuBG = new JImage();
                        menuBG.load("/menu_effects.png", null);
                    }
                    yDisp = menuBG.getHeight();
                } else if (this.pCommonData.mMenuState == 7) {
                    vTitleText = StateCommonData.mHintText[78];
                    if (menuBG == null) {
                        menuBG = new JImage();
                        menuBG.load("/menu_effects.png", null);
                    }
                    yDisp = menuBG.getHeight();
                }
                this.pCommonData.mTextComponent.DrawString("" + vTitleText, 0, (TextComponent.FontNormalArray_HEIGHT[1] << 1) + yDisp, 1, 4, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)0);
                if (this.pCommonData.mMenuState != 6) break;
                break;
            }
            case 5: 
            case 9: {
                this.pCommonData.paintAlertMessageScreen(g, StateCommonData.mTextIndex, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, (byte)0);
                break;
            }
            case 1: {
                this.paintHighScores(g);
                break;
            }
            case 3: {
                this.pCommonData.paintTextOnScreen(g, StateCommonData.mTitleIndex, this.aboutString, this.mAboutTextRect, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, 4);
                break;
            }
            case 4: {
                this.pCommonData.paintTextScreen(g, StateCommonData.mTitleIndex, StateCommonData.mTextIndex, this.mAboutTextRect, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey, 1);
            }
        }
    }

    protected void resume(boolean aTapi) {
        this.pCommonData.mTimer.reset();
        if (!aTapi) {
            if (menuBG == null) {
                menuBG = new JImage();
                menuBG.load("/menu_effects.png", null);
            }
            this.mAboutTextRect.TextBox_W = StateCommonData.screen_Width - 8;
            this.mAboutTextRect.TextBox_H = StateCommonData.screen_Height - menuBG.getHeight() - this.pCommonData.mTextComponent.GetNormalFontHeight(0) - this.pCommonData.mTextComponent.GetNormalFontHeight(1);
            this.mAboutTextRect.TextBox_X = 4;
            this.mAboutTextRect.TextBox_Y = menuBG.getHeight() + this.pCommonData.mTextComponent.GetNormalFontHeight(1);
            this.pCommonData.mMenuTextDisplayRect.TextBox_X = 0;
            this.pCommonData.mMenuTextDisplayRect.TextBox_Y = this.pCommonData.mTextComponent.GetNormalFontHeight(0);
            this.pCommonData.mMenuTextDisplayRect.TextBox_W = StateCommonData.screen_Width;
            this.pCommonData.mMenuTextDisplayRect.TextBox_H = StateCommonData.screen_Height - this.pCommonData.mMenuTextDisplayRect.TextBox_Y - this.pCommonData.mTextComponent.GetNormalFontHeight(0);
            this.pCommonData.mSelectedMeuIndex = 0;
        } else {
            if (StateCommonData.mPaintLoadingScreen) {
                this.pCommonData.mSoundPlayer.stopSound();
                return;
            }
            if (this.pCommonData.mMenuState == 0 || this.pCommonData.mMenuState == 8) {
                if (SoundPlayer.mIsSoundActive) {
                    this.pCommonData.mSoundPlayer.playSound(0);
                } else {
                    this.pCommonData.mSoundPlayer.stopSound();
                }
            }
        }
    }

    protected void suspend(boolean aTapi) {
        if (!aTapi) {
            menuBG.destroy();
            menuBG = null;
        }
    }

    public void resetHighScoreScrollingData() {
        this.bDownKeyPress = false;
        this.bUpKeyPress = false;
        this.mStartLineNumber = 0;
        this.mEndLineNumber = 0;
        this.mDisplayFormLine = 0;
        this.mCurrentlyDisplayLines = 0;
    }

    public void paintHighScores(JDisplay g) {
        int vPart1Width = this.pCommonData.mTextComponent.GetTextWidth((StateCommonData.mHintText[37] + " " + 7 + "").toCharArray(), 1);
        int vPart2Width = this.pCommonData.mTextComponent.GetTextWidth("99999".toCharArray(), 1);
        int vPArt3Wodth = this.pCommonData.mTextComponent.GetTextWidth(" = ".toCharArray(), 1);
        int vToatalWidth = vPart1Width + vPart2Width + vPArt3Wodth;
        int vOffsetOnBothSide = (StateCommonData.screen_Width >> 1) - (vToatalWidth >> 1);
        this.mMaxLines = 7;
        this.mCurrentlyDisplayLines = this.mAboutTextRect.TextBox_H / (TextComponent.FontNormalArray_HEIGHT[1] + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions());
        if (this.mCurrentlyDisplayLines > this.mMaxLines) {
            this.mCurrentlyDisplayLines = this.mMaxLines;
        }
        if (this.bDownKeyPress) {
            this.mDisplayFormLine = this.mDisplayFormLine + this.mCurrentlyDisplayLines >= this.mMaxLines ? this.mMaxLines - this.mCurrentlyDisplayLines : ++this.mDisplayFormLine;
            this.bDownKeyPress = false;
        } else if (this.bUpKeyPress) {
            this.mDisplayFormLine = this.mDisplayFormLine <= 0 ? 0 : --this.mDisplayFormLine;
            this.bUpKeyPress = false;
        }
        this.mStartLineNumber = this.mDisplayFormLine;
        this.mEndLineNumber = this.mDisplayFormLine + this.mCurrentlyDisplayLines;
        int vYpos = this.mAboutTextRect.TextBox_Y;
        int vHighScoreHeadingTitlePosY = vYpos - (TextComponent.FontNormalArray_HEIGHT[1] + (TextComponent.FontNormalArray_HEIGHT[0] >> 1));
        this.pCommonData.mTextComponent.DrawString(StateCommonData.mHintText[19], 0, vHighScoreHeadingTitlePosY, 1, 4, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)0);
        for (int i = this.mStartLineNumber; i < this.mEndLineNumber; ++i) {
            String scoreText = StateCommonData.mHintText[37] + " " + (i + 1);
            this.pCommonData.mTextComponent.DrawString(scoreText, vOffsetOnBothSide, vYpos, 1, 1, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)1);
            this.pCommonData.mTextComponent.DrawString(" = ", vOffsetOnBothSide + vPart1Width, vYpos, 1, 1, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)1);
            this.pCommonData.mTextComponent.DrawString("" + this.pCommonData.mPrefs.levelScores[i], -(StateCommonData.screen_Width - (vOffsetOnBothSide + vPart1Width + vPart2Width + vPArt3Wodth)), vYpos, 1, 2, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)1);
            vYpos += TextComponent.FontNormalArray_HEIGHT[1] + this.pCommonData.mTextComponent.SpaceBetweenMenuOptions();
        }
        if (this.mStartLineNumber != 0) {
            this.pCommonData.mTextComponent.DrawString("\u00af", (StateCommonData.screen_Width >> 1) - this.pCommonData.mTextComponent.GetTextWidth("\u00af".toCharArray(), 1), vYpos, 0, 1, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)0);
        }
        if (this.mEndLineNumber != this.mMaxLines) {
            this.pCommonData.mTextComponent.DrawString("\u00ae", StateCommonData.screen_Width >> 1, vYpos, 0, 1, this.pCommonData.mTextComponent.Defaultvalue, g, (byte)0);
        }
        this.pCommonData.setSoftKeys(g, StateCommonData.mLeftSoftKey, StateCommonData.mRightSoftKey);
    }
}

