/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Animation;
import Game.BenGame;
import Game.Character;
import Game.Map;
import Game.SoundPlayer;
import Game.Weapons;
import StateManager.StateCommonData;

public class Player
extends Character {
    StateCommonData pCommonData;
    BenGame mCanvas;
    public static boolean sIsPlayerAnimationStopped;
    public static final byte STATE_BEN_MORPH = 0;
    public static final byte STATE_BEN_ATTACK_SMALL_START = 1;
    public static final byte STATE_BEN_ATTACK_SMALL_END = 2;
    public static final byte STATE_BEN_CLIMB_LAND = 3;
    public static final byte STATE_BEN_DIE = 4;
    public static final byte STATE_BEN_HURT = 5;
    public static final byte STATE_BEN_IDLE = 6;
    public static final byte STATE_BEN_JUMP_FORWORD_UP = 7;
    public static final byte STATE_BEN_JUMP_FORWORD_DOWN = 8;
    public static final byte STATE_BEN_RUN_SWING1 = 9;
    public static final byte STATE_BEN_RUN_SWING2 = 10;
    public static final byte STATE_BEN_WALK_START = 11;
    public static final byte STATE_BEN_WALK_TO_RUN = 12;
    public static final byte STATE_BEN_WALK_END = 13;
    public static final byte STATE_BEN_RUN_END_SWING1 = 14;
    public static final byte STATE_BEN_RUN_END_SWING2 = 15;
    public static final byte STATE_BEN_JUMP_START = 16;
    public static final byte STATE_BEN_JUMP_END = 17;
    public static final byte STATE_BEN_JUMP_STRAIGHT_UP = 18;
    public static final byte STATE_BEN_JUMP_STRAIGHT_DOWN = 19;
    public static final byte STATE_BEN_FALL = 20;
    public static final byte STATE_BEN_JUMP_STRAIGHT_END = 21;
    public static final byte STATE_BEN_CLING_CLIMB = 22;
    public static final byte STATE_BEN_FALL_FROM_SOFT_PLATFORM = 23;
    public static final byte STATE_BEN_ATTACK_MEDIUM_START = 24;
    public static final byte STATE_BEN_ATTACK_MEDIUM_END = 25;
    public static final byte STATE_BEN_ATTACK_COMBO = 26;
    public static final byte STATE_BEN_JUMP_END_AND_SLIDE = 27;
    public static final byte STATE_BEN_JUMP_TRAMPOLINE_UP = 28;
    public static final byte STATE_BEN_JUMP_TRAMPOLINE_DOWN = 29;
    public byte mComboAttackCounter;
    public static byte MAX_COMBO_ATTACK_COUNTER;
    public static byte MEDIUM_ATTACK_INDEX;
    public static byte COMBO_ATTACK_INDEX;
    public static byte FRAME_TO_START_HEATBLAST_SP_EFF;
    public boolean mIsComboAttack = true;
    public static byte mHeroType;
    boolean mIsInclinedJumpActivated;
    public byte mPlayerScriptIndex;
    Character.Struct_Character struct_Player;
    Weapons pWeapon;
    public int i_CbPlatForm_Y;
    public short mBulletStartX;
    public short mBulletBlastX;
    public int mAnimStartY;
    public byte mClingClimbRestrictOffset;
    public boolean misInvincible;
    public long mInvincibleTimer;

    public Player(BenGame aCanvas, StateCommonData pCommonData) {
        this.pCommonData = pCommonData;
        this.mCanvas = aCanvas;
        this.struct_Player = new Character.Struct_Character();
    }

    public void releasePlayerStructure() {
        this.releaseAniStructure(this.struct_Player);
        if (mHeroType == 0 && this.pWeapon != null) {
            this.pWeapon.releaseWeaponStructure();
            this.pWeapon = null;
        }
    }

    public void realeasePlayerResource() {
        this.releaseAniReasourse();
        if (mHeroType == 0 && this.pWeapon != null) {
            this.pWeapon.realeaseWeaponResource();
        }
    }

    public void unloadPlayerResource() {
        this.realeasePlayerResource();
        this.releasePlayerStructure();
    }

    public void loadBenResources(byte aLevel) {
        switch (aLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                mHeroType = 0;
                this.pWeapon = new Weapons(this);
                this.mClingClimbRestrictOffset = (byte)48;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                mHeroType = 1;
                this.mClingClimbRestrictOffset = (byte)60;
            }
        }
        switch (mHeroType) {
            case 0: {
                this.charAnimation = new Animation();
                String[] HEATBLAST_PNG_ARRAY = new String[]{"/morph_spr.png", "/heatblast.png"};
                this.charAnimation.loadAnimImages(HEATBLAST_PNG_ARRAY);
                this.charAnimation.LoadAnimation("/heatblast.ani");
                this.pWeapon.loadWeaponResource("/fireball.png", "/fireball.ani");
                break;
            }
            case 1: {
                String[] WILDMUTT_PNG_ARRAY = new String[]{"/morph_spr.png", "/wildmutt.png"};
                this.charAnimation = new Animation();
                this.charAnimation.loadAnimImages(WILDMUTT_PNG_ARRAY);
                this.charAnimation.LoadAnimation("/wildmutt.ani");
                break;
            }
        }
    }

    public void initPlayer(byte aLevel) {
        this.struct_Player.state = (byte)6;
        this.struct_Player.mIsCharacterFlipped = false;
        this.struct_Player.iCharFrameNumber = 0;
        int vCharacterWidth = this.charAnimation.mObjAnimationsArray[this.struct_Player.state].AnimationFrames[0].FrameWidth;
        int vCharacterHeight = this.charAnimation.mObjAnimationsArray[this.struct_Player.state].AnimationFrames[0].FrameHeight;
        this.setCharacterWidth(vCharacterWidth, this.struct_Player);
        this.setCharacterHeight(vCharacterHeight, this.struct_Player);
        int YR0W = 0;
        switch (aLevel) {
            case 1: {
                this.setCharacterXOnCanvas(48, this.struct_Player);
                this.setCharacterYOnCanvas(468 - vCharacterHeight, this.struct_Player);
                YR0W = 39;
                break;
            }
            case 2: {
                this.setCharacterXOnCanvas(12, this.struct_Player);
                this.setCharacterYOnCanvas(348 - vCharacterHeight, this.struct_Player);
                YR0W = 29;
                break;
            }
            case 3: {
                this.setCharacterXOnCanvas(24, this.struct_Player);
                this.setCharacterYOnCanvas(216 - vCharacterHeight, this.struct_Player);
                YR0W = 18;
                break;
            }
            case 4: {
                this.setCharacterXOnCanvas(24, this.struct_Player);
                this.setCharacterYOnCanvas(468 - vCharacterHeight, this.struct_Player);
                YR0W = 39;
                break;
            }
            case 5: {
                this.setCharacterXOnCanvas(36, this.struct_Player);
                this.setCharacterYOnCanvas(228 - vCharacterHeight, this.struct_Player);
                YR0W = 19;
                break;
            }
            case 6: {
                this.setCharacterXOnCanvas(12, this.struct_Player);
                this.setCharacterYOnCanvas(708 - vCharacterHeight, this.struct_Player);
                YR0W = 59;
                break;
            }
            case 7: {
                this.setCharacterXOnCanvas(60, this.struct_Player);
                this.setCharacterYOnCanvas(96 - vCharacterHeight, this.struct_Player);
                YR0W = 8;
            }
        }
        int xCamera = this.getCharacterXOnCanvas(this.struct_Player) - this.mCanvas.mPanLeftX <= 0 ? 0 : this.getCharacterXOnCanvas(this.struct_Player) - this.mCanvas.mPanLeftX;
        int yCamera = YR0W * 12 - StateCommonData.screen_Height <= 0 ? 0 : YR0W * 12 - StateCommonData.screen_Height;
        this.mCanvas.setMapXY(xCamera, yCamera);
        this.mCanvas.updateMap();
        this.struct_Player.CurrentAnimFrameRect.x = this.getCharacterXOnCanvas(this.struct_Player);
        this.struct_Player.CurrentAnimFrameRect.y = this.getCharacterYOnCanvas(this.struct_Player);
        this.struct_Player.CurrentAnimFrameRect.dx = this.getCharacterWidth(this.struct_Player);
        this.struct_Player.CurrentAnimFrameRect.dy = this.getCharacterHeight(this.struct_Player);
    }

    public void UpdateBen() {
        if (!sIsPlayerAnimationStopped) {
            if (this.struct_Player.b_KEYPRESSED && this.struct_Player.state == 6 && this.struct_Player.iCharFrameNumber == 0) {
                this.struct_Player.b_KEYPRESSED = false;
                this.struct_Player.state = this.struct_Player.nextState;
                this.mAnimStartY = this.struct_Player.CurrentAnimFrameRect.y;
            }
            if (this.misInvincible) {
                this.mInvincibleTimer -= (long)this.pCommonData.mTimer.getDtMSeconds();
                if (this.mInvincibleTimer <= 0L) {
                    this.misInvincible = false;
                }
            }
            switch (this.struct_Player.state) {
                case 0: {
                    if (StateCommonData.mGameMode == 0) {
                        this.mCanvas.mTimerModeTimer.setStartTimerValue(this.mCanvas.mTimerModeTimer.adjustStartTimerOnPause());
                    }
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    int Yrow = 0;
                    switch (BenGame.mCurrentLevel) {
                        case 1: {
                            this.mCanvas.mMapObjects.TutorialObjectActivate[0] = true;
                            Yrow = 39;
                            break;
                        }
                        case 5: {
                            Yrow = 19;
                        }
                    }
                    this.struct_Player.CurrentAnimFrameRect.y = Yrow * 12 - this.charAnimation.mObjAnimationsArray[this.struct_Player.state].AnimationFrames[0].FrameHeight;
                    break;
                }
                case 27: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 28: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.mIsInclinedJumpActivated) {
                        this.struct_Player.CurrentAnimFrameRect.x = !this.struct_Player.mIsCharacterFlipped ? (this.struct_Player.CurrentAnimFrameRect.x += 6) : (this.struct_Player.CurrentAnimFrameRect.x -= 6);
                    }
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.prevAttack = false;
                    this.struct_Player.state = (byte)29;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 29: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.iCharFrameNumber = this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames - 3;
                    break;
                }
                case 11: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)13;
                    this.struct_Player.iCharFrameNumber = 1;
                    if (!this.mCanvas.mIskeyReapeated) break;
                    this.struct_Player.state = (byte)12;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 12: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)9;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 13: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 7: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)8;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 8: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)17;
                    if (mHeroType == 3) {
                        this.struct_Player.state = (byte)20;
                    }
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 21: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 22: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.mCanvas.mMapObjects.Playerclimb = true;
                    this.struct_Player.state = (byte)3;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 23: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)20;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 5: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 3: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    this.mCanvas.mMapObjects.Playerclimb = false;
                    break;
                }
                case 14: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 15: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 9: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)10;
                    this.struct_Player.iCharFrameNumber = 1;
                    if (!this.mCanvas.mIskeyReleased || this.mCanvas.mIskeyPressedOnce) break;
                    this.struct_Player.state = (byte)14;
                    this.struct_Player.iCharFrameNumber = 1;
                    this.mCanvas.mIskeyReleased = false;
                    break;
                }
                case 10: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)9;
                    this.struct_Player.iCharFrameNumber = 1;
                    if (!this.mCanvas.mIskeyReleased || this.mCanvas.mIskeyPressedOnce) break;
                    this.struct_Player.state = (byte)15;
                    this.struct_Player.iCharFrameNumber = 1;
                    this.mCanvas.mIskeyReleased = false;
                    break;
                }
                case 1: {
                    this.struct_Player.prevAttack = true;
                    if ((mHeroType == 0 || mHeroType == 3) && this.struct_Player.iCharFrameNumber == 3) {
                        for (int i = 0; i < 3; ++i) {
                            if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                            if (SoundPlayer.mIsSoundActive) {
                                // empty if block
                            }
                            int aLayerIndexToBitmap = this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].AnimationLayers[this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].NOFLayers - 1].IndexOfSpriteArray;
                            byte aBitmapIndex = this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].AnimationLayers[this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].NOFLayers - 1].BitmapIndex;
                            this.pWeapon.struct_Weapon[i].state = 0;
                            this.pWeapon.struct_Weapon[i].iCharFrameNumber = 0;
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.dx = this.getCharacterWidth(this.pWeapon.struct_Weapon[i].state, this.pWeapon.struct_Weapon[i].iCharFrameNumber);
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.x = this.struct_Player.CurrentAnimFrameRect.x + (this.struct_Player.mIsCharacterFlipped ? this.charAnimation.mBitmapLayers[aBitmapIndex][aLayerIndexToBitmap].dx - this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.dx : this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].AnimationLayers[this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].NOFLayers - 1].LayerX);
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.y = this.struct_Player.CurrentAnimFrameRect.y + this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].AnimationLayers[this.charAnimation.mObjAnimationsArray[1].AnimationFrames[3].NOFLayers - 1].LayerY + 5;
                            this.setCharacterXOnCanvas(this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.x, this.struct_Player);
                            this.setCharacterYOnCanvas(this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.y, this.struct_Player);
                            this.mBulletStartX = (short)this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.x;
                            this.pWeapon.struct_Weapon[i].mIsActive = true;
                            break;
                        }
                    }
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    if (this.mComboAttackCounter > MEDIUM_ATTACK_INDEX && mHeroType != 2) {
                        if (mHeroType != 1 || SoundPlayer.mIsSoundActive) {
                            // empty if block
                        }
                        this.struct_Player.state = (byte)24;
                        this.struct_Player.iCharFrameNumber = 1;
                        break;
                    }
                    this.struct_Player.state = (byte)2;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 2: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.mComboAttackCounter = 0;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 24: {
                    this.struct_Player.prevAttack = true;
                    if ((mHeroType == 0 || mHeroType == 3) && this.struct_Player.iCharFrameNumber == 1) {
                        for (int i = 0; i < 3; ++i) {
                            if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                            if (SoundPlayer.mIsSoundActive) {
                                // empty if block
                            }
                            int aLayerIndexToBitmap = this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].AnimationLayers[this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].NOFLayers - 1].IndexOfSpriteArray;
                            byte aBitmapIndex = this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].AnimationLayers[this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].NOFLayers - 1].BitmapIndex;
                            this.pWeapon.struct_Weapon[i].state = 0;
                            this.pWeapon.struct_Weapon[i].iCharFrameNumber = 0;
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.dx = this.getCharacterWidth(this.pWeapon.struct_Weapon[i].state, this.pWeapon.struct_Weapon[i].iCharFrameNumber);
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.x = this.struct_Player.CurrentAnimFrameRect.x + (this.struct_Player.mIsCharacterFlipped ? this.charAnimation.mBitmapLayers[aBitmapIndex][aLayerIndexToBitmap].dx - this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.dx : this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].AnimationLayers[this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].NOFLayers - 1].LayerX);
                            this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.y = this.struct_Player.CurrentAnimFrameRect.y + this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].AnimationLayers[this.charAnimation.mObjAnimationsArray[24].AnimationFrames[1].NOFLayers - 1].LayerY + 5;
                            this.setCharacterXOnCanvas(this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.x, this.struct_Player);
                            this.setCharacterYOnCanvas(this.pWeapon.struct_Weapon[i].CurrentAnimFrameRect.y, this.struct_Player);
                            this.pWeapon.struct_Weapon[i].mIsActive = true;
                            break;
                        }
                    }
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)25;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 25: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.mComboAttackCounter = 0;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 6: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 16: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = this.struct_Player.jumpState;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 17: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)6;
                    this.struct_Player.iCharFrameNumber = 0;
                    break;
                }
                case 18: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)19;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 19: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)21;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 20: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.state = (byte)20;
                    this.struct_Player.iCharFrameNumber = 1;
                    break;
                }
                case 4: {
                    ++this.struct_Player.iCharFrameNumber;
                    if (this.struct_Player.iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames) break;
                    this.struct_Player.iCharFrameNumber = this.charAnimation.mObjAnimationsArray[this.struct_Player.state].NOFFrames - 1;
                    sIsPlayerAnimationStopped = true;
                    if (this.mCanvas.mIsLevelComplete) break;
                    if (BenGame.getPlayerLifes() > 0) {
                        this.mCanvas.resetPlayerProps();
                        this.struct_Player.nextState = (byte)6;
                        BenGame.mIsAlertOn = true;
                        StateCommonData.mTextIndex = (byte)63;
                        StateCommonData.mLeftSoftKey = (byte)9;
                        StateCommonData.mRightSoftKey = (byte)10;
                        break;
                    }
                    this.mCanvas.mIsGameOver = true;
                    BenGame.mIsAlertOn = true;
                    StateCommonData.mTextIndex = StateCommonData.mGameMode == 0 ? (byte)65 : (byte)50;
                    StateCommonData.mLeftSoftKey = (byte)9;
                    StateCommonData.mRightSoftKey = (byte)10;
                }
            }
            this.updateNextFrame();
            if (this.mCanvas.mIskeyPressedOnce) {
                this.mCanvas.mIskeyReapeated = true;
            }
            if (this.mCanvas.mIskeyPressedOnce) {
                this.mCanvas.mIskeyPressedOnce = false;
            }
        }
        if (this.struct_Player.state != 28 && this.struct_Player.state != 1 && this.struct_Player.state != 24 && this.struct_Player.state != 26) {
            this.mIsInclinedJumpActivated = false;
            this.struct_Player.prevAttack = false;
        }
    }

    public void updateNextFrame() {
        this.struct_Player.NextAnimFrameRect = this.charAnimation.GetNextFrame(this.struct_Player.state, (short)this.struct_Player.iCharFrameNumber);
        if (this.struct_Player.mIsCharacterFlipped) {
            this.struct_Player.NextAnimFrameRect.x = -this.struct_Player.NextAnimFrameRect.x;
        }
    }

    protected void KEYPRESS_Ben(int keyCode) {
        if (!this.struct_Player.b_KEYPRESSED) {
            block0 : switch (keyCode) {
                case -7: {
                    break;
                }
                case -3: 
                case 52: {
                    if (this.struct_Player.state == 6) {
                        if (this.struct_Player.mIsCharacterFlipped) {
                            this.struct_Player.nextState = (byte)11;
                            this.struct_Player.b_KEYPRESSED = true;
                        }
                        this.struct_Player.mIsCharacterFlipped = true;
                        if (mHeroType == 0 || mHeroType == 3) {
                            for (int i = 0; i < 3; ++i) {
                                if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                                this.pWeapon.struct_Weapon[i].mIsCharacterFlipped = true;
                            }
                        }
                    } else if (!(this.struct_Player.state != 11 && this.struct_Player.state != 13 && this.struct_Player.state != 12 && this.struct_Player.state != 9 && this.struct_Player.state != 10 && this.struct_Player.state != 14 && this.struct_Player.state != 15 || this.struct_Player.mIsCharacterFlipped)) {
                        this.mCanvas.mIskeyPressedOnce = false;
                        this.mCanvas.mIskeyReapeated = false;
                        this.mCanvas.mIskeyReleased = true;
                    } else if (mHeroType == 1 && (this.struct_Player.state == 28 || this.struct_Player.state == 29) || mHeroType == 2 && (this.struct_Player.state == 18 || this.struct_Player.state == 19)) {
                        this.struct_Player.mIsCharacterFlipped = true;
                    }
                    if (mHeroType != 2 && mHeroType != 1 || this.struct_Player.state != 28) break;
                    this.mIsInclinedJumpActivated = true;
                    this.struct_Player.mIsCharacterFlipped = true;
                    break;
                }
                case -4: 
                case 54: {
                    if (this.struct_Player.state == 6) {
                        if (!this.struct_Player.mIsCharacterFlipped) {
                            this.struct_Player.nextState = (byte)11;
                            this.struct_Player.b_KEYPRESSED = true;
                        }
                        this.struct_Player.mIsCharacterFlipped = false;
                        if (mHeroType == 0 || mHeroType == 3) {
                            for (int i = 0; i < 3; ++i) {
                                if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                                this.pWeapon.struct_Weapon[i].mIsCharacterFlipped = false;
                            }
                        }
                    } else if ((this.struct_Player.state == 11 || this.struct_Player.state == 13 || this.struct_Player.state == 12 || this.struct_Player.state == 9 || this.struct_Player.state == 10 || this.struct_Player.state == 14 || this.struct_Player.state == 15) && this.struct_Player.mIsCharacterFlipped) {
                        this.mCanvas.mIskeyPressedOnce = false;
                        this.mCanvas.mIskeyReapeated = false;
                        this.mCanvas.mIskeyReleased = true;
                    } else if (mHeroType == 1 && (this.struct_Player.state == 28 || this.struct_Player.state == 29) || mHeroType == 2 && (this.struct_Player.state == 18 || this.struct_Player.state == 19)) {
                        this.struct_Player.mIsCharacterFlipped = false;
                    }
                    if (mHeroType != 2 && mHeroType != 1 || this.struct_Player.state != 28) break;
                    this.mIsInclinedJumpActivated = true;
                    this.struct_Player.mIsCharacterFlipped = false;
                    break;
                }
                case -1: 
                case 50: {
                    if (this.struct_Player.state == 6) {
                        this.struct_Player.nextState = (byte)16;
                        this.struct_Player.jumpState = (byte)18;
                        this.struct_Player.b_KEYPRESSED = true;
                        break;
                    }
                    if (this.struct_Player.state != 11 && this.struct_Player.state != 13 && this.struct_Player.state != 12 && this.struct_Player.state != 9 && this.struct_Player.state != 10 && this.struct_Player.state != 14 && this.struct_Player.state != 15) break;
                    this.mCanvas.mIskeyPressedOnce = false;
                    this.mCanvas.mIskeyReapeated = false;
                    this.mCanvas.mIskeyReleased = true;
                    break;
                }
                case -2: 
                case 56: {
                    int i;
                    if (this.struct_Player.state != 6) break;
                    int vTileRow = (this.struct_Player.CurrentAnimFrameRect.y + this.struct_Player.CurrentAnimFrameRect.dy) / 12;
                    int vTileCol = (this.struct_Player.CurrentAnimFrameRect.x + this.struct_Player.CurrentAnimFrameRect.dx) / 12;
                    if (this.mPlayerScriptIndex != 1 && (this.mPlayerScriptIndex != 5 || Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][vTileCol + 1]) != 1)) break;
                    this.struct_Player.nextState = (byte)23;
                    this.struct_Player.b_KEYPRESSED = true;
                    for (i = this.struct_Player.CurrentAnimFrameRect.x / 12; i <= (this.struct_Player.CurrentAnimFrameRect.x + this.struct_Player.CurrentAnimFrameRect.dx) / 12; ++i) {
                        if (Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][i]) == 1 || Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][i]) == 6) continue;
                        if (i == this.struct_Player.CurrentAnimFrameRect.x / 12) break;
                        if (i * 12 > this.struct_Player.CurrentAnimFrameRect.x + (this.struct_Player.CurrentAnimFrameRect.dx >> 1)) {
                            this.struct_Player.CurrentAnimFrameRect.x = i * 12 - this.struct_Player.NextAnimFrameRect.dx;
                            break;
                        }
                        this.struct_Player.nextState = (byte)6;
                        break;
                    }
                    for (i = (this.struct_Player.CurrentAnimFrameRect.x + this.struct_Player.CurrentAnimFrameRect.dx) / 12; i >= this.struct_Player.CurrentAnimFrameRect.x / 12; --i) {
                        if (Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][i]) == 1 || Map.getFirstByte(Map.MapData.MapBoundArray[vTileRow][i]) == 5) continue;
                        if (i == (this.struct_Player.CurrentAnimFrameRect.x + this.struct_Player.CurrentAnimFrameRect.dx) / 12) break block0;
                        if (i * 12 + 12 < this.struct_Player.CurrentAnimFrameRect.x + (this.struct_Player.CurrentAnimFrameRect.dx >> 1)) {
                            this.struct_Player.CurrentAnimFrameRect.x = i * 12 + 12;
                            break block0;
                        }
                        this.struct_Player.nextState = (byte)6;
                        break block0;
                    }
                    break;
                }
                case 51: {
                    if (this.struct_Player.state == 6) {
                        this.struct_Player.mIsCharacterFlipped = false;
                        if (mHeroType == 0 || mHeroType == 3) {
                            for (int i = 0; i < 3; ++i) {
                                if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                                this.pWeapon.struct_Weapon[i].mIsCharacterFlipped = false;
                            }
                        }
                        this.struct_Player.nextState = (byte)16;
                        this.struct_Player.jumpState = (byte)7;
                        this.struct_Player.b_KEYPRESSED = true;
                        break;
                    }
                    if (this.struct_Player.state != 11 && this.struct_Player.state != 13 && this.struct_Player.state != 12 && this.struct_Player.state != 9 && this.struct_Player.state != 10 && this.struct_Player.state != 14 && this.struct_Player.state != 15) break;
                    this.mCanvas.mIskeyPressedOnce = false;
                    this.mCanvas.mIskeyReapeated = false;
                    this.mCanvas.mIskeyReleased = true;
                    break;
                }
                case 49: {
                    if (this.struct_Player.state == 6) {
                        this.struct_Player.mIsCharacterFlipped = true;
                        if (mHeroType == 0 || mHeroType == 3) {
                            for (int i = 0; i < 3; ++i) {
                                if (this.pWeapon.struct_Weapon[i].mIsActive) continue;
                                this.pWeapon.struct_Weapon[i].mIsCharacterFlipped = true;
                            }
                        }
                        this.struct_Player.nextState = (byte)16;
                        this.struct_Player.jumpState = (byte)7;
                        this.struct_Player.b_KEYPRESSED = true;
                        break;
                    }
                    if (this.struct_Player.state != 11 && this.struct_Player.state != 13 && this.struct_Player.state != 12 && this.struct_Player.state != 9 && this.struct_Player.state != 10 && this.struct_Player.state != 14 && this.struct_Player.state != 15) break;
                    this.mCanvas.mIskeyPressedOnce = false;
                    this.mCanvas.mIskeyReapeated = false;
                    this.mCanvas.mIskeyReleased = true;
                    break;
                }
                case 55: {
                    break;
                }
                case 57: {
                    break;
                }
                case -5: 
                case 53: {
                    if ((this.struct_Player.state == 6 || this.struct_Player.state == 1 || this.struct_Player.state == 24) && this.mComboAttackCounter < MAX_COMBO_ATTACK_COUNTER) {
                        this.mComboAttackCounter = (byte)(this.mComboAttackCounter + 1);
                    }
                    if (this.struct_Player.state == 6) {
                        if (mHeroType != 1 && mHeroType != 2 || SoundPlayer.mIsSoundActive) {
                            // empty if block
                        }
                        this.struct_Player.nextState = 1;
                        this.struct_Player.b_KEYPRESSED = true;
                        break;
                    }
                    if (this.struct_Player.state != 11 && this.struct_Player.state != 13 && this.struct_Player.state != 12 && this.struct_Player.state != 9 && this.struct_Player.state != 10 && this.struct_Player.state != 14 && this.struct_Player.state != 15) break;
                    this.mCanvas.mIskeyPressedOnce = false;
                    this.mCanvas.mIskeyReapeated = false;
                    this.mCanvas.mIskeyReleased = true;
                    break;
                }
            }
        }
    }

    static {
        MAX_COMBO_ATTACK_COUNTER = (byte)3;
        MEDIUM_ATTACK_INDEX = 1;
        COMBO_ATTACK_INDEX = (byte)2;
        FRAME_TO_START_HEATBLAST_SP_EFF = 1;
    }
}

