/*
 * Decompiled with CFR 0.152.
 */
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Image;

final class Map {
    GameControl gamecontrol;
    GameClass game;
    Renderer renderer;
    CompassMIDlet theApp;
    AI ai;
    int layer1VirtualWidth;
    int layer1VirtualHeight;
    static final int ROL_KIND_NOP = 0;
    static final int ROL_KIND_NORMAL = 1;
    static final int ROL_KIND_HALF_LR = 2;
    static final int ROL_KIND_OPTION_LR = 3;
    static final int ROL_KIND_OPTION_UD = 4;
    static final int ROL_KIND_OPTION_LRUD = 5;
    static final int ROL_KIND_SPECIAL = 6;
    static final int ROL_KIND_ICICLE = 7;
    byte percenthi;
    byte percentlo;
    static final int NUM_COLLISION_BOXES = 5;
    static final int COLLISION_BOX_X = 0;
    static final int COLLISION_BOX_Y = 1;
    static final int COLLISION_BOX_W = 2;
    static final int COLLISION_BOX_H = 3;
    static final int COLLISION_BOX_VAR_SIZE = 4;
    static final int COLLISION_BOX_ARRAY_SIZE = 20;
    int[] collisionBoxes = new int[20];
    static final int REMAP_BLOCKSET_MASK = 63;
    static final int REMAP_BLOCKSET_SHIFT = 10;
    static final int REMAP_STAGE_MASK = 15;
    static final int REMAP_STAGE_SHIFT = 6;
    static final int REMAP_AREA_MASK = 63;
    static final int REMAP_AREA_SHIFT = 0;
    int Map_FloorInCentre;
    static final int MAX_STAGES = 11;
    static final int DRAW_MAP_MULTIPLIER = 4;
    static final int DRAW_MAP_X = 0;
    static final int DRAW_MAP_Y = 1;
    static final int DRAW_MAP_VAR_SIZE = 2;
    static final String SRN_FILE_EXTENSION = "_v1.srn";
    static final short END_OF_LINK_DATA = 127;
    static final short LINK_STAGE = 0;
    static final short LINK_AREA = 1;
    static final short LINK_CHECKX = 2;
    static final short LINK_CHECKY = 3;
    static final short LINK_OFFSETX = 4;
    static final short LINK_OFFSETY = 5;
    static final short LINK_NEWX = 6;
    static final short LINK_NEWY = 7;
    static final short LENGTH_OF_LINK_DATA = 8;
    byte[] hitArray;
    short[] hitMetaBlocks;
    int gbaVirtualScreenSize;
    static final int SHAKE_AMOUNT = 500;
    int pixelWidth;
    int blockWidth;
    int charWidth;
    int blockPixelWidth;
    int charPixelWidth;
    int blockImageWidth;
    static final int BLOCKS_ACROSS_IMAGE = 8;
    static final int BLOCKS_ACROSS_IMAGE_MASK = 7;
    static final int BLOCKS_ACROSS_IMAGE_SHIFT = 3;
    static final int BLOCKS_DOWN_IMAGE = 7;
    static final int PIXELS_ACROSS_METABLOCK_IMAGE = 128;
    static final int PIXELS_PER_CHAR = 16;
    static final int PIXELS_PER_METABLOCK = 128;
    static final int PIXELS_ACROSS_METABLOCK = 16;
    static final int CHARS_ACROSS_METABLOCK = 4;
    static final int PIXELS_ACROSS_CHAR = 4;
    static final int METABLOCK_PIXEL_SIZE = 256;
    static final int NUM_LAYERS = 3;
    int[] layerWidth = new int[3];
    int[] layerHeight = new int[3];
    int[] layerSize = new int[3];
    short[][] layers;
    int maxMapVirtualWidth;
    int maxMapVirtualHeight;
    int layer0GBAWidth;
    int layer0GBAHeight;
    int layer0Width;
    int layer0Height;
    int layer0Size;
    int layer1Width;
    int layer1Height;
    int layer1Size;
    int screenBlockWidth;
    int screenBlockHeight;
    int virtualScreenBlockWidth;
    int virtualScreenBlockHeight;
    static final int MAX_BLOCK_SPRITES = 56;
    int[] blockSprites = new int[56];
    int[][] nonEmptyBlock = new int[56][];
    int currentBlockSprite = -1;
    static final int METABLOCKS_PER_SCREEN = 56;
    static final int PIXELS_DOWN_METABLOCK_IMAGE = 112;
    static final int METABLOCKS_PER_SCREEN_SHIFT = 6;
    int mapX;
    int mapY;
    int mapTargetX;
    int mapTargetY;
    boolean mapSnap;
    int MAP_SMOOTH = 2;
    int mapMaxX;
    int mapMaxY;
    int mapMinY;
    int bottomOfMap;
    static final byte COLLISION_NONE = 0;
    static final byte COLLISION_SOLID = 1;
    static final byte COLLISION_SOFT = 2;
    static final byte COLLISION_ANGLETYPE = 4;
    static final byte COLLISION_ANGLE = 8;
    static final int COLLISION_DEMON = 128;
    Image bgMap = null;
    int bgMapOffsetX = 0;
    int bgMapOffsetY = 0;
    byte needRebuild = (byte)16;
    static final byte REBUILD_LEFT = 1;
    static final byte REBUILD_RIGHT = 2;
    static final byte REBUILD_TOP = 4;
    static final byte REBUILD_BOTTOM = 8;
    static final byte REBUILD_ALL = 16;
    int numberOfMetaBlocks;
    boolean metaBlocksLoaded;
    boolean layer2drawInFront = false;
    int pngImage;
    static final byte[] jordan_exits = new byte[]{0, 2, 20, 1, 1, 0, 1, 0, 0, 3, 0, 0, 1, 2, 0, 19, 3, 0, 1, 2, 0, 3, 10, 1, 2, 0, 0, 14, 1, 1, 2, 2, 0, 14, 3, 0, 3, 0, 0, 8, 1, 1, 3, 2, 0, 8, 6, 0, 4, 0, 0, 8, 3, 1, 4, 2, 0, 8, 5, 0, 5, 0, 0, 8, 3, 1, 5, 2, 0, 8, 6, 0, 6, 0, 0, 9, 3, 1, 6, 0, 0, 3, 9, 0, 7, 2, 0, 3, 6, 1, 7, 0, 0, 3, 8, 0, 8, 2, 0, 3, 6, 1, 8, 0, 0, 3, 9, 0, 9, 2, 0, 3, 6, 1, 9, 0, 0, 8, 10, 0, 10, 2, 0, 8, 9, 1, 10, 0, 0, 3, 1, 2};
    static final byte[] trollsund_exits = new byte[]{0, 4, 13, 8, 1, 0, 0, 4, 49, 8, 1, 3, 1, 5, 13, 8, 0, 0, 1, 4, 19, 8, 2, 1, 1, 4, 26, 8, 2, 2, 1, 5, 48, 8, 0, 1, 1, 4, 54, 8, 2, 5, 2, 4, 13, 8, 3, 0, 2, 5, 20, 8, 1, 1, 2, 5, 33, 8, 1, 2, 2, 4, 40, 8, 3, 1, 2, 4, 54, 8, 3, 2, 2, 5, 57, 8, 1, 4, 3, 5, 10, 8, 2, 0, 3, 5, 30, 8, 2, 3, 3, 5, 41, 8, 2, 4};
    static final byte[] icesheet_exits = new byte[]{0, 2, 3, 8, 1, 0, 1, 0, 0, 8, 0, 0, 1, 2, 10, 8, 2, 0, 2, 0, 0, 8, 1, 0};
    static final byte[][] stage_exits = new byte[][]{jordan_exits, null, trollsund_exits, null, icesheet_exits};
    byte[] startArea = new byte[]{0, 1, 0, 2, 0};
    byte[] Layer2OnFront = new byte[]{2, 0, 2, 1, 2, 2};
    static final int EXIT_AT_LEFT = 0;
    static final int EXIT_AT_TOP = 1;
    static final int EXIT_AT_RIGHT = 2;
    static final int EXIT_AT_BOTTOM = 3;
    static final int[] pngTransparentArray = new int[]{0};
    static final int PALETTE_DATA_OFFSET = 0;
    static final int PALETTE_NUMBER_OFFSET = 2;
    static final int PALETTE_HEADER_SIZE = 4;
    int temp;
    static final int B3_CHAR_FLIP_SHIFT = 4;
    static final int B2_CHAR_FLIP_SHIFT = 6;
    static final int METABLOCK_FLIP_SHIFT = 14;
    static final int FLIP_V = 1;
    static final int FLIP_H = 2;
    static final int SRNM_STAGE = 0;
    static final int SRNM_AREA = 1;
    static final int SRNM_LAYER_X_WIDTH = 2;
    static final int SRNM_LAYER_X_HEIGHT = 3;
    static final int SRNM_LAYER_Y_WIDTH = 4;
    static final int SRNM_LAYER_Y_HEIGHT = 5;
    static final int SRNM_LAYER_Z_WIDTH = 6;
    static final int SRNM_LAYER_Z_HEIGHT = 7;
    static final int SRNM_HEADER_SIZE = 8;

    Map() {
    }

    void Map_initClass(GameControl g2) {
        this.gamecontrol = g2;
        this.game = g2.game;
        this.renderer = g2.renderer;
        this.theApp = g2.theApp;
        this.ai = g2.ai;
    }

    void Map_SetupStage(int i) {
        if (i < 0) {
            i = 0;
        }
        this.gamecontrol.stageNumber = (byte)i;
        this.gamecontrol.areaNumber = this.startArea[i];
        this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
    }

    void Map_OpenArea() {
        short[] tempArray;
        int layerNumber;
        byte thisStage;
        int thisArea;
        int i;
        byte stageNumber;
        this.game.map = this;
        byte areaNumber = this.gamecontrol.areaNumber;
        byte blockSet = stageNumber = this.gamecontrol.stageNumber;
        byte stageToLoad = stageNumber;
        byte areaToLoad = areaNumber;
        this.layer2drawInFront = false;
        for (i = 0; i < this.Layer2OnFront.length; i += 2) {
            if (this.Layer2OnFront[i] != stageNumber || this.Layer2OnFront[i + 1] != areaNumber) continue;
            this.layer2drawInFront = true;
            break;
        }
        this.layers = null;
        this.hitArray = null;
        this.hitMetaBlocks = null;
        this.gamecontrol.remapStageNumber = stageToLoad;
        this.gamecontrol.remapAreaNumber = areaToLoad;
        this.mapSnap = true;
        this.mapX = 0;
        this.mapY = 0;
        this.mapTargetX = 0;
        this.mapTargetY = 0;
        this.blockWidth = Renderer.convertToVirtual(128);
        this.blockWidth = CompassMIDlet.divideWithRemainder(this.blockWidth, 8);
        this.charWidth = this.blockWidth >> 4;
        this.pixelWidth = 65536 / 128;
        String filename1 = "" + blockSet / 10 + blockSet % 10 + SRN_FILE_EXTENSION;
        int size = this.theApp.fileLoad(filename1, null, true, 0, 0);
        byte[] data = new byte[size];
        this.theApp.fileLoad(filename1, data, false, 0, 0);
        this.metaBlocksLoaded = true;
        int srnIndex = -8;
        this.layerSize[0] = 0;
        this.layerSize[1] = 0;
        this.layerSize[2] = 0;
        do {
            thisArea = data[(srnIndex += (this.layerSize[0] << 1) + (this.layerSize[1] << 2) + (this.layerSize[2] << 1) + 8) + 1] & 0x7F;
            thisStage = data[srnIndex + 0];
            for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
                this.layerWidth[layerNumber] = data[srnIndex + 2 + (layerNumber << 1)];
                this.layerHeight[layerNumber] = data[srnIndex + 3 + (layerNumber << 1)];
                if (this.layerWidth[layerNumber] != 0) {
                    if (layerNumber == 0) {
                        this.layer0GBAWidth = this.layerWidth[layerNumber] >> 3;
                        this.layer0GBAHeight = this.layerHeight[layerNumber] >> 3;
                    }
                    this.layerSize[layerNumber] = this.layerWidth[layerNumber] * this.layerHeight[layerNumber];
                    continue;
                }
                this.layerSize[layerNumber] = 0;
            }
        } while (thisArea != areaToLoad || thisStage != stageToLoad);
        this.layers = new short[3][];
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            this.layers[layerNumber] = null;
            if (this.layerSize[layerNumber] == 0) continue;
            this.layers[layerNumber] = new short[this.layerSize[layerNumber]];
            if (layerNumber != 1) continue;
            this.layer1VirtualWidth = this.layerWidth[layerNumber] * this.blockWidth;
            this.layer1VirtualHeight = this.layerHeight[layerNumber] * this.blockWidth;
        }
        int sv_srn_index = srnIndex += 8;
        srnIndex += this.layerSize[1] * 2;
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            if (this.layerSize[layerNumber] == 0) continue;
            this.Map_CopySRNData(layerNumber, data, srnIndex);
            srnIndex += this.layerSize[layerNumber] * 2;
        }
        int sv_srn_size = srnIndex - sv_srn_index;
        data = null;
        short[] metablocks = new short[this.layerSize[0] + this.layerSize[1] + this.layerSize[2]];
        this.theApp.fillShortArray(metablocks, (short)-1);
        int index = 1;
        metablocks[0] = 0;
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            tempArray = this.layers[layerNumber];
            for (i = 0; i < this.layerSize[layerNumber]; ++i) {
                int j;
                for (j = 0; metablocks[j] != tempArray[i] && j < index; ++j) {
                }
                if (j != index) continue;
                metablocks[index++] = tempArray[i];
            }
        }
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            this.layers[layerNumber] = null;
        }
        index = (index + 7) / 8;
        this.Map_BuildMetaBlocks(metablocks, index *= 8, blockSet, areaToLoad);
        data = new byte[sv_srn_size];
        filename1 = "" + blockSet / 10 + blockSet % 10 + SRN_FILE_EXTENSION;
        this.theApp.fileLoad(filename1, data, false, sv_srn_size, sv_srn_index);
        srnIndex = 0;
        this.hitMetaBlocks = new short[this.layerSize[1]];
        for (i = 0; i < this.layerSize[1] << 1; i += 2) {
            this.hitMetaBlocks[i >> 1] = (short)(((data[srnIndex + i] & 0xFF) << 8) + (data[srnIndex + 1 + i] & 0xFF));
        }
        srnIndex += this.layerSize[1] * 2;
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            if (this.layerSize[layerNumber] == 0) continue;
            this.layers[layerNumber] = new short[this.layerSize[layerNumber]];
            this.Map_CopySRNData(layerNumber, data, srnIndex);
            srnIndex += this.layerSize[layerNumber] * 2;
        }
        data = null;
        for (layerNumber = 0; layerNumber < 3; ++layerNumber) {
            tempArray = this.layers[layerNumber];
            for (i = 0; i < this.layerSize[layerNumber]; ++i) {
                int k = 0;
                short tmpShort = (short)(tempArray[i] & 0xFFFF);
                while (metablocks[k] != tmpShort) {
                    ++k;
                }
                tempArray[i] = (short)k;
            }
        }
        metablocks = null;
        filename1 = "hit_lib_v1.hit";
        size = this.theApp.fileLoad(filename1, null, true, 0, 0);
        this.hitArray = new byte[size];
        this.theApp.fileLoad(filename1, this.hitArray, false, 0, 0);
        this.screenBlockWidth = CompassMIDlet.divideWithRemainder(65536, this.blockWidth) + 2;
        this.screenBlockHeight = CompassMIDlet.divideWithRemainder(71680, this.blockWidth) + 1;
        this.virtualScreenBlockHeight = this.screenBlockHeight * this.blockWidth;
        this.virtualScreenBlockWidth = this.screenBlockWidth * this.blockWidth;
        this.gbaVirtualScreenSize = this.blockWidth << 3;
        this.Map_FloorInCentre = this.Map_GetFloor(this.layer1VirtualWidth >> 1, this.layer1VirtualHeight - this.blockWidth, 0);
        this.maxMapVirtualWidth = this.layerWidth[1] * this.blockWidth;
        this.maxMapVirtualHeight = this.layerHeight[1] * this.blockWidth;
        this.mapMaxX = this.maxMapVirtualWidth - 65536 - (this.blockWidth >> 1);
        this.bottomOfMap = this.layerHeight[1] * this.blockWidth;
        this.mapMaxY = this.maxMapVirtualHeight - (140 / 16 - 1) * this.blockWidth - 8000;
        if (this.mapMaxY < 0) {
            this.mapMaxY = 0;
        }
        if (this.mapMaxX < 0) {
            this.mapMaxX = 0;
        }
        this.mapMinY = this.layer0GBAHeight > 1 ? this.blockWidth : 0;
        this.mapX = 0;
        this.mapY = 0;
        this.mapTargetX = 0;
        this.mapTargetY = 0;
        this.bgMap = Image.createImage(128, 140);
        this.needRebuild = (byte)16;
    }

    void Map_drawCollisionBlock(int x, int y, int i) {
        if (i != 0) {
            int ix = i % 8;
            int iy = i / 8;
            ix *= this.blockWidth;
            iy *= this.blockWidth;
        }
    }

    void Map_setMapCoords(int x, int y) {
        this.mapTargetX = CompassMIDlet.limit(x, 0, this.mapMaxX);
        this.mapTargetY = CompassMIDlet.limit(y, this.mapMinY, this.mapMaxY);
        this.mapX = this.mapTargetX;
        this.mapY = this.mapTargetY;
    }

    int Map_GetHeight(int x, int y) {
        return (y /= this.blockWidth) * this.blockWidth;
    }

    int Map_GetBlockIndex(int x, int y, int width, int height) {
        return CompassMIDlet.limit(y / this.blockWidth, 0, height - 1) * width + CompassMIDlet.limit(x / this.blockWidth, 0, width - 1);
    }

    int Map_GetFloor(int x, int y, int collisionType) {
        byte collision;
        block8: {
            y /= this.charWidth;
            y *= this.charWidth;
            boolean validblock = true;
            collision = 0;
            int collisionMapHeight = this.layerHeight[1] * this.blockWidth - this.charWidth;
            while (collision == 0) {
                block7: {
                    block6: {
                        collision = this.Map_GetCollision(x, y);
                        if (collision == 0) break block6;
                        if (collisionType != 0 || (collision & 0x80) == 0) break block7;
                    }
                    collision = 0;
                    validblock = false;
                    if ((y += this.charWidth) <= collisionMapHeight) continue;
                    return Integer.MAX_VALUE;
                }
                validblock = true;
            }
            if (!validblock) break block8;
            while (collision != 0) {
                block9: {
                    block10: {
                        collision = this.Map_GetCollision(x, y);
                        if (collision == 0) break block9;
                        if (collisionType == 1) break block10;
                        if (collisionType != 0 || (collision & 0x80) != 0) break block9;
                    }
                    if ((y -= this.charWidth) >= 0) continue;
                    return Integer.MAX_VALUE;
                }
                y += this.charWidth;
                collision = 0;
            }
        }
        collision = this.Map_GetCollision(x, y);
        y /= this.charWidth;
        --y;
        return y *= this.charWidth;
    }

    int Map_GetBoxFloor(int x, int y) {
        int boxFloor = Integer.MAX_VALUE;
        int x2 = 0;
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] == 0) continue;
            int x1 = this.collisionBoxes[i + 0];
            x2 = this.collisionBoxes[i + 2] + x1;
            int y1 = this.collisionBoxes[i + 1];
            int y2 = y1 + this.collisionBoxes[i + 3];
            if (x < x1 || x > x2 || y > y2 || boxFloor <= y1) continue;
            boxFloor = y1;
        }
        return boxFloor;
    }

    int Map_GetCeiling(int x, int y) {
        if (y > this.maxMapVirtualHeight) {
            return 0;
        }
        while ((this.Map_GetCollision(x, y) & 1) == 0) {
            if ((y -= this.charWidth) >= 0) continue;
            return -this.blockWidth;
        }
        byte col = this.Map_GetCollision(x, y);
        if ((col & 8) != 0) {
            return this.Map_GetSlopeHeight(x, y, col);
        }
        return (y /= this.charWidth) * this.charWidth;
    }

    void Map_UnloadArea() {
        for (int i = 0; i < 56; ++i) {
            this.renderer.RFM_IUnload(this.blockSprites[i]);
            this.blockSprites[i] = 0;
        }
        this.layers = null;
        this.hitArray = null;
        this.bgMap = null;
        System.gc();
    }

    int Map_GetSlopeHeight(int x, int y, byte col) {
        int basey = y / this.charWidth;
        basey *= this.charWidth;
        if ((col & 0x80) != 0) {
            x = (col & 0x30) >> 4;
            int dy = x * this.charWidth >> 2;
            return basey + dy - this.charWidth;
        }
        int dy = x %= this.charWidth;
        if ((col & 4) != 0) {
            dy = this.charWidth - dy;
        }
        return basey + dy - this.charWidth;
    }

    byte Map_GetCollision(int x, int y) {
        int index = this.Map_GetBlockIndex(x, y, this.layerWidth[1], this.layerHeight[1]);
        if (index < 0 || index >= this.layerWidth[1] * this.layerHeight[1]) {
            return -1;
        }
        short blockNumber = this.hitMetaBlocks[index];
        int charx = x % this.blockWidth / (this.blockWidth >> 2) & 3;
        int chary = y % this.blockWidth / (this.blockWidth >> 2) & 3;
        charx = (chary << 2) + charx;
        int collisionIndex = (blockNumber << 4) + charx;
        byte col = (byte)(this.hitArray[collisionIndex] & 0xFF);
        return col;
    }

    void Map_Update() {
        this.mapX = CompassMIDlet.limit(this.mapX, 0, this.mapMaxX);
        this.mapY = CompassMIDlet.limit(this.mapY, this.mapMinY, this.mapMaxY);
    }

    void Map_GetNextAreaAndExit(int direction) {
        int i;
        byte[] curExits = stage_exits[this.gamecontrol.stageNumber];
        int numExits = curExits.length / 6;
        int distance = 100000;
        int exitIndex = -1;
        byte exitNumber = 0;
        for (i = 0; i < numExits; ++i) {
            int calcDistance;
            if (curExits[i * 6 + 0] != this.gamecontrol.areaNumber || curExits[i * 6 + 1] != direction) continue;
            int lx = Renderer.convertToBuild(this.ai.playerMapX);
            lx /= 16;
            int ly = Renderer.convertToBuild(this.ai.playerMapY);
            ly /= 16;
            if ((calcDistance = (lx -= curExits[i * 6 + 2]) * lx + (ly -= curExits[i * 6 + 3]) * ly) >= distance) continue;
            distance = calcDistance;
            exitIndex = i;
            exitNumber = curExits[exitIndex * 6 + 5];
        }
        if (exitIndex == -1) {
            ++this.ai.playerOutOfMap;
        } else {
            int npx = -1;
            int npy = -1;
            byte currExitNumber = 0;
            for (i = 0; i < numExits; ++i) {
                if (curExits[exitIndex * 6 + 4] != curExits[i * 6 + 0]) continue;
                if (currExitNumber == exitNumber) {
                    npx = curExits[i * 6 + 2];
                    npy = curExits[i * 6 + 3];
                    break;
                }
                ++currExitNumber;
            }
            if (npx != -1 || npy == -1) {
                // empty if block
            }
            this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
            this.gamecontrol.forceNewArea = curExits[exitIndex * 6 + 4];
            ++npy;
            npx *= 16;
            npy *= 16;
            npx = Renderer.convertToVirtual(npx);
            npy = Renderer.convertToVirtual(npy);
            this.gamecontrol.levelDirection = direction;
            this.gamecontrol.newLevelPlayerScreenX = npx;
            this.gamecontrol.newLevelPlayerScreenY = npy;
        }
    }

    void Map_CheckCentreExits() {
        byte[] curExits = stage_exits[this.gamecontrol.stageNumber];
        int numExits = curExits.length / 6;
        this.ai.playerCanExitUp = false;
        this.ai.playerCanExitDown = false;
        for (int i = 0; i < numExits; ++i) {
            int dy;
            if (this.gamecontrol.areaNumber != curExits[i * 6 + 0] || curExits[i * 6 + 1] < 4) continue;
            int ex = Renderer.convertToBuild(this.ai.playerMapX);
            int ey = Renderer.convertToBuild(this.ai.playerMapY);
            ey /= 16;
            byte mx = curExits[i * 6 + 2];
            int dx = (ex /= 16) - mx;
            byte my = curExits[i * 6 + 3];
            if (dx * dx + (dy = --ey - my) * dy >= 4) continue;
            if (curExits[i * 6 + 1] == 4) {
                this.ai.playerCanExitUp = true;
            }
            if (curExits[i * 6 + 1] != 5) continue;
            this.ai.playerCanExitDown = true;
        }
    }

    void Map_SetPlayerCentreExit() {
        int i;
        byte toArea = 0;
        byte toExit = 0;
        byte[] curExits = stage_exits[this.gamecontrol.stageNumber];
        int numExits = curExits.length / 6;
        for (i = 0; i < numExits; ++i) {
            int dy;
            if (this.gamecontrol.areaNumber != curExits[i * 6 + 0] || curExits[i * 6 + 1] < 4) continue;
            int ex = Renderer.convertToBuild(this.ai.playerMapX);
            int ey = Renderer.convertToBuild(this.ai.playerMapY);
            ey /= 16;
            byte mx = curExits[i * 6 + 2];
            int dx = (ex /= 16) - mx;
            byte my = curExits[i * 6 + 3];
            if (dx * dx + (dy = --ey - my) * dy >= 4) continue;
            toArea = curExits[i * 6 + 4];
            toExit = curExits[i * 6 + 5];
        }
        int npx = -1;
        int npy = -1;
        byte currExitNumber = 0;
        for (i = 0; i < numExits; ++i) {
            if (toArea != curExits[i * 6 + 0]) continue;
            if (currExitNumber == toExit) {
                npx = curExits[i * 6 + 2];
                npy = curExits[i * 6 + 3];
                break;
            }
            ++currExitNumber;
        }
        this.gamecontrol.forceNewArea = toArea;
        this.gamecontrol.forceNewStage = this.gamecontrol.stageNumber;
        ++npy;
        npx *= 16;
        npy *= 16;
        npx = Renderer.convertToVirtual(npx);
        npy = Renderer.convertToVirtual(npy);
        this.gamecontrol.levelDirection = -1;
        this.gamecontrol.newLevelPlayerScreenX = npx;
        this.gamecontrol.newLevelPlayerScreenY = npy;
    }

    boolean Map_CheckExit() {
        int px = this.ai.playerMapX;
        int py = this.ai.playerMapY;
        int bx = (this.layerWidth[1] - 1) * this.blockWidth + ((this.blockWidth >> 1) - 1200);
        int by = (this.layerHeight[1] - 1) * this.blockWidth + ((this.blockWidth >> 1) - 1200);
        boolean validExit = false;
        if (px >= bx) {
            this.Map_GetNextAreaAndExit(2);
            return true;
        }
        if (px <= this.blockWidth / 2) {
            this.Map_GetNextAreaAndExit(0);
            return true;
        }
        if (py <= this.blockWidth / 2) {
            this.Map_GetNextAreaAndExit(1);
            return true;
        }
        if (py >= by) {
            this.Map_GetNextAreaAndExit(3);
            return true;
        }
        this.Map_CheckCentreExits();
        return false;
    }

    int Map_AddMetablock(short[] array, short value, int max) {
        int i;
        for (i = 0; array[i] != value && i < max; ++i) {
        }
        if (i == max) {
            array[i] = value;
            return max + 1;
        }
        return max;
    }

    short Map_FindMetablock(short[] array, short value) {
        short i = 0;
        while (array[i] != value) {
            i = (short)(i + 1);
        }
        return i;
    }

    void Map_BuildMetaBlocks(short[] metablocks, int numMetablocks, int blockSet, int areaToLoad) {
        int stage;
        int area;
        int i;
        int destPaletteIndex = 0;
        String filename = "" + blockSet / 10 + blockSet % 10;
        String filename1 = filename + "_4x4.csr";
        int size = this.theApp.fileLoad(filename1, null, true, 0, 0);
        byte[] chars = new byte[size];
        this.theApp.fileLoad(filename1, chars, false, 0, 0);
        filename1 = filename + "_b3.mod";
        size = this.theApp.fileLoad(filename1, null, true, 0, 0);
        byte[] mod = new byte[size];
        this.theApp.fileLoad(filename1, mod, false, 0, 0);
        byte[] metablockPixels = new byte[numMetablocks * 256];
        for (i = 0; i < numMetablocks; ++i) {
            short metablocknumber = metablocks[i];
            if (metablocknumber == -1) continue;
            this.Map_DrawMetablock(mod, metablocks[i] & 0x3FFF, chars, metablockPixels, i, metablocks[i] & 0xC000);
        }
        chars = null;
        mod = null;
        byte[] metablockpalette = new byte[768];
        filename1 = "pal_lib_v1.col";
        size = this.theApp.fileLoad(filename1, null, true, 0, 0);
        byte[] palettes = new byte[size];
        this.theApp.fileLoad(filename1, palettes, false, 0, 0);
        int sourcePaletteStart = ((palettes[0] & 0xFF) << 8) + (palettes[1] & 0xFF);
        if (blockSet == 16) {
            blockSet = 0;
        }
        int headerIndex = 4;
        int numPalettes = 0;
        do {
            headerIndex += numPalettes;
            area = palettes[headerIndex++] & 0xFF;
            stage = palettes[headerIndex] & 0xF;
            numPalettes = palettes[headerIndex++] >> 4 & 0xF;
        } while (area != areaToLoad || stage != blockSet);
        for (i = 0; i < numPalettes; ++i) {
            int sourcePaletteIndex;
            if ((sourcePaletteIndex = palettes[headerIndex++] & 0xFF) != 255) {
                sourcePaletteIndex <<= 5;
                sourcePaletteIndex += sourcePaletteStart;
                for (int j = 0; j < 16; ++j) {
                    int colour = (palettes[sourcePaletteIndex++] & 0xFF) << 8;
                    metablockpalette[destPaletteIndex++] = (byte)((colour += palettes[sourcePaletteIndex++] & 0xFF) << 3 & 0xF8);
                    metablockpalette[destPaletteIndex++] = (byte)(colour >> 2 & 0xF8);
                    metablockpalette[destPaletteIndex++] = (byte)(colour >> 7 & 0xF8);
                }
                continue;
            }
            destPaletteIndex += 48;
        }
        if (blockSet == 1 && areaToLoad == 5) {
            metablockpalette[474] = 40;
            metablockpalette[475] = 40;
            metablockpalette[476] = 40;
        }
        palettes = null;
        this.currentBlockSprite = 0;
        while (numMetablocks > 0) {
            if (this.blockSprites[this.currentBlockSprite] != 0) {
                this.renderer.RFM_IUnload(this.blockSprites[this.currentBlockSprite]);
            }
            if (this.nonEmptyBlock[this.currentBlockSprite] == null) {
                int bitsCount = 56;
                this.nonEmptyBlock[this.currentBlockSprite] = new int[(bitsCount >> 5) + 1];
            }
            this.theApp.fillIntArray(this.nonEmptyBlock[this.currentBlockSprite], 0);
            int height = numMetablocks < 56 ? numMetablocks / 8 * 16 : 112;
            this.blockSprites[this.currentBlockSprite] = this.renderer.RFM_ILoadRAW(128, height, 256, metablockPixels, metablockpalette, 255, this.currentBlockSprite * 128 * 112);
            numMetablocks -= 56;
            ++this.currentBlockSprite;
        }
        this.currentBlockSprite = -1;
        metablockpalette = null;
        metablockPixels = null;
    }

    void Map_DrawChar(byte[] chars, int charnumber, byte[] metablockpixels, int metablockindex, int metacharnumber, int palette, int flip) {
        int add;
        int charindex = charnumber * 8;
        palette <<= 4;
        int charx = metacharnumber % 4 * 4;
        int chary = metacharnumber / 4 * 4;
        metablockindex += charx + (chary *= 128);
        if ((flip & 1) != 0) {
            add = -128;
            metablockindex += 384;
        } else {
            add = 128;
        }
        if ((flip & 2) != 0) {
            for (int y = 0; y < 4; ++y) {
                byte val = chars[charindex++];
                metablockpixels[metablockindex + 3] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 2] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 1] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 0] = (byte)((val & 0xF) + palette & 0xFF);
                metablockindex += add;
            }
        } else {
            for (int y = 0; y < 4; ++y) {
                byte val = chars[charindex++];
                metablockpixels[metablockindex + 0] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 1] = (byte)((val & 0xF) + palette & 0xFF);
                val = chars[charindex++];
                metablockpixels[metablockindex + 2] = (byte)((val >> 4 & 0xF) + palette & 0xFF);
                metablockpixels[metablockindex + 3] = (byte)((val & 0xF) + palette & 0xFF);
                metablockindex += add;
            }
        }
    }

    void Map_drawBlock(int x, int y, int i, Graphics destGraphics) {
        int ix = i & 7;
        int iy = i >> 3;
        iy %= 7;
        this.renderer.Renderer_DrawClippedIndexedBmp(this.blockSprites[i / 56], x, y, 16, 16, ix *= 16, iy *= 16, destGraphics);
    }

    void Map_DrawMetablock(byte[] mod, int modnumber, byte[] chars, byte[] metablockpixels, int metablocknumber, int metaflip) {
        int charadd;
        int lineindex;
        int lineadd = 4;
        if (modnumber == 0) {
            return;
        }
        metaflip >>= 14;
        if (((metaflip &= 3) & 2) != 0) {
            lineindex = 3;
            charadd = -1;
        } else {
            lineindex = 0;
            charadd = 1;
        }
        if ((metaflip & 1) != 0) {
            lineindex += 12;
            lineadd = -4;
        }
        int metablockindex = (metablocknumber & 7) * 16 + (metablocknumber >> 3) * 16 * 128;
        int modindex = 4 + modnumber * 48;
        for (int y = 0; y < 4; ++y) {
            int charindex = lineindex;
            for (int x = 0; x < 4; ++x) {
                int flip = mod[modindex] >> 4 ^ metaflip;
                int palette = mod[modindex++] & 0xF;
                int charnumber = (mod[modindex++] & 0xFF) << 8;
                this.Map_DrawChar(chars, charnumber += mod[modindex++] & 0xFF, metablockpixels, metablockindex, charindex, palette, flip);
                charindex += charadd;
            }
            lineindex += lineadd;
        }
    }

    void Map_RenderLayer() {
        Graphics g2 = null;
        int iw = 0;
        int ih = 0;
        if (this.needRebuild != 0) {
            g2 = this.bgMap.getGraphics();
            iw = this.bgMap.getWidth();
            ih = this.bgMap.getHeight();
            if (this.gamecontrol.stageNumber == 2) {
                g2.setColor(143);
            } else if (this.gamecontrol.stageNumber == 4) {
                g2.setColor(5758903);
            } else {
                g2.setColor(13886463);
            }
        }
        if ((this.needRebuild & 0x10) != 0) {
            g2.fillRect(0, 0, iw, ih);
        }
        if (this.needRebuild != 0) {
            int y;
            int x;
            int blockLineIndex;
            int Size = this.layerSize[1];
            int Width = this.layerWidth[1];
            int Height = this.layerHeight[1];
            short[] layer = this.layers[1];
            boolean stopDraw = false;
            if (Size != 0 && (blockLineIndex = this.Map_GetBlockIndex(x = this.mapX, y = this.mapY, Width, Height)) <= Size) {
                x %= this.blockWidth;
                y %= this.blockWidth;
                x = -x;
                y = -y;
                x = Renderer.convertToBuild(x);
                y = Renderer.convertToBuild(y);
                int xstore = x;
                for (int dy = 0; dy < this.screenBlockHeight; ++dy) {
                    x = xstore;
                    if (dy > this.layerHeight[1] - 2) break;
                    if (blockLineIndex < 0) {
                        blockLineIndex = 0;
                    }
                    int i = blockLineIndex;
                    for (int dx = 0; dx < this.screenBlockWidth; ++dx) {
                        short blockNumber;
                        if (i >= Size) {
                            stopDraw = true;
                            break;
                        }
                        if (this.isNonEmptyBlock(blockNumber = layer[i++])) {
                            this.Map_drawBlock(x, y, blockNumber, g2);
                        }
                        x += 16;
                    }
                    if (stopDraw) break;
                    y += 16;
                    blockLineIndex += Width;
                }
            }
        }
        this.renderer.gameCanvasGraphics.drawImage(this.bgMap, 0, 0, 0);
    }

    boolean isNonEmptyBlock(int blockNumber) {
        int nonEmptySpriteMask;
        int blockSpritesIndex = blockNumber / 56;
        int nonEmptySpriteIndex = blockNumber % 56;
        return (this.nonEmptyBlock[blockSpritesIndex][nonEmptySpriteIndex >>= 5] & (nonEmptySpriteMask = 1 << (nonEmptySpriteIndex & 0x1F))) != 0;
    }

    void Map_AddCollisionBox(int x, int y, int width, int height) {
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] != 0) continue;
            this.collisionBoxes[i + 0] = x;
            this.collisionBoxes[i + 1] = y;
            this.collisionBoxes[i + 2] = width;
            this.collisionBoxes[i + 3] = height;
            return;
        }
    }

    void Map_ClearCollisionBoxes() {
        for (int i = 2; i < 20; i += 4) {
            this.collisionBoxes[i] = 0;
        }
    }

    boolean Map_ScanBoxes(int x, int y) {
        int x2 = 0;
        for (int i = 0; i < 20; i += 4) {
            if (this.collisionBoxes[i + 2] == 0) continue;
            int x1 = this.collisionBoxes[i + 0];
            x2 = this.collisionBoxes[i + 2] + x1;
            int y1 = this.collisionBoxes[i + 1];
            int y2 = y1 + this.collisionBoxes[i + 3];
            if (x < x1 || x > x2 || y > y2 || y < y1) continue;
            return true;
        }
        return false;
    }

    void Map_CopySRNData(int layerNumber, byte[] data, int Index) {
        short[] layer = this.layers[layerNumber];
        int Width = this.layerWidth[layerNumber];
        int Height = this.layerHeight[layerNumber];
        boolean maxx = false;
        boolean maxy = false;
        int i = 0;
        try {
            for (int y = 0; y < Height; ++y) {
                for (int x = 0; x < Width; ++x) {
                    layer[i] = (short)(((data[Index + (i << 1)] & 0xFF) << 8) + (data[Index + (i << 1) + 1] & 0xFF));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

