/*
 * Decompiled with CFR 0.152.
 */
import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Image;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.game.GameCanvas;

final class Renderer
extends GameCanvas
implements Runnable {
    public static final int TEXT_SPLIT_WIDTH_DEC = 5;
    static final int WHITE = 0;
    static final int RED = 1;
    static final int BLUE = 2;
    static final int GREEN = 3;
    static final int GRAY = 4;
    static final int BROWN = 5;
    static final int YELLOW = 6;
    static final int BLACK = 7;
    static final int NUM_COLOURS = 8;
    static final int[] colorTable = new int[]{0xFFFFFF, 0xFF0000, 255, 65280, 0x7F7F7F, 0x9F9F00, 0xFFFF00, 0};
    Font font = null;
    Image loadedSprite;
    String[] outputStrings = new String[20];
    CompassMIDlet theApp;
    GameClass game;
    Graphics gameCanvasGraphics;
    Image pImage;
    int bgColor = 0;
    static final int B_W = 128;
    static final int B_H = 140;
    static final int LEFT_EDGE = 42;
    static final int RIGHT_EDGE = 86;
    static final int TOP_EDGE = 46;
    static final int BOTTOM_EDGE = 132;
    static final int V_W = 65536;
    static final int V_SHIFT = 16;
    static final int V_H = 71680;
    static final int BORDER = 4;
    static final int virtualBorder = 2048;
    static final int virtualPixelWidth = 512;
    static final int virtualScreenWidth = 65536;
    static final int virtualScreenHeight = 71680;
    int physicalScreenWidth;
    static final int RTA_X = 0;
    static final int RTA_XC = 1;
    static final int RTA_XR = 2;
    static final int RTA_Y = 0;
    static final int RTA_YC = 4;
    static final int RTA_YB = 8;
    static final int RTA_YSB = 16;
    static final int RF_IIMAGE = 0;
    static final int RF_RESID = 1;
    static final int RF_IMAX = 64;
    Image[] RFIimage = new Image[64];
    int LoadedNotification;
    boolean anyKeyPressed = false;
    static int dataptr;
    static int crcfrom;
    static int pngsize;
    static byte[] data;
    static byte[] PNG_header;
    static byte[] PNG_End;
    public boolean outline = false;
    public boolean flash = false;
    int subFontHeight = 0;
    private String sv_lsk = null;
    private String sv_rsk = null;
    Thread actionThread = null;

    Renderer(boolean suppress) {
        super(suppress);
        this.setFullScreenMode(true);
    }

    void Renderer_initClass(CompassMIDlet app) {
        this.theApp = app;
        this.game = this.theApp.game;
        this.setDisplay();
        this.gameCanvasGraphics = this.getGraphics();
        this.game = this.theApp.game;
    }

    void setDisplay() {
        Core.getDisplay(this.theApp);
        Core.setCurrent(this);
        while (!this.isShown()) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
    }

    void Renderer_DrawClippedIndexedBmp(int spr, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, Graphics destGraphics) {
        Image pImage = this.RFIimage[spr];
        if (spr == 0) {
            return;
        }
        int ImageR = ImageL + ImageW;
        int ImageB = ImageT + ImageH;
        if (ImageR < 0 || ImageL >= 128 || ImageB < 0 || ImageT >= 140) {
            return;
        }
        destGraphics.drawRegion(this.RFIimage[spr], ImageIX, ImageIY, ImageW, ImageH, 0, ImageL, ImageT, 20);
    }

    void Renderer_DrawClippedIndexedBmp(int spr, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        Image pImage = this.RFIimage[spr];
        if (spr == 0) {
            return;
        }
        int ImageR = ImageL + ImageW;
        int ImageB = ImageT + ImageH;
        if (ImageR < 0 || ImageL >= 128 || ImageB < 0 || ImageT >= 140) {
            return;
        }
        this.gameCanvasGraphics.drawRegion(this.RFIimage[spr], ImageIX, ImageIY, ImageW, ImageH, mirror ? 2 : 0, ImageL, ImageT, 20);
    }

    void Renderer_DrawBmp(int sprite, int ImageL, int ImageT) {
        this.gameCanvasGraphics.drawImage(this.RFIimage[sprite], ImageL, ImageT, 0);
    }

    void Renderer_DrawBmpVirtual(int sprite, int ImageL, int ImageT) {
        this.gameCanvasGraphics.drawImage(this.RFIimage[sprite], Renderer.convertToBuild(ImageL), Renderer.convertToBuild(ImageT), 0);
    }

    void drawImage(Image image, int x, int y, int anchor) {
        this.gameCanvasGraphics.drawImage(image, x, y, anchor);
    }

    void drawRegion(int sprite, int src_x, int src_y, int width, int height, int transform, int dest_x, int dest_y, int anchor) {
        this.gameCanvasGraphics.drawRegion(this.RFIimage[sprite], src_x, src_y, width, height, transform, dest_x, dest_y, anchor);
    }

    void Renderer_DrawText(String pStr, int Align, int colour, int X, int Y) {
        int stringWidth = this.Renderer_GetStringWidth(pStr);
        if ((Align & 2) != 0) {
            stringWidth = this.Renderer_GetStringWidth(pStr);
            X = 128 - stringWidth;
        }
        if ((Align & 1) != 0) {
            X = -1;
        }
        if ((Align & 4) != 0) {
            Y = 140 - Y >> 1;
        }
        if ((Align & 8) != 0) {
            Y = 140 - this.Renderer_GetFontHeight() * 3 / 2;
        }
        if ((Align & 0x10) != 0) {
            Y = 140 - (this.Renderer_GetFontHeight() << 1);
        }
        this.drawStringWithOutline(pStr, X, Y, this.gameCanvasGraphics, colour);
    }

    void Renderer_DrawTextVirtual(String pStr, int Align, int colour, int X, int Y) {
        this.Renderer_DrawText(pStr, Align, colour, Renderer.convertToBuild(X), Renderer.convertToBuild(Y));
    }

    int Renderer_CalcTextWH(String pStr, int MaxWidth) {
        int W;
        int H;
        int FontH = this.Renderer_GetFontHeightVirtual();
        int i = this.createSplitStrings(pStr, this.outputStrings, MaxWidth);
        if (i > 1) {
            H = FontH * i;
            W = MaxWidth;
        } else {
            H = FontH;
            W = Renderer.convertToVirtual(this.Renderer_GetStringWidth(pStr));
        }
        return W << 16 & 0xFFFF0000 | H & 0xFFFF;
    }

    int Renderer_GetSpriteWidthVirtual(int ResID) {
        return Renderer.convertToVirtual(this.RFIimage[ResID].getWidth());
    }

    int Renderer_GetSpriteHeightVirtual(int ResID) {
        return Renderer.convertToVirtual(this.RFIimage[ResID].getHeight());
    }

    int Renderer_GetSpriteWidth(int ResID) {
        return this.RFIimage[ResID].getWidth();
    }

    int Renderer_GetSpriteHeight(int ResID) {
        return this.RFIimage[ResID].getHeight();
    }

    void RFM_Open() {
        this.RFM_IEmptyLib();
        this.Renderer_FontOpen();
    }

    int RFM_ILoad(String filename) {
        Image pBrewRes = this.loadImage(filename);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = pBrewRes;
        return Index;
    }

    int RFM_ILoadRAW(int width, int height, int palette, byte[] idata, byte[] pal, int trans, int imgStart) {
        this.create(width, height, palette, idata, pal, trans, imgStart);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = this.loadedSprite;
        this.loadedSprite = null;
        return Index;
    }

    void RFM_IUnload(int ResID) {
        if (this.RFIimage[ResID] == null) {
            return;
        }
        this.RFIimage[ResID] = null;
    }

    int RFM_IFindSlot() {
        for (int Index = 1; Index < 64; ++Index) {
            if (this.RFIimage[Index] != null) continue;
            return Index;
        }
        return 65535;
    }

    void RFM_IEmptyLib() {
        int Index = 64;
        while (Index-- != 0) {
            if (this.RFIimage[Index] == null) continue;
            this.RFIimage[Index] = null;
        }
    }

    static final int convertToBuild(int x) {
        if (((x *= 128) & 0x8000) != 0) {
            x += 65536;
        }
        return x >> 16;
    }

    public void keyPressed(int keyCode) {
        if (this.game != null) {
            this.game.keyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (this.game != null) {
            this.game.keyReleased(keyCode);
        }
    }

    Image loadImage(String filename) {
        try {
            Image img = Image.createImage(filename + ".png");
            return img;
        }
        catch (Throwable t) {
            return null;
        }
    }

    boolean isGameScreenShown() {
        return this.isShown();
    }

    static final int convertToVirtual(int width) {
        int i = (width << 16) / 128;
        return i;
    }

    void Renderer_ClearScreen() {
        this.gameCanvasGraphics.setColor(this.bgColor);
        this.gameCanvasGraphics.fillRect(0, 0, 128, 140);
    }

    static void writeInt(int crc) {
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 24 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 16 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 8 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc & 0xFF);
    }

    void create(int width, int height, int paletteCount, byte[] idata, byte[] pal, int trans, int imgStart) {
        int i;
        byte[] transTable = new byte[256];
        pngsize = 768 + (width + 1) * height + 80;
        if (trans > -1) {
            pngsize += 13 + trans;
        }
        data = new byte[pngsize];
        for (i = 0; i < PNG_header.length; ++i) {
            Renderer.data[i] = PNG_header[i];
        }
        Renderer.data[18] = (byte)(width >> 8 & 0xFF);
        Renderer.data[19] = (byte)(width & 0xFF);
        Renderer.data[22] = (byte)(height >> 8 & 0xFF);
        Renderer.data[23] = (byte)(height & 0xFF);
        dataptr = 29;
        Renderer.writeInt(Core.crc32(data, 12, 17));
        Renderer.writeInt(768);
        crcfrom = dataptr;
        Renderer.writeInt(1347179589);
        int whitePalette = dataptr;
        int palEnd = paletteCount * 3;
        int j = 0;
        i = 0;
        while (i < palEnd) {
            byte r = pal[i + 2];
            byte g2 = pal[i + 1];
            byte b = pal[i];
            transTable[j] = r >= -8 && r <= -1 && g2 >= 0 && g2 <= 8 && b >= -8 && b <= -1 ? 0 : -1;
            Renderer.data[Renderer.dataptr++] = r;
            Renderer.data[Renderer.dataptr++] = g2;
            Renderer.data[Renderer.dataptr++] = b;
            i += 3;
            ++j;
        }
        Renderer.writeInt(Core.crc32(data, crcfrom, (dataptr += 768 - paletteCount * 3) - crcfrom));
        if (trans > -1) {
            Renderer.writeInt(trans + 1);
            crcfrom = dataptr;
            Renderer.writeInt(1951551059);
            for (i = 0; i < trans + 1; ++i) {
                Renderer.data[Renderer.dataptr++] = transTable[i];
            }
            Renderer.writeInt(Core.crc32(data, crcfrom, dataptr - crcfrom));
        }
        int compsize = (width + 1) * height;
        Renderer.writeInt(compsize + 11);
        crcfrom = dataptr;
        Renderer.writeInt(1229209940);
        Renderer.data[Renderer.dataptr++] = 120;
        Renderer.data[Renderer.dataptr++] = -38;
        Renderer.data[Renderer.dataptr++] = 1;
        Renderer.data[Renderer.dataptr++] = (byte)(compsize & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(compsize >>> 8 & 0xFF);
        Renderer.data[Renderer.dataptr] = ~data[dataptr - 2];
        Renderer.data[++Renderer.dataptr] = ~data[dataptr - 2];
        int adlerstart = ++dataptr;
        i = imgStart;
        for (int y = 0; y < height; ++y) {
            Renderer.data[Renderer.dataptr++] = 0;
            for (int x = 0; x < width; ++x) {
                Renderer.data[Renderer.dataptr++] = idata[i];
                if (this.game.map.currentBlockSprite != -1) {
                    int nonEmptySpriteIndex = y / 16 * 8 + x / 16;
                    int nonEmptySpriteMask = 1 << (nonEmptySpriteIndex & 0x1F);
                    nonEmptySpriteIndex >>= 5;
                    if (transTable[idata[i] & 0xFF] != 0) {
                        int[] nArray = this.game.map.nonEmptyBlock[this.game.map.currentBlockSprite];
                        int n = nonEmptySpriteIndex;
                        nArray[n] = nArray[n] | nonEmptySpriteMask;
                    }
                }
                ++i;
            }
        }
        int adler1 = 1;
        int adler2 = 0;
        for (i = 0; i < compsize; ++i) {
            adler2 = (adler1 += data[adlerstart + i] & 0xFF) + adler2;
            adler1 %= 65521;
            adler2 %= 65521;
        }
        Renderer.writeInt(adler2 << 16 | adler1);
        Renderer.writeInt(Core.crc32(data, crcfrom, dataptr - crcfrom));
        for (i = 0; i < PNG_End.length; ++i) {
            Renderer.data[Renderer.dataptr++] = PNG_End[i];
        }
        this.loadedSprite = Image.createImage(data, 0, pngsize);
        transTable = null;
        data = null;
    }

    void Renderer_DrawClippedIndexedBmpVirtual(int sprite, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        int IL = Renderer.convertToBuild(ImageL);
        int IT = Renderer.convertToBuild(ImageT);
        int IW = Renderer.convertToBuild(ImageW);
        int IH = Renderer.convertToBuild(ImageH);
        int IX = Renderer.convertToBuild(ImageIX);
        int IY = Renderer.convertToBuild(ImageIY);
        this.Renderer_DrawClippedIndexedBmp(sprite, IL, IT, IW, IH, IX, IY, mirror);
    }

    void Renderer_FillRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillRect(x, y, w, h);
    }

    void Renderer_FillTri(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillTriangle(x, y, x1, y1, x2, y2);
    }

    void Renderer_DrawLine(int x, int y, int x1, int y1, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawLine(x, y, x1, y1);
    }

    void Renderer_DrawLineVitual(int x, int y, int x1, int y1, int colour) {
        this.Renderer_DrawLine(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(x1), Renderer.convertToBuild(y1), colour);
    }

    void Renderer_DrawRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawRect(x, y, w, h);
    }

    void Renderer_FillRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_FillRect(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(w), Renderer.convertToBuild(h), colour);
    }

    void Renderer_FillTriVirtual(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        this.Renderer_FillTri(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(x1), Renderer.convertToBuild(y1), Renderer.convertToBuild(x2), Renderer.convertToBuild(y2), colour);
    }

    void Renderer_DrawRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_DrawRect(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(w), Renderer.convertToBuild(h), colour);
    }

    int Renderer_GetStringLength(String string) {
        int len = this.Renderer_GetStringWidth(string);
        len = Renderer.convertToVirtual(len);
        return len;
    }

    int Renderer_GetFontHeightVirtual() {
        return Renderer.convertToVirtual(this.Renderer_GetFontHeight());
    }

    int Renderer_GetFontHeight() {
        return this.font.getHeight();
    }

    void Renderer_FontOpen() {
        this.font = Font.getFont(0, 0, 0);
    }

    int Renderer_GetStringWidth(String pStr) {
        return this.font.stringWidth(pStr);
    }

    void Renderer_DrawChar(int x, int y, int chr, int colour, Graphics g2) {
        g2.setFont(this.font);
        g2.setColor(colorTable[colour]);
        g2.drawChar((char)chr, x, y, 4 | 0x10);
    }

    void drawStringWithOutline(String text, int x, int y, Graphics g2, int colour) {
        if (this.flash && (this.game.frameCounter & 8) == 0) {
            return;
        }
        if (colour > 8 || colour < 0) {
            colour = 0;
        }
        int clr = colorTable[colour];
        if (x == -1) {
            x = 128 - this.Renderer_GetStringWidth(text) >> 1;
        }
        g2.setFont(this.font);
        int l = text.indexOf(37);
        if (l >= 0) {
            text = text.replace('%', ':');
        }
        if (this.outline) {
            g2.setColor(0x550000);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if ((ox | oy) == 0) continue;
                    g2.drawString(text, x + ox, y + oy, 4 | 0x10);
                }
            }
        }
        g2.setColor(clr);
        g2.drawString(text, x, y, 4 | 0x10);
    }

    int Renderer_GetCharWidth(int chr) {
        return this.font.charWidth((char)chr);
    }

    void Renderer_SetClipFullScreen() {
        this.gameCanvasGraphics.setClip(0, 0, 128, 140);
    }

    int Renderer_DrawTextMultipleVirtual(String pStr, int Align, int BGR0, int X, int Y, int maxWidth) {
        int y = this.Renderer_DrawTextMultiple(pStr, Align, BGR0, Renderer.convertToBuild(X), Renderer.convertToBuild(Y), Renderer.convertToBuild(maxWidth));
        return Renderer.convertToVirtual(y);
    }

    int Renderer_DrawTextMultiple(String pStr, int Align, int BGR0, int X, int Y, int maxWidth) {
        int fontHeight = this.Renderer_GetFontHeight();
        String[] strings = new String[20];
        int numStrings = this.createSplitStrings(pStr, strings, maxWidth);
        for (int i = 0; i < numStrings; ++i) {
            this.Renderer_DrawText(strings[i], Align, BGR0, X, Y);
            Y += fontHeight + 1 - this.subFontHeight;
        }
        strings = null;
        return Y;
    }

    int createSplitStrings(String text, String[] output, int maxWidth) {
        char currentChar = '\u0000';
        boolean endoftext = false;
        int numStrings = 0;
        int index = output.length;
        while (index-- != 0) {
            output[index] = null;
        }
        if (maxWidth == 0) {
            maxWidth = 123;
        }
        while (!endoftext) {
            String tempString = "";
            int lastSpacePosition = 0;
            boolean endofline = false;
            for (index = 0; this.Renderer_GetStringWidth(tempString) < maxWidth && index < text.length() && !endofline; ++index) {
                currentChar = text.charAt(index);
                tempString = tempString + currentChar;
                if (currentChar == ' ' || currentChar == ':') {
                    lastSpacePosition = index;
                }
                if (currentChar != ':') continue;
                endofline = true;
            }
            if (lastSpacePosition == 0) {
                endofline = false;
                for (index = 0; index < tempString.length() && !endofline; ++index) {
                    currentChar = tempString.charAt(index);
                    if (currentChar != ':') continue;
                    lastSpacePosition = index;
                    endofline = true;
                }
            }
            if (index >= text.length()) {
                lastSpacePosition = text.length();
                endoftext = true;
            }
            tempString = tempString.substring(0, lastSpacePosition);
            if (!endoftext) {
                text = text.substring(lastSpacePosition + 1, text.length());
            }
            output[numStrings++] = tempString;
        }
        return numStrings;
    }

    void Renderer_Render() {
        this.gameCanvasGraphics.setColor(0);
        this.flushGraphics();
    }

    void Renderer_DrawSoftKeys(int keys, int color) {
        this.theApp.menu.Menu_SetupSoftKeys(keys);
    }

    void Renderer_SetupSoftKeys(String lsk, String rsk) {
        if (this.sv_lsk != lsk || this.sv_rsk != rsk) {
            this.sv_lsk = lsk;
            this.sv_rsk = rsk;
        }
    }

    public void beginLongOperation() {
        this.actionThread = new Thread(this);
        this.actionThread.start();
    }

    public void endLongOperation() {
        this.actionThread = null;
    }

    public void run() {
        try {
            StringBuffer loadingString = new StringBuffer(this.game.gameStrings[77] + "...");
            int step = 2;
            Thread currentThread = Thread.currentThread();
            while (currentThread == this.actionThread) {
                if (step == 2) {
                    step = 0;
                    loadingString.delete(loadingString.length() - 2, loadingString.length());
                } else {
                    ++step;
                    loadingString.append('.');
                }
                this.bgColor = 0;
                this.Renderer_ClearScreen();
                this.Renderer_DrawText(loadingString.toString(), 5, 0xFFFFFF, 0, 0);
                this.Renderer_Render();
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable t) {}
            }
        }
        catch (IllegalMonitorStateException e) {
            e.printStackTrace();
        }
    }

    static {
        PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
        PNG_End = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

