/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction.j2j.javax.microedition.lcdui;

import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Ticker;

public abstract class Displayable {
    public static final int FULL_SCREEN_HEIGHT = 160;
    public static final int J2J_KEY_DPAD_UP = -1;
    public static final int J2J_KEY_DPAD_DOWN = -2;
    public static final int J2J_KEY_DPAD_LEFT = -3;
    public static final int J2J_KEY_DPAD_RIGHT = -4;
    public static final int J2J_KEY_DPAD_MIDDLE = -5;
    public static final int J2J_KEY_LSK = -6;
    public static final int J2J_KEY_RSK = -7;
    public static final int J2J_KEY_BACK_CLEAR = -8;
    public static final int J2J_KEY_BACK = -8;
    public static final int J2J_KEY_CLEAR = -8;
    public static final int J2J_KEY_0 = 48;
    public static final int J2J_KEY_1 = 49;
    public static final int J2J_KEY_2 = 50;
    public static final int J2J_KEY_3 = 51;
    public static final int J2J_KEY_4 = 52;
    public static final int J2J_KEY_5 = 53;
    public static final int J2J_KEY_6 = 54;
    public static final int J2J_KEY_7 = 55;
    public static final int J2J_KEY_8 = 56;
    public static final int J2J_KEY_9 = 57;
    public static final int J2J_KEY_STAR = 42;
    public static final int J2J_KEY_POUND = 35;
    public static final int J2J_KEY_ACTION_SK = -6;
    public static final int J2J_KEY_BACK_SK = -7;
    public static final int J2J_DISPLAYABLE_COLOR_BACKGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_BACKGROUND = 986895;
    public static final int J2J_DISPLAYABLE_COLOR_FOREGROUND = 0;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_FOREGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_BORDER = 0xDDDDFF;
    public static final int J2J_DISPLAYABLE_COLOR_HIGHLIGHTED_BORDER = 8959;
    public static final int J2J_DISPLAYABLE_COLOR_TITLE_BACKGROUND = 8959;
    public static final int J2J_DISPLAYABLE_COLOR_TITLE_FOREGROUND = 0xFFFFFF;
    public static final int J2J_DISPLAYABLE_COLOR_HOT_FOREGROUND = 0xFF1111;
    public static final int J2J_CANVAS_COMMAND_DRAW_V_GAP = 2;
    public static final int J2J_CANVAS_COMMAND_DRAW_H_GAP = 2;
    public static final int _X = 0;
    public static final int _Y = 1;
    public static final int _WIDTH = 2;
    public static final int _HEIGHT = 3;
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    private static Object mutex;
    protected volatile int j2j_keyHeld = 0;
    private String title = null;
    private boolean bIsCurrent = false;
    private boolean bFullScreenMode = false;
    private Command cmdLSK = null;
    private Command cmdRSK = null;
    private Command cmdProxyLSK = null;
    private Command cmdProxyRSK = null;
    protected static Proxy j2j_proxy;
    private static final int J2J_COMMAND_TYPE_LEFT = 4;
    private static final int J2J_COMMAND_TYPE_RIGHT = 2;
    private static final int J2J_COMMAND_PRIORITY_LEFT = 1;
    private static final int J2J_COMMAND_PRIORITY_RIGHT = 1;
    private static final Command CMD_PROXY_SPACE_FOR_RIGHT;

    protected Displayable() {
        if (mutex == null) {
            mutex = new Object();
        }
        if (j2j_proxy == null) {
            j2j_proxy = new Proxy();
        }
    }

    public final javax.microedition.lcdui.Displayable getNativeDisplayable() {
        return j2j_proxy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        this.title = s;
        if (this.isShown()) {
            this.repaint();
        }
    }

    public Ticker getTicker() {
        return null;
    }

    public void setTicker(Ticker ticker) {
    }

    public int getWidth() {
        return Displayable.j2j_proxy.iScreenWidth;
    }

    public int getHeight() {
        int result = this.bFullScreenMode ? Displayable.j2j_proxy.iFullScreenHeight : Displayable.j2j_proxy.iScreenHeight;
        return result;
    }

    public final boolean isShown() {
        return this.j2j_isCurrent();
    }

    public final boolean j2j_isCurrent() {
        return Core.getCurrent() == this && !Core.isPaused();
    }

    public void setFullScreenMode(boolean bFull) {
        this.bFullScreenMode = bFull;
        j2j_proxy.nativeSetFullScreenMode(this.bFullScreenMode);
        this.repaint();
    }

    public int getGameAction(int key) {
        int gan = 0;
        try {
            gan = j2j_proxy.getGameAction(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return gan;
    }

    public int getKeyCode(int gameAction) {
        return j2j_proxy.getKeyCode(gameAction);
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public boolean hasPointerEvents() {
        return false;
    }

    public boolean hasRepeatEvents() {
        return false;
    }

    public final void repaint() {
        if (this.isShown()) {
            j2j_proxy.repaint();
        }
    }

    public final void repaint(int x, int y, int width, int height) {
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (width <= 0 || height <= 0 || x >= Displayable.j2j_proxy.iScreenWidth || y >= Displayable.j2j_proxy.iFullScreenHeight) {
            return;
        }
        if (x + width > Displayable.j2j_proxy.iScreenWidth) {
            width = Displayable.j2j_proxy.iScreenWidth - x;
        }
        if (y + height > Displayable.j2j_proxy.iFullScreenHeight) {
            height = Displayable.j2j_proxy.iFullScreenHeight - y;
        }
        if (this.isShown()) {
            j2j_proxy.repaint(x, y, width, height);
        }
    }

    public void serviceRepaints() {
        if (this.isShown()) {
            j2j_proxy.serviceRepaints();
            try {
                Thread.sleep(35L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void keyPressed(int key) {
    }

    protected void keyRepeated(int key) {
    }

    protected void keyReleased(int key) {
    }

    protected void sizeChanged(int w, int h) {
    }

    protected abstract void paint(Graphics var1);

    protected final void j2j_setTitle(String title) {
        this.title = title;
    }

    private final void _commandsChanged() {
        if (!this._updateProxyCommands()) {
            return;
        }
    }

    private final void _restoreProxyState() {
        Displayable.j2j_proxy.stub = this;
    }

    private final void _clearProxyState() {
        Displayable.j2j_proxy.stub = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onShowNotify(boolean fromPause) {
        Object object = mutex;
        synchronized (object) {
            if (!this.bIsCurrent) {
                this.bIsCurrent = true;
                this._restoreProxyState();
                this.showNotify();
                if (!fromPause) {
                    j2j_proxy.repaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onHideNotify(boolean fromPause) {
        Object object = mutex;
        synchronized (object) {
            if (this.bIsCurrent) {
                this.bIsCurrent = false;
                this.hideNotify();
                this._clearProxyState();
            }
        }
    }

    public final void j2j_onPaint(Graphics g2, int[] r) {
        try {
            this.paint(g2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onKeyPressed(int key) {
        Object object = mutex;
        synchronized (object) {
            if (!this.isShown() || key == 0) {
                return;
            }
            this._releaseHeldKey();
            this.j2j_keyHeld = key;
            try {
                this.keyPressed(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void j2j_onKeyReleased(int key) {
        Object object = mutex;
        synchronized (object) {
            if (this.isShown() && key != 0 && this.j2j_keyHeld == key) {
                boolean release = key == this.j2j_keyHeld;
                this.j2j_keyHeld = 0;
                if (release) {
                    try {
                        this.keyReleased(key);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _releaseHeldKey() {
        Object object = mutex;
        synchronized (object) {
            if (this.j2j_keyHeld != 0) {
                int keyHeld = this.j2j_keyHeld;
                this.j2j_keyHeld = 0;
                this.keyReleased(keyHeld);
            }
        }
    }

    public final void onCommandAction(Command c) {
        if (this.isShown() && c != null) {
            this._releaseHeldKey();
            if (c == this.cmdProxyLSK || c == this.cmdProxyRSK) {
                Command cmd = c == this.cmdProxyLSK ? this.cmdLSK : this.cmdRSK;
                final int softkey = Displayable._isAction(cmd) ? -6 : -7;
                this.j2j_onKeyPressed(softkey);
                Core.callSerially(new Runnable(){

                    public void run() {
                        Displayable.this.j2j_onKeyReleased(softkey);
                    }
                });
            }
        }
    }

    protected static final Font j2j_getDefaultFont() {
        return Font.getDefaultFont();
    }

    private final void _removeProxyCommands() {
        if (this.cmdProxyLSK != null) {
            j2j_proxy.removeCommand(this.cmdProxyLSK);
        }
        if (this.cmdProxyRSK != null) {
            j2j_proxy.removeCommand(this.cmdProxyRSK);
        }
    }

    private final void _addProxyCommands() {
        if (this.cmdProxyLSK != null) {
            j2j_proxy.addCommand(this.cmdProxyLSK);
        }
        if (this.cmdProxyRSK != null) {
            j2j_proxy.addCommand(this.cmdProxyRSK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean _updateProxyCommands() {
        Object object = mutex;
        synchronized (object) {
            Command cmdLSK = this.cmdLSK;
            Command cmdRSK = this.cmdRSK;
            Command newCmdProxyLSK = null;
            Command newCmdProxyRSK = null;
            Command oldCmdProxyLSK = this.cmdProxyLSK;
            Command oldCmdProxyRSK = this.cmdProxyRSK;
            if (cmdLSK != null) {
                newCmdProxyLSK = Displayable._isDifferentLabel(cmdLSK.getLabel(), oldCmdProxyLSK) ? new Command(cmdLSK.getLabel(), 4, 1) : oldCmdProxyLSK;
            }
            if (cmdRSK != null) {
                newCmdProxyRSK = Displayable._isDifferentLabel(cmdRSK.getLabel(), oldCmdProxyRSK) ? new Command(cmdRSK.getLabel(), 2, 1) : oldCmdProxyRSK;
            }
            if (newCmdProxyLSK == null && newCmdProxyRSK != null) {
                newCmdProxyLSK = CMD_PROXY_SPACE_FOR_RIGHT;
            }
            if (newCmdProxyLSK == oldCmdProxyLSK && newCmdProxyRSK == oldCmdProxyRSK) {
                return false;
            }
            boolean bShown = this.isShown();
            if (bShown) {
                this._removeProxyCommands();
            }
            this.cmdProxyLSK = newCmdProxyLSK;
            this.cmdProxyRSK = newCmdProxyRSK;
            if (bShown) {
                this._addProxyCommands();
            }
        }
        return true;
    }

    private static final boolean _isDifferentLabel(String s, Command c) {
        return c == null || !s.equals(c.getLabel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _isAction(Command c) {
        if (c == null) {
            return false;
        }
        int type = c.getCommandType();
        if (type == 1) return true;
        if (type == 4) return true;
        if (type != 8) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _isOK(Command c) {
        if (c == null) return false;
        if (c.getCommandType() != 4) return false;
        return true;
    }

    static {
        CMD_PROXY_SPACE_FOR_RIGHT = new Command(" ", 4, 1);
    }

    protected static final class Proxy
    extends Canvas {
        public volatile Displayable stub = null;
        public final int iScreenWidth;
        public final int iScreenHeight;
        public int iFullScreenHeight = 160;
        private final int[] _saveClip = new int[4];
        private boolean bFullScreenMode = false;

        public Proxy() {
            this.iScreenWidth = 128;
            this.iScreenHeight = 140;
        }

        final void nativeSetFullScreenMode(boolean bFullScreenMode) {
            if (bFullScreenMode != this.bFullScreenMode) {
                this.bFullScreenMode = bFullScreenMode;
                this.setFullScreenMode(bFullScreenMode);
            }
        }

        public void paint(javax.microedition.lcdui.Graphics g2) {
            Displayable stub = this.stub;
            if (stub == null) {
                return;
            }
            try {
                this._saveClip(g2);
                stub.j2j_onPaint(new Graphics(g2), this._saveClip);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected void keyPressed(int keyCode) {
            Displayable stub = this.stub;
            if (stub == null) {
                return;
            }
            stub.j2j_onKeyPressed(keyCode);
        }

        protected void keyReleased(int keyCode) {
            Displayable stub = this.stub;
            if (stub == null) {
                return;
            }
            stub.j2j_onKeyReleased(keyCode);
        }

        private final void _saveClip(javax.microedition.lcdui.Graphics g2) {
            this._saveClip[0] = g2.getClipX();
            this._saveClip[1] = g2.getClipY();
            this._saveClip[2] = g2.getClipWidth();
            this._saveClip[3] = g2.getClipHeight();
        }
    }
}

