/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction.j2j.javax.microedition.lcdui;

import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Image;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public final class Font {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    private int iFontStyle;
    private int iFontSize;
    private int iFontHeight;
    private int iFontBaseLine;
    private static final int FREE_IMAGE = -1;
    private static final int MULTI_COLOR_CACHE_SIZE = 7;
    private int iFontColorIndex;
    private int iCharSpace;
    private int iSpaceWidth;
    private byte[] imageData;
    private Image[] images = new Image[7];
    private int[] imageColors = new int[7];
    private int imageFreePosition;
    private String chars;
    private byte[] charW;
    private short[] charX;
    private short[] charY;
    private static final Hashtable fontMap = new Hashtable();

    public static Font getFont(int fontSpecifier) {
        return Font.getDefaultFont();
    }

    public static Font getDefaultFont() {
        return Font._getFont("m.f", 0, 0);
    }

    public static Font getFont(int face, int style, int size) {
        Font f;
        int i = 0;
        char[] s = new char[7];
        if ("/".length() != 0) {
            s[i++] = "/".charAt(0);
        }
        if (size == 8) {
            s[i] = 115;
        }
        if (size == 16) {
            s[i] = 108;
        }
        if (size == 0) {
            s[i] = 109;
        }
        ++i;
        if ((style & 1) != 0) {
            s[i++] = 98;
        }
        if ((style & 2) != 0) {
            s[i++] = 105;
        }
        if ((style & 4) != 0) {
            s[i++] = 117;
        }
        s[i++] = 46;
        s[i++] = 102;
        try {
            f = Font._getFont(new String(s, 0, i), style, size);
        }
        catch (Throwable t) {
            f = Font.getDefaultFont();
        }
        return f;
    }

    public int getStyle() {
        return this.iFontStyle;
    }

    public int getSize() {
        return this.iFontSize;
    }

    public int getFace() {
        return 0;
    }

    public boolean isPlain() {
        return this.iFontStyle == 0;
    }

    public boolean isBold() {
        return (this.iFontStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.iFontStyle & 2) != 0;
    }

    public boolean isUnderlined() {
        return (this.iFontStyle & 4) != 0;
    }

    public int getHeight() {
        int result = this.iFontHeight + 1;
        return result;
    }

    public int getBaselinePosition() {
        int result = this.iFontBaseLine;
        return result;
    }

    public int charWidth(char ch) {
        return this._getCharWidth(ch) + this.iCharSpace;
    }

    private int _charsWidth(char[] ch, int offset, int length) {
        int iWidth = 0;
        int iend = offset + length;
        for (int i = offset; i < iend; ++i) {
            iWidth += this._getCharWidth(ch[i]);
        }
        return iWidth + this.iCharSpace * length;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        return this._charsWidth(ch, offset, length);
    }

    public int stringWidth(String str) {
        char[] ch = str.toCharArray();
        return this._charsWidth(ch, 0, ch.length);
    }

    public int substringWidth(String str, int offset, int length) {
        char[] ch = str.toCharArray();
        return this._charsWidth(ch, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Font(String file, int style, int size) throws IOException {
        byte[] data;
        InputStream in = Core.getResourceAsStream(file);
        if (in == null) {
            throw new IOException();
        }
        try {
            DataInputStream din = new DataInputStream(in);
            this.iFontStyle = style;
            this.iFontSize = size;
            this.iFontHeight = din.readByte();
            this.iFontBaseLine = din.readByte();
            this.iCharSpace = din.readByte();
            this.iSpaceWidth = din.readByte();
            this.iFontColorIndex = din.readShort();
            short iImageWidth = din.readShort();
            String chars = din.readUTF();
            int iCountChars = chars.length();
            din.readShort();
            this.chars = chars;
            this.charW = new byte[iCountChars];
            din.readFully(this.charW);
            this.charX = new short[iCountChars];
            this.charY = new short[iCountChars];
            int x = 0;
            int y = 0;
            for (int i = 0; i < iCountChars; ++i) {
                byte cw = this.charW[i];
                if (x + cw > iImageWidth) {
                    x = 0;
                    y += this.iFontHeight;
                }
                this.charX[i] = (short)x;
                this.charY[i] = (short)y;
                x += cw;
            }
            data = new byte[din.readShort()];
            din.readFully(data);
        }
        finally {
            in.close();
        }
        this.imageData = data;
        for (int i = 0; i < 7; ++i) {
            this.imageColors[i] = -1;
        }
    }

    private static Font _getFont(String url, int style, int size) {
        Font f = (Font)fontMap.get(url);
        if (f == null) {
            try {
                f = new Font(url, style, size);
                fontMap.put(url, f);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (f == null) {
            throw new IllegalArgumentException("Raster font not found: " + url);
        }
        return f;
    }

    private int _getCharWidth(char ch) {
        int i = this.chars.indexOf(ch);
        return i == -1 ? this.iSpaceWidth : this.charW[i];
    }

    private synchronized Image _getColorImage(int color) {
        color &= 0xFFFFFF;
        int iFree = -1;
        for (int i = 0; i < 7; ++i) {
            if (color == this.imageColors[i]) {
                return this.images[i];
            }
            if (this.imageColors[i] != -1) continue;
            iFree = i;
        }
        if (iFree == -1) {
            iFree = this.imageFreePosition++ % 7;
        }
        Core.replacePNGpallete(this.imageData, this.iFontColorIndex, color);
        this.images[iFree] = Image.createImage(this.imageData, 0, this.imageData.length);
        this.imageColors[iFree] = color;
        return this.images[iFree];
    }

    private final int _adjustHorzAnchor(int anchor, int width) {
        int x1 = 0;
        if ((anchor & 8) != 0) {
            x1 = width;
        }
        if ((anchor & 1) != 0) {
            x1 = width >> 1;
        }
        return x1;
    }

    private final int _adjustVertAnchor(int anchor) {
        int y1 = 0;
        if ((anchor & 0x20) != 0) {
            y1 = this.getHeight();
        }
        if ((anchor & 2) != 0) {
            y1 = this.getHeight() >> 1;
        }
        if ((anchor & 0x40) != 0) {
            y1 = this.getBaselinePosition();
        }
        return y1;
    }

    public void drawChar(Graphics g2, char c, int x, int y, int anchor) {
        int index = this.chars.indexOf(c);
        if (index == -1) {
            return;
        }
        Image image = this._getColorImage(g2.getColor());
        g2.drawRegion(image, this.charX[index], this.charY[index], this.charW[index], this.iFontHeight, 0, x -= this._adjustHorzAnchor(anchor, this.charW[index]), y -= this._adjustVertAnchor(anchor), 0x10 | 4);
    }

    private void _drawChars(Graphics g2, char[] data, int offset, int length, int x, int y, int anchor) {
        int width = this.charsWidth(data, offset, length);
        y -= this._adjustVertAnchor(anchor);
        x -= this._adjustHorzAnchor(anchor, width);
        Image image = this._getColorImage(g2.getColor());
        while (length-- > 0) {
            char c;
            int index;
            if ((index = this.chars.indexOf(c = data[offset++])) != -1) {
                g2.drawRegion(image, this.charX[index], this.charY[index], this.charW[index], this.iFontHeight, 0, x, y, 0x10 | 4);
                x += this.charW[index];
            } else {
                x += this.iSpaceWidth;
            }
            x += this.iCharSpace;
        }
    }

    public void drawChars(Graphics g2, char[] data, int offset, int length, int x, int y, int anchor) {
        this._drawChars(g2, data, offset, length, x, y, anchor);
    }

    public void drawString(Graphics g2, String str, int x, int y, int anchor) {
        char[] ch = str.toCharArray();
        this._drawChars(g2, ch, 0, ch.length, x, y, anchor);
    }

    public void drawSubstring(Graphics g2, String str, int offset, int length, int x, int y, int anchor) {
        char[] ch = str.toCharArray();
        this._drawChars(g2, ch, offset, length, x, y, anchor);
    }
}

