/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction.j2j;

import com.mobilepostproduction.j2j.J2JStartProxy;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Display;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Displayable;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.media.mmapi.Manager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Core {
    public static J2JStartProxy j2jStartProxy;
    private static Core instance;
    public static final int STATE_STARTUP = 0;
    public static final int STATE_CONSTRUCTING = 1;
    public static final int STATE_CONSTRUCTED = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_RUNNING = 4;
    public static final int STATE_DESTROYING = 5;
    public static final int STATE_DESTROYED = 6;
    private static volatile int state;
    private volatile Displayable currentDisplayable = null;
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private static final int[] COLOR_VALUES;
    private static final boolean DISPLAY_IS_COLOR = true;
    private static final int DISPLAY_BIT_DEPTH = 16;
    private static final int DISPLAY_ALPHA_LEVELS = 0;
    private static final SamsungEffect samsungVibraEffect;
    public static final String J2J_RESOURCE_SLASH = "/";
    public static final int _X = 0;
    public static final int _Y = 1;
    public static final int _WIDTH = 2;
    public static final int _HEIGHT = 3;
    private static final char[] PRIORITIZED_SEPARATORS;
    private static final int[] SEPARATOR_ALIGNMENTS;
    public static final int BLOCK_SIZE = 512;
    public static final char RESOURCE_SLASH = '/';
    private static final char BAD_RESOURCE_SLASH = '\\';
    private static String[] _index_names;
    private static short[] _index_packages;
    private static int[] _index_offsets;
    private static int[] _index_sizes;
    private static final Object _index_lock;
    private static final int[] CRC32_TABLE;
    public static final int LANG_ENGLISH = 0;
    public static final int LANG_FRENCH = 1;
    public static final int LANG_ITALIAN = 2;
    public static final int LANG_GERMAN = 3;
    public static final int LANG_SPANISH = 4;
    public static final int LANG_PORTUGUESE = 5;
    public static final int LANG_EFIGS_MIN = 0;
    public static final int LANG_EFIGS_MAX = 4;
    public static final int LANG_DEFAULT = 0;

    public static final MIDlet getNativeMidlet() {
        return (MIDlet)j2jStartProxy;
    }

    public static final javax.microedition.lcdui.Display getNativeDisplay() {
        return javax.microedition.lcdui.Display.getDisplay((MIDlet)j2jStartProxy.proxyGetNativeMIDlet());
    }

    public static final int getState() {
        return state;
    }

    public static final synchronized void onInit(J2JStartProxy j2jStartProxy) {
        Core.j2jStartProxy = j2jStartProxy;
        if (instance == null) {
            new Display();
        }
    }

    protected Core() {
        instance = this;
    }

    private final synchronized void _Ctor() {
        state = 1;
        try {
            Core.spawnDaemon(new SelfSuspendDaemon());
            j2jStartProxy.proxyCreateGameMIDlet();
        }
        catch (Throwable t) {
            j2jStartProxy.proxyNotifyDestroyed();
            return;
        }
        state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void _Dtor() {
        try {
            j2jStartProxy.proxyDestroyApp(true);
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
        }
        finally {
            state = 6;
        }
        Manager.onDestroyApp();
        SamsungEffect.destroy(samsungVibraEffect);
    }

    public static void onStartApp() {
        instance._startApp();
    }

    private synchronized void _startApp() {
        if (state == 0) {
            this._Ctor();
        }
        if (state == 2 || state == 3) {
            state = 4;
            Manager.onStartApp();
            try {
                j2jStartProxy.proxyStartApp();
            }
            catch (MIDletStateChangeException e) {
                // empty catch block
            }
            Displayable currentDisplayable = this.currentDisplayable;
            if (currentDisplayable != null) {
                currentDisplayable.j2j_onShowNotify(true);
            }
        }
    }

    public static void onPauseApp() {
        instance._pauseApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _pauseApp() {
        if (state == 4) {
            try {
                Displayable currentDisplayable = this.currentDisplayable;
                if (currentDisplayable != null) {
                    currentDisplayable.j2j_onHideNotify(true);
                }
                j2jStartProxy.proxyPauseApp();
                Manager.onPauseApp();
                Core.vibrate(0);
            }
            finally {
                state = 3;
            }
        }
    }

    public static void onDestroyApp(boolean unconditional) {
        instance._destroyApp();
    }

    private synchronized void _destroyApp() {
        int prevState = state;
        state = 5;
        try {
            if (prevState == 2 || prevState == 4 || prevState == 3) {
                this._Dtor();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean isPaused() {
        return state == 3;
    }

    public static final boolean isDestroyed() {
        return state == 6;
    }

    public static final Display getDisplay(Object m) {
        return (Display)instance;
    }

    public static final Display getDisplay() {
        return Core.getDisplay(null);
    }

    public static final int getColor(int colorSpecifier) {
        return COLOR_VALUES[colorSpecifier];
    }

    public static final int getBorderStyle(boolean highlighted) {
        return 0;
    }

    public static final boolean isColor() {
        return true;
    }

    public static final int numColors() {
        return 65536;
    }

    public static final int numAlphaLevels() {
        return 0;
    }

    public static final Displayable getCurrent() {
        return Core.instance.currentDisplayable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setCurrent(Displayable nextDisplayable) {
        Core core = instance;
        synchronized (core) {
            if (Core.instance.currentDisplayable != nextDisplayable && nextDisplayable != null) {
                if (Core.instance.currentDisplayable != null) {
                    Core.instance.currentDisplayable.j2j_onHideNotify(false);
                }
                Core.instance.currentDisplayable = nextDisplayable;
                Core.getNativeDisplay().setCurrent(nextDisplayable.getNativeDisplayable());
                nextDisplayable.j2j_onShowNotify(false);
            }
        }
    }

    public static final void setCurrent(Alert alert, Displayable nextDisplayable) {
    }

    public static void setCurrentItem(Item item) {
        Core._hideJ2JDisplayable();
    }

    public static final void setCurrent(javax.microedition.lcdui.Displayable nextDisplayable) {
        Core._hideJ2JDisplayable();
        Core.getNativeDisplay().setCurrent(nextDisplayable);
    }

    public static final void setCurrent(Alert alert, javax.microedition.lcdui.Displayable nextDisplayable) {
        Core._hideJ2JDisplayable();
        Core.getNativeDisplay().setCurrent(alert, nextDisplayable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _hideJ2JDisplayable() {
        Core core = instance;
        synchronized (core) {
            if (Core.instance.currentDisplayable != null) {
                Core.instance.currentDisplayable.j2j_onHideNotify(false);
                Core.instance.currentDisplayable = null;
            }
        }
    }

    public static final boolean flashBacklight(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public static final boolean vibrate(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException();
        }
        if (samsungVibraEffect == null) {
            return false;
        }
        samsungVibraEffect.start(duration);
        return true;
    }

    public static final void callSerially(Runnable r) {
        Core.getNativeDisplay().callSerially(r);
    }

    public static void notifyDestroyed() {
        j2jStartProxy.proxyNotifyDestroyed();
    }

    public static void notifyPaused() {
        j2jStartProxy.proxyNotifyPaused();
    }

    public static String getAppProperty(String key) {
        return j2jStartProxy.proxyGetAppProperty(key);
    }

    public static void resumeRequest() {
        j2jStartProxy.proxyResumeRequest();
    }

    public static synchronized boolean platformRequest(String url) throws ConnectionNotFoundException {
        return j2jStartProxy.proxyPlatformRequest(url);
    }

    public static int checkPermission(String permission) {
        return -1;
    }

    private static final void _addString(int width, String line, Vector v, Font font) {
        block0: while (font.stringWidth(line) > width) {
            int len = line.length();
            for (int k = PRIORITIZED_SEPARATORS.length - 1; k >= 0; --k) {
                int pos = len;
                while ((pos = line.lastIndexOf(PRIORITIZED_SEPARATORS[k], pos - 1)) > 0) {
                    int possplit = pos + SEPARATOR_ALIGNMENTS[k];
                    if (possplit >= len || font.substringWidth(line, 0, possplit) > width) continue;
                    v.addElement(line.substring(0, possplit));
                    line = line.substring(possplit);
                    continue block0;
                }
            }
            for (int c = 2; c < len; ++c) {
                if (font.substringWidth(line, 0, c) <= width) continue;
                v.addElement(line.substring(0, c - 1));
                line = line.substring(c - 1);
                continue block0;
            }
        }
        v.addElement(line);
    }

    public static final void splitStrings(int width, String text, Vector v, Font font) {
        if (text == null || width <= 0) {
            return;
        }
        int len = text.length();
        int pos = 0;
        boolean force_break = true;
        String line = "";
        StringBuffer new_line = new StringBuffer();
        do {
            String word;
            int pos_break;
            int fspos = pos;
            while (pos < len && text.charAt(pos) == ' ') {
                ++pos;
            }
            int pos_space = text.indexOf(32, pos);
            if (pos_space == -1) {
                pos_space = text.length();
            }
            if (force_break) {
                pos = fspos;
            }
            boolean bl = force_break = (pos_break = (word = text.substring(pos, pos_space)).indexOf(10)) != -1;
            if (force_break) {
                word = word.substring(0, pos_break);
                pos_space = pos + pos_break;
            }
            pos = pos_space + 1;
            new_line.setLength(0);
            new_line.append(line);
            if (line.length() != 0 && word.length() != 0) {
                new_line.append(' ');
            }
            new_line.append(word);
            String new_line_string = new_line.toString();
            int new_line_string_len = font.stringWidth(new_line_string);
            if (new_line_string_len > width) {
                if (line.length() != 0) {
                    Core._addString(width, line, v, font);
                }
                line = word;
            } else {
                line = new_line_string;
            }
            if (!force_break) continue;
            Core._addString(width, line, v, font);
            line = "";
        } while (pos < len);
        if (line.length() != 0) {
            Core._addString(width, line, v, font);
        }
    }

    public static final String[] splitStrings(int width, String text, Font font) {
        Vector v = new Vector();
        Core.splitStrings(width, text, v, font);
        String[] res = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            res[i] = (String)v.elementAt(i);
        }
        return res;
    }

    public static final void deflateRect(int[] dst, int dx, int dy) {
        dst[0] = dst[0] + dx;
        dst[1] = dst[1] + dy;
        dst[2] = dst[2] - dx * 2;
        dst[3] = dst[3] - dy * 2;
    }

    public static final void intersectRect(int[] dst, int[] r) {
        Core.intersectRect(dst, r[0], r[1], r[2], r[3]);
    }

    public static final void intersectRect(int[] dst, int x, int y, int width, int height) {
        int r_x2 = x + width;
        int dst_x2 = dst[0] + dst[2];
        dst[0] = dst[0] > x ? dst[0] : x;
        dst[2] = (dst_x2 < r_x2 ? dst_x2 : r_x2) - dst[0];
        int r_y2 = y + height;
        int dst_y2 = dst[1] + dst[3];
        dst[1] = dst[1] > y ? dst[1] : y;
        dst[3] = (dst_y2 < r_y2 ? dst_y2 : r_y2) - dst[1];
    }

    public static final void unionRect(int[] dst, int[] r) {
        Core.unionRect(dst, r[0], r[1], r[2], r[3]);
    }

    public static final void unionRect(int[] dst, int x, int y, int width, int height) {
        int r_x2 = x + width;
        int dst_x2 = dst[0] + dst[2];
        dst[0] = dst[0] < x ? dst[0] : x;
        dst[2] = (dst_x2 > r_x2 ? dst_x2 : r_x2) - dst[0];
        int r_y2 = y + height;
        int dst_y2 = dst[1] + dst[3];
        dst[1] = dst[1] < y ? dst[1] : y;
        dst[3] = (dst_y2 > r_y2 ? dst_y2 : r_y2) - dst[1];
    }

    public static final boolean isNormalRect(int[] r) {
        return r[2] >= 0 && r[3] >= 0;
    }

    public static final int indexOf(byte[] a, byte v) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(char[] a, char v) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(short[] a, short v) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] a, int v) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(long[] a, long v) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public static final int pairMap(int[] m, int key, int defaultValue) {
        int len = m.length;
        for (int k = 0; k < len; k += 2) {
            if (m[k] != key) continue;
            return m[k + 1];
        }
        return defaultValue;
    }

    public static final int pairMapReverse(int[] m, int value, int defaultKey) {
        int len = m.length;
        for (int v = 1; v < len; v += 2) {
            if (m[v] != value) continue;
            return m[v - 1];
        }
        return defaultKey;
    }

    public static final void threadSleep(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final int time() {
        return (int)System.currentTimeMillis();
    }

    public static final int readBEIntFromBuffer(byte[] buffer, int index) {
        int i = buffer[index++] & 0xFF;
        int j = buffer[index++] & 0xFF;
        int k = buffer[index++] & 0xFF;
        int l = buffer[index] & 0xFF;
        return (i << 24) + (j << 16) + (k << 8) + (l << 0);
    }

    public static final void writeBEIntToBuffer(byte[] buffer, int index, int value) {
        buffer[index++] = (byte)(value >>> 24 & 0xFF);
        buffer[index++] = (byte)(value >>> 16 & 0xFF);
        buffer[index++] = (byte)(value >>> 8 & 0xFF);
        buffer[index] = (byte)(value >>> 0 & 0xFF);
    }

    public static final void replacePNGpallete(byte[] data, int colorIndex, int newCol) {
        int plteIndex;
        int id;
        int PLTE = 1347179589;
        int dataLen = 0;
        int index = 8;
        do {
            plteIndex = index;
            dataLen = Core.readBEIntFromBuffer(data, index);
            id = Core.readBEIntFromBuffer(data, index += 4);
            index += dataLen + 8;
        } while (id != 1347179589);
        index = plteIndex + 8 + colorIndex * 3;
        data[index++] = (byte)(newCol >>> 16 & 0xFF);
        data[index++] = (byte)(newCol >>> 8 & 0xFF);
        data[index] = (byte)(newCol >>> 0 & 0xFF);
        int crcValue = Core.crc32(data, plteIndex + 4, dataLen + 4);
        Core.writeBEIntToBuffer(data, plteIndex + dataLen + 8, crcValue);
    }

    public static final void skip(InputStream is, int offset) throws IOException {
        while (offset > 0) {
            long sk = is.skip(offset);
            if (sk > 0L) {
                offset = (int)((long)offset - sk);
                continue;
            }
            throw new EOFException();
        }
    }

    public static final String toNativeResName(String anyResName) {
        int i;
        char[] chars = anyResName.toCharArray();
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '\\') continue;
            chars[i] = 47;
        }
        if (i > 0 && chars[0] != '/') {
            return '/' + new String(chars);
        }
        return new String(chars);
    }

    private static final String _toTableResName(String anyResName) {
        int i;
        char[] chars = anyResName.toCharArray();
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' && chars[i] != '\\') continue;
            chars[i] = 47;
        }
        if (i > 0 && chars[0] == '/') {
            return new String(chars, 1, chars.length - 1);
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] _getResourceData(String tableResName, int offset, int size, byte[] data, int[] forSize) {
        if (forSize != null) {
            forSize[0] = size;
            return null;
        }
        InputStream is = tableResName.getClass().getResourceAsStream(Core.toNativeResName(tableResName));
        if (is == null) {
            return null;
        }
        try {
            if (data == null) {
                data = new byte[size];
            } else if (size > data.length) {
                size = data.length;
            }
            try {
                Core.skip(is, offset);
                offset = 0;
                while (size > 0) {
                    int nRead = is.read(data, offset, size);
                    if (nRead < 0) {
                        data = null;
                        break;
                    }
                    offset += nRead;
                    size -= nRead;
                }
            }
            catch (Throwable t) {
                data = null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable t) {}
        }
        return data;
    }

    private static final byte[] _getResourceData(int packageIndex, int offset, int size, byte[] data, int[] forSize) {
        return Core._getResourceData(Core._toTableResName("" + packageIndex), offset, size, data, forSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _loadResourceIndex() throws IOException {
        String INDEX_NAME = "0";
        InputStream is = "0".getClass().getResourceAsStream(Core.toNativeResName("0"));
        try {
            DataInputStream dis = new DataInputStream(is);
            int count = dis.readInt();
            _index_names = new String[count];
            _index_packages = new short[count];
            _index_offsets = new int[count];
            _index_sizes = new int[count];
            while (count-- > 0) {
                Core._index_names[count] = dis.readUTF();
                Core._index_packages[count] = dis.readShort();
                Core._index_offsets[count] = dis.readInt();
                Core._index_sizes[count] = dis.readInt();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] _getResourceAsByteArray(String tableResName, int offset, byte[] data, int[] forSize) {
        Object object = _index_lock;
        synchronized (object) {
            if (_index_names == null) {
                try {
                    Core._loadResourceIndex();
                }
                catch (Exception e) {
                    _index_names = null;
                }
            }
        }
        if (_index_names == null) {
            return null;
        }
        for (int i = 0; i < _index_names.length; ++i) {
            if (!_index_names[i].equals(tableResName)) continue;
            if (_index_packages[i] == -1) {
                return Core._getResourceData(tableResName, offset, _index_sizes[i] - offset, data, forSize);
            }
            return Core._getResourceData(_index_packages[i], _index_offsets[i] + offset, _index_sizes[i] - offset, data, forSize);
        }
        return null;
    }

    public static final InputStream getResourceAsStream(String anyResName) {
        byte[] data = Core._getResourceAsByteArray(Core._toTableResName(anyResName), 0, null, null);
        return data == null ? null : new ByteArrayInputStream(data);
    }

    public static final int getResourceSize(String anyResName) {
        int[] forSize = new int[1];
        byte[] data = Core._getResourceAsByteArray(Core._toTableResName(anyResName), 0, null, forSize);
        return data == null ? forSize[0] : data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readInputStream(InputStream is) throws IOException {
        byte[] block = new byte[512];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int read;
            while ((read = is.read(block)) != -1) {
                bos.write(block, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            bos.close();
        }
    }

    public static final byte[] getResourceAsByteArray(String anyResName, int offset, byte[] data) {
        return Core._getResourceAsByteArray(Core._toTableResName(anyResName), offset, data, null);
    }

    public static final byte[] getResourceAsByteArray(String anyResName) {
        return Core.getResourceAsByteArray(anyResName, 0, null);
    }

    public static final int getMIDILength(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        Core.skip(dis, 4);
        int offset = dis.readInt();
        Core.skip(dis, 2);
        int tracks = dis.readShort();
        int division = dis.readShort();
        if (division < 0) {
            division = 96;
        }
        Core.skip(dis, offset - 6);
        long mcsMIDILength = 0L;
        while (tracks > 0) {
            int trackID = dis.readInt();
            int trackSize = dis.readInt();
            if (trackID == 1297379947) {
                --tracks;
                long mcsTrackLength = Core._getMIDITrackLength(dis, division);
                if (mcsTrackLength <= mcsMIDILength) continue;
                mcsMIDILength = mcsTrackLength;
                continue;
            }
            Core.skip(dis, trackSize);
        }
        return (int)((mcsMIDILength + 500L) / 1000L);
    }

    private static final long _getMIDITrackLength(DataInputStream dis, int division) throws IOException {
        long mcsTrackLength = 0L;
        long ppqn = 0L;
        int mcsPerPPQN = 500000 / division;
        int runStatus = 0;
        int metaEventType = 0;
        do {
            ppqn += (long)Core._readMIDIVarInt(dis);
            int status = dis.readUnsignedByte();
            if ((status & 0x80) == 0) {
                if ((runStatus & 0x80) == 0) continue;
                status = runStatus;
            }
            boolean param1 = false;
            boolean param2 = false;
            if ((status & 0x80) != 0) continue;
            runStatus = status;
            if ((status & 0xF0) == 240) {
                if (status == 255) {
                    metaEventType = dis.readUnsignedByte();
                    if (metaEventType == 81) {
                        mcsTrackLength += ppqn * (long)mcsPerPPQN;
                        ppqn = 0L;
                        int t0 = dis.readUnsignedByte();
                        int t1 = dis.readUnsignedByte();
                        int t2 = dis.readUnsignedByte();
                        mcsPerPPQN = (t0 << 16 | t1 << 8 | t2) / division;
                        continue;
                    }
                    if (metaEventType == 84) {
                        // empty if block
                    }
                }
                Core.skip(dis, Core._readMIDIVarInt(dis));
                continue;
            }
            int type = status & 0xF0;
            int paramCount = type == 192 || type == 208 ? 1 : 2;
            Core.skip(dis, paramCount);
        } while (metaEventType != 47);
        return mcsTrackLength += ppqn * (long)mcsPerPPQN;
    }

    private static final int _readMIDIVarInt(DataInputStream dis) throws IOException {
        int b = dis.readUnsignedByte();
        int value = b;
        if ((value & 0x80) != 0) {
            value &= 0x7F;
            do {
                b = dis.readUnsignedByte();
                value <<= 7;
                value |= b & 0x7F;
            } while ((b & 0x80) != 0);
        }
        return value;
    }

    public static final void spawnDaemon(Runnable daemon) {
        Thread tDaemon = new Thread(daemon);
        try {
            tDaemon.setPriority(10);
        }
        catch (Throwable t) {
            // empty catch block
        }
        tDaemon.start();
        try {
            tDaemon.setPriority(10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] readUTF8Array(String anyResName, boolean nullEmpty) {
        InputStream is = Core.getResourceAsStream(anyResName);
        if (is == null) {
            return null;
        }
        String[] result = null;
        DataInputStream dis = new DataInputStream(is);
        try {
            try {
                int count = dis.readInt();
                result = new String[count];
                for (int i = 0; i < count; ++i) {
                    result[i] = dis.readUTF();
                    if (!nullEmpty || result[i].length() != 0) continue;
                    result[i] = null;
                }
            }
            finally {
                dis.close();
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static final int crc32(byte[] buffer, int offset, int length, int _crc32) {
        if (length == 0) {
            return _crc32;
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            _crc32 ^= buffer[i] & 0xFF;
            _crc32 = CRC32_TABLE[_crc32 & 0xF] ^ _crc32 >>> 4;
            _crc32 = CRC32_TABLE[_crc32 & 0xF] ^ _crc32 >>> 4;
        }
        return _crc32;
    }

    public static final int crc32(byte[] buffer, int offset, int length) {
        return ~Core.crc32(buffer, offset, length, -1);
    }

    public static final int adler32(byte[] buffer, int offset, int length) {
        int a1 = 1;
        int a2 = 0;
        int i = offset;
        int iend = i + length;
        while (i < iend) {
            a2 += (a1 += buffer[i++] & 0xFF);
            a1 %= 65521;
            a2 %= 65521;
        }
        return a2 << 16 | a1;
    }

    public static int getDefaultLanguage() {
        return Core._getDefaultLanguageGeneric();
    }

    private static int _getDefaultLanguageGeneric() {
        return 0;
    }

    private static int _parseISOLangID(String isoLangID) {
        if (isoLangID.equals("eng") || isoLangID.equals("en")) {
            return 0;
        }
        if (isoLangID.equals("fre/fra") || isoLangID.equals("fre") || isoLangID.equals("fra") || isoLangID.equals("fr")) {
            return 1;
        }
        if (isoLangID.equals("ita") || isoLangID.equals("it")) {
            return 2;
        }
        if (isoLangID.equals("ger/deu") || isoLangID.equals("ger") || isoLangID.equals("deu") || isoLangID.equals("de")) {
            return 3;
        }
        if (isoLangID.equals("spa") || isoLangID.equals("es")) {
            return 4;
        }
        if (isoLangID.equals("por") || isoLangID.equals("pt")) {
            return 5;
        }
        return Core._getDefaultLanguageGeneric();
    }

    static {
        state = 0;
        COLOR_VALUES = new int[]{0xFFFFFF, 0, 986895, 0xFFFFFF, 0xDDDDFF, 8959};
        samsungVibraEffect = SamsungEffect.create(true);
        PRIORITIZED_SEPARATORS = new char[]{',', '.', '@', ':', '*', '&', '?', '\\', '/', '=', '-', '{', '[', '('};
        SEPARATOR_ALIGNMENTS = new int[]{1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0};
        _index_lock = new Object();
        CRC32_TABLE = new int[]{0, 498536548, 997073096, 651767980, 1994146192, 1802195444, 1303535960, 1342533948, -306674912, -267414716, -690576408, -882789492, -1687895376, -2032938284, -1609899400, -1111625188};
    }

    static final class SelfSuspendDaemon
    implements Runnable {
        private static final int DELAY = 2000;

        SelfSuspendDaemon() {
        }

        public void run() {
            int startTime = Core.time();
            while (state < 6) {
                Core.threadSleep(500L);
                int endTime = Core.time();
                if (endTime - startTime > 2000 && !Core.isPaused()) {
                    Core.onPauseApp();
                    Core.onStartApp();
                    startTime = Core.time();
                    continue;
                }
                startTime = endTime;
            }
        }
    }

    private static final class SamsungEffect
    implements Runnable {
        private volatile int async_duration_ms = 0;
        private final boolean vibra;
        private final Object event;

        SamsungEffect(boolean vibra) {
            this.vibra = vibra;
            this.event = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                int sync_duration_ms = 0;
                while (true) {
                    if (sync_duration_ms == 0) {
                        Object object = this.event;
                        synchronized (object) {
                            while (this.async_duration_ms == 0) {
                                this.event.wait();
                            }
                            sync_duration_ms = this.async_duration_ms;
                            this.async_duration_ms = 0;
                        }
                    }
                    if (sync_duration_ms < 0) {
                        return;
                    }
                    int duration_ms = sync_duration_ms;
                    sync_duration_ms = 0;
                    int duration_s = (duration_ms + 999) / 1000;
                    Object object = this.event;
                    synchronized (object) {
                        if (this.async_duration_ms == 0) {
                            this.event.wait(duration_ms);
                        }
                        sync_duration_ms = this.async_duration_ms;
                        this.async_duration_ms = 0;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private static boolean _isSupported(boolean vibra) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _sendMessage(int value) {
            Object object = this.event;
            synchronized (object) {
                this.async_duration_ms = value;
                this.event.notify();
            }
        }

        public static SamsungEffect create(boolean vibra) {
            if (!SamsungEffect._isSupported(vibra)) {
                return null;
            }
            SamsungEffect effect = new SamsungEffect(vibra);
            Core.spawnDaemon(effect);
            return effect;
        }

        public static void destroy(SamsungEffect effect) {
            if (effect != null) {
                effect._sendMessage(-1);
            }
        }

        public void start(int duration_ms) {
            this._sendMessage(duration_ms);
        }
    }
}

