/*
 * Decompiled with CFR 0.152.
 */
package com.mobilepostproduction.j2j.javax.microedition.lcdui;

import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Image;

public final class Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    private static final int _X = 0;
    private static final int _Y = 1;
    private static final int _WIDTH = 2;
    private static final int _HEIGHT = 3;
    protected final javax.microedition.lcdui.Graphics nativeGraphics;
    private Font font;
    private final int[] _saveClip = new int[4];

    public javax.microedition.lcdui.Graphics getNativeGraphics() {
        return this.nativeGraphics;
    }

    public Graphics(javax.microedition.lcdui.Graphics nativeGraphics) {
        this.nativeGraphics = nativeGraphics;
    }

    public void translate(int x, int y) {
        this.nativeGraphics.translate(x, y);
    }

    public int getTranslateX() {
        return this.nativeGraphics.getTranslateX();
    }

    public int getTranslateY() {
        return this.nativeGraphics.getTranslateY();
    }

    public int getColor() {
        return this.nativeGraphics.getColor();
    }

    public int getRedComponent() {
        return this.nativeGraphics.getRedComponent();
    }

    public int getGreenComponent() {
        return this.nativeGraphics.getGreenComponent();
    }

    public int getBlueComponent() {
        return this.nativeGraphics.getBlueComponent();
    }

    public int getGrayScale() {
        return this.nativeGraphics.getGrayScale();
    }

    public void setColor(int red, int green, int blue) {
        this.nativeGraphics.setColor(red, green, blue);
    }

    public void setColor(int RGB) {
        this.nativeGraphics.setColor(RGB);
    }

    public void setGrayScale(int value) {
        this.nativeGraphics.setGrayScale(value);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
        return this.font;
    }

    public void setStrokeStyle(int style) {
        this.nativeGraphics.setStrokeStyle(style);
    }

    public int getStrokeStyle() {
        return this.nativeGraphics.getStrokeStyle();
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.getDefaultFont();
        }
        this.font = font;
    }

    public int getClipX() {
        return this.nativeGraphics.getClipX();
    }

    public int getClipY() {
        return this.nativeGraphics.getClipY();
    }

    public int getClipWidth() {
        return this.nativeGraphics.getClipWidth();
    }

    public int getClipHeight() {
        return this.nativeGraphics.getClipHeight();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.nativeGraphics.clipRect(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.nativeGraphics.setClip(x, y, width, height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.nativeGraphics.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.nativeGraphics.fillRect(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.nativeGraphics.drawRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.nativeGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.nativeGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.nativeGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.nativeGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawString(String str, int x, int y, int anchor) {
        this.getFont().drawString(this, str, x, y, anchor);
    }

    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        this.getFont().drawSubstring(this, str, offset, len, x, y, anchor);
    }

    public void drawChar(char character, int x, int y, int anchor) {
        this.getFont().drawChar(this, character, x, y, anchor);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y, int anchor) {
        this.getFont().drawChars(this, data, offset, length, x, y, anchor);
    }

    public void drawImage(Image img, int x, int y, int anchor) {
        this.nativeGraphics.drawImage(img.nativeImage, x, y, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRegion(Image img, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        this._saveClip();
        this.clipRect(x_dest, y_dest, width, height);
        try {
            this.nativeGraphics.drawImage(img.nativeImage, x_dest - x_src, y_dest - y_src, 20);
        }
        finally {
            this._restoreClip();
        }
    }

    public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        int rightx;
        int tmp;
        int J2J_GRAPHICS_FILLTRIANGLE_METHOD3_SHIFT = 8;
        if (y1 > y3) {
            tmp = y1;
            y1 = y3;
            y3 = tmp;
            tmp = x1;
            x1 = x3;
            x3 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y3) {
            tmp = y2;
            y2 = y3;
            y3 = tmp;
            tmp = x2;
            x2 = x3;
            x3 = tmp;
        }
        int shiftChange = 0;
        int dx11 = y1 != y2 ? (x1 - x2 << 8 + shiftChange) / (y1 - y2) : (x2 < x1 ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        int dx12 = y1 != y3 ? (x1 - x3 << 8 + shiftChange) / (y1 - y3) : (x3 < x1 ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        int dx22 = y2 != y3 ? (x2 - x3 << 8 + shiftChange) / (y2 - y3) : (x3 < x2 ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        int leftx = rightx = x1 << 8 + shiftChange;
        rightx += 1 << 8 + shiftChange;
        int increase = 1;
        if (dx11 < dx12) {
            while (y1 < y2) {
                this.fillRect(leftx >> 8 + shiftChange, y1, rightx - leftx >> 8 + shiftChange, 1);
                leftx += dx11;
                rightx += dx12;
                y1 += increase;
            }
            leftx = x2 << 8 + shiftChange;
            while (y1 < y3) {
                this.fillRect(leftx >> 8 + shiftChange, y1, rightx - leftx >> 8 + shiftChange, 1);
                leftx += dx22;
                rightx += dx12;
                y1 += increase;
            }
        } else {
            while (y1 < y2) {
                this.fillRect(leftx >> 8 + shiftChange, y1, rightx - leftx >> 8 + shiftChange, 1);
                leftx += dx12;
                rightx += dx11;
                y1 += increase;
            }
            rightx = x2 + 1 << 8 + shiftChange;
            while (y1 < y3) {
                this.fillRect(leftx >> 8 + shiftChange, y1, rightx - leftx >> 8 + shiftChange, 1);
                leftx += dx12;
                rightx += dx22;
                y1 += increase;
            }
        }
    }

    public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
    }

    public int getDisplayColor(int color) {
        return color;
    }

    public final int[] getClip() {
        return new int[]{this.getClipX(), this.getClipY(), this.getClipWidth(), this.getClipHeight()};
    }

    public final void setClip(int[] clip) {
        this.setClip(clip[0], clip[1], clip[2], clip[3]);
    }

    final void _saveClip() {
        this._saveClip[0] = this.getClipX();
        this._saveClip[1] = this.getClipY();
        this._saveClip[2] = this.getClipWidth();
        this._saveClip[3] = this.getClipHeight();
    }

    final void _restoreClip() {
        this.setClip(this._saveClip);
    }
}

