/*
 * Decompiled with CFR 0.152.
 */
final class GameControl {
    CompassMIDlet theApp;
    Renderer renderer;
    AudioClass audio;
    Fight fight;
    Map map;
    AI ai;
    GameClass game;
    Menu menu;
    boolean playerBorderLeft;
    boolean playerBorderRight;
    boolean playerBorderTop;
    boolean playerBorderBottom;
    static final int eGameControlState_Normal = 0;
    static final int eGameControlState_Menu = 1;
    static final int eGameControlState_Event = 3;
    static final int eGameControlState_Continue = 4;
    static final int eGameControlState_CutScene = 5;
    static final int eGameControlState_GameOver = 6;
    static final int eGameControlState_Cut = 8;
    static final int eGameControlState_Fight = 9;
    boolean wonFightingGame;
    static final int EVENT_COLLECT_COURAGE = 2;
    static final int EVENT_COLLECT_ARMOUR = 3;
    static final int EVENT_MEET_IOREK = 4;
    static final int EVENT_TOUCH_IOREK = 5;
    static final int EVENT_CUTSCENE = 6;
    static final int EVENT_IOREK_COMBAT = 7;
    static final int EVENT_ALCOVE = 8;
    static final int EVENT_DOCK_LOCK_UNLOCKED = 9;
    static final int EVENT_LOCK_CUT_SCENE_PLAYED = 10;
    static final int EVENT_BEWARE_WITCHES = 11;
    static final int EVENT_IOREK_WON_COMBAT = 12;
    static final int EVENT_ICFINAL_A = 13;
    static final int EVENT_ICFINAL_B = 14;
    static final int EVENT_ICFINAL_C = 15;
    static final int NUM_EVENTS = 16;
    int[] eventsCompleted = new int[1];
    static final int CUTSCENE_NUM_STAGE_CUTSCENES = 4;
    static final byte ccsOffsetA = 13;
    static final byte ccsOffsetB = 6;
    static final byte ccsOffsetC = 0;
    static final byte ccsOffsetD = 8;
    static final byte ccsOffsetE = 0;
    static final byte ccsOffsetF = 8;
    static final byte ccsOffsetG = 0;
    static final short[] customCutScenes = new short[]{0, 7442, 1, 0, 1030, 2, 0, 2823, 3, 1, 3334, 17, 8193, 7944, 4, 128, 26384, 5, 128, 23570, 12, 128, 257, 13, 128, 19986, 6, 129, 22290, 6, 131, 786, 6, 130, 15378, 6, 131, 28690, 6, 8325, 28178, 7, 133, 28434, 8, 8647, 1799, 7, 256, 272, 9, 257, 15, 10, 16640, 514, 14, 257, 0, 16, 256, 0, 15, 258, 1799, 18, 258, 2056, 19, 8450, 2313, 20};
    byte areaNumber = 0;
    byte stageNumber = 1;
    short levelNumber = 0;
    byte remapAreaNumber = 0;
    byte remapStageNumber = 0;
    byte forceNewArea = (byte)-1;
    byte forceNewStage = (byte)-1;
    byte forcedDirection;
    int gameState;
    boolean cutSceneFinalFlag = false;
    boolean cutSceneCombatFlag = false;
    short cutSceneTextId = 0;
    public String[] cutStrings;
    static final byte FORCED_OFF_TOP = 0;
    static final byte FORCED_OFF_LEFT = 1;
    static final byte FORCED_OFF_RIGHT = 2;
    static final byte FORCED_OFF_BOTTOM = 3;
    byte currentEvent = 0;
    byte eventPages = 0;
    byte eventScreen = 0;
    boolean isSave;
    int oldLevelXOffset;
    int newLevelPlayerScreenY;
    int newLevelPlayerScreenX;
    int levelDirection;
    int newLevelScreenY;
    int newLevelScreenX;
    int oldLevelXAdjust;
    int oldLevelYAdjust;
    static final int STATS_PLAYER_STATS = 0;
    int currentGameControlState;
    int nextGameControlState;
    long gameStartTime;
    long gameTime;
    int percentCompleted;
    boolean bStartGame = true;
    boolean trialOver = false;
    public boolean inPause = false;
    public static boolean fillCorridorBlack;
    public static boolean fillBottomStripBlack;
    public static boolean fillFightBottomStripGreen;
    GameControl gamecontrol;
    int hudX;
    int hudY;
    int hudstoneSprite;
    int[] hudIorekArmorParts = new int[4];
    int hudIorekBelly = 0;
    int hudIorekFoot = 0;
    int hudIorekHand = 0;
    int hudIorekHead = 0;
    int hudIorekBrain = 0;
    String Hud_TextBoxString = null;
    int Hud_TextBoxTimer;
    int textBoxLeftSprite;
    int textBoxRightSprite;
    int textBoxMidSprite;
    static final int TEXT_BOX_X = 1000;
    static final int TEXT_BOX_Y = 1000;
    static final int TEXT_BOX_BORDER = 500;
    static final int TEXT_BOX_BACK_COLOUR = 32896;
    static final int TEXT_BOX_COLOUR = 0xFFFFFF;
    static final int TEXT_BOX_ON_TIME = 120;
    volatile int loading = 0;
    int loadingCount = 0;
    volatile boolean catchedInPause = false;

    GameControl() {
    }

    void GameControl_InitClass(CompassMIDlet app) {
        this.ai = null;
        this.map = null;
        this.theApp = app;
        this.renderer = this.theApp.renderer;
        this.audio = this.theApp.audio;
        this.game = this.theApp.game;
        this.menu = this.theApp.menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean GameControl_OpenGame() {
        this.bStartGame = true;
        this.renderer.Renderer_translateScene(true);
        try {
            this.updateLoadingScreen(1);
            this.theApp.zeroIntArray(this.eventsCompleted);
            this.renderer.RFM_Open();
            this.gameState = 0;
            if (this.map == null) {
                this.map = new Map();
            }
            if (this.ai == null) {
                this.ai = new AI();
            }
            this.ai.newGame = true;
            this.ai.Player_initClass(this);
            this.map.Map_initClass(this);
            this.map.Map_SetupStage(this.game.startFromStage);
            this.updateLoadingScreen();
            this.game.gameSave(false);
            this.ai.Player_OpenGame();
            this.updateLoadingScreen();
            this.Hud_initClass(this);
            this.Hud_OpenGame();
            this.ai.AI_OpenGame();
            this.updateLoadingScreen();
            this.renderer.Renderer_translateScene(false);
            this.GameControl_OpenArea();
            this.renderer.Renderer_translateScene(true);
            this.currentGameControlState = 0;
            this.gameStartTime = System.currentTimeMillis();
            this.forceNewArea = (byte)-1;
            this.forceNewStage = (byte)-1;
            this.GameControl_StartEvent(0, 3);
            this.updateLoadingScreen();
            this.currentGameControlState = this.nextGameControlState = 0;
        }
        catch (Throwable t) {
            this.game.gameStrings[77] = t.toString();
        }
        finally {
            this.updateLoadingScreen(-1);
        }
        this.renderer.Renderer_translateScene(false);
        this.bStartGame = false;
        return true;
    }

    boolean GameControl_Close() {
        this.map = null;
        this.ai.enemySpec = null;
        this.ai = null;
        this.Hud_Close();
        return true;
    }

    static void resetEmptyAreasfills() {
        fillCorridorBlack = false;
        fillBottomStripBlack = false;
        fillFightBottomStripGreen = false;
    }

    /*
     * Unable to fully structure code
     */
    boolean GameControl_Update() {
        this.gameTime = System.currentTimeMillis() - this.gameStartTime;
        if (!this.trialOver && this.gameTime > 60000L && this.theApp.demoMode) {
            this.trialOver = true;
            this.nextGameControlState = 0;
        }
        if (this.nextGameControlState != this.currentGameControlState) {
            if (this.nextGameControlState != 1 && this.nextGameControlState != 6 && this.nextGameControlState != 4) {
                this.menu.Menu_Close();
            }
            if (this.currentGameControlState == 9) {
                this.fight.Fight_Close();
                this.fight = null;
                if (this.stageNumber == 4 && this.areaNumber == 0) {
                    if (this.wonFightingGame) {
                        this.GameControl_SetEventCompleted(12);
                        this.GameControl_StartCustomCutScene(4, 0, 0, 0);
                    } else {
                        this.ai.newGame = true;
                        this.forceNewArea = this.map.startArea[this.stageNumber];
                        this.forceNewStage = this.stageNumber;
                        this.nextGameControlState = 0;
                    }
                }
            }
            if (this.currentGameControlState == 8) {
                this.cutStrings = null;
                if (this.cutSceneFinalFlag) {
                    if (this.stageNumber == 4) {
                        this.game.availableStage = 5;
                    } else {
                        if (this.game.availableStage == -1) {
                            this.game.availableStage = 0;
                        }
                        if (this.game.availableStage <= this.stageNumber) {
                            this.game.availableStage += 2;
                        }
                    }
                    this.game.gameSave(false);
                    this.game.openStartGame = this.stageNumber != 4;
                    this.game.Game_SetState(3);
                    this.nextGameControlState = 1;
                    this.menu.Menu_SetMenu(18);
                } else if (this.stageNumber == 4 && this.areaNumber == 0 && !this.GameControl_IsEventCompleted(12) && this.cutSceneCombatFlag) {
                    this.cutSceneCombatFlag = false;
                    this.nextGameControlState = 9;
                } else if (this.stageNumber == 4 && this.areaNumber == 1 && !this.GameControl_IsEventCompleted(11)) {
                    this.GameControl_SetEventCompleted(11);
                    this.GameControl_StartCustomCutScene(4, 1, 0, 0);
                }
            }
            this.currentGameControlState = this.nextGameControlState;
            if (this.currentGameControlState == 9) {
                this.renderer.Renderer_translateScene(true);
                this.renderer.beginLongOperation();
                this.fight = new Fight();
                this.fight.Fight_initClass(this, 1);
                this.renderer.endLongOperation();
                this.renderer.Renderer_translateScene(false);
                this.renderer.Renderer_drawIngameBackground();
            }
            if (this.currentGameControlState == 8) {
                this.cutStrings = GameClass.loadStrings(GameClass.languageStrings[this.game.language] + "c");
            }
        }
        switch (this.currentGameControlState) {
            case 0: {
                if (this.forceNewArea != -1) {
                    sv_forceNewArea = this.forceNewArea;
                    sv_forceNewStage = this.forceNewStage;
                    this.forceNewArea = (byte)-1;
                    this.forceNewStage = (byte)-1;
                    this.unloadArea();
                    this.areaNumber = sv_forceNewArea;
                    this.stageNumber = sv_forceNewStage;
                    this.GameControl_OpenArea();
                }
                if ((this.game.debounceKeyMap & (64 | 131072)) != 0) {
                    this.theApp.pauseApp();
                }
                if (this.theApp.cheats) {
                    if ((this.game.debounceKeyMap & (4096 | 16)) != 0 && AI.DEBUG_CAMERA) {
                        AI.DEBUG_CAMERA = false;
                        AI.debugCamera = 0;
                        this.game.debounceKeyMap &= ~(4096 | 16);
                    }
                }
                if (this.trialOver) {
                    this.ai.Player_Reset();
                    this.menu.fromGameMenu = false;
                    this.GameControl_InitInGameMenu(27);
                }
                psx = Renderer.convertToBuild(this.ai.playerScreenX);
                psy = Renderer.convertToBuild(this.ai.playerScreenY);
                if (!this.ai.showCam) {
                    if (psx < 58 && !this.playerBorderLeft) {
                        this.playerBorderLeft = true;
                        this.map.needRebuild = (byte)16;
                    }
                    if (psx >= 58) {
                        this.playerBorderLeft = false;
                    }
                    if (psx > 118 && !this.playerBorderRight) {
                        this.playerBorderRight = true;
                        this.map.needRebuild = (byte)16;
                    }
                    if (psx <= 118) {
                        this.playerBorderRight = false;
                    }
                    if (psy < Renderer.TOP_EDGE && !this.playerBorderTop) {
                        this.playerBorderTop = true;
                        this.map.needRebuild = (byte)16;
                    }
                    if (psy >= Renderer.TOP_EDGE) {
                        this.playerBorderTop = false;
                    }
                    if (psy > Renderer.BOTTOM_EDGE && !this.playerBorderBottom) {
                        this.playerBorderBottom = true;
                        this.map.needRebuild = (byte)16;
                    }
                    if (psy <= Renderer.BOTTOM_EDGE) {
                        this.playerBorderBottom = false;
                    }
                } else {
                    this.playerBorderLeft = false;
                    this.playerBorderRight = false;
                    this.playerBorderTop = false;
                    this.playerBorderBottom = false;
                }
                if (psy > Renderer.B_H || psy < 0 || psx < 0) ** GOTO lbl139
                if (psx <= 176) ** GOTO lbl140
lbl139:
                // 2 sources

                this.map.needRebuild = (byte)16;
lbl140:
                // 2 sources

                this.map.Map_Update();
                this.ai.AI_Update();
                this.ai.Player_Update();
                if (this.renderer.isShown()) break;
                return false;
            }
            case 1: 
            case 6: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
                break;
            }
            case 4: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
                this.ai.Player_Reset();
                this.forceNewArea = this.areaNumber = this.map.startArea[this.stageNumber];
                this.forceNewStage = this.stageNumber;
                break;
            }
            case 9: {
                if (this.fight.Fight_Update()) break;
                this.nextGameControlState = 0;
                break;
            }
            case 8: {
                debounce = this.game.debounceKeyMap;
                if ((debounce & (64 | 131072)) != 0) {
                    this.theApp.pauseApp();
                }
                if ((debounce & (16 | 32)) == 0) break;
                this.nextGameControlState = 0;
                break;
            }
            case 5: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
            }
        }
        return true;
    }

    boolean GameControl_Render() {
        if (this.stageNumber == 0 && this.areaNumber == 3) {
            fillCorridorBlack = true;
            fillBottomStripBlack = true;
            this.renderer.Renderer_drawIngameBackground();
        } else {
            fillCorridorBlack = false;
            fillBottomStripBlack = false;
        }
        if (this.stageNumber == 2 || this.stageNumber == 4) {
            fillBottomStripBlack = true;
            this.renderer.Renderer_drawIngameBackground();
        } else {
            fillBottomStripBlack = false;
        }
        if (this.currentGameControlState == 9) {
            fillFightBottomStripGreen = true;
            this.renderer.Renderer_drawIngameBackground();
        } else {
            fillFightBottomStripGreen = false;
        }
        if (this.currentGameControlState == 0) {
            if (this.nextGameControlState != 8 && this.nextGameControlState != 9 && this.nextGameControlState != 1 && this.game.nextState != 3) {
                this.renderer.Renderer_translateScene(true);
                this.map.Map_RenderLayer();
                this.ai.AI_Render(0);
                this.ai.Player_Render();
                this.map.needRebuild = 0;
                this.Hud_Render();
                this.renderer.Renderer_translateScene(false);
                this.renderer.Renderer_drawIngameBackground();
            }
        } else if (this.currentGameControlState != 3) {
            if (this.currentGameControlState == 8) {
                this.renderer.Renderer_ClearScreen();
                this.renderer.Renderer_DrawTextMultipleVirtual(this.cutStrings[this.cutSceneTextId], 1, 0xFFFFFF, 0, 15000, 0);
                this.renderer.Renderer_DrawSoftKeys(65546, 0);
            } else if (this.currentGameControlState == 9) {
                this.map.mapX = this.fight.mapX;
                this.map.mapY = this.fight.mapY;
                this.map.Map_RenderLayer();
                this.map.needRebuild = 0;
                this.fight.Fight_Render();
            } else {
                this.menu.Menu_Render();
            }
        }
        return true;
    }

    void unloadArea() {
        this.ai.AI_UnloadArea();
        this.map.Map_UnloadArea();
    }

    void SetGameOver() {
        this.menu.Menu_SetMenu(19);
        this.nextGameControlState = 6;
    }

    void SetContinue() {
        this.menu.Menu_Open();
        this.menu.Menu_SetMenu(20);
        this.nextGameControlState = 4;
    }

    void GameControl_StartEvent(int event, int pages) {
        this.currentEvent = (byte)event;
        this.eventPages = (byte)pages;
        this.nextGameControlState = 3;
        this.eventScreen = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void GameControl_OpenArea() {
        this.renderer.Renderer_translateScene(true);
        try {
            this.playerBorderLeft = false;
            this.playerBorderRight = false;
            this.playerBorderTop = false;
            this.playerBorderBottom = false;
            this.updateLoadingScreen(1);
            this.map.Map_OpenArea();
            this.updateLoadingScreen();
            this.ai.AI_OpenArea();
            this.updateLoadingScreen();
            this.ai.Player_OpenArea();
            this.updateLoadingScreen();
        }
        catch (Throwable t) {
            this.game.gameStrings[77] = t.toString();
        }
        finally {
            this.updateLoadingScreen(-1);
        }
        this.renderer.Renderer_translateScene(false);
    }

    void GameControl_InitInGameMenu(int menuNumber) {
        this.menu.Menu_Open();
        this.menu.Menu_SetMenu(menuNumber);
        this.nextGameControlState = 1;
    }

    void Hud_initClass(GameControl g2) {
        this.gamecontrol = g2;
        this.renderer = g2.renderer;
        this.theApp = g2.theApp;
        this.map = g2.map;
        this.game = g2.game;
    }

    void Hud_OpenGame() {
        this.hudstoneSprite = this.renderer.RFM_ILoad("sticon");
    }

    void Hud_OpenArea() {
        this.Hud_TextBoxTimer = 0;
        this.Hud_TextBoxString = null;
    }

    void Hud_Render() {
        int nMenubarHeight = Renderer.convertToVirtual(12);
        this.renderer.Renderer_FillRectVirtual(0, Renderer.V_H - nMenubarHeight, 65536, nMenubarHeight + 200, 9061419);
        int nText = 59;
        int nFirstGapX = (65536 << 1) + 3000;
        int nStoneHeight = this.renderer.Renderer_GetSpriteHeightVirtual(this.hudstoneSprite);
        if (this.ai.playerStoneFrameCount > 0) {
            int num = this.ai.playerStoneFrameCount / 5;
            for (int i = 0; i < num; ++i) {
                this.renderer.Renderer_DrawBmpVirtual(this.hudstoneSprite, i * 4000 + 30000, Renderer.V_H - (nStoneHeight << 1) + (nStoneHeight >> 1));
            }
        }
        this.renderer.Renderer_DrawSoftKeys(10, 0);
        int courageBarGap = 3;
        int menuBarHeighBuild = 12;
        this.renderer.Renderer_FillRect(3, Renderer.B_H - menuBarHeighBuild + 3, 176 / 3 - 3, menuBarHeighBuild - 6, 0);
        this.renderer.Renderer_FillRect(4, Renderer.B_H - menuBarHeighBuild + 3 + 1, this.ai.playerhp * (176 / 3 - 3 - 2) / this.ai.playermaxhp, menuBarHeighBuild - 6 - 2, 16242539);
        if (this.hudIorekBelly == 0) {
            this.hudIorekBelly = this.renderer.RFM_ILoad("hud_iorek_belly");
        }
        int nHudItemWidth = this.renderer.Renderer_GetSpriteWidth(this.hudIorekBelly);
        int nHudItemTop = Renderer.B_H - (4 + this.renderer.Renderer_GetSpriteHeight(this.hudIorekBelly) + this.renderer.Renderer_GetSpriteHeight(this.hudIorekBelly) >> 1);
        int hudIconPos = 176 - 8 + 4;
        nHudItemWidth = -nHudItemWidth;
        if ((AI.playerHasYorekArmor & 1) != 0) {
            this.renderer.Renderer_DrawBmp(this.hudIorekBelly, hudIconPos += nHudItemWidth, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 2) != 0) {
            if (this.hudIorekFoot == 0) {
                this.hudIorekFoot = this.renderer.RFM_ILoad("hud_iorek_foot");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekFoot, hudIconPos += nHudItemWidth, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 4) != 0) {
            if (this.hudIorekHand == 0) {
                this.hudIorekHand = this.renderer.RFM_ILoad("hud_iorek_hand");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekHand, hudIconPos += nHudItemWidth, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 8) != 0) {
            if (this.hudIorekHead == 0) {
                this.hudIorekHead = this.renderer.RFM_ILoad("hud_iorek_head");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekHead, hudIconPos += nHudItemWidth, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 0x10) != 0) {
            if (this.hudIorekBrain == 0) {
                this.hudIorekBrain = this.renderer.RFM_ILoad("hud_iorek_brain");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekBrain, hudIconPos += nHudItemWidth, nHudItemTop);
        }
    }

    void Hud_Close() {
        this.renderer.RFM_IUnload(this.hudIorekBelly);
        this.renderer.RFM_IUnload(this.hudIorekFoot);
        this.renderer.RFM_IUnload(this.hudIorekHand);
        this.renderer.RFM_IUnload(this.hudIorekHead);
        this.renderer.RFM_IUnload(this.hudIorekBrain);
    }

    void Hud_InitTextBox(String str) {
        if (str.compareTo("") != 0) {
            this.Hud_TextBoxString = str;
            this.Hud_TextBoxTimer = 120;
        }
    }

    void Hud_DrawTextBox() {
        if (this.Hud_TextBoxTimer > 0) {
            int textx;
            --this.Hud_TextBoxTimer;
            int len = this.renderer.Renderer_GetStringLength(this.Hud_TextBoxString);
            int sprheight = this.renderer.Renderer_GetSpriteHeightVirtual(this.textBoxMidSprite);
            int textheight = this.renderer.Renderer_GetFontHeightVirtual();
            int currentx = textx = 65536 - len >> 1;
            this.renderer.Renderer_DrawBmpVirtual(this.textBoxLeftSprite, currentx - this.renderer.Renderer_GetSpriteWidthVirtual(this.textBoxLeftSprite), 1000);
            int dx = this.renderer.Renderer_GetSpriteWidthVirtual(this.textBoxMidSprite);
            for (int currentlen = len; currentlen > dx; currentlen -= dx) {
                this.renderer.Renderer_DrawBmpVirtual(this.textBoxMidSprite, currentx, 1000);
                currentx += dx;
            }
            this.renderer.Renderer_DrawBmpVirtual(this.textBoxRightSprite, currentx, 1000);
            this.renderer.Renderer_DrawTextVirtual(this.Hud_TextBoxString, 0, 0xFFFFFF, textx, 1000 + (sprheight - textheight >> 1));
        }
    }

    void updateLoadingScreen(int cnt) {
        if (this.loading == 0) {
            this.catchedInPause = false;
        }
        this.loading += cnt;
        if (this.loading > 0) {
            this.updateLoadingScreen();
        } else if (this.loading == 0 && this.catchedInPause) {
            this.catchedInPause = false;
            if (!this.bStartGame) {
                this.theApp.pauseApp();
            }
        }
        this.game.KeyMan_Open();
    }

    void updateLoadingScreen() {
        ++this.loadingCount;
        if (this.loadingCount > 3) {
            this.loadingCount = 0;
        }
        String dots = " ";
        for (int i = 0; i < this.loadingCount; ++i) {
            dots = dots + ".";
        }
        this.renderer.Renderer_ClearScreen();
        this.renderer.Renderer_DrawTextVirtual(this.game.gameStrings[77] + dots, 5, 0xFFFFFF, 0, 0);
        this.renderer.Renderer_SetupSoftKeys(null, null);
        this.renderer.Renderer_translateScene(false);
        this.renderer.Renderer_drawIngameBackground();
        this.renderer.Renderer_translateScene(true);
        this.renderer.flushGraphics();
    }

    void GameControl_StartCutScene(int num) {
        this.nextGameControlState = 8;
    }

    boolean GameControl_StartCustomCutScene(int nStageNumber, int nAreaNumber, int nCoordX, int nCoordY) {
        for (int i = 0; i < customCutScenes.length; ++i) {
            short nCutSceneVal0 = customCutScenes[i];
            short nCutSceneVal1 = customCutScenes[++i];
            short nCutSceneVal2 = customCutScenes[++i];
            short nCutSceneStage = (short)((nCutSceneVal0 & 0x7FF) >> 6);
            short nCutSceneArea = (short)(nCutSceneVal0 & 0x3F);
            short nCutSceneCoordX = (short)(nCutSceneVal1 >> 8);
            short nCutSceneCoordY = (short)(nCutSceneVal1 & 0xFF);
            if (nCutSceneStage != nStageNumber || nCutSceneArea != nAreaNumber || nCutSceneCoordX != nCoordX || nCutSceneCoordY != nCoordY) continue;
            this.cutSceneFinalFlag = (nCutSceneVal0 >> 13 & 1) != 0;
            this.cutSceneCombatFlag = (nCutSceneVal0 >> 13 & 2) != 0;
            this.cutSceneTextId = (short)(nCutSceneVal2 & 0xFF);
            this.nextGameControlState = 8;
            this.audio.stop();
            this.audio.playSFX(165);
            return true;
        }
        return false;
    }

    boolean GameControl_IsEventCompleted(int num) {
        int mask = 1 << (num & 0x1F);
        return (this.eventsCompleted[num / 32] & mask) != 0;
    }

    void GameControl_SetEventCompleted(int num) {
        int mask = 1 << (num & 0x1F);
        int n = num / 32;
        this.eventsCompleted[n] = this.eventsCompleted[n] | mask;
    }

    void GameControl_SetEventDirty(int num) {
        int mask = 1 << (num & 0x1F);
        int n = num / 32;
        this.eventsCompleted[n] = this.eventsCompleted[n] ^ mask;
    }
}

