/*
 * Decompiled with CFR 0.152.
 */
import com.mobilepostproduction.j2j.javax.microedition.media.Player;
import com.mobilepostproduction.j2j.javax.microedition.media.mmapi.Manager;

public final class AudioClass {
    private static GameClass game;
    private static CompassMIDlet midlet;
    private static final int PRIORITY = 5;
    public static final int SFX_DEATHCHASM = 64;
    public static final int SFX_OPENDOOR = 97;
    public static final int SFX_PICKUP = 130;
    public static final int SFX_PICKUP_KEY = 131;
    public static final int SFX_VICTORY = 4;
    public static final int SFX_CUT = 165;
    public static final int SFX_LONGJUMP = 6;
    public static final int SFX_LYRA_HURT = 7;
    public static final int SFX_PULLUP = 72;
    public static final int SFX_EFFORT = 73;
    public static final int SFX_JUMP = 42;
    public static final int SFX_MAN_CONFUSE = 43;
    public static final int SFX_WOMAN_HURT = 44;
    public static final int SFX_MAN_HURT = 45;
    public static final int SFX_ENEMY_HURT = 46;
    public static final int SFX_BIRD_HURT = 47;
    public static final int SFX_COULTER = 208;
    public static final int SFX_OWL = 209;
    public static final int SFX_ALETHIO_CORRECT = 50;
    public static final int SFX_ALETHIO_WRONG = 51;
    public static final int SFX_SWITCH = 84;
    public static final int SFX_IOREK_ATTACK = 213;
    public static final int SFX_PAN_ATTACK = 214;
    public static final int SFX_ICEBEAR_ATTACK = 215;
    public static final int SFX_MONKEY_ATTACK = 216;
    public static final int SFX_LYRA_ATTACK = 185;
    private static final String[] sfx_names;
    private final Player[] sfxPlayers = new Player[sfx_names.length];
    private Player tunePlayer;
    private String tunePlaying = null;
    private Player sfxPlayer = null;
    private int sfxPlayerPriority = 255;

    void InitClass(CompassMIDlet c) {
        midlet = c;
        game = c.game;
        for (int isfx = 0; isfx < this.sfxPlayers.length; ++isfx) {
            this.sfxPlayers[isfx] = Manager.createPlayer(sfx_names[isfx] + ".amr", "audio/amr");
            Manager.setRestore(this.sfxPlayers[isfx], false);
        }
    }

    void startTune() {
        this.startTune("t", false);
    }

    void startTune(String filename, boolean bLoop) {
        if (AudioClass.game.music == 0) {
            return;
        }
        if (this.tunePlaying != filename) {
            Manager.stop();
            this.tunePlaying = filename;
            this.tunePlayer = Manager.createPlayer(filename + ".mid", "audio/midi");
            Manager.play(this.tunePlayer, bLoop);
        }
    }

    public void playSFX(int sfx) {
        if (AudioClass.game.music == 0) {
            return;
        }
        if (this.tunePlaying != null) {
            Manager.stop();
            this.tunePlaying = null;
            this.tunePlayer = null;
        }
        int priority = sfx >> 5;
        if (this.sfxPlayer != null && priority > this.sfxPlayerPriority && this.isPlaying()) {
            return;
        }
        int index = sfx & 0x1F;
        this.sfxPlayer = this.sfxPlayers[index];
        this.sfxPlayerPriority = priority;
        Manager.play(this.sfxPlayer, false);
    }

    public boolean isPlaying() {
        return Manager.getState() == 1;
    }

    public boolean isOpenDoorPlaying() {
        return this.isPlaying() && this.sfxPlayer == this.sfxPlayers[1];
    }

    void stop() {
        Manager.stop();
        this.tunePlaying = null;
        this.sfxPlayer = null;
        this.sfxPlayerPriority = 255;
        this.tunePlayer = null;
    }

    static {
        sfx_names = new String[]{"deathchasm", "open-door", "pickup", "pickup-key", "victory", "cut", "longjump", "lyra-hurt", "pullup", "effort", "jump", "man-confuse", "woman-hurt", "man-hurt", "enemy-hurt", "bird-hurt", "coulter", "owl", "alethio-correct", "alethio-wrong", "switch", "iorek-attack", "pan-attack", "icebear-attack", "monkey-attack", "lyra-attack"};
    }
}

