/*
 * Decompiled with CFR 0.152.
 */
final class GameControl
implements Runnable {
    CompassMIDlet theApp;
    Renderer renderer;
    AudioClass audio;
    Puzzle puzzle;
    Cut cut;
    Fight fight;
    Map map;
    AI ai;
    GameClass game;
    Menu menu;
    static final int eGameControlState_Normal = 0;
    static final int eGameControlState_Menu = 1;
    static final int eGameControlState_Event = 3;
    static final int eGameControlState_Continue = 4;
    static final int eGameControlState_CutScene = 5;
    static final int eGameControlState_GameOver = 6;
    static final int eGameControlState_Puzzle = 7;
    static final int eGameControlState_Cut = 8;
    static final int eGameControlState_Fight = 9;
    boolean wonFightingGame;
    static final int EVENT_COLLECT_KEY = 0;
    static final int EVENT_LYRA_AND_PAN = 1;
    static final int EVENT_COLLECT_COURAGE = 2;
    static final int EVENT_COLLECT_ARMOUR = 3;
    static final int EVENT_MEET_IOREK = 4;
    static final int EVENT_TOUCH_IOREK = 5;
    static final int EVENT_CUTSCENE = 6;
    static final int EVENT_ALCOVE = 7;
    static final int EVENT_DOCK_LOCK_UNLOCKED = 8;
    static final int EVENT_LOCK_CUT_SCENE_PLAYED = 9;
    static final int EVENT_LOCK_NOKEY_PLAYED = 10;
    static final int EVENT_BEWARE_WITCHES = 11;
    static final int EVENT_IOREK_WON_COMBAT = 12;
    static final int EVENT_PAN_WON_COMBAT = 14;
    static final int EVENT_ICFINAL_A = 16;
    static final int EVENT_ICFINAL_B = 17;
    static final int EVENT_ICFINAL_C = 18;
    static final int NUM_EVENTS = 19;
    int[] eventsCompleted = new int[1];
    static final int CUTSCENE_NUM_STAGE_CUTSCENES = 4;
    static final byte ccsOffsetA = 13;
    static final byte ccsOffsetB = 6;
    static final byte ccsOffsetC = 0;
    static final byte ccsOffsetD = 8;
    static final byte ccsOffsetE = 0;
    static final byte ccsOffsetF = 8;
    static final byte ccsOffsetG = 0;
    static final short[] customCutScenes = new short[]{0, 7442, 2049, 0, 1030, 2306, 0, 3080, 2307, 1, 5910, 2308, 1, 3336, 2340, 2, 1310, 517, 3, 2578, 2330, 8193, 7944, 2310, 65, 3856, 2328, 66, 5138, 2312, 76, 514, 2341, 8269, 17954, 2313, 128, 26640, 2314, 128, 23570, 1055, 128, 257, 1056, 128, 19986, 523, 129, 22290, 524, 131, 786, 525, 130, 15378, 526, 131, 28690, 550, 8325, 28178, 1295, 133, 28434, 1040, 8647, 1799, 2575, 194, 7952, 2321, 16587, 7184, 2322, 203, 10250, 2333, 199, 786, 1566, 8389, 1554, 2323, 256, 272, 1300, 257, 14, 1813, 2, 5406, 2327, 74, 2578, 2329, 76, 2832, 2331, 16640, 514, 2593, 257, 0, 2595, 256, 0, 2594, 258, 1799, 3367, 258, 2056, 1320, 8450, 2313, 2089};
    byte areaNumber = 0;
    byte stageNumber = 1;
    short levelNumber = 0;
    byte remapAreaNumber = 0;
    byte remapStageNumber = 0;
    byte forceNewArea = (byte)-1;
    byte forceNewStage = (byte)-1;
    byte forcedDirection;
    int gameState;
    boolean cutSceneFinalFlag = false;
    boolean cutSceneCombatFlag = false;
    short cutSceneImageId = 0;
    short cutSceneTextId = 0;
    static final byte FORCED_OFF_TOP = 0;
    static final byte FORCED_OFF_LEFT = 1;
    static final byte FORCED_OFF_RIGHT = 2;
    static final byte FORCED_OFF_BOTTOM = 3;
    byte currentEvent = 0;
    byte eventPages = 0;
    byte eventScreen = 0;
    boolean isSave;
    int oldLevelXOffset;
    int newLevelPlayerScreenY;
    int newLevelPlayerScreenX;
    int levelDirection;
    int newLevelScreenY;
    int newLevelScreenX;
    int oldLevelXAdjust;
    int oldLevelYAdjust;
    static final int STATS_PLAYER_STATS = 0;
    int currentGameControlState;
    int nextGameControlState;
    long gameStartTime;
    long gameTime;
    int percentCompleted;
    int loadBridgeImage = 0;
    int backgroundImage = 0;
    boolean bStartGame = true;
    boolean trailOver = false;
    public boolean inPause = false;
    int hudstoneSprite;
    int hudX;
    int hudY;
    int hudMenubar;
    int hudKey = 0;
    int hudIorekBelly = 0;
    int hudIorekFoot = 0;
    int hudIorekHand = 0;
    int hudIorekHead = 0;
    int hudIorekBrain = 0;
    int courBack;
    int courStart;
    int courFinish;
    int courPoint;
    int courTail;
    String Hud_TextBoxString = null;
    int Hud_TextBoxTimer;
    int textBoxLeftSprite;
    int textBoxRightSprite;
    int textBoxMidSprite;
    static final int TEXT_BOX_X = 1000;
    static final int TEXT_BOX_Y = 1000;
    static final int TEXT_BOX_BORDER = 500;
    static final int TEXT_BOX_BACK_COLOUR = 32896;
    static final int TEXT_BOX_COLOUR = 0xFFFFFF;
    static final int TEXT_BOX_ON_TIME = 120;
    volatile int loadingType;
    volatile boolean catchedInPause = false;
    private Thread loadingThread;
    static final int NO_LOADING = 0;
    static final int LONG_LOADING = 1;
    static final int SHORT_LOADING = 2;

    GameControl() {
        this.map = new Map();
        this.ai = new AI();
    }

    void GameControl_InitClass(CompassMIDlet app) {
        this.ai = null;
        this.map = null;
        this.theApp = app;
        this.renderer = this.theApp.renderer;
        this.audio = this.theApp.audio;
        this.game = this.theApp.game;
        this.menu = this.theApp.menu;
    }

    boolean GameControl_OpenGame() {
        this.bStartGame = true;
        this.theApp.zeroIntArray(this.eventsCompleted);
        this.renderer.RFM_Open();
        if (this.loadBridgeImage == 0) {
            this.loadBridgeImage = this.renderer.RFM_ILoad("loadbridge");
        }
        if (this.backgroundImage == 0) {
            this.backgroundImage = this.renderer.RFM_ILoad("bg");
        }
        this.gameState = 0;
        if (this.map == null) {
            this.map = new Map();
        }
        if (this.ai == null) {
            this.ai = new AI();
        }
        this.ai.newGame = true;
        this.ai.Player_initClass(this);
        this.map.Map_initClass(this);
        this.map.Map_SetupStage(this.game.startFromStage);
        this.game.gameSave(false);
        this.ai.Player_OpenGame();
        this.ai.Player_OpenSpriteForLoading();
        this.startLoadingScreen(1);
        this.ai.AI_initClass(this);
        this.ai.AI_OpenGame();
        this.GameControl_OpenArea();
        this.currentGameControlState = 0;
        this.gameStartTime = System.currentTimeMillis();
        this.forceNewArea = (byte)-1;
        this.forceNewStage = (byte)-1;
        this.GameControl_StartEvent(0, 3);
        this.currentGameControlState = this.nextGameControlState = 0;
        this.startLoadingScreen(0);
        this.bStartGame = false;
        return true;
    }

    boolean GameControl_Close() {
        if (this.backgroundImage != 0) {
            this.renderer.RFM_IUnload(this.backgroundImage);
            this.backgroundImage = 0;
        }
        if (this.loadBridgeImage != 0) {
            this.renderer.RFM_IUnload(this.loadBridgeImage);
            this.loadBridgeImage = 0;
        }
        this.unloadArea();
        this.map.Map_Close();
        this.map = null;
        this.ai.AI_CloseGame();
        this.ai.Player_Close();
        this.ai = null;
        this.Hud_Close();
        if (this.cut != null) {
            this.cut.Cut_Close();
            this.cut = null;
        }
        if (this.puzzle != null) {
            this.puzzle.Puzzle_Close();
            this.puzzle = null;
        }
        if (this.fight != null) {
            this.fight.Fight_Close();
            this.fight = null;
        }
        return true;
    }

    boolean GameControl_Update() {
        if (this.currentGameControlState != 1 && this.currentGameControlState != 4) {
            this.gameTime = System.currentTimeMillis() - this.gameStartTime;
        } else {
            this.gameStartTime = System.currentTimeMillis() - this.gameTime;
        }
        if (!this.trailOver && this.gameTime > 60000L && this.theApp.demoMode) {
            this.trailOver = true;
            this.nextGameControlState = 0;
        }
        if (this.nextGameControlState != this.currentGameControlState) {
            if (this.nextGameControlState != 1 && this.nextGameControlState != 6 && this.nextGameControlState != 4) {
                this.menu.Menu_Close();
            }
            if (this.currentGameControlState == 7) {
                this.puzzle.Puzzle_Close();
                this.puzzle = null;
                if (this.cutSceneFinalFlag) {
                    this.game.gameSave(false);
                    this.game.openStartGame = true;
                    this.game.Game_SetState(3);
                    return false;
                }
            }
            if (this.currentGameControlState == 9) {
                this.fight.Fight_Close();
                this.fight = null;
                if (this.stageNumber == 3 && this.areaNumber == 11) {
                    if (this.wonFightingGame) {
                        this.GameControl_SetEventCompleted(14);
                        this.GameControl_StartCustomCutScene(3, 11, 40, 10, true);
                    } else {
                        this.ai.newGame = true;
                        this.forceNewArea = Map.startArea[this.stageNumber];
                        this.forceNewStage = this.stageNumber;
                        this.nextGameControlState = 0;
                    }
                } else if (this.stageNumber == 4 && this.areaNumber == 0) {
                    if (this.wonFightingGame) {
                        this.GameControl_SetEventCompleted(12);
                        this.GameControl_StartCustomCutScene(4, 0, 0, 0, true);
                    } else {
                        this.ai.newGame = true;
                        this.forceNewArea = Map.startArea[this.stageNumber];
                        this.forceNewStage = this.stageNumber;
                        this.nextGameControlState = 0;
                    }
                }
            }
            if (this.currentGameControlState == 8) {
                this.cut.Cut_Close();
                this.cut = null;
                if (this.cutSceneFinalFlag) {
                    if (this.stageNumber == 4) {
                        this.game.availableStage = 5;
                        this.game.gameSave(false);
                        this.game.openStartGame = false;
                        this.game.Game_SetState(3);
                    } else {
                        this.nextGameControlState = 7;
                    }
                } else {
                    if (this.stageNumber == 3 && this.areaNumber == 11 && !this.GameControl_IsEventCompleted(14) && this.cutSceneCombatFlag) {
                        this.cutSceneCombatFlag = false;
                        this.nextGameControlState = 9;
                    }
                    if (this.stageNumber == 4 && this.areaNumber == 0 && !this.GameControl_IsEventCompleted(12) && this.cutSceneCombatFlag) {
                        this.cutSceneCombatFlag = false;
                        this.nextGameControlState = 9;
                    } else if (this.stageNumber == 4 && this.areaNumber == 1 && !this.GameControl_IsEventCompleted(11)) {
                        this.GameControl_SetEventCompleted(11);
                        this.GameControl_StartCustomCutScene(4, 1, 0, 0, true);
                    }
                }
            }
            this.currentGameControlState = this.nextGameControlState;
            if (this.currentGameControlState == 7 && this.puzzle == null) {
                this.unloadArea();
                this.puzzle = new Puzzle();
                this.puzzle.Puzzle_initClass(this, 0);
            }
            if (this.currentGameControlState == 9 && this.fight == null) {
                this.fight = new Fight();
                this.fight.Fight_initClass(this, this.stageNumber == 4 ? 1 : 0);
            }
            if (this.currentGameControlState == 8 && this.cut == null) {
                this.cut = new Cut();
                this.cut.Cut_initClass(this, this.cutSceneFinalFlag, this.cutSceneImageId, this.cutSceneTextId);
            }
        }
        switch (this.currentGameControlState) {
            case 0: {
                if (this.forceNewArea != -1) {
                    byte save_forceNewArea = this.forceNewArea;
                    byte save_forceNewStage = this.forceNewStage;
                    this.forceNewArea = (byte)-1;
                    this.forceNewStage = (byte)-1;
                    this.unloadArea();
                    this.areaNumber = save_forceNewArea;
                    this.stageNumber = save_forceNewStage;
                    this.GameControl_OpenArea();
                }
                if ((this.game.debounceKeyMap & (0x40 | 0x20000)) != 0) {
                    this.theApp.pauseApp();
                }
                if (this.theApp.cheats) {
                    if ((this.game.debounceKeyMap & (0x1000 | 0x10)) != 0 && AI.DEBUG_CAMERA) {
                        AI.DEBUG_CAMERA = false;
                        AI.debugCamera = 0;
                        this.game.debounceKeyMap &= ~(0x1000 | 0x10);
                    }
                }
                if (this.trailOver) {
                    this.ai.Player_Reset();
                    this.GameControl_InitInGameMenu(28);
                }
                this.map.Map_Update();
                this.Hud_Update();
                this.ai.AI_Update();
                this.ai.Player_Update();
                if (this.forceNewArea != -1) {
                    this.renderer.Renderer_StartFade(2);
                }
                if (this.renderer.isShown()) break;
                return false;
            }
            case 1: 
            case 6: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
                break;
            }
            case 4: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
                this.ai.Player_Reset();
                this.forceNewArea = this.areaNumber = Map.startArea[this.stageNumber];
                this.forceNewStage = this.stageNumber;
                break;
            }
            case 7: {
                if (this.puzzle.Puzzle_Update()) break;
                this.nextGameControlState = 0;
                break;
            }
            case 9: {
                if (this.fight.Fight_Update()) break;
                this.nextGameControlState = 0;
                break;
            }
            case 8: {
                if (this.cut.Cut_Update()) break;
                this.nextGameControlState = 7;
                break;
            }
            case 5: {
                if (this.menu.Menu_Update()) break;
                this.nextGameControlState = 0;
            }
        }
        return true;
    }

    boolean GameControl_Render() {
        if (this.currentGameControlState == 0) {
            if (this.nextGameControlState != 8 && this.nextGameControlState != 9 && this.nextGameControlState != 1 && this.game.nextState != 3) {
                this.map.Map_RenderLayer(0);
                this.map.Map_RenderLayer(1);
                if (this.map.layer2drawInFront) {
                    this.ai.AI_Render(0);
                    this.ai.Player_Render();
                    this.map.Map_RenderLayer(2);
                } else {
                    this.map.Map_RenderLayer(2);
                    this.ai.AI_Render(0);
                    this.ai.Player_Render();
                }
                this.Hud_Render();
            }
        } else if (this.currentGameControlState != 3) {
            if (this.currentGameControlState == 7) {
                this.puzzle.Puzzle_Render();
            } else if (this.currentGameControlState == 8) {
                this.cut.Cut_Render();
            } else if (this.currentGameControlState == 9) {
                this.map.mapX = this.fight.mapX;
                this.map.mapY = this.fight.mapY;
                this.map.Map_RenderLayer(0);
                this.map.Map_RenderLayer(1);
                this.fight.Fight_Render();
            } else {
                this.menu.Menu_Render();
            }
        }
        return true;
    }

    void unloadArea() {
        this.Hud_CloseGame();
        this.ai.AI_UnloadArea();
        this.map.Map_UnloadArea();
    }

    void drawHealthBars(int x, int y1, int y2, int dx, int dy) {
        int startred = 47;
        int startgreen = 239;
        int startblue = 232;
        int endred = 255;
        int endgreen = 0;
        int endblue = 0;
        int diffred = startred - endred;
        int diffgreen = startgreen - endgreen;
        int diffblue = startblue - endblue;
        int red = diffred * this.ai.playerhp / this.ai.playermaxhp;
        int green = diffgreen * this.ai.playerhp / this.ai.playermaxhp;
        int blue = diffblue * this.ai.playerhp / this.ai.playermaxhp;
        int colour = (red += endred) << 16 | (green += endgreen) << 8 | (blue += endblue);
        this.renderer.Renderer_SetClipFullScreen();
        this.renderer.Renderer_FillRectVirtual(x, y1, dx * this.ai.playerhp / this.ai.playermaxhp, dy, colour);
    }

    void drawItemBars(int x, int y, int dx, int dy) {
    }

    void SetGameOver() {
        this.menu.Menu_SetMenu(20);
        this.nextGameControlState = 6;
    }

    void SetContinue() {
        this.menu.Menu_Open();
        this.menu.Menu_SetMenu(21);
        this.nextGameControlState = 4;
    }

    void SetCutScene() {
        this.menu.Menu_SetMenu(22);
        this.nextGameControlState = 5;
    }

    void GameControl_StartEvent(int event, int pages) {
        this.currentEvent = (byte)event;
        this.eventPages = (byte)pages;
        this.nextGameControlState = 3;
        this.eventScreen = 0;
    }

    void GameControl_OpenArea() {
        if (this.loadBridgeImage == 0) {
            this.loadBridgeImage = this.renderer.RFM_ILoad("loadbridge");
        }
        if (this.backgroundImage == 0) {
            this.backgroundImage = this.renderer.RFM_ILoad("bg");
        }
        if (this.loadingType == 0) {
            this.startLoadingScreen(2);
        }
        this.map.Map_OpenArea();
        this.ai.Player_OpenSpriteForLoading();
        this.ai.AI_OpenArea();
        this.ai.Player_OpenArea();
        this.Hud_OpenGame();
        if (this.loadingType == 2) {
            this.startLoadingScreen(0);
        }
    }

    void GameControl_InitInGameMenu(int menuNumber) {
        this.menu.Menu_Open();
        this.menu.Menu_SetMenu(menuNumber);
        this.nextGameControlState = 1;
    }

    void Hud_OpenGame() {
        this.hudstoneSprite = this.renderer.RFM_ILoad("sticon");
        this.hudMenubar = this.renderer.RFM_ILoad("menubar");
        this.courBack = this.renderer.RFM_ILoad("courback");
        this.courStart = this.renderer.RFM_ILoad("courstart");
        this.courFinish = this.renderer.RFM_ILoad("courfinish");
        this.courPoint = this.renderer.RFM_ILoad("courpoint");
        this.courTail = this.renderer.RFM_ILoad("courtail");
    }

    void Hud_CloseGame() {
        this.renderer.RFM_IUnload(this.hudstoneSprite);
        this.renderer.RFM_IUnload(this.hudMenubar);
        this.renderer.RFM_IUnload(this.courBack);
        this.renderer.RFM_IUnload(this.courStart);
        this.renderer.RFM_IUnload(this.courFinish);
        this.renderer.RFM_IUnload(this.courPoint);
        this.renderer.RFM_IUnload(this.courTail);
    }

    void Hud_OpenArea() {
        this.Hud_TextBoxTimer = 0;
        this.Hud_TextBoxString = null;
    }

    void Hud_Render() {
        int nMenubarHeight = this.renderer.Renderer_GetSpriteHeightVirtual(this.hudMenubar);
        this.renderer.Renderer_DrawBmpVirtual(this.hudMenubar, 0, 83285 - nMenubarHeight);
        int nFont = 1;
        int nText = 57;
        int nMenutextHeight = this.renderer.Renderer_GetFontHeightVirtual(nFont);
        int nMenuTextY = 83285 - nMenutextHeight;
        int nMenuTextXGap = 2000;
        int textW = this.renderer.convertCoordToVirtual(this.renderer.Renderer_GetStringWidth(this.game.gameStrings[nText], nFont));
        this.renderer.Renderer_DrawTextVirtual(this.game.gameStrings[nText], nFont, 0, 0xFFFFFF, 65536 - textW - nMenuTextXGap, nMenuTextY);
        int nFirstGapX = 65536 - textW - nMenuTextXGap - 2184 - 400 - 12000;
        int nStoneHeight = this.renderer.Renderer_GetSpriteHeightVirtual(this.hudstoneSprite);
        nStoneHeight = nMenubarHeight + nStoneHeight >> 1;
        if (this.ai.playerStoneFrameCount > 0) {
            int num = this.ai.playerStoneFrameCount / 5;
            for (int i = 0; i < num; ++i) {
                this.renderer.Renderer_DrawBmpVirtual(this.hudstoneSprite, nFirstGapX, 83285 - nStoneHeight);
                nFirstGapX += 4000;
            }
        }
        int nCourHeight = this.renderer.Renderer_GetSpriteHeightVirtual(this.courBack);
        int nCourBackWidth = this.renderer.Renderer_GetSpriteWidthVirtual(this.courBack);
        int j = 0;
        while (true) {
            if (j >= 65536 / nCourBackWidth + 1) break;
            this.renderer.Renderer_DrawBmpVirtual(this.courBack, nCourBackWidth * j, 83285 - nMenubarHeight - nCourHeight);
            ++j;
        }
        int nCourStartFinishWidth = this.renderer.Renderer_GetSpriteWidthVirtual(this.courStart);
        this.renderer.Renderer_DrawBmpVirtual(this.courStart, 0, 83285 - nMenubarHeight - nCourHeight);
        this.renderer.Renderer_DrawBmpVirtual(this.courFinish, 65536 - nCourStartFinishWidth, 83285 - nMenubarHeight - nCourHeight);
        int nCurCourPointVirtualX = nCourStartFinishWidth;
        int nCourPointWidthVirtual = this.renderer.Renderer_GetSpriteWidthVirtual(this.courPoint);
        int nPlayerhpSteps = (65536 - 2 * nCourStartFinishWidth) * this.ai.playerhp / this.ai.playermaxhp / nCourPointWidthVirtual;
        for (int k = 0; k < nPlayerhpSteps - 1; ++k) {
            this.renderer.Renderer_DrawBmpVirtual(this.courPoint, nCurCourPointVirtualX, 83285 - nMenubarHeight - nCourHeight);
            nCurCourPointVirtualX += nCourPointWidthVirtual;
        }
        this.renderer.Renderer_DrawBmpVirtual(this.courTail, nCurCourPointVirtualX, 83285 - nMenubarHeight - nCourHeight);
        if (this.hudKey == 0) {
            this.hudKey = this.renderer.RFM_ILoad("hud_key");
        }
        nMenubarHeight = this.renderer.Renderer_GetSpriteHeight(this.hudMenubar);
        int nHudItemWidth = this.renderer.Renderer_GetSpriteWidth(this.hudKey);
        int nHudItemTop = 305 - (nMenubarHeight + this.renderer.Renderer_GetSpriteHeight(this.hudKey) >> 1);
        int hudIconPos = 8 - nHudItemWidth;
        boolean increaseItem = true;
        if (this.GameControl_IsEventCompleted(0) && !this.GameControl_IsEventCompleted(9)) {
            this.renderer.Renderer_DrawBmp(this.hudKey, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 1) != 0) {
            if (this.hudIorekBelly == 0) {
                this.hudIorekBelly = this.renderer.RFM_ILoad("hud_iorek_belly");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekBelly, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 2) != 0) {
            if (this.hudIorekFoot == 0) {
                this.hudIorekFoot = this.renderer.RFM_ILoad("hud_iorek_foot");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekFoot, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 4) != 0) {
            if (this.hudIorekHand == 0) {
                this.hudIorekHand = this.renderer.RFM_ILoad("hud_iorek_hand");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekHand, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 8) != 0) {
            if (this.hudIorekHead == 0) {
                this.hudIorekHead = this.renderer.RFM_ILoad("hud_iorek_head");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekHead, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
        if ((AI.playerHasYorekArmor & 0x10) != 0) {
            if (this.hudIorekBrain == 0) {
                this.hudIorekBrain = this.renderer.RFM_ILoad("hud_iorek_brain");
            }
            this.renderer.Renderer_DrawBmp(this.hudIorekBrain, hudIconPos += nHudItemWidth * 1, nHudItemTop);
        }
    }

    void Hud_Close() {
        this.renderer.RFM_IUnload(this.hudMenubar);
        this.renderer.RFM_IUnload(this.courBack);
        this.renderer.RFM_IUnload(this.courStart);
        this.renderer.RFM_IUnload(this.courFinish);
        this.renderer.RFM_IUnload(this.courPoint);
        this.renderer.RFM_IUnload(this.courTail);
        this.renderer.RFM_IUnload(this.hudKey);
        this.renderer.RFM_IUnload(this.hudIorekBelly);
        this.renderer.RFM_IUnload(this.hudIorekFoot);
        this.renderer.RFM_IUnload(this.hudIorekHand);
        this.renderer.RFM_IUnload(this.hudIorekHead);
    }

    void Hud_Update() {
    }

    void Hud_InitTextBox(String str) {
        if (str.compareTo("") != 0) {
            this.Hud_TextBoxString = str;
            this.Hud_TextBoxTimer = 120;
        }
    }

    void Hud_DrawTextBox() {
        if (this.Hud_TextBoxTimer > 0) {
            int textx;
            --this.Hud_TextBoxTimer;
            int len = this.renderer.Renderer_GetStringLength(this.Hud_TextBoxString, 0);
            int sprheight = this.renderer.Renderer_GetSpriteHeightVirtual(this.textBoxMidSprite);
            int textheight = this.renderer.Renderer_GetFontHeightVirtual(0);
            int currentx = textx = 65536 - len >> 1;
            this.renderer.Renderer_DrawBmpVirtual(this.textBoxLeftSprite, currentx - this.renderer.Renderer_GetSpriteWidthVirtual(this.textBoxLeftSprite), 1000);
            int dx = this.renderer.Renderer_GetSpriteWidthVirtual(this.textBoxMidSprite);
            for (int currentlen = len; currentlen > dx; currentlen -= dx) {
                this.renderer.Renderer_DrawBmpVirtual(this.textBoxMidSprite, currentx, 1000);
                currentx += dx;
            }
            this.renderer.Renderer_DrawBmpVirtual(this.textBoxRightSprite, currentx, 1000);
            this.renderer.Renderer_DrawTextVirtual(this.Hud_TextBoxString, 0, 0, 0xFFFFFF, textx, 1000 + (sprheight - textheight >> 1));
        }
    }

    void startLoadingScreen(int type) {
        int prevType = this.loadingType;
        this.loadingType = type;
        if (prevType == 0 && this.loadingType != 0) {
            this.catchedInPause = false;
            this.loadingThread = new Thread(this);
            this.loadingThread.start();
        }
        if (this.loadingType == 0) {
            if (this.loadingThread != null) {
                try {
                    this.loadingThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.loadingThread = null;
            if (this.catchedInPause) {
                this.catchedInPause = false;
                if (!this.bStartGame) {
                    this.theApp.pauseApp();
                }
            }
        }
        this.game.KeyMan_Open();
        this.game.clearStoredKeyCodes();
    }

    public void run() {
        this.ai.hitTimer = 0;
        int dotcount = 0;
        int icount = 0;
        int sizew = 0;
        int step = 0;
        int sizeh = 0;
        if (this.renderer != null && this.loadBridgeImage != 0) {
            sizew = this.renderer.Renderer_GetSpriteWidthVirtual(this.loadBridgeImage);
            sizeh = this.renderer.Renderer_GetSpriteHeightVirtual(this.loadBridgeImage);
            step = sizew / 10;
        }
        while (this.loadingType != 0) {
            ++icount;
            if (this.renderer != null) {
                int i;
                if (this.backgroundImage != 0) {
                    this.renderer.Renderer_DrawBmp(this.backgroundImage, 0, 0);
                }
                if (this.ai != null) {
                    this.ai.playerState = 257;
                    this.ai.playerDX = 1;
                    ++this.ai.playerFrameTimer;
                    this.ai.playerScreenX = 65536 >> 1;
                    this.ai.playerScreenY = 83285 - sizeh;
                    this.ai.Player_Render();
                }
                if (this.loadBridgeImage != 0) {
                    for (i = 0; i < 6; ++i) {
                        this.renderer.Renderer_DrawBmpVirtual(this.loadBridgeImage, (i - 1) * sizew + (this.ai.playerDirection > 0 ? -icount * step : icount * step), 83285 - sizeh);
                    }
                    if (icount > 9) {
                        icount = 0;
                    }
                }
                String str = this.game.gameStrings[74];
                int posX = 65536 - this.renderer.Renderer_GetStringLength(str, 0) >> 1;
                dotcount = (dotcount + 1) % 4;
                for (i = 0; i < dotcount; ++i) {
                    str = str + ".";
                }
                this.renderer.Renderer_DrawTextVirtual(str, 0, 0, 0xFFFFFF, posX, 83285 - 5000);
                this.renderer.flushGraphics();
            }
            try {
                Thread.sleep(80L);
            }
            catch (Exception e) {}
        }
    }

    void GameControl_StartCutScene(int num) {
        this.nextGameControlState = 8;
    }

    boolean GameControl_StartCustomCutScene(int nStageNumber, int nAreaNumber, int nCoordX, int nCoordY, boolean playDefaultSound) {
        boolean nOverflowError = false;
        boolean val0 = false;
        boolean val1 = false;
        boolean val2 = false;
        boolean val0Flag = true;
        for (int i = 0; i < customCutScenes.length; ++i) {
            short nCutSceneVal0 = customCutScenes[i];
            short nCutSceneVal1 = customCutScenes[++i];
            short nCutSceneVal2 = customCutScenes[++i];
            short nCutSceneStage = (short)((nCutSceneVal0 & 0x7FF) >> 6);
            short nCutSceneArea = (short)(nCutSceneVal0 & 0x3F);
            short nCutSceneCoordX = (short)(nCutSceneVal1 >> 8);
            short nCutSceneCoordY = (short)(nCutSceneVal1 & 0xFF);
            if (nCutSceneStage != nStageNumber || nCutSceneArea != nAreaNumber || nCutSceneCoordX != nCoordX || nCutSceneCoordY != nCoordY) continue;
            this.cutSceneFinalFlag = (nCutSceneVal0 >> 13 & 1) != 0;
            this.cutSceneCombatFlag = (nCutSceneVal0 >> 13 & 2) != 0;
            this.cutSceneImageId = (short)(nCutSceneVal2 >> 8);
            this.cutSceneTextId = (short)(nCutSceneVal2 & 0xFF);
            this.nextGameControlState = 8;
            if (playDefaultSound) {
                this.audio.stop();
                this.audio.playSFX(165);
            }
            return true;
        }
        return false;
    }

    boolean GameControl_IsEventCompleted(int num) {
        int mask = 1 << (num & 0x1F);
        return (this.eventsCompleted[num / 32] & mask) != 0;
    }

    void GameControl_SetEventCompleted(int num) {
        int mask = 1 << (num & 0x1F);
        int n = num / 32;
        this.eventsCompleted[n] = this.eventsCompleted[n] | mask;
    }

    void GameControl_SetEventDirty(int num) {
        int mask = 1 << (num & 0x1F);
        int n = num / 32;
        this.eventsCompleted[n] = this.eventsCompleted[n] ^ mask;
    }
}

