/*
 * Decompiled with CFR 0.152.
 */
final class Puzzle {
    GameControl gamecontrol;
    GameClass game;
    Renderer renderer;
    CompassMIDlet theApp;
    AI ai;
    String[] puzzleStrings;
    static final int PUZZLE_STATE_GAME = 0;
    static final int PUZZLE_STATE_RESULT = 1;
    int puzzleState;
    int puzzleNumber;
    boolean puzzleResult;
    int backgroundImage;
    int iconImage;
    int arrowupImage;
    int arrowdownImage;
    int arrowupselectedImage;
    int arrowdownselectedImage;
    byte[] icons = new byte[1];
    int currentIcon;
    int c_language = -1;
    static final int PUZZLE_QUESTION_TEXT_Y = 5000;
    static final int PUZZLE_ICON_TEXT_Y = 30000;
    static final int ICON_ALPHAOMEGA = 0;
    static final int ICON_ANCHOR = 1;
    static final int ICON_ANGEL = 2;
    static final int ICON_ANT = 3;
    static final int ICON_APPLE = 4;
    static final int ICON_BABY = 5;
    static final int ICON_BEE = 6;
    static final int ICON_BIRD = 7;
    static final int ICON_BREAD = 8;
    static final int ICON_BULL = 9;
    static final int ICON_CAMEL = 10;
    static final int ICON_CANDLE = 11;
    static final int ICON_CHAMELEON = 12;
    static final int ICON_COMPASS = 13;
    static final int ICON_CORNOCOPIA = 14;
    static final int ICON_CROCODILE = 15;
    static final int ICON_CRUCIBLE = 16;
    static final int ICON_DOLPHIN = 17;
    static final int ICON_ELEPHANT = 18;
    static final int ICON_GLOBE = 19;
    static final int ICON_GRIFFIN = 20;
    static final int ICON_HELMET = 21;
    static final int ICON_HORSE = 22;
    static final int ICON_HOURGLASS = 23;
    static final int ICON_LUTE = 24;
    static final int ICON_MADONNA = 25;
    static final int ICON_MARIONETTE = 26;
    static final int ICON_MOONBEAM = 27;
    static final int ICON_OWL = 28;
    static final int ICON_SERPENT = 29;
    static final int ICON_SUN = 30;
    static final int ICON_SWORD = 31;
    static final int ICON_THUNDERBOLT = 32;
    static final int ICON_TREE = 33;
    static final int ICON_WALLEDGARDEN = 34;
    static final int ICON_WILDMAN = 35;
    static final int NUM_ICONS = 36;
    static final int MAX_PUZZLES = 11;
    static final int ICON_TEXT_START = 11;
    static final byte[] correctAnswers = new byte[]{27, 33, 6, 31, 26, 10, 11, 1, 28, 30, 29};
    static final int ARROW_SPEED = 28;
    static final int ARROW_MOVE_AMOUNT = 3;
    int updownflash;
    static final int FLASH_AMOUNT = 2;
    static final int[] iconX = new int[]{7200, 26860, 46520};
    static final int iconY = 59000;
    int ICON_WIDTH = 0;
    static final int ICONS_ACROSS_IMAGE = 6;

    Puzzle() {
    }

    void Puzzle_initClass(GameControl g2, int num) {
        this.gamecontrol = g2;
        this.game = g2.game;
        this.renderer = g2.renderer;
        this.theApp = g2.theApp;
        this.ai = g2.ai;
        this.puzzleResult = true;
        this.puzzleNumber = this.GetNextPuzzle();
        this.backgroundImage = this.renderer.RFM_ILoad("t");
        this.iconImage = this.renderer.RFM_ILoad("all");
        this.arrowupImage = this.renderer.RFM_ILoad("u");
        this.arrowdownImage = this.renderer.RFM_ILoad("d");
        this.arrowupselectedImage = this.renderer.RFM_ILoad("us");
        this.arrowdownselectedImage = this.renderer.RFM_ILoad("ds");
        this.icons[0] = 0;
        this.c_language = -1;
        this.ICON_WIDTH = this.renderer.Renderer_GetSpriteWidth(this.iconImage) / 6;
    }

    boolean Puzzle_Render() {
        this.renderer.Renderer_DrawBmp(this.backgroundImage, 0, 0);
        if (this.c_language != this.game.language) {
            this.c_language = this.game.language;
            this.puzzleStrings = GameClass.loadStrings(GameClass.languageStrings[this.game.language] + "p");
        }
        if (this.puzzleState == 0) {
            if (!this.puzzleResult) {
                this.renderer.Renderer_DrawTextMultipleVirtual(this.game.gameStrings[71], 0, 1 + 4, 0xFFFFFF, 0, 0, 0);
            } else {
                this.Puzzle_RenderIcon(1);
                int sin = this.theApp.cmSin(this.game.frameCounter << 28);
                sin = sin * 3 >> 12;
                int x = this.renderer.convertXToBuild(iconX[this.currentIcon + 1]);
                int y = this.renderer.convertXToBuild(59000) - this.ICON_WIDTH - (this.ICON_WIDTH >> 4);
                int image = this.arrowupImage;
                if (this.updownflash > 0) {
                    image = this.arrowupselectedImage;
                    --this.updownflash;
                }
                this.renderer.Renderer_DrawBmp(image, x, y + sin - 14);
                y += (this.ICON_WIDTH << 1) + (this.ICON_WIDTH >> 4) + (this.ICON_WIDTH >> 5);
                image = this.arrowdownImage;
                if (this.updownflash < 0) {
                    image = this.arrowdownselectedImage;
                    ++this.updownflash;
                }
                this.renderer.Renderer_DrawBmp(image, x, y - sin - 14);
                this.renderer.Renderer_DrawTextMultipleVirtual(this.puzzleStrings[this.puzzleNumber], 1, 1, 0xFFFFFF, 0, 5000, 0);
                this.renderer.Renderer_DrawTextVirtual(this.puzzleStrings[11 + this.icons[this.currentIcon]], 0, 1, 0xFFFFFF, 0, 30000);
            }
        } else if (this.puzzleResult) {
            this.renderer.Renderer_DrawTextMultipleVirtual(this.game.gameStrings[31], 0, 1 + 4, 0xFFFFFF, 0, 0, 0);
        }
        this.renderer.Renderer_DrawSoftKeys(65544);
        return true;
    }

    int GetNextPuzzle() {
        int puz = 0;
        for (int i = 0; i < 20; ++i) {
            puz = this.theApp.randomNumber256() % 11;
            if (this.game.puzzleAnswered[puz] != 0) continue;
            int n = puz;
            this.game.puzzleAnswered[n] = (byte)(this.game.puzzleAnswered[n] + 1);
            return puz;
        }
        this.theApp.zeroByteArray(this.game.puzzleAnswered);
        puz = this.theApp.randomNumber256() % 11;
        this.game.puzzleAnswered[puz] = 1;
        return puz;
    }

    boolean Puzzle_Update() {
        int debounce = this.game.debounceKeyMap;
        if ((debounce & (0x40 | 0x20000)) != 0) {
            this.gamecontrol.theApp.pauseApp();
            return true;
        }
        if (this.puzzleState == 0) {
            if (!this.puzzleResult) {
                if ((debounce & (0x10 | 0x20)) != 0) {
                    this.puzzleNumber = this.GetNextPuzzle();
                    this.icons[0] = 0;
                    this.puzzleResult = true;
                }
            } else {
                if ((debounce & 1) != 0) {
                    int n = this.currentIcon;
                    this.icons[n] = (byte)(this.icons[n] - 1);
                    if (this.icons[this.currentIcon] < 0) {
                        this.icons[this.currentIcon] = 35;
                    }
                    this.updownflash = 2;
                    if (!this.game.audio.isPlaying()) {
                        this.game.audio.playSFX(84);
                    }
                }
                if ((debounce & 2) != 0) {
                    int n = this.currentIcon;
                    this.icons[n] = (byte)(this.icons[n] + 1);
                    int n2 = this.currentIcon;
                    this.icons[n2] = (byte)(this.icons[n2] % 36);
                    this.updownflash = -2;
                    if (!this.game.audio.isPlaying()) {
                        this.game.audio.playSFX(84);
                    }
                }
                if ((debounce & (0x10 | 0x20)) != 0) {
                    int index = this.puzzleNumber;
                    if (this.icons[0] == correctAnswers[index + 0]) {
                        this.game.audio.playSFX(50);
                        this.puzzleResult = true;
                        this.puzzleState = 1;
                        if (this.game.availableStage <= this.gamecontrol.stageNumber) {
                            ++this.game.availableStage;
                        }
                        if (this.game.availableStage == 0) {
                            ++this.game.availableStage;
                        }
                        this.game.gameSave(false);
                    } else {
                        this.game.audio.stop();
                        this.game.audio.playSFX(51);
                        this.puzzleResult = false;
                    }
                }
            }
        } else if ((debounce & (0x10 | 0x20)) != 0) {
            return false;
        }
        return true;
    }

    void Puzzle_RenderIcon(int iconNumber) {
        byte id = this.icons[iconNumber - 1];
        int ix = id % 6;
        int iy = id / 6;
        int x = this.renderer.convertXToBuild(iconX[iconNumber]);
        int y = this.renderer.convertYToBuild(59000);
        this.renderer.Renderer_DrawClippedIndexedBmp(this.iconImage, x, y - 14, this.ICON_WIDTH, this.ICON_WIDTH, ix *= this.ICON_WIDTH, iy *= this.ICON_WIDTH, false);
    }

    void Puzzle_Close() {
        this.renderer.RFM_IUnload(this.backgroundImage);
        this.renderer.RFM_IUnload(this.iconImage);
        this.renderer.RFM_IUnload(this.arrowupImage);
        this.renderer.RFM_IUnload(this.arrowdownImage);
        this.renderer.RFM_IUnload(this.arrowupselectedImage);
        this.renderer.RFM_IUnload(this.arrowdownselectedImage);
        this.puzzleStrings = null;
    }
}

