/*
 * Decompiled with CFR 0.152.
 */
import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.Image;

final class Renderer
extends GameCanvas {
    static final int MEDIUM_FONT = 0;
    static final int SMALL_FONT = 1;
    static final int NUM_FONTS = 2;
    static final int WHITE = 0;
    static final int RED = 1;
    static final int BLUE = 2;
    static final int GREEN = 3;
    static final int GRAY = 4;
    static final int BROWN = 5;
    static final int YELLOW = 6;
    static final int BLACK = 7;
    static final int NUM_COLOURS = 8;
    static final int[] colorTable = new int[]{0xFFFFFF, 0xFF0000, 255, 65280, 0x7F7F7F, 0x9F9F00, 0xFFFF00, 0};
    Font[] fonts = new Font[2];
    int bgColor = 0;
    Image loadedSprite;
    String[] outputStrings = new String[20];
    CompassMIDlet theApp;
    GameClass game;
    Graphics gameCanvasGraphics;
    Image pImage;
    static final int B_W = 240;
    static final int B_H = 305;
    static final int V_W = 65536;
    static final int V_SHIFT = 16;
    static final int V_H = 83285;
    static final int BORDER = 4;
    static final int virtualBorder = 1092;
    static final int virtualPixelWidth = 273;
    static final int virtualScreenWidth = 65536;
    static final int virtualScreenHeight = 83285;
    int physicalScreenWidth;
    static final int RTA_X = 0;
    static final int RTA_XC = 1;
    static final int RTA_XR = 2;
    static final int RTA_Y = 0;
    static final int RTA_YC = 4;
    static final int RTA_YB = 8;
    static final int RTA_YSB = 16;
    static final int RF_IIMAGE = 0;
    static final int RF_RESID = 1;
    static final int RF_IMAX = 64;
    Image[] RFIimage = new Image[64];
    int LoadedNotification;
    boolean anyKeyPressed = false;
    static int dataptr;
    static int crcfrom;
    static int pngsize;
    static byte[] data;
    static byte[] PNG_header;
    static byte[] PNG_End;
    public boolean outline = false;
    public boolean flash = false;
    static final int FADE_NONE = 0;
    static final int FADE_IN = 1;
    static final int FADE_OUT = 2;
    int fadeCount;
    int fadeType;
    static final int FADE_STAGES = 8;

    Renderer(boolean suppress) {
        super(suppress);
    }

    void Renderer_initClass(CompassMIDlet app) {
        this.theApp = app;
        this.game = this.theApp.game;
        this.setDisplay();
        this.gameCanvasGraphics = this.getGraphics();
        this.game = this.theApp.game;
    }

    void setDisplay() {
        Core.getDisplay(this.theApp);
        Core.setCurrent(this);
        this.setFullScreenMode(true);
        while (!this.isShown()) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
    }

    void Renderer_DrawClippedIndexedBmp(int spr, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        Image pImage = this.RFIimage[spr];
        if (spr == 0) {
            return;
        }
        Graphics g2 = this.gameCanvasGraphics;
        int ImageR = ImageL + ImageW;
        int ImageB = ImageT + ImageH;
        if (ImageR < 0 || ImageL >= 240 || ImageB < 0 || ImageT >= 305) {
            return;
        }
        if (mirror) {
            g2.drawRegion(this.RFIimage[spr], ImageIX, ImageIY, ImageW, ImageH, 2, ImageL, ImageT, 0);
        } else {
            g2.setClip(ImageL, ImageT, ImageW, ImageH);
            g2.drawImage(this.RFIimage[spr], ImageL - ImageIX, ImageT - ImageIY, 0);
            g2.setClip(0, 0, 240, 305);
        }
    }

    void Renderer_DrawBmp(int sprite, int ImageL, int ImageT) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setClip(0, 0, 240, 305);
        g2.drawImage(this.RFIimage[sprite], ImageL, ImageT, 0);
    }

    void Renderer_DrawBmpVirtual(int sprite, int ImageL, int ImageT) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setClip(0, 0, 240, 305);
        g2.drawImage(this.RFIimage[sprite], this.convertXToBuild(ImageL), this.convertYToBuild(ImageT), 0);
    }

    void Renderer_DrawText(String pStr, int Font2, int Align, int colour, int X, int Y) {
        int stringWidth = this.Renderer_GetStringWidth(pStr, Font2);
        Graphics g2 = this.gameCanvasGraphics;
        if ((Align & 2) != 0) {
            stringWidth = this.Renderer_GetStringWidth(pStr, Font2);
            X = 240 - stringWidth;
        }
        if ((Align & 1) != 0) {
            X = -1;
        }
        if ((Align & 4) != 0) {
            Y = 305 - Y >> 1;
        }
        if ((Align & 8) != 0) {
            Y = 305 - this.Renderer_GetFontHeight(Font2) * 3 / 2;
        }
        if ((Align & 0x10) != 0) {
            Y = 305 - (this.Renderer_GetFontHeight(Font2) << 1);
        }
        this.drawStringWithOutline(pStr, X, Y, g2, Font2, colour);
    }

    void Renderer_DrawTextVirtual(String pStr, int Font2, int Align, int colour, int X, int Y) {
        this.Renderer_DrawText(pStr, Font2, Align, colour, this.convertXToBuild(X), this.convertYToBuild(Y));
    }

    int Renderer_CalcTextWH(String pStr, int Font2, int MaxWidth) {
        int H = 0;
        int W = 0;
        int FontH = this.Renderer_GetFontHeightVirtual(Font2);
        int i = this.createSplitStrings(pStr, this.outputStrings, Font2, MaxWidth);
        if (i > 1) {
            H = FontH * i;
            W = MaxWidth;
        } else {
            H = FontH;
            W = this.convertCoordToVirtual(this.Renderer_GetStringWidth(pStr, Font2));
        }
        return W << 16 & 0xFFFF0000 | H & 0xFFFF;
    }

    int Renderer_GetSpriteWidthVirtual(int ResID) {
        return this.convertCoordToVirtual(this.RFIimage[ResID].getWidth());
    }

    int Renderer_GetSpriteHeightVirtual(int ResID) {
        return this.convertCoordToVirtual(this.RFIimage[ResID].getHeight());
    }

    int Renderer_GetSpriteWidth(int ResID) {
        return this.RFIimage[ResID].getWidth();
    }

    int Renderer_GetSpriteHeight(int ResID) {
        return this.RFIimage[ResID].getHeight();
    }

    void RFM_Open() {
        this.RFM_IEmptyLib();
        this.Renderer_FontOpen();
    }

    int RFM_ILoad(String filename) {
        Image pBrewRes = this.loadImage(filename);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = pBrewRes;
        return Index;
    }

    int RFM_ILoadRAW(int width, int height, int palette, byte[] idata, byte[] pal, int trans, int imgStart, int palStart) {
        this.create(width, height, palette, idata, pal, trans, imgStart, palStart);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = this.loadedSprite;
        this.loadedSprite = null;
        return Index;
    }

    void RFM_IUnload(int ResID) {
        if (this.RFIimage[ResID] == null) {
            return;
        }
        this.RFIimage[ResID] = null;
    }

    int RFM_IFindSlot() {
        for (int Index = 1; Index < 64; ++Index) {
            if (this.RFIimage[Index] != null) continue;
            return Index;
        }
        return 65535;
    }

    void RFM_IEmptyLib() {
        int Index = 64;
        while (Index-- != 0) {
            this.RFIimage[Index] = null;
        }
    }

    int convertXToBuild(int x) {
        if (((x *= 240) & 0x8000) != 0) {
            x += 65536;
        }
        return x >> 16;
    }

    int convertYToBuild(int y) {
        if (((y *= 240) & 0x8000) != 0) {
            y += 65536;
        }
        return y >> 16;
    }

    int convertCoordToBuild(int x) {
        if (((x *= 240) & 0x8000) != 0) {
            x += 65536;
        }
        return x >> 16;
    }

    public void keyPressed(int keyCode) {
        if (this.game != null) {
            this.game.keyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (this.game != null) {
            this.game.keyReleased(keyCode);
        }
    }

    public void showNotify() {
    }

    Image loadImage(String filename) {
        Image image = null;
        filename = filename + ".png";
        int size = this.theApp.fileLoad(filename, null, true, 0, 0);
        byte[] array = new byte[size];
        size = this.theApp.fileLoad(filename, array, false, size, 0);
        image = Image.createImage((byte[])array, (int)0, (int)array.length);
        array = null;
        return image;
    }

    boolean isGameScreenShown() {
        return this.isShown();
    }

    int convertXToVirtual(int x) {
        return this.convertCoordToVirtual(x);
    }

    int convertCoordToVirtual(int width) {
        int i = (width << 16) / 240;
        return i;
    }

    int convertVirtualToCoord(int width) {
        int pw = width * 240;
        if ((pw & 0xFFFF) > Short.MAX_VALUE) {
            pw += 65536;
        }
        return pw >> 16;
    }

    int convertYToVirtual(int y) {
        return this.convertCoordToVirtual(y);
    }

    void Renderer_ClearScreen() {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, 240, 305);
    }

    int readIntFromByteArray(byte[] array, int offset) {
        int val = array[offset + 0] & 0xFF;
        val += (array[offset + 1] & 0xFF) << 8;
        val += (array[offset + 2] & 0xFF) << 16;
        return val += (array[offset + 3] & 0xFF) << 24;
    }

    short readShortFromByteArray(byte[] array, int offset) {
        short val = (short)(array[offset + 0] & 0xFF);
        val = (short)(val + ((array[offset + 1] & 0xFF) << 8));
        return val;
    }

    void create(int width, int height, int paletteCount, byte[] idata, byte[] pal, int trans, int imgStart, int palStart) {
        int i;
        byte[] transTable = new byte[256];
        pngsize = 768 + (width + 1) * height + 80;
        if (trans > -1) {
            pngsize += 13 + trans;
        }
        data = new byte[pngsize];
        for (i = 0; i < PNG_header.length; ++i) {
            Renderer.data[i] = PNG_header[i];
        }
        Renderer.data[18] = (byte)(width >> 8 & 0xFF);
        Renderer.data[19] = (byte)(width & 0xFF);
        Renderer.data[22] = (byte)(height >> 8 & 0xFF);
        Renderer.data[23] = (byte)(height & 0xFF);
        dataptr = 29;
        Renderer.writeInt(Core.crc32(data, 12, 17));
        Renderer.writeInt(768);
        crcfrom = dataptr;
        Renderer.writeInt(1347179589);
        int palEnd = paletteCount * 3 + palStart;
        int j = 0;
        i = palStart;
        while (i < palEnd) {
            byte r = pal[i + 2];
            byte g2 = pal[i + 1];
            byte b = pal[i];
            transTable[j] = r >= -8 && r <= -1 && g2 >= 0 && g2 <= 8 && b >= -8 && b <= -1 ? 0 : -1;
            Renderer.data[Renderer.dataptr++] = r;
            Renderer.data[Renderer.dataptr++] = g2;
            Renderer.data[Renderer.dataptr++] = b;
            i += 3;
            ++j;
        }
        Renderer.writeInt(Core.crc32(data, crcfrom, (dataptr += 768 - paletteCount * 3) - crcfrom));
        if (trans > -1) {
            Renderer.writeInt(trans + 1);
            crcfrom = dataptr;
            Renderer.writeInt(1951551059);
            for (i = 0; i < trans + 1; ++i) {
                Renderer.data[Renderer.dataptr++] = transTable[i];
            }
            Renderer.writeInt(Core.crc32(data, crcfrom, dataptr - crcfrom));
        }
        int compsize = (width + 1) * height;
        Renderer.writeInt(compsize + 11);
        crcfrom = dataptr;
        Renderer.writeInt(1229209940);
        Renderer.data[Renderer.dataptr++] = 120;
        Renderer.data[Renderer.dataptr++] = -38;
        Renderer.data[Renderer.dataptr++] = 1;
        Renderer.data[Renderer.dataptr++] = (byte)(compsize & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(compsize >>> 8 & 0xFF);
        Renderer.data[Renderer.dataptr] = ~data[dataptr - 2];
        Renderer.data[++Renderer.dataptr] = ~data[dataptr - 2];
        int adlerstart = ++dataptr;
        i = imgStart;
        for (int y = 0; y < height; ++y) {
            Renderer.data[Renderer.dataptr++] = 0;
            for (int x = 0; x < width; ++x) {
                Renderer.data[Renderer.dataptr++] = idata[i++];
            }
        }
        int adler1 = 1;
        int adler2 = 0;
        for (i = 0; i < compsize; ++i) {
            adler2 = (adler1 += data[adlerstart + i] & 0xFF) + adler2;
            adler1 %= 65521;
            adler2 %= 65521;
        }
        Renderer.writeInt(adler2 << 16 | adler1);
        Renderer.writeInt(Core.crc32(data, crcfrom, dataptr - crcfrom));
        for (i = 0; i < PNG_End.length; ++i) {
            Renderer.data[Renderer.dataptr++] = PNG_End[i];
        }
        this.loadedSprite = Image.createImage((byte[])data, (int)0, (int)pngsize);
        transTable = null;
        data = null;
    }

    static void writeInt(int crc) {
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 24 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 16 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc >>> 8 & 0xFF);
        Renderer.data[Renderer.dataptr++] = (byte)(crc & 0xFF);
    }

    void Renderer_DrawClippedIndexedBmpVirtual(int sprite, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        int IL = this.convertXToBuild(ImageL);
        int IT = this.convertYToBuild(ImageT);
        int IW = this.convertCoordToBuild(ImageW);
        int IH = this.convertCoordToBuild(ImageH);
        int IX = this.convertCoordToBuild(ImageIX);
        int IY = this.convertCoordToBuild(ImageIY);
        this.Renderer_DrawClippedIndexedBmp(sprite, IL, IT, IW, IH, IX, IY, mirror);
    }

    void Renderer_FillRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillRect(x, y, w, h);
    }

    void Renderer_FillTri(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillTriangle(x, y, x1, y1, x2, y2);
    }

    void Renderer_DrawLine(int x, int y, int x1, int y1, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawLine(x, y, x1, y1);
    }

    void Renderer_DrawLineVitual(int x, int y, int x1, int y1, int colour) {
        this.Renderer_DrawLine(this.convertXToBuild(x), this.convertYToBuild(y), this.convertXToBuild(x1), this.convertYToBuild(y1), colour);
    }

    void Renderer_DrawRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawRect(x, y, w, h);
    }

    void Renderer_FillRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_FillRect(this.convertXToBuild(x), this.convertYToBuild(y), this.convertCoordToBuild(w), this.convertCoordToBuild(h), colour);
    }

    void Renderer_FillTriVirtual(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        this.Renderer_FillTri(this.convertXToBuild(x), this.convertYToBuild(y), this.convertXToBuild(x1), this.convertYToBuild(y1), this.convertXToBuild(x2), this.convertYToBuild(y2), colour);
    }

    void Renderer_DrawRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_DrawRect(this.convertXToBuild(x), this.convertYToBuild(y), this.convertCoordToBuild(w), this.convertCoordToBuild(h), colour);
    }

    int Renderer_GetStringLength(String string, int f) {
        int len = this.Renderer_GetStringWidth(string, f);
        len = this.convertCoordToVirtual(len);
        return len;
    }

    int Renderer_GetFontHeightVirtual(int f) {
        return this.convertCoordToVirtual(this.Renderer_GetFontHeight(f));
    }

    int Renderer_GetFontHeight(int f) {
        return this.fonts[f].getHeight();
    }

    void Renderer_FontOpen() {
        this.fonts[0] = Font.getFont(0, 0, 0);
        this.fonts[1] = Font.getFont(0, 0, 8);
    }

    int Renderer_GetStringWidth(String pStr, int font) {
        return this.fonts[font].stringWidth(pStr);
    }

    void Renderer_DrawChar(int x, int y, int font, int chr, int colour, Graphics g2) {
        g2.setFont(this.fonts[font]);
        g2.setColor(colorTable[colour]);
        g2.drawChar((char)chr, x, y, 4 | 0x10);
    }

    void drawStringWithOutline(String text, int x, int y, Graphics g2, int f, int colour) {
        if (this.flash && (this.game.frameCounter & 8) == 0) {
            return;
        }
        if (colour > 8 || colour < 0) {
            colour = 0;
        }
        int clr = colorTable[colour];
        if (x == -1) {
            x = 240 - this.Renderer_GetStringWidth(text, f) >> 1;
        }
        g2.setFont(this.fonts[f]);
        int l = text.indexOf(37);
        if (l >= 0) {
            text = text.replace('%', ':');
        }
        if (this.outline) {
            g2.setColor(0x550000);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if (ox == 0 || oy == 0) continue;
                    g2.drawString(text, x + ox, y + oy, 4 | 0x10);
                }
            }
            g2.drawString(text, x, y - 1, 4 | 0x10);
            g2.drawString(text, x + 1, y, 4 | 0x10);
            g2.drawString(text, x, y + 1, 4 | 0x10);
            g2.drawString(text, x - 2, y, 4 | 0x10);
            g2.drawString(text, x, y - 2, 4 | 0x10);
            g2.drawString(text, x + 2, y, 4 | 0x10);
            g2.drawString(text, x, y + 2, 4 | 0x10);
        }
        g2.setColor(clr);
        g2.drawString(text, x, y, 4 | 0x10);
    }

    int Renderer_GetCharWidth(int chr, int font) {
        return this.fonts[font].charWidth((char)chr);
    }

    void Renderer_SetClipFullScreen() {
        this.gameCanvasGraphics.setClip(0, 0, 240, 305);
    }

    int Renderer_DrawTextMultipleVirtual(String pStr, int Font2, int Align, int BGR0, int X, int Y, int maxWidth) {
        int y = this.Renderer_DrawTextMultiple(pStr, Font2, Align, BGR0, this.convertXToBuild(X), this.convertYToBuild(Y), this.convertCoordToBuild(maxWidth));
        return this.convertYToVirtual(y);
    }

    int Renderer_DrawTextMultiple(String pStr, int Font2, int Align, int BGR0, int X, int Y, int maxWidth) {
        int fontHeight = this.Renderer_GetFontHeight(Font2);
        String[] strings = new String[20];
        int numStrings = this.createSplitStrings(pStr, strings, Font2, maxWidth);
        for (int i = 0; i < numStrings; ++i) {
            this.Renderer_DrawText(strings[i], Font2, Align, BGR0, X, Y);
            Y += fontHeight + 1;
        }
        strings = null;
        return Y;
    }

    int createSplitStrings(String text, String[] output, int f, int maxWidth) {
        char currentChar = '\u0000';
        boolean endoftext = false;
        int numStrings = 0;
        int index = output.length;
        while (index-- != 0) {
            output[index] = null;
        }
        if (maxWidth == 0) {
            maxWidth = 240;
        }
        while (!endoftext) {
            String tempString = "";
            int lastSpacePosition = 0;
            boolean endofline = false;
            for (index = 0; this.Renderer_GetStringWidth(tempString, f) < maxWidth && index < text.length() && !endofline; ++index) {
                currentChar = text.charAt(index);
                tempString = tempString + currentChar;
                if (currentChar == ' ' || currentChar == ':') {
                    lastSpacePosition = index;
                }
                if (currentChar != ':') continue;
                endofline = true;
            }
            if (lastSpacePosition == 0) {
                endofline = false;
                for (index = 0; index < tempString.length() && !endofline; ++index) {
                    currentChar = tempString.charAt(index);
                    if (currentChar != ':') continue;
                    lastSpacePosition = index;
                    endofline = true;
                }
            }
            if (index >= text.length()) {
                lastSpacePosition = text.length();
                endoftext = true;
            }
            tempString = tempString.substring(0, lastSpacePosition);
            if (!endoftext) {
                text = text.substring(lastSpacePosition + 1, text.length());
            }
            output[numStrings++] = tempString;
        }
        return numStrings;
    }

    void Renderer_FadeScreen() {
        if (this.fadeType == 0) {
            return;
        }
        int dx = 32768 * this.fadeCount / 8;
        int dy = 41642 * this.fadeCount / 8;
        this.Renderer_FillRectVirtual(0, 0, 65536, dy, 0);
        this.Renderer_FillRectVirtual(0, 83285 - dy, 65536, dy, 0);
        this.Renderer_FillRectVirtual(0, 0, dx, 83285, 0);
        this.Renderer_FillRectVirtual(65536 - dx, 0, dx, 83285, 0);
        if (this.fadeType == 1) {
            boolean loop = false;
            --this.fadeCount;
            if (this.fadeCount == 0) {
                this.fadeType = 0;
                return;
            }
        } else {
            boolean loop = true;
            ++this.fadeCount;
            if (this.fadeCount > 8) {
                this.fadeType = 0;
                return;
            }
        }
    }

    void Renderer_StartFade(int type) {
        this.fadeType = type;
        this.fadeCount = type == 1 ? 8 : 0;
        this.game.KeyMan_Open();
        this.game.clearStoredKeyCodes();
    }

    void Renderer_Render() {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setClip(0, 0, 240, 305);
        g2.setColor(0);
        this.Renderer_FadeScreen();
        this.flushGraphics();
    }

    void Renderer_DrawSoftKeys(int keys) {
        this.theApp.menu.Menu_SetupSoftKeys(keys);
        Menu cfr_ignored_0 = this.theApp.menu;
        int i = 30;
        while (true) {
            Menu cfr_ignored_1 = this.theApp.menu;
            if (i > 31) break;
            if (this.theApp.menu.Menu_Strings[i] != null) {
                int TextAlign = 0;
                Menu cfr_ignored_2 = this.theApp.menu;
                if ((this.theApp.menu.Menu_flags[i] & 0x8000) != 0) {
                    TextAlign = 0;
                }
                Menu cfr_ignored_3 = this.theApp.menu;
                if ((this.theApp.menu.Menu_flags[i] & 0x10000) != 0) {
                    TextAlign = 2;
                }
                Menu cfr_ignored_4 = this.theApp.menu;
                this.Renderer_DrawTextVirtual(this.theApp.menu.Menu_Strings[i], 1, TextAlign, 0, this.theApp.menu.Menu_x[i], this.theApp.menu.Menu_y[i]);
            }
            ++i;
        }
    }

    static {
        PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
        PNG_End = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

