/*
 * Decompiled with CFR 0.152.
 */
final class Menu {
    CompassMIDlet theApp;
    Renderer renderer;
    Map map;
    GameClass game;
    GameControl gamecontrol;
    AudioClass audio;
    AI ai;
    static final int menuLeft = 5000;
    static final int menuRight = 60536;
    static final int menuTop = 10000;
    static final int KEY_UP = 1;
    static final int KEY_DOWN = 2;
    static final int KEY_LEFT = 4;
    static final int KEY_RIGHT = 8;
    static final int KEY_SELECT = 16;
    static final int KEY_SOFT1 = 32;
    static final int KEY_SOFT2 = 64;
    static final int KEY_0 = 128;
    static final int KEY_1 = 256;
    static final int KEY_2 = 512;
    static final int KEY_3 = 1024;
    static final int KEY_4 = 2048;
    static final int KEY_5 = 4096;
    static final int KEY_6 = 8192;
    static final int KEY_7 = 16384;
    static final int KEY_8 = 32768;
    static final int KEY_9 = 65536;
    static final int KEY_CLR = 131072;
    static final int KEY_GREEN = 262144;
    static final int KMF_EMPTY = 0;
    static final int KMF_FLUSH = 0x10000000;
    static final int KMF_KEY_PRESS = 0x20000000;
    static final int KMF_KEY_RELEASE = 0x40000000;
    static final int IIF_FONT_SMALL = 1;
    static final int IIF_FONT_MEDIUM = 0;
    static final int IIF_FONT_OUTLINED = 64;
    static final int IIF_FONT_RED = 256;
    static final int IIF_FONT_BLACK = 512;
    static final int IIF_FONT_WHITE = 4096;
    static final int IIF_FONT_BROWN = 1024;
    static final int IIF_FONT_GREY = 2048;
    static final int IIF_HIDE = 8192;
    static final int IIF_PLACK = 16384;
    static final int IIF_TEXT_LEFT = 32768;
    static final int IIF_TEXT_RIGHT = 65536;
    static final int IIF_NONSELECTABLE = 262144;
    static final int IIF_GROUP2 = 524288;
    static final int IIF_LEAVEAGAP = 0x100000;
    static final int IIF_MULTIPLE = 0x200000;
    static final int IIA_LEFT = 1;
    static final int IIA_RIGHT = 2;
    static final int IIA_CENTER_HORZ = 4;
    static final int IIA_BOTTOM = 16;
    static final int IIA_CENTER_VERT = 32;
    static final int IIA_SOFT_BOTTOM = 64;
    static final int Menu_Null = -1;
    static final int Menu_Title = 0;
    static final int Menu_Main = 1;
    static final int Menu_HighScores = 3;
    static final int Menu_Quit = 4;
    static final int Menu_RUSure = 5;
    static final int Menu_Help0 = 6;
    static final int Menu_Help1 = 7;
    static final int Menu_Help2 = 8;
    static final int Menu_About0 = 9;
    static final int Menu_About1 = 10;
    static final int Menu_Sound = 11;
    static final int Menu_Config = 12;
    static final int Menu_Game_Menu = 13;
    static final int Menu_Language = 17;
    static final int Menu_StartGame = 18;
    static final int Menu_Load = 19;
    static final int Menu_GameOver = 20;
    static final int Menu_Continue = 21;
    static final int Menu_CutScene = 22;
    static final int Menu_Help0InGame = 23;
    static final int Menu_Help1InGame = 24;
    static final int Menu_Help2InGame = 25;
    static final int Menu_GetMoreGames = 26;
    static final int Menu_TrialRemaind = 27;
    static final int Menu_TrialOver = 28;
    static final int Menu_Cheats = 29;
    static final int Menu_ConfirmNewGame = 30;
    static final int Menu_ConfirmExitToMainMenu = 31;
    static final int Menu_Max = 32;
    static final int eMenu_0 = 0;
    static final int eMenu_1 = 1;
    static final int eMenu_2 = 2;
    static final int eMenu_3 = 3;
    static final int eMenu_4 = 4;
    static final int eMenu_5 = 5;
    static final int eMenu_6 = 6;
    static final int eMenu_7 = 7;
    static final int eMenu_8 = 8;
    static final int eMenu_9 = 9;
    static final int eMenu_10 = 10;
    static final int eMenu_11 = 11;
    static final int eMenu_12 = 12;
    static final int eMenu_13 = 13;
    static final int eMenu_14 = 14;
    static final int eMenu_15 = 15;
    static final int eMenu_16 = 16;
    static final int eMenu_17 = 17;
    static final int eMenu_18 = 18;
    static final int eMenu_19 = 19;
    static final int eMenu_20 = 20;
    static final int eMenu_21 = 21;
    static final int eMenu_22 = 22;
    static final int eMenu_23 = 23;
    static final int eMenu_24 = 24;
    static final int eMenu_25 = 25;
    static final int eMenu_26 = 26;
    static final int eMenu_Price = 27;
    static final int eMenu_Title = 28;
    static final int eMenu_Description = 29;
    static final int eMenu_SoftKeyLeft = 30;
    static final int eMenu_SoftKeyRight = 31;
    static final int eMenu_Max = 32;
    int minMenuGroup1;
    int maxMenuGroup1;
    int minMenuGroup2;
    int maxMenuGroup2;
    int currentMenuGroup;
    int menuPositionGroup1;
    int menuPositionGroup2;
    int forceMenuPos = -1;
    static final int MenuFontSize = 0;
    static final int SoftKeyFontSize = 1;
    boolean forceGoBack = false;
    final int[] Menu_x = new int[32];
    final int[] Menu_y = new int[32];
    final int[] Menu_height = new int[32];
    final int[] Menu_width = new int[32];
    final int[] Menu_flags = new int[32];
    final String[] Menu_Strings = new String[32];
    final int[] prevMenu = new int[32];
    int debounceKeyMap;
    int currentMenu;
    int nextMenu;
    int previousMenu;
    int currentItem;
    boolean lastActionWasContinue = false;
    int menuBackgroundImage;
    private static final int GLU_LOGO_Y_POS = 2500;
    int gluLogo;
    boolean godMode = false;
    boolean showLocation = false;
    boolean allStagesOpened = false;

    Menu() {
    }

    void Menu_initClass(CompassMIDlet app) {
        this.theApp = app;
        this.renderer = this.theApp.renderer;
        this.game = this.theApp.game;
        this.audio = this.theApp.audio;
    }

    boolean Menu_Open() {
        this.currentMenu = -1;
        this.nextMenu = -1;
        for (int i = 0; i < 32; ++i) {
            this.prevMenu[i] = -1;
        }
        this.currentItem = 1;
        this.FE_ResetMenu();
        this.currentItem = 0;
        if (this.menuBackgroundImage == 0) {
            this.menuBackgroundImage = this.renderer.RFM_ILoad("menub");
        }
        if (this.gluLogo == 0) {
            this.gluLogo = this.renderer.RFM_ILoad("glu");
        }
        return true;
    }

    void Menu_SetMenu(int menu) {
        this.nextMenu = menu;
        this.currentMenu = -1;
    }

    boolean Menu_Close() {
        this.forceGoBack = false;
        if (this.menuBackgroundImage != 0) {
            this.renderer.RFM_IUnload(this.menuBackgroundImage);
            this.menuBackgroundImage = 0;
        }
        if (this.gluLogo != 0) {
            this.renderer.RFM_IUnload(this.gluLogo);
            this.gluLogo = 0;
        }
        return true;
    }

    boolean Menu_Update() {
        boolean status = true;
        this.gamecontrol = this.game.gamecontrol;
        if (this.gamecontrol != null) {
            if (this.gamecontrol.ai != null) {
                this.ai = this.gamecontrol.ai;
            }
            if (this.gamecontrol.map != null) {
                this.map = this.gamecontrol.map;
            }
        }
        boolean goBack = false;
        this.debounceKeyMap = this.game.debounceKeyMap;
        if ((this.debounceKeyMap & 0x20040) != 0 || this.forceGoBack) {
            if (this.currentMenu == 21 || this.currentMenu == 11) {
                return true;
            }
            if (this.currentMenu == 13) {
                return false;
            }
            this.forceGoBack = false;
            if (this.prevMenu[this.currentMenu] != -1) {
                this.nextMenu = this.prevMenu[this.currentMenu];
                this.prevMenu[this.currentMenu] = -1;
                goBack = true;
            } else {
                return false;
            }
        }
        this.Menu_SelectCurrentItem();
        switch (this.currentMenu) {
            case 0: 
            case 1: {
                this.Menu_UpdateMainMenu();
                break;
            }
            case 13: {
                status = this.Menu_UpdateGameMenu();
                break;
            }
            case 4: {
                this.Menu_UpdateQuitMenu();
                break;
            }
            case 17: {
                this.Menu_UpdateLanguageMenu();
                break;
            }
            case 18: {
                this.Menu_UpdateStartGameMenu();
                break;
            }
            case 19: {
                this.Menu_UpdateLoadMenu();
                break;
            }
            case 11: {
                this.Menu_UpdateSoundMenu();
                break;
            }
            case 20: {
                this.Menu_UpdateGOMenu();
                break;
            }
            case 21: {
                status = this.Menu_UpdateContinueMenu();
                break;
            }
            case 22: {
                this.Menu_UpdateCSMenu();
                break;
            }
            case 5: {
                this.Menu_UpdateRUSureMenu();
                break;
            }
            case 9: {
                this.Menu_UpdateAbout0Menu();
                break;
            }
            case 10: {
                this.Menu_UpdateAbout1Menu();
                break;
            }
            case 6: 
            case 23: {
                this.Menu_UpdateHelp0Menu(this.currentMenu == 23 || this.currentMenu == 24);
                break;
            }
            case 7: 
            case 24: {
                this.Menu_UpdateHelp1Menu(this.currentMenu == 23 || this.currentMenu == 24);
                break;
            }
            case 12: {
                this.Menu_UpdateConfigMenu();
                break;
            }
            case 27: {
                this.Menu_UpdateTrialRemaindMenu();
                break;
            }
            case 28: {
                this.Menu_UpdateTrialOverMenu();
                break;
            }
            case 30: {
                this.Menu_UpdateConfirmNewGameMenu();
                break;
            }
            case 31: {
                this.Menu_UpdateConfirmExitToMainMenu();
            }
        }
        if (!status) {
            return false;
        }
        if (this.currentMenu != this.nextMenu) {
            this.previousMenu = this.currentMenu;
            this.forceGoBack = false;
            this.game.clearStoredKeyCodes();
            if (!goBack) {
                this.prevMenu[this.nextMenu] = this.currentMenu;
            }
            this.currentMenu = this.nextMenu;
            switch (this.currentMenu) {
                case 0: 
                case 1: {
                    this.Menu_SetupMainMenu();
                    break;
                }
                case 13: {
                    this.Menu_SetupGameMenu();
                    break;
                }
                case 4: {
                    this.Menu_SetupQuitMenu();
                    break;
                }
                case 17: {
                    this.Menu_SetupLanguageMenu();
                    break;
                }
                case 18: {
                    this.Menu_SetupStartGameMenu();
                    break;
                }
                case 19: {
                    this.Menu_SetupLoadMenu();
                    break;
                }
                case 11: {
                    this.Menu_SetupSoundMenu();
                    break;
                }
                case 20: {
                    this.Menu_SetupGOMenu();
                    break;
                }
                case 21: {
                    this.Menu_SetupContinueMenu();
                    break;
                }
                case 22: {
                    this.Menu_SetupCSMenu();
                    break;
                }
                case 5: {
                    this.Menu_SetupRUSureMenu();
                    break;
                }
                case 9: 
                case 10: {
                    this.Menu_SetupAboutMenu(this.currentMenu - 9);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.Menu_SetupHelpMenu(this.currentMenu - 6, false);
                    break;
                }
                case 23: 
                case 24: 
                case 25: {
                    this.Menu_SetupHelpMenu(this.currentMenu - 23, true);
                    break;
                }
                case 12: {
                    this.Menu_SetupConfigMenu();
                    break;
                }
                case 26: {
                    this.Menu_SetupGetMoreGamesMenu();
                    break;
                }
                case 27: {
                    this.Menu_SetupTrialRemaindMenu();
                    break;
                }
                case 28: {
                    this.Menu_SetupTrialOverMenu();
                    break;
                }
                case 30: {
                    this.Menu_SetupConfirmNewGameMenu();
                    break;
                }
                case 31: {
                    this.Menu_SetupConfirmExitToMainMenu();
                }
            }
            this.Menu_GetGroups();
        }
        return true;
    }

    void Menu_SetupMainMenu() {
        this.Menu_SetupGenericMenu();
        if (this.theApp.demoMode) {
            this.Menu_SetupTitle(this.Menu_GetResourceString(60));
        }
        int i = 0;
        if (this.theApp.demoMode) {
            if (this.theApp.ms_demoMode == 2) {
                int n = i++;
                this.Menu_Strings[n] = this.Menu_GetResourceString(62);
            }
            int n = i++;
            this.Menu_Strings[n] = this.Menu_GetResourceString(61);
        } else {
            int n = i++;
            this.Menu_Strings[n] = this.Menu_GetResourceString(34);
        }
        if (this.theApp.getMoreGamesExist) {
            int n = i;
            this.Menu_flags[n] = this.Menu_flags[n] | 0x400;
            int n2 = i++;
            this.Menu_Strings[n2] = this.Menu_GetResourceString(58);
        }
        int n = i++;
        this.Menu_Strings[n] = this.Menu_GetResourceString(2);
        int n3 = i++;
        this.Menu_Strings[n3] = this.Menu_GetResourceString(36);
        int n4 = i++;
        this.Menu_Strings[n4] = this.Menu_GetResourceString(12);
        int n5 = i++;
        this.Menu_Strings[n5] = this.Menu_GetResourceString(3);
        this.Menu_SetupSoftKeys(196608);
        this.FE_AlignMenu(0, i, 36);
    }

    void Menu_SetupGameMenu() {
        this.audio.stop();
        this.Menu_SetupGenericMenu();
        int i = 0;
        int n = i++;
        this.Menu_Strings[n] = this.Menu_GetResourceString(70);
        int n2 = i++;
        this.Menu_Strings[n2] = this.Menu_GetResourceString(2);
        int n3 = i++;
        this.Menu_Strings[n3] = this.Menu_GetResourceString(36);
        int n4 = i++;
        this.Menu_Strings[n4] = this.Menu_GetResourceString(33);
        if (this.theApp.demoMode) {
            int n5 = i++;
            this.Menu_Strings[n5] = this.Menu_GetResourceString(69);
        }
        this.Menu_SetupTitle(this.Menu_GetResourceString(57));
        this.Menu_SetupSoftKeys(196617);
        this.FE_AlignMenu(0, i, 36);
    }

    void Menu_SetupQuitMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(3));
        this.Menu_Strings[0] = this.Menu_GetResourceString(4);
        this.Menu_Strings[1] = this.Menu_GetResourceString(5);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_SetupLanguageMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.Menu_GetResourceString(21);
        this.Menu_Strings[1] = this.Menu_GetResourceString(22);
        this.Menu_Strings[2] = this.Menu_GetResourceString(23);
        this.Menu_Strings[3] = this.Menu_GetResourceString(24);
        this.Menu_Strings[4] = this.Menu_GetResourceString(25);
        if (this.game.currentState == 6) {
            this.Menu_SetupSoftKeys(196608);
        }
        this.FE_AlignMenu(0, GameClass.languageStrings.length, 36);
    }

    void Menu_SetupStartGameMenu() {
        this.prevMenu[this.nextMenu] = 1;
        int i = 0;
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[i] = this.Menu_GetResourceString(1);
        if (this.game.availableStage != -1 && this.game.availableStage != 5) {
            this.game.startFromStage = this.game.availableStage;
            this.Menu_Strings[++i] = this.Menu_GetResourceString(35);
            this.forceMenuPos = 1;
        }
        int n = i++;
        this.Menu_flags[n] = this.Menu_flags[n] | 0x100000;
        this.Menu_Strings[i] = this.Menu_GetResourceString(51);
        if (this.game.availableStage < 0) {
            int n2 = i;
            this.Menu_flags[n2] = this.Menu_flags[n2] | 0x40800;
        }
        this.Menu_Strings[++i] = this.Menu_GetResourceString(52);
        if (this.game.availableStage < 1) {
            int n3 = i;
            this.Menu_flags[n3] = this.Menu_flags[n3] | 0x40800;
        }
        this.Menu_Strings[++i] = this.Menu_GetResourceString(53);
        if (this.game.availableStage < 2) {
            int n4 = i;
            this.Menu_flags[n4] = this.Menu_flags[n4] | 0x40800;
        }
        this.Menu_Strings[++i] = this.Menu_GetResourceString(54);
        if (this.game.availableStage < 3) {
            int n5 = i;
            this.Menu_flags[n5] = this.Menu_flags[n5] | 0x40800;
        }
        this.Menu_Strings[++i] = this.Menu_GetResourceString(55);
        if (this.game.availableStage < 4) {
            int n6 = i;
            this.Menu_flags[n6] = this.Menu_flags[n6] | 0x40800;
        }
        this.FE_AlignMenu(0, ++i, 36);
    }

    void Menu_SetupLoadMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(6));
        this.Menu_Strings[0] = this.Menu_GetResourceString(4);
        this.Menu_Strings[1] = this.Menu_GetResourceString(5);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_SetupSoundMenu() {
        if (this.game.savedLanguage == -1) {
            this.Menu_SetupGenericMenu();
        } else {
            this.FE_ResetMenu();
        }
        this.Menu_SetupSoftKeys(196608);
        this.Menu_SetupTitle(this.Menu_GetResourceString(27));
        this.Menu_Strings[0] = this.Menu_GetResourceString(5);
        this.Menu_Strings[1] = this.Menu_GetResourceString(4);
        this.forceMenuPos = this.game.music;
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_SetupGOMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.Menu_GetResourceString(48);
        this.Menu_SetupSoftKeys(65536);
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_SetupContinueMenu() {
        this.audio.stop();
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(29));
        this.Menu_Strings[0] = this.Menu_GetResourceString(4);
        this.Menu_Strings[1] = this.Menu_GetResourceString(5);
        this.Menu_SetupSoftKeys(196608);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_SetupCSMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.Menu_GetResourceString(50);
        this.Menu_SetupSoftKeys(65536);
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_SetupRUSureMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(6));
        this.Menu_Strings[0] = this.Menu_GetResourceString(4);
        this.Menu_Strings[1] = this.Menu_GetResourceString(5);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_UpdateHelp0Menu(boolean ingame) {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.nextMenu = ingame ? 24 : 7;
    }

    void Menu_UpdateHelp1Menu(boolean ingame) {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.nextMenu = ingame ? 25 : 8;
    }

    void Menu_UpdateAbout0Menu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.nextMenu = 10;
    }

    void Menu_UpdateAbout1Menu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
    }

    void Menu_UpdateMainMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        if (this.theApp.demoMode) {
            if (this.theApp.ms_demoMode == 2) {
                if (i == pos) {
                    try {
                        this.theApp.platformRequest(this.theApp.ms_demoUrl);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.theApp.exit = true;
                }
                ++i;
            }
            if (i == pos) {
                this.nextMenu = 27;
            }
            ++i;
        } else {
            if (i == pos) {
                this.nextMenu = 18;
            }
            ++i;
        }
        if (this.theApp.getMoreGamesExist) {
            if (i == pos) {
                if (this.theApp.ms_upsell == 1) {
                    this.nextMenu = 26;
                } else {
                    try {
                        this.theApp.platformRequest(this.theApp.ms_upsellUrl);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.theApp.exit = true;
                }
            }
            ++i;
        }
        if (i == pos) {
            this.nextMenu = 12;
        }
        if (++i == pos) {
            this.nextMenu = 6;
        }
        if (++i == pos) {
            this.nextMenu = 9;
        }
        if (++i == pos) {
            this.nextMenu = 4;
        }
    }

    boolean Menu_UpdateGameMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return true;
        }
        if (i == pos) {
            return false;
        }
        if (++i == pos) {
            this.nextMenu = 12;
        }
        if (++i == pos) {
            this.nextMenu = 23;
        }
        if (++i == pos) {
            this.nextMenu = 31;
        }
        if (this.theApp.demoMode && ++i == pos) {
            this.nextMenu = 28;
        }
        return true;
    }

    void Menu_UpdateQuitMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        if (i == pos) {
            this.theApp.exit = true;
        }
        if (++i == pos) {
            this.forceGoBack = true;
        }
    }

    void Menu_UpdateLanguageMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.game.language = pos;
        this.game.Game_LoadLanguage();
        this.game.gameSave(true);
        if (this.game.currentState == 6) {
            this.nextMenu = 11;
        } else {
            this.forceGoBack = true;
        }
    }

    void Menu_UpdateStartGameMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        if (i == pos) {
            if (this.game.availableStage != -1) {
                this.nextMenu = 30;
            } else {
                this.game.Game_SetState(4);
                this.nextMenu = 18;
                this.game.availableStage = -1;
                this.game.startFromStage = -1;
                for (int j = 0; j < 12; ++j) {
                    this.game.puzzleAnswered[j] = 0;
                }
            }
        }
        ++i;
        if (this.game.availableStage != -1 && this.game.availableStage != 5) {
            if (i == pos) {
                this.game.Game_SetState(4);
                this.nextMenu = 18;
            }
            ++i;
        }
        if (i == pos) {
            this.game.Game_SetState(4);
            this.nextMenu = 18;
            this.game.startFromStage = 0;
        }
        if (++i == pos) {
            this.game.Game_SetState(4);
            this.nextMenu = 18;
            this.game.startFromStage = 1;
        }
        if (++i == pos) {
            this.game.Game_SetState(4);
            this.nextMenu = 18;
            this.game.startFromStage = 2;
        }
        if (++i == pos) {
            this.game.Game_SetState(4);
            this.nextMenu = 18;
            this.game.startFromStage = 3;
        }
        if (++i == pos) {
            this.game.Game_SetState(4);
            this.nextMenu = 18;
            this.game.startFromStage = 4;
        }
        this.audio.stop();
    }

    void Menu_UpdateLoadMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
    }

    void Menu_UpdateSoundMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.game.music = 1;
        if (i == pos) {
            this.game.music = 0;
        }
        this.game.gameSave(true);
        this.game.Game_SetState(2);
    }

    void Menu_UpdateGOMenu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.game.Game_SetState(1);
    }

    void Menu_UpdateCSMenu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        this.game.Game_SetState(1);
    }

    boolean Menu_UpdateContinueMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return true;
        }
        if (i == pos) {
            this.lastActionWasContinue = true;
            this.game.Game_SetState(4);
            this.ai.AI_ResetEsetData();
            this.theApp.zeroIntArray(this.gamecontrol.eventsCompleted);
            this.ai.AI_DestroyAll();
            this.ai.AI_SetupAndLoadAis();
            this.ai.playerExitedFirstRoom = false;
        }
        if (++i == pos) {
            this.game.Game_SetState(3);
        }
        return false;
    }

    void Menu_UpdateRUSureMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        if (i == pos) {
            this.theApp.exit = true;
        }
        if (++i == pos) {
            this.forceGoBack = true;
        }
    }

    void FE_ResetMenu() {
        for (int i = 0; i < 32; ++i) {
            this.Menu_x[i] = 0;
            this.Menu_y[i] = 0;
            this.Menu_width[i] = 0;
            this.Menu_height[i] = 0;
            this.Menu_flags[i] = 0;
            this.Menu_Strings[i] = null;
        }
    }

    void FE_AlignMenu(int i, int Entrys, int Align) {
        int Index;
        int pos = 0;
        int cxScreen = 65536;
        for (Index = i; Index < i + Entrys; ++Index) {
            int Font2 = 0;
            if ((this.Menu_flags[Index] & 1) != 0) {
                Font2 = 1;
            }
            int WH = this.renderer.Renderer_CalcTextWH(this.Menu_Strings[Index], Font2, this.renderer.convertXToBuild(55536));
            this.Menu_height[Index] = WH & 0xFFFF;
            this.Menu_width[Index] = WH >> 16 & 0xFFFF;
            if ((this.Menu_flags[Index] & 0x100000) == 0) continue;
            int n = Index;
            this.Menu_height[n] = this.Menu_height[n] + (this.Menu_height[Index] >> 1);
        }
        if ((Align & 0x40) != 0) {
            pos = 83285 - this.renderer.Renderer_GetFontHeightVirtual(1);
        }
        if ((Align & 0x10) != 0) {
            pos = 83285;
            for (Index = 0; Index < Entrys; ++Index) {
                pos -= this.Menu_height[i + Index];
            }
        }
        if ((Align & 0x20) != 0) {
            pos = 0;
            boolean gluScreen = false;
            gluScreen |= this.currentMenu == 27 || this.currentMenu == 28;
            if (gluScreen |= this.currentMenu == 26) {
                pos = -(this.renderer.Renderer_GetSpriteHeightVirtual(this.gluLogo) >> 1);
            }
            for (Index = 0; Index < Entrys; ++Index) {
                pos += this.Menu_height[i + Index];
            }
            pos = 83285 - pos >> 1;
        }
        for (Index = 0; Index < Entrys; ++Index) {
            if ((Align & 1) != 0) {
                this.Menu_x[i + Index] = 1092;
            }
            if ((Align & 2) != 0) {
                this.Menu_x[i + Index] = cxScreen - this.Menu_width[i + Index] - 1092;
            }
            if ((Align & 4) != 0) {
                this.Menu_x[i + Index] = cxScreen - this.Menu_width[i + Index] >> 1;
            }
            this.Menu_y[i + Index] = pos;
            pos += this.Menu_height[i + Index];
        }
        if (i != 28 && this.Menu_Strings[28] != null) {
            this.FE_AlignMenuTitle(Align);
        }
    }

    void FE_AlignMenuTitle(int Align) {
        this.FE_AlignMenu(28, 1, 4);
        this.Menu_height[28] = this.Menu_height[28] * 3 >> 1;
        int shift = 0;
        if ((Align & 0x20) != 0) {
            shift = this.Menu_height[28] >> 1;
        }
        if (shift != 0) {
            int i = 0;
            while (i < 25) {
                int n = i++;
                this.Menu_y[n] = this.Menu_y[n] + shift;
            }
        }
        this.Menu_y[28] = this.Menu_y[0] - this.Menu_height[28];
    }

    void Menu_SetupTitle(String str) {
        this.Menu_Strings[28] = str;
        this.Menu_flags[28] = 262464;
        this.FE_AlignMenuTitle(0);
    }

    void Menu_SetupSoftKeys(int Layout) {
        int[] nArray = new int[11];
        nArray[0] = 0;
        nArray[1] = 15;
        nArray[2] = 16;
        nArray[3] = 17;
        nArray[4] = 18;
        nArray[5] = 64;
        nArray[6] = 65;
        nArray[7] = 63;
        nArray[8] = 32;
        nArray[9] = 70;
        nArray[10] = 57;
        int[] SoftKeys = nArray;
        int divider = 11;
        this.Menu_Strings[30] = this.Menu_GetResourceString(SoftKeys[(Layout >> 16) % 11]);
        this.Menu_flags[30] = this.Menu_flags[30] | 0x8001;
        this.FE_AlignMenu(30, 1, 65);
        this.Menu_Strings[31] = this.Menu_GetResourceString(SoftKeys[(Layout & 0xFFFF) % 11]);
        this.Menu_flags[31] = this.Menu_flags[31] | 0x8001;
        this.FE_AlignMenu(31, 1, 66);
    }

    void Menu_Render() {
        boolean gluScreen = false;
        gluScreen |= this.currentMenu == 27 || this.currentMenu == 28;
        if (gluScreen |= this.currentMenu == 26) {
            this.renderer.Renderer_FillRectVirtual(0, 0, 65536, 83285, 255);
            this.renderer.Renderer_DrawBmpVirtual(this.gluLogo, (65536 >> 1) - (this.renderer.Renderer_GetSpriteWidthVirtual(this.gluLogo) >> 1), 2500);
        } else {
            this.renderer.Renderer_FillRectVirtual(0, 0, 65536, 83285, 0xFFFFFF);
            this.renderer.Renderer_DrawBmpVirtual(this.menuBackgroundImage, 0, (83285 >> 1) - (this.renderer.Renderer_GetSpriteHeightVirtual(this.menuBackgroundImage) >> 1));
        }
        int max = this.maxMenuGroup1;
        int pos = this.menuPositionGroup1;
        if (this.currentMenuGroup != 0) {
            max = this.maxMenuGroup2;
            pos = this.menuPositionGroup2;
        }
        for (int i = 0; i < 32; ++i) {
            if (this.Menu_Strings[i] == null) continue;
            int Font2 = (this.Menu_flags[i] & 1) != 0 ? 1 : 0;
            int TextAlign = 1;
            if ((this.Menu_flags[i] & 0x8000) != 0) {
                TextAlign = 0 | 0;
            }
            if ((this.Menu_flags[i] & 0x10000) != 0) {
                TextAlign = 2;
            }
            boolean bl = this.renderer.outline = i == pos && (this.Menu_flags[i] & 0x40000) == 0 || (this.Menu_flags[i] & 0x40) != 0;
            if ((this.Menu_flags[i] & 0x200000) == 0) {
                this.renderer.Renderer_DrawTextVirtual(this.Menu_Strings[i], Font2, TextAlign, i == pos ? 0 : this._menuColor(i), this.Menu_x[i], this.Menu_y[i]);
            } else {
                this.renderer.Renderer_DrawTextMultipleVirtual(this.Menu_Strings[i], Font2, TextAlign, this._menuColor(i), this.Menu_x[i], this.Menu_y[i], 55536);
            }
            this.renderer.outline = false;
        }
    }

    private int _menuColor(int i) {
        if ((this.Menu_flags[i] & 0x100) != 0) {
            return 1;
        }
        if ((this.Menu_flags[i] & 0x1000) != 0) {
            return 0;
        }
        if ((this.Menu_flags[i] & 0x400) != 0) {
            return 5;
        }
        if ((this.Menu_flags[i] & 0x800) != 0) {
            return 4;
        }
        return 7;
    }

    void Menu_GetGroups() {
        this.minMenuGroup1 = Integer.MAX_VALUE;
        this.minMenuGroup2 = Integer.MAX_VALUE;
        this.maxMenuGroup1 = Integer.MIN_VALUE;
        this.maxMenuGroup2 = Integer.MIN_VALUE;
        for (int i = 0; i < 30; ++i) {
            if ((this.Menu_flags[i] & 0x40000) != 0 || this.Menu_Strings[i] == null) continue;
            if ((this.Menu_flags[i] & 0x80000) == 0) {
                if (i > this.maxMenuGroup1) {
                    this.maxMenuGroup1 = i;
                }
                if (i >= this.minMenuGroup1) continue;
                this.minMenuGroup1 = i;
                this.menuPositionGroup1 = i;
                if (this.forceMenuPos == -1) continue;
                this.menuPositionGroup1 = this.forceMenuPos;
                continue;
            }
            if (i > this.maxMenuGroup2) {
                this.maxMenuGroup2 = i;
            }
            if (i >= this.minMenuGroup2) continue;
            this.minMenuGroup2 = i;
            this.menuPositionGroup2 = i;
            if (this.forceMenuPos == -1) continue;
            this.menuPositionGroup2 = this.forceMenuPos;
        }
        this.forceMenuPos = -1;
        this.currentMenuGroup = 0;
    }

    int Menu_SelectCurrentItem() {
        int Dir = 0;
        boolean i = false;
        int min = this.minMenuGroup1;
        int max = this.maxMenuGroup1;
        int pos = this.menuPositionGroup1;
        if (this.currentMenuGroup != 0) {
            min = this.minMenuGroup2;
            max = this.maxMenuGroup2;
            pos = this.menuPositionGroup2;
        }
        if (max < 0) {
            return 0;
        }
        if ((this.debounceKeyMap & 2) != 0) {
            this.game.time = 0;
            Dir = 1;
        }
        if ((this.debounceKeyMap & 1) != 0) {
            this.game.time = 0;
            Dir = -1;
        }
        if ((pos += Dir) > max) {
            pos = min;
        }
        if (pos < min) {
            pos = max;
        }
        if (this.currentMenuGroup == 0) {
            this.menuPositionGroup1 = pos;
        } else {
            this.menuPositionGroup2 = pos;
        }
        return pos;
    }

    void Menu_SetupConfigMenu() {
        this.Menu_SetupGenericMenu();
        int cnt = 1 + (this.game.isVibrationSupported() ? 1 : 0) + 1 + 0;
        this.Menu_SetupTitle(this.Menu_GetResourceString(2));
        this.Menu_SetupConfigStrings();
    }

    void Menu_UpdateConfigMenu() {
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        if (i == pos) {
            this.game.music = (byte)(this.game.music ^ 1);
            if (this.game.music == 0) {
                this.audio.stop();
            } else {
                this.audio.startTune();
            }
            this.game.gameSave(true);
        }
        ++i;
        if (this.game.isVibrationSupported()) {
            if (i == pos) {
                this.game.vibrate = (byte)(this.game.vibrate ^ 1);
                if (this.game.vibrate != 0) {
                    this.game.GameControl_Vibrate(500);
                }
            }
            ++i;
        }
        if (i == pos) {
            this.nextMenu = 17;
        }
        ++i;
        this.Menu_SetupConfigStrings();
    }

    void Menu_SetupConfigStrings() {
        int index = 0;
        String tempstr = " " + this.Menu_GetResourceString(13 + this.game.music);
        int n = index++;
        this.Menu_Strings[n] = this.Menu_GetResourceString(56) + tempstr;
        if (this.game.isVibrationSupported()) {
            tempstr = " " + this.Menu_GetResourceString(13 + this.game.vibrate);
            int n2 = index++;
            this.Menu_Strings[n2] = this.Menu_GetResourceString(28) + tempstr;
        }
        int n3 = index++;
        this.Menu_Strings[n3] = this.Menu_GetResourceString(37);
        this.FE_AlignMenu(0, index, 36);
    }

    void Menu_SetStrings(String str, int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.Menu_Strings[i] = str;
        }
    }

    String Menu_GetResourceString(int val) {
        if (val == 46) {
            return this.game.gameStrings[val] + GameClass.HELP_CONTROL[this.game.language];
        }
        if (val == 40) {
            return this.game.gameStrings[val] + ":For Customer Support please email% mobile@sega-support.com";
        }
        if (val == 47) {
            StringBuffer remaindText = new StringBuffer(this.game.gameStrings[val]);
            int replacePos = remaindText.toString().indexOf(35);
            remaindText.deleteCharAt(replacePos).insert(replacePos, GameClass.LSK[this.game.language]);
            return remaindText.toString();
        }
        return this.game.gameStrings[val];
    }

    void Menu_SetupGenericMenu() {
        this.FE_ResetMenu();
        this.Menu_SetupSoftKeys(196616);
    }

    void Menu_SetupAboutMenu(int h) {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = h == 0 ? this.Menu_GetResourceString(39) + ":1.0.0:" + this.Menu_GetResourceString(40) : this.Menu_GetResourceString(41);
        this.Menu_flags[0] = 2359297;
        this.prevMenu[this.nextMenu] = 1;
        if (h == 0) {
            this.Menu_SetupSoftKeys(131080);
        } else {
            this.Menu_SetupSoftKeys(8);
        }
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_SetupHelpMenu(int h, boolean ingame) {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.Menu_GetResourceString(45 + h);
        this.Menu_flags[0] = 0x240000;
        int n = this.prevMenu[this.nextMenu] = ingame ? 13 : 1;
        if (h == 0 || h == 1) {
            this.Menu_flags[0] = this.Menu_flags[0] | 1;
            this.Menu_SetupSoftKeys(131080);
        } else {
            this.Menu_flags[0] = this.Menu_flags[0] | 1;
            this.Menu_SetupSoftKeys(8);
        }
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_SetupGetMoreGamesMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.Menu_GetResourceString(59);
        this.Menu_flags[0] = 2363392;
        this.prevMenu[this.nextMenu] = 1;
        this.Menu_SetupSoftKeys(4);
        this.Menu_flags[30] = this.Menu_flags[30] | 0x1000;
        this.Menu_flags[31] = this.Menu_flags[31] | 0x1000;
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_SetupTrialRemaindMenu() {
        this.Menu_SetupGenericMenu();
        StringBuffer remaindText = new StringBuffer(this.Menu_GetResourceString(39));
        remaindText.append(this.Menu_GetResourceString(67));
        int replacePos = remaindText.toString().indexOf(35);
        remaindText.deleteCharAt(replacePos).insert(replacePos, 60);
        this.Menu_Strings[0] = remaindText.toString();
        this.Menu_flags[0] = 2363392;
        this.prevMenu[this.nextMenu] = 1;
        this.Menu_SetupSoftKeys(327686);
        this.Menu_flags[30] = this.Menu_flags[30] | 0x1000;
        this.Menu_flags[31] = this.Menu_flags[31] | 0x1000;
        this.FE_AlignMenu(0, 1, 36);
    }

    void Menu_UpdateTrialRemaindMenu() {
        if ((this.debounceKeyMap & 0x20040) != 0) {
            this.theApp.exit = true;
        }
        if ((this.debounceKeyMap & 0x30) != 0) {
            this.nextMenu = 18;
        }
    }

    void Menu_SetupTrialOverMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_Strings[0] = this.theApp.ms_demoMode == 2 ? this.Menu_GetResourceString(39) + this.Menu_GetResourceString(68) : this.Menu_GetResourceString(66);
        this.Menu_flags[0] = 2363393;
        int keyLayout = 0;
        if (this.previousMenu == 13) {
            keyLayout = 6;
            this.prevMenu[this.nextMenu] = 28;
        } else {
            keyLayout = 8;
            this.prevMenu[this.nextMenu] = 1;
        }
        if (this.theApp.ms_demoMode == 2) {
            keyLayout |= 0x70000;
        }
        this.Menu_SetupSoftKeys(keyLayout);
        this.FE_AlignMenu(0, 1, 36);
        this.Menu_flags[30] = this.Menu_flags[30] | 0x1000;
        this.Menu_flags[31] = this.Menu_flags[31] | 0x1000;
    }

    void Menu_UpdateTrialOverMenu() {
        if (this.theApp.ms_demoMode == 2 && (this.debounceKeyMap & 0x30) != 0) {
            try {
                this.theApp.platformRequest(this.theApp.ms_demoUrl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.theApp.exit = true;
            return;
        }
        if ((this.debounceKeyMap & 0x20040) != 0) {
            if (this.previousMenu == 13) {
                this.theApp.exit = true;
            } else {
                this.game.Game_SetState(3);
            }
        }
    }

    void Menu_SetupCheatsMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupCheatsMenuStrings();
        this.Menu_SetupSoftKeys(196616);
    }

    boolean Menu_UpdateCheatsMenu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return true;
        }
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if (i == pos) {
            boolean bl = this.godMode = !this.godMode;
        }
        if (++i == pos) {
            boolean bl = this.showLocation = !this.showLocation;
        }
        if (++i == pos) {
            AI.DEBUG_CAMERA = !AI.DEBUG_CAMERA;
            int n = AI.debugCamera = AI.DEBUG_CAMERA ? 1 : 0;
        }
        if (++i == pos) {
            this.allStagesOpened = true;
        }
        this.Menu_SetupCheatsMenuStrings();
        return true;
    }

    void Menu_SetupCheatsMenuStrings() {
        int i = 0;
        this.Menu_Strings[i++] = "God mode - " + (this.godMode ? "On" : "Off");
        this.Menu_Strings[i++] = "Show location - " + (this.showLocation ? "On" : "Off");
        this.Menu_Strings[i++] = "Fly - " + (AI.DEBUG_CAMERA ? "On" : "Off");
        this.Menu_Strings[i++] = this.allStagesOpened ? "Stages are opened" : "Open all stages";
        this.FE_AlignMenu(0, i, 36);
    }

    void Menu_SetupConfirmNewGameMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(1) + ":" + this.Menu_GetResourceString(6));
        this.Menu_flags[28] = this.Menu_flags[28] | 0x200000;
        this.Menu_Strings[0] = this.Menu_GetResourceString(5);
        this.Menu_Strings[1] = this.Menu_GetResourceString(4);
        this.Menu_SetupSoftKeys(196616);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_UpdateConfirmNewGameMenu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if (i == pos) {
            this.nextMenu = 18;
        }
        if (++i == pos) {
            this.game.Game_SetState(4);
            this.game.startFromStage = -1;
            this.game.availableStage = -1;
            this.renderer.Renderer_FadeScreen();
            for (int j = 0; j < 12; ++j) {
                this.game.puzzleAnswered[j] = 0;
            }
        }
    }

    void Menu_SetupConfirmExitToMainMenu() {
        this.Menu_SetupGenericMenu();
        this.Menu_SetupTitle(this.Menu_GetResourceString(33) + "?");
        this.Menu_flags[28] = this.Menu_flags[28] | 0x200000;
        this.Menu_Strings[0] = this.Menu_GetResourceString(5);
        this.Menu_Strings[1] = this.Menu_GetResourceString(4);
        this.Menu_SetupSoftKeys(196616);
        this.FE_AlignMenu(0, 2, 36);
    }

    void Menu_UpdateConfirmExitToMainMenu() {
        if ((this.debounceKeyMap & 0x30) == 0) {
            return;
        }
        int i = this.minMenuGroup1;
        int pos = this.menuPositionGroup1;
        if (i == pos) {
            this.nextMenu = 13;
        }
        if (++i == pos) {
            this.game.Game_SetState(3);
        }
    }
}

