/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    int curAnim;
    int curFrame;
    public int curTime;
    private int nbLoop;
    private boolean animIsOver;
    int curBlend;
    int curScale;
    private static int k_animBaseFrameTime = 1000 / 6;
    int palette;
    public static int k_AnimNone = -1;
    private static final int k_snd_nbChannel = 2;
    static int s_snd_masterVolume;
    static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static int[] s_snd_sndDuration;
    private static String[] s_snd_sndResourceURL;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static long[] s_snd_playTime;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static GLLibPlayer s_pSoundPlayerIns;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    static int[] s_snd_queue_size;
    private static boolean s_snd_bInUpdate;
    private static int[] s_snd_requestBuffer;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    static int[] s_TilesetInfo;
    static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    static Image[][] s_TilesetLayerImage;
    static Graphics[][] s_TilesetLayerGraphics;
    private static int[][][] s_TilesetLayerLastUpdatedArea;
    private static int s_TilesetLayerLastUpdatedAreaIndex;
    private static ASprite[] s_TilesetSprite;
    private static ASprite[][] s_TilesetMultiSprites;
    static byte[] s_TilesetMultiBlockHeadInfo;
    private static byte[] s_TilesetMultiBlockBlockInfo;
    private static byte[][][][] s_TilesetMultiBlockLayerData;

    GLLibPlayer() {
        this.Reset();
    }

    GLLibPlayer(ASprite aSprite, int n, int n2) {
        this.Reset();
        this.posX = n;
        this.posY = n2;
        this.SetSprite(aSprite);
    }

    void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = k_AnimNone;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.palette = -1;
        this.animIsOver = true;
        if (false) {
            this.curScale = -1;
        }
        if (false) {
            this.curBlend = -1;
        }
    }

    void SetSprite(ASprite aSprite) {
        this.sprite = aSprite;
        this.SetAnim(k_AnimNone, -1);
    }

    void SetAnim(int n, int n2) {
        if (this.animIsOver || n != this.curAnim) {
            this.curAnim = n;
            this.SetFrame(0);
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    int SetFrame(int n) {
        if (this.curAnim < 0) {
            return -1;
        }
        int n2 = this.GetNbFrame();
        while (n > n2) {
            n -= n2;
        }
        this.curFrame = n;
        this.curTime = 0;
        return n;
    }

    final int GetAnimFrame() {
        if (this.sprite == null || this.curAnim == k_AnimNone) {
            return -1;
        }
        return this.sprite.GetAnimFrame(this.curAnim, this.curFrame);
    }

    int GetNbFrame() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    final int GetDuration() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    boolean IsAnimOver() {
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    void Render() {
        if (this.curAnim < 0) {
            return;
        }
        if (!false && this.animIsOver) {
            return;
        }
        if (false || false) {
            if (false && this.curScale != -1) {
                int n = 11;
                GLLib.PFX_EnableEffect(n, false);
                int n2 = this.curScale;
                int n3 = 1;
                int n4 = 11;
                GLLib.s_PFX_params[n4][n3] = n2;
                if (false && this.curBlend != -1) {
                    int n5 = this.curBlend;
                    int n6 = 2;
                    int n7 = 11;
                    GLLib.s_PFX_params[n7][n6] = n5;
                }
            } else if (false && this.curBlend != -1) {
                int n = 10;
                GLLib.PFX_EnableEffect(n, false);
                int n8 = this.curBlend;
                int n9 = 1;
                int n10 = 10;
                GLLib.s_PFX_params[n10][n9] = n8;
            }
        }
        if (this.palette != -1) {
            int n = this.sprite.GetCurrentPalette();
            this.sprite.SetCurrentPalette(this.palette);
            this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
            this.sprite.SetCurrentPalette(n);
        } else {
            this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
        }
        if (false || false) {
            GLLib.s_PFX_type &= 0xFFFFF21F;
        }
    }

    void Update(int n) {
        if (this.animIsOver || this.curAnim < 0) {
            return;
        }
        int n2 = this.GetDuration();
        if (true && n2 == 0) {
            return;
        }
        if (false) {
            if (this.curTime >= n2) {
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else if (this.nbLoop == 0) {
                    this.animIsOver = true;
                } else {
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
            }
        } else {
            while (this.curTime >= n2) {
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else {
                    if (this.nbLoop == 0) {
                        this.animIsOver = true;
                        break;
                    }
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                n2 = this.GetDuration();
                if (!true || n2 != 0) continue;
            }
        }
        this.curTime += n;
    }

    private static final int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static void SndQueue_Push_Normal(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        int n10 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n10 - i - 1);
            if (s_snd_queue[(n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)) + 0] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7 + 0] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n10);
        GLLibPlayer.s_snd_queue[n7 + 0] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n11 = n;
        s_snd_queue_size[n11] = s_snd_queue_size[n11] + 1;
    }

    private static synchronized void SndQueue_Push_Synched(int n, int n2, int n3, int n4, int n5, int n6) {
        GLLibPlayer.SndQueue_Push_Normal(n, n2, n3, n4, n5, n6);
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        if (true && false) {
            GLLibPlayer.SndQueue_Push_Synched(n, n2, n3, n4, n5, n6);
        } else {
            GLLibPlayer.SndQueue_Push_Normal(n, n2, n3, n4, n5, n6);
        }
    }

    private static final void SndQueue_Push(int n, int n2) {
        GLLibPlayer.SndQueue_Push(n, n2, -1, -1, -1, -1);
    }

    private static void SndQueue_Pop_Normal(int n, int[] nArray) {
        nArray[5] = s_snd_queue_size[n];
        if (s_snd_queue_size[n] > 0) {
            int n2 = GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]);
            System.arraycopy(s_snd_queue, n2, nArray, 0, 5);
            GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
            int n3 = n;
            s_snd_queue_size[n3] = s_snd_queue_size[n3] - 1;
        }
    }

    private static synchronized void SndQueue_Pop_Synched(int n, int[] nArray) {
        GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
    }

    private static void SndQueue_Pop(int n, int[] nArray) {
        if (true && false) {
            GLLibPlayer.SndQueue_Pop_Synched(n, nArray);
        } else {
            GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
        }
    }

    static void Snd_Init(int n) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (k_snd_nbChannel > 1) {
            if (false) {
                // empty if block
            }
            if (false) {
                // empty if block
            }
            if (false) {
                // empty if block
            }
        }
        s_snd_Player = new Player[k_snd_nbChannel];
        if (false) {
            s_snd_PlayerSlot = new Player[n];
        }
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        s_snd_requestBuffer = new int[6];
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.s_snd_index[i] = -1;
            GLLibPlayer.s_snd_queue_pointer[i] = 0;
            GLLibPlayer.s_snd_queue_size[i] = 0;
        }
        s_snd_maxNbSoundSlot = n;
        s_snd_sndSlot = new byte[s_snd_maxNbSoundSlot][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        if (false) {
            s_snd_sndResourceURL = new String[s_snd_maxNbSoundSlot];
        }
        if (false) {
            s_snd_sndDuration = new int[s_snd_maxNbSoundSlot];
            s_snd_playTime = new long[k_snd_nbChannel];
        }
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
        if (true) {
            s_pSoundPlayerIns = new GLLibPlayer();
            s_pThread = new Thread(s_pSoundPlayerIns);
            s_pThread.start();
        }
    }

    static void Snd_LoadSound(String string, int n, boolean bl) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (n < 0) {
            return;
        }
        GLLib.Pack_Open(string);
        byte[] byArray = GLLib.Pack_ReadData(n);
        GLLibPlayer.Snd_LoadSound(byArray, GLLib.s_pack_lastDataReadMimeType, n, bl);
    }

    static void Snd_LoadSound(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (byArray == null || byArray.length <= 0) {
            if (false) {
                // empty if block
            }
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.s_snd_sndSlot[n2] = byArray;
        GLLibPlayer.s_snd_sndType[n2] = n;
        if (false) {
            // empty if block
        }
        if (false && bl) {
            if (false) {
                // empty if block
            }
            GLLibPlayer.s_snd_PlayerSlot[n2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
            if (false) {
                if (false) {
                    // empty if block
                }
                s_snd_PlayerSlot[n2].realize();
                if (false) {
                    if (false) {
                        // empty if block
                    }
                    s_snd_PlayerSlot[n2].prefetch();
                }
            }
            GLLibPlayer.s_snd_sndSlot[n2] = null;
        }
    }

    static void Snd_UnLoadSound(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (n < 0) {
            return;
        }
        GLLibPlayer.s_snd_sndSlot[n] = null;
        if (false) {
            GLLibPlayer.s_snd_sndResourceURL[n] = null;
        }
        if (false) {
            if (s_snd_PlayerSlot != null && s_snd_PlayerSlot[n] != null) {
                s_snd_PlayerSlot[n].close();
            }
            GLLibPlayer.s_snd_PlayerSlot[n] = null;
            for (int i = 0; i < k_snd_nbChannel; ++i) {
                if (n != GLLibPlayer.Snd_GetCurrentSoundIndex(i)) continue;
                GLLibPlayer.s_snd_state[i] = 0;
                GLLibPlayer.s_snd_Player[i] = null;
            }
        }
        if (false) {
            System.gc();
        }
    }

    static void Snd_Play(int n, int n2, int n3, int n4, int n5) {
        if (true) {
            if (false) {
                // empty if block
            }
            if (n2 < 0 || n4 == 0) {
                if (false) {
                    // empty if block
                }
                return;
            }
            GLLibPlayer.SndQueue_Push(n, 3, n2, n5, n4, n3);
        }
    }

    static final void Snd_Stop(int n) {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.SndQueue_Push(n, 4);
    }

    static final void Snd_Pause(int n) {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.SndQueue_Push(n, 5);
    }

    private static void Snd_PrepareExec(int n, int n2, int n3) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        int n4 = s_snd_index[n];
        GLLibPlayer.Snd_FreeChannelExec(n);
        if (false) {
            // empty if block
        }
        if (false) {
            // empty if block
        }
        if (false) {
            GLLibPlayer.s_snd_Player[n] = s_snd_PlayerSlot[n2];
        }
        if (false && s_snd_Player[n] == null && s_snd_sndResourceURL[n2] != null) {
            s_snd_IgnoreSoundsOnInterrupt = true;
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((String)s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = false;
        }
        if (s_snd_Player[n] == null) {
            if (false) {
                // empty if block
            }
            if (s_snd_sndSlot[n2] == null) {
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        if (!false) {
            if (false) {
                // empty if block
            }
            s_snd_Player[n].realize();
        }
        if (!false) {
            if (false) {
                // empty if block
            }
            s_snd_Player[n].prefetch();
        }
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
        if (n4 >= 0 && n4 < s_snd_maxNbSoundSlot && GLLibPlayer.Snd_GetSlotState(n4) == 400) {
            s_snd_PlayerSlot[n4].stop();
        }
    }

    private static void Snd_PlayExec(int n, int n2, int n3, int n4, int n5) throws Exception {
        if (!true || GLLib.s_game_isPaused) {
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.Snd_PrepareExec(n, n2, n3);
        if (GLLib.s_game_isPaused) {
            return;
        }
        if (s_snd_state[n] != 1 || s_snd_Player[n] == null) {
            if (false) {
                // empty if block
            }
            return;
        }
        if (false) {
            // empty if block
        }
        if (n4 == 0) {
            s_snd_Player[n].setLoopCount(-1);
        } else {
            s_snd_Player[n].setLoopCount(n4);
        }
        if (false) {
            if (false) {
                // empty if block
            }
            ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n5 * s_snd_masterVolume * 100 / 10000);
        }
        if (false) {
            // empty if block
        }
        if (false) {
            s_snd_Player[n].setMediaTime(0L);
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
        GLLibPlayer.s_snd_volume[n] = n5;
        GLLibPlayer.s_snd_loop[n] = n4;
        GLLibPlayer.s_snd_priority[n] = n3;
        GLLibPlayer.s_snd_index[n] = n2;
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = System.currentTimeMillis();
        }
    }

    static void Snd_SetMasterVolume(int n) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        s_snd_masterVolume = n;
        try {
            for (int i = 0; i < k_snd_nbChannel; ++i) {
                if (s_snd_Player[i] == null || s_snd_Player[i] == null || !false) continue;
                ((VolumeControl)s_snd_Player[i].getControl("VolumeControl")).setLevel(s_snd_volume[i] * s_snd_masterVolume * 100 / 10000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void Snd_StopExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 1;
        if (true) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = 0L;
        }
    }

    private static void Snd_PauseExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] != 2) {
            return;
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 3;
    }

    private static void Snd_ResumeExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] != 3) {
            if (false) {
                // empty if block
            }
            return;
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
    }

    static void Snd_Update() {
        if (true) {
            if (s_pThread != null && !s_pThread.isAlive()) {
                s_pThread.start();
            }
        } else {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    private static void Snd_Update_Exec() {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (true) {
            if (s_snd_bInUpdate) {
                return;
            }
            s_snd_bInUpdate = true;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.SndQueue_Pop(i, s_snd_requestBuffer);
            if (s_snd_requestBuffer[5] <= 0) continue;
            if (s_snd_state[i] == 2) {
                boolean bl;
                try {
                    bl = GLLibPlayer.Snd_IsPlaying(i);
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) {
                    GLLibPlayer.s_snd_state[i] = 1;
                }
            }
            while (s_snd_requestBuffer[5] > 0) {
                try {
                    if (false) {
                        // empty if block
                    }
                    switch (s_snd_requestBuffer[0]) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(i, s_snd_requestBuffer[1], s_snd_requestBuffer[2]);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(i);
                            break;
                        }
                        case 3: {
                            GLLibPlayer.Snd_PlayExec(i, s_snd_requestBuffer[1], s_snd_requestBuffer[2], s_snd_requestBuffer[4], s_snd_requestBuffer[3]);
                            break;
                        }
                        case 4: {
                            GLLibPlayer.Snd_StopExec(i);
                            break;
                        }
                        case 5: {
                            GLLibPlayer.Snd_PauseExec(i);
                            break;
                        }
                        case 6: {
                            GLLibPlayer.Snd_ResumeExec(i);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GLLibPlayer.SndQueue_Pop(i, s_snd_requestBuffer);
            }
        }
        if (true) {
            s_snd_bInUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                if (false && !false) {
                    GLLib gLLib = GLLib.s_gllib_instance;
                    synchronized (gLLib) {
                        if (GLLib.s_game_isPaused) {
                            this.wait();
                        }
                    }
                }
                Thread.sleep(1000 / 10);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (n >= k_snd_nbChannel || s_snd_Player[n] == null) {
            return false;
        }
        if (false) {
            int n2 = GLLibPlayer.Snd_GetCurrentSoundIndex(n);
            if (n2 < 0) {
                return false;
            }
            if (s_snd_loop[n] != 0 && System.currentTimeMillis() - s_snd_playTime[n] > (long)(s_snd_sndDuration[n2] * s_snd_loop[n])) {
                return false;
            }
        } else if (s_snd_Player[n].getState() != 400) {
            return false;
        }
        return true;
    }

    static int Snd_GetSlotState(int n) {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (n < 0 || n >= s_snd_maxNbSoundSlot || s_snd_PlayerSlot[n] == null) {
            return -1;
        }
        return s_snd_PlayerSlot[n].getState();
    }

    static void Snd_SetMediaDuration(int n, int n2) throws Exception {
        if (!true) {
            return;
        }
        if (!false) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n < 0) {
            if (false) {
                // empty if block
            }
            return;
        }
        GLLibPlayer.s_snd_sndDuration[n] = n2;
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            if (!false) {
                s_snd_Player[n].deallocate();
            }
            if (!false) {
                s_snd_Player[n].close();
            } else {
                int n2 = s_snd_index[n];
                if (n2 < 0 || s_snd_PlayerSlot[n2] == null) {
                    s_snd_Player[n].close();
                }
            }
            GLLibPlayer.s_snd_Player[n] = null;
            if (false) {
                System.gc();
            }
        }
        GLLibPlayer.s_snd_state[n] = 0;
        GLLibPlayer.s_snd_index[n] = -1;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        if (!true) {
            GLLibPlayer.Snd_Update();
        } else if (GLLib.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static int Snd_GetCurrentSoundIndex(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[n];
        }
        return -1;
    }

    static void Snd_PauseNotify() {
        if (!(!true || s_snd_IgnoreSoundsOnInterrupt && false)) {
            try {
                GLLibPlayer.Snd_StopAllSounds();
                if (true && GLLib.s_game_isPaused) {
                    GLLibPlayer.Snd_Update_Exec();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void Tileset_Init(int n, int n2, int n3, int n4) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][16];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        if (false) {
            s_TilesetMultiSprites = new ASprite[s_TilesetMaxLayerCount][];
        }
        if (false) {
            s_TilesetLayerLastUpdatedArea = new int[s_TilesetMaxLayerCount][6][4];
        }
        GLLibPlayer.s_TilesetInfo[0] = n;
        GLLibPlayer.s_TilesetInfo[1] = n2;
        if (false) {
            n3 = GLLib.Math_Log2(n3);
            n4 = GLLib.Math_Log2(n4);
            GLLibPlayer.s_TilesetInfo[3] = n3;
            GLLibPlayer.s_TilesetInfo[2] = 1 << n3;
            GLLibPlayer.s_TilesetInfo[4] = s_TilesetInfo[2] - 1;
            GLLibPlayer.s_TilesetInfo[6] = n4;
            GLLibPlayer.s_TilesetInfo[5] = 1 << n4;
            GLLibPlayer.s_TilesetInfo[7] = s_TilesetInfo[5] - 1;
        } else {
            GLLibPlayer.s_TilesetInfo[2] = n3;
            GLLibPlayer.s_TilesetInfo[4] = 0;
            GLLibPlayer.s_TilesetInfo[5] = n4;
            GLLibPlayer.s_TilesetInfo[7] = 0;
        }
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][15] & n2) != 0;
    }

    private static final void setFlag(int n, int n2, boolean bl) {
        if (bl) {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[15] = nArray[15] | n2;
        } else {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[15] = nArray[15] & ~n2;
        }
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, boolean bl, int n2, int n3, int n4) {
        if (bl) {
            GLLibPlayer.Tileset_LoadLayer(n, byArray, byArray2, byArray3, aSprite, n, n2, n3, n4);
        } else {
            GLLibPlayer.Tileset_LoadLayer(n, byArray, byArray2, byArray3, aSprite, -1, n2, n3, n4);
        }
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, int n2, int n3, int n4, int n5) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.Tileset_Destroy(n, false);
        if (!false) {
            GLLibPlayer.s_TilesetLayerData[n][0] = byArray2;
            GLLibPlayer.s_TilesetLayerData[n][1] = byArray3;
        }
        GLLibPlayer.s_TilesetLayerInfo[n][2] = GLLib.Mem_GetShort(byArray, 0);
        GLLibPlayer.s_TilesetLayerInfo[n][3] = GLLib.Mem_GetShort(byArray, 2);
        if (false && byArray.length > 4 || false) {
            GLLibPlayer.s_TilesetLayerInfo[n][4] = GLLib.Mem_GetShort(byArray, 4);
        }
        GLLibPlayer.s_TilesetLayerInfo[n][5] = s_TilesetLayerInfo[n][2] * s_TilesetInfo[2];
        GLLibPlayer.s_TilesetLayerInfo[n][6] = s_TilesetLayerInfo[n][3] * s_TilesetInfo[5];
        GLLibPlayer.s_TilesetSprite[n] = aSprite;
        if (n2 > -1) {
            try {
                if (false) {
                    GLLibPlayer.s_TilesetLayerInfo[n][7] = (s_TilesetInfo[0] & ~s_TilesetInfo[4]) + 1 * s_TilesetInfo[2];
                    GLLibPlayer.s_TilesetLayerInfo[n][8] = (s_TilesetInfo[1] & ~s_TilesetInfo[7]) + 1 * s_TilesetInfo[5];
                    if (s_TilesetLayerInfo[n][7] - s_TilesetInfo[0] < s_TilesetInfo[2]) {
                        int[] nArray = s_TilesetLayerInfo[n];
                        nArray[7] = nArray[7] + s_TilesetInfo[2];
                    }
                    if (s_TilesetLayerInfo[n][8] - s_TilesetInfo[1] < s_TilesetInfo[5]) {
                        int[] nArray = s_TilesetLayerInfo[n];
                        nArray[8] = nArray[8] + s_TilesetInfo[5];
                    }
                } else {
                    int n6 = s_TilesetInfo[0] % s_TilesetInfo[2];
                    int n7 = 1 + (n6 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][7] = s_TilesetInfo[0] - n6 + n7 * s_TilesetInfo[2];
                    int n8 = s_TilesetInfo[1] % s_TilesetInfo[5];
                    int n9 = 1 + (n8 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][8] = s_TilesetInfo[1] - n8 + n9 * s_TilesetInfo[5];
                    if (false) {
                        if ((s_TilesetLayerInfo[n][7] & 1) != 0) {
                            int[] nArray = s_TilesetLayerInfo[n];
                            nArray[7] = nArray[7] + s_TilesetInfo[2];
                        }
                        if ((s_TilesetLayerInfo[n][8] & 1) != 0) {
                            int[] nArray = s_TilesetLayerInfo[n];
                            nArray[8] = nArray[8] + s_TilesetInfo[5];
                        }
                    }
                }
                if (n2 == n) {
                    if (s_TilesetLayerImage[n][0] == null || s_TilesetLayerImage[n][0].getWidth() != s_TilesetLayerInfo[n][7] || s_TilesetLayerImage[n][0].getHeight() != s_TilesetLayerInfo[n][8]) {
                        GLLibPlayer.s_TilesetLayerImage[n][0] = false && ASprite.s_resizeOn ? Image.createImage((int)ASprite.scaleX(s_TilesetLayerInfo[n][7]), (int)ASprite.scaleY(s_TilesetLayerInfo[n][8])) : Image.createImage((int)s_TilesetLayerInfo[n][7], (int)s_TilesetLayerInfo[n][8]);
                        GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerImage[n][0].getGraphics();
                        if (false) {
                            GLLibPlayer.setFlag(n, 64, true);
                        }
                    }
                } else {
                    GLLibPlayer.s_TilesetLayerImage[n][0] = s_TilesetLayerImage[n2][0];
                    GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerGraphics[n2][0];
                }
                GLLibPlayer.setFlag(n, 4, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLLibPlayer.s_TilesetLayerInfo[n][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][11] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][12] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][0] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][1] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
        GLLibPlayer.s_TilesetLayerInfo[n][14] = 0;
        GLLibPlayer.setFlag(n, 1, n4 == 1);
        GLLibPlayer.setFlag(n, 16, n4 == 0);
        GLLibPlayer.setFlag(n, 2, n5 == 1);
        GLLibPlayer.setFlag(n, 32, n5 == 0);
        GLLibPlayer.setFlag(n, 8, n3 == 32);
    }

    static void Tileset_Destroy(int n) {
        GLLibPlayer.Tileset_Destroy(n, true);
    }

    static void Tileset_Destroy(int n, boolean bl) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n] = new int[16];
        if (bl) {
            GLLibPlayer.s_TilesetLayerImage[n] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[n] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[n] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[n] = null;
        if (false && s_TilesetMultiSprites[n] != null) {
            GLLibPlayer.s_TilesetMultiSprites[n] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void Tileset_Draw(Graphics graphics, int n, int n2, int n3) {
        block48: {
            int n4;
            int n5;
            int n6;
            int n7;
            block47: {
                void var21_40;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int[] nArray;
                block54: {
                    block52: {
                        block53: {
                            block51: {
                                block49: {
                                    block50: {
                                        int n13;
                                        int n14;
                                        int n15;
                                        int n16;
                                        int n17;
                                        int n18;
                                        if (!s_bTilesetPlayerInitialized) {
                                            return;
                                        }
                                        n7 = s_TilesetInfo[0];
                                        n6 = s_TilesetInfo[1];
                                        if (n3 == -1) {
                                            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                                                if (false) {
                                                    if (i == s_TilesetAlphaLayer) continue;
                                                    GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                                    continue;
                                                }
                                                GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                            }
                                            return;
                                        }
                                        nArray = s_TilesetLayerInfo[n3];
                                        if (nArray[0] != 1 || nArray[1] != 1) {
                                            return;
                                        }
                                        n5 = nArray[13];
                                        n4 = nArray[14];
                                        if (!GLLibPlayer.isFlag(n3, 4)) break block47;
                                        n12 = 0;
                                        n11 = 0;
                                        n10 = 0;
                                        n9 = 0;
                                        if (GLLib.IsClipValid(graphics)) {
                                            n12 = GLLib.GetClipX(graphics);
                                            n11 = GLLib.GetClipY(graphics);
                                            n10 = GLLib.GetClipWidth(graphics);
                                            n9 = GLLib.GetClipHeight(graphics);
                                        }
                                        if (false) {
                                            n18 = n5 >> s_TilesetInfo[3];
                                            n17 = n4 >> s_TilesetInfo[6];
                                            n16 = n5 + s_TilesetInfo[0] >> s_TilesetInfo[3];
                                            n15 = n4 + s_TilesetInfo[1] >> s_TilesetInfo[6];
                                        } else {
                                            n14 = n5;
                                            n13 = n4;
                                            if (n14 < 0) {
                                                n14 -= s_TilesetInfo[2];
                                            }
                                            if (n13 < 0) {
                                                n13 -= s_TilesetInfo[5];
                                            }
                                            n18 = n14 / s_TilesetInfo[2];
                                            n17 = n13 / s_TilesetInfo[5];
                                            n16 = n18 + nArray[7] / s_TilesetInfo[2] - 1;
                                            n15 = n17 + nArray[8] / s_TilesetInfo[5] - 1;
                                        }
                                        n14 = 0;
                                        n13 = 0;
                                        int n19 = 0;
                                        int n20 = 0;
                                        if (nArray[10] != n17 || nArray[12] != n15) {
                                            if (nArray[10] < n17 || nArray[12] < n15) {
                                                if (nArray[12] < n17) {
                                                    n19 = n17;
                                                    n20 = n15;
                                                } else {
                                                    n19 = nArray[12] + 1;
                                                    n20 = n15;
                                                }
                                            } else if (nArray[10] > n15) {
                                                n19 = n17;
                                                n20 = n15;
                                            } else {
                                                n19 = n17;
                                                n20 = nArray[10] - 1;
                                            }
                                        }
                                        if (false && GLLibPlayer.isFlag(n3, 64)) {
                                            s_TilesetLayerLastUpdatedAreaIndex = 0;
                                        }
                                        if (nArray[9] != n18 || nArray[11] != n16) {
                                            void var21_33;
                                            if (nArray[9] < n18 || nArray[11] < n16) {
                                                if (nArray[11] < n18) {
                                                    n14 = n18;
                                                    n13 = n16;
                                                } else {
                                                    n14 = nArray[11] + 1;
                                                    n13 = n16;
                                                }
                                            } else if (nArray[9] > n16) {
                                                n14 = n18;
                                                n13 = n16;
                                            } else {
                                                n14 = n18;
                                                n13 = nArray[9] - 1;
                                            }
                                            int bl = n15 - n17;
                                            n8 = n17;
                                            if (nArray[10] != n17 || nArray[12] != n15) {
                                                if (nArray[10] < n17 || nArray[12] < n15) {
                                                    int n21 = bl - (n20 - n19 + 1);
                                                } else {
                                                    int n22 = bl - (n20 - n19 + 1);
                                                    n8 += n20 - n19 + 1;
                                                }
                                            }
                                            if (var21_33 >= 0) {
                                                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n14, n8, n13 - n14, (int)var21_33, 0, 0);
                                            }
                                            nArray[9] = n18;
                                            nArray[11] = n16;
                                        }
                                        if (nArray[10] != n17 || nArray[12] != n15) {
                                            GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n18, n19, n16 - n18, n20 - n19, 0, 0);
                                            nArray[10] = n17;
                                            nArray[12] = n15;
                                        }
                                        if (graphics == null) break block48;
                                        boolean bl = false;
                                        if (GLLibPlayer.isFlag(n3, 17)) break block49;
                                        if (n5 >= 0) break block50;
                                        n -= n5;
                                        n5 = 0;
                                        boolean bl2 = true;
                                        break block51;
                                    }
                                    if (n5 <= nArray[5] - n7) break block51;
                                    n -= n5 - (nArray[5] - n7);
                                    n5 = nArray[5] - n7;
                                    boolean bl = true;
                                    break block51;
                                }
                                while (n5 < 0) {
                                    n5 += nArray[7];
                                }
                            }
                            if (GLLibPlayer.isFlag(n3, 34)) break block52;
                            if (n4 >= 0) break block53;
                            n2 -= n4;
                            n4 = 0;
                            boolean bl = true;
                            break block54;
                        }
                        if (n4 <= nArray[6] - n6) break block54;
                        n2 -= n4 - (nArray[6] - n6);
                        n4 = nArray[6] - n6;
                        boolean bl = true;
                        break block54;
                    }
                    while (n4 < 0) {
                        n4 += nArray[8];
                    }
                }
                n8 = n5 % nArray[7];
                int n23 = n4 % nArray[8];
                int n24 = (n5 + n7) % nArray[7];
                int n25 = (n4 + n6) % nArray[8];
                GLLib.SetClip(graphics, n12, n11, n10, n9);
                if (n24 > n8) {
                    if (n25 > n23) {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n23, n7, n6, 0 + n, 0 + n2, (boolean)var21_40);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n23, n7, n6 - n25, 0 + n, 0 + n2, (boolean)var21_40);
                        GLLib.SetClip(graphics, n12, n11, n10, n9);
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7, n25, 0 + n, n6 - n25 + n2, (boolean)var21_40);
                    }
                } else if (n25 > n23) {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n23, n7 - n24, n6, 0 + n, 0 + n2, (boolean)var21_40);
                    GLLib.SetClip(graphics, n12, n11, n10, n9);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n23, n24, n6, n7 - n24 + n, 0 + n2, (boolean)var21_40);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n23, n7 - n24, n6 - n25, 0 + n, 0 + n2, (boolean)var21_40);
                    GLLib.SetClip(graphics, n12, n11, n10, n9);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7 - n24, n25, 0 + n, n6 - n25 + n2, (boolean)var21_40);
                    GLLib.SetClip(graphics, n12, n11, n10, n9);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n23, n24, n6 - n25, n7 - n24 + n, 0 + n2, (boolean)var21_40);
                    GLLib.SetClip(graphics, n12, n11, n10, n9);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, 0, n24, n25, n7 - n24 + n, n6 - n25 + n2, (boolean)var21_40);
                }
                GLLib.SetClip(graphics, n12, n11, n10, n9);
                break block48;
            }
            if (graphics != null) {
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                int n29;
                if (false) {
                    n29 = n5 >> s_TilesetInfo[3];
                    n28 = n4 >> s_TilesetInfo[6];
                    n27 = n7 >> s_TilesetInfo[3];
                    if (n27 << s_TilesetInfo[3] < n7) {
                        ++n27;
                    }
                    if ((n26 = n6 >> s_TilesetInfo[6]) << s_TilesetInfo[6] < n6) {
                        ++n26;
                    }
                    n25 = (n29 << s_TilesetInfo[3]) - n5;
                    n24 = (n28 << s_TilesetInfo[6]) - n4;
                } else {
                    int n30 = n5;
                    int n31 = n4;
                    if (n30 < 0) {
                        n30 -= s_TilesetInfo[2];
                    }
                    if (n31 < 0) {
                        n31 -= s_TilesetInfo[5];
                    }
                    n29 = n30 / s_TilesetInfo[2];
                    n28 = n31 / s_TilesetInfo[5];
                    n27 = n7 / s_TilesetInfo[2];
                    if (n27 * s_TilesetInfo[2] < n7) {
                        ++n27;
                    }
                    if ((n26 = n6 / s_TilesetInfo[5]) * s_TilesetInfo[5] < n6) {
                        ++n26;
                    }
                    n25 = n29 * s_TilesetInfo[2] - n5;
                    n24 = n28 * s_TilesetInfo[5] - n4;
                }
                GLLibPlayer.Tileset_UpdateBuffer(graphics, n3, n29, n28, n27, n26, n25 + n, n24 + n2);
            }
        }
    }

    private static void Tileset_Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (false && ASprite.s_resizeOn) {
            n2 = ASprite.scaleX(n2);
            n3 = ASprite.scaleY(n3);
            n4 = ASprite.scaleX(n4);
            n5 = ASprite.scaleY(n5);
            n6 = ASprite.scaleX(n6);
            n7 = ASprite.scaleY(n7);
        }
        if (bl) {
            if (n6 > GLLib.s_screenWidth || n7 > GLLib.s_screenHeight || n6 + n4 < 0 || n7 + n5 < 0) {
                return;
            }
            GLLib.ClipRect(graphics, n6, n7, n4, n5);
            GLLib.ClipRect(graphics, 0, 0, GLLib.s_screenWidth, GLLib.s_screenHeight);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
        } else {
            GLLib.ClipRect(graphics, n6, n7, n4, n5);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
        }
    }

    private static void Tileset_UpdateBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        boolean bl = GLLibPlayer.isFlag(n, 4);
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl2 = GLLibPlayer.isFlag(n, 1);
        boolean bl3 = GLLibPlayer.isFlag(n, 2);
        int n17 = s_TilesetLayerInfo[n][2];
        int n18 = s_TilesetLayerInfo[n][3];
        int n19 = s_TilesetInfo[2];
        int n20 = s_TilesetInfo[5];
        if (false) {
            n13 = GLLib.GetClipX(graphics);
            n14 = GLLib.GetClipY(graphics);
            n15 = GLLib.GetClipWidth(graphics);
            n16 = GLLib.GetClipHeight(graphics);
        }
        if (bl) {
            if (false) {
                n12 = (n2 << s_TilesetInfo[3]) % s_TilesetLayerInfo[n][7] + n6;
                n11 = (n3 << s_TilesetInfo[6]) % s_TilesetLayerInfo[n][8] + n7;
            } else {
                n12 = n2 * s_TilesetInfo[2] % s_TilesetLayerInfo[n][7] + n6;
                n11 = n3 * s_TilesetInfo[5] % s_TilesetLayerInfo[n][8] + n7;
            }
            if (n12 < 0) {
                n12 += s_TilesetLayerInfo[n][7];
            }
            if (n11 < 0) {
                n11 += s_TilesetLayerInfo[n][8];
            }
        } else {
            n12 = n6;
            n11 = n7;
        }
        if (bl2) {
            while (n2 < 0) {
                n2 += n17;
            }
            while (n2 >= n17) {
                n2 -= n17;
            }
        } else if (!GLLibPlayer.isFlag(n, 16)) {
            if (n2 < 0) {
                n12 -= n2 * n19;
                n4 += n2;
                n2 = 0;
                if (bl && n12 >= s_TilesetLayerInfo[n][7]) {
                    n12 = 0;
                }
            }
            if (n2 + n4 >= n17) {
                n4 = n17 - n2 - 1;
            }
            if (n4 < 0) {
                return;
            }
        }
        if (bl3) {
            while (n3 < 0) {
                n3 += n18;
            }
            while (n3 >= n18) {
                n3 -= n18;
            }
        } else if (!GLLibPlayer.isFlag(n, 32)) {
            if (n3 < 0) {
                n11 -= n3 * n20;
                n5 += n3;
                n3 = 0;
                if (bl && n11 >= s_TilesetLayerInfo[n][8]) {
                    n11 = 0;
                }
            }
            if (n3 + n5 >= n18) {
                n5 = n18 - n3 - 1;
            }
            if (n5 < 0) {
                return;
            }
        }
        int n21 = n12;
        int n22 = n11;
        int n23 = (1 << s_TilesetLayerInfo[n][4]) - 1;
        while (n5-- >= 0) {
            n21 = n12;
            int n24 = n4;
            int n25 = n2;
            while (n24-- >= 0) {
                int n26 = n25 + n3 * n17;
                n10 = n17 * n18;
                if (n26 < n10) {
                    boolean bl4;
                    int n27;
                    if (false && s_TilesetMultiSprites[n] != null) {
                        n27 = GLLibPlayer.Tileset_GetLayerData(n, 0, n26, true);
                        boolean bl5 = bl4 = n27 == 65535;
                        if (!bl4) {
                            GLLibPlayer.s_TilesetSprite[n] = s_TilesetMultiSprites[n][n27 & n23];
                            n27 >>= s_TilesetLayerInfo[n][4];
                        }
                    } else if (false) {
                        n27 = GLLibPlayer.Tileset_GetLayerData(n, 0, n26, true);
                        bl4 = n27 == 65535;
                    } else {
                        n27 = GLLibPlayer.Tileset_GetLayerData(n, 0, n26);
                        boolean bl6 = bl4 = n27 == 255;
                    }
                    if (!bl4) {
                        int n28 = GLLibPlayer.Tileset_GetLayerBlock(n, 1, n26) == null ? 0 : GLLibPlayer.Tileset_GetLayerData(n, 1, n26);
                        if (false) {
                            GLLib.ClipRect(graphics, n21, n22, n19, n20);
                        }
                        if (s_TilesetSprite[n].GetFrameCount() == 0) {
                            s_TilesetSprite[n].PaintModule(graphics, n27, n21, n22, n28);
                        } else {
                            n9 = n21;
                            n8 = n22;
                            if (true) {
                                if ((n28 & 1) != 0) {
                                    n9 += n19;
                                }
                                if ((n28 & 2) != 0) {
                                    n8 += n20;
                                }
                            }
                            int n29 = n28;
                            int n30 = n8;
                            int n31 = n9;
                            int n32 = n27;
                            Graphics graphics2 = graphics;
                            ASprite aSprite = s_TilesetSprite[n];
                            aSprite.PaintFrame(graphics2, n32, n31, n30, n29, 0, 0);
                        }
                        if (false && n == s_TilesetEffectLayer && s_TilesetAlphaLayer > 0) {
                            boolean bl7;
                            int n33;
                            if (false) {
                                n33 = GLLibPlayer.Tileset_GetLayerData(s_TilesetAlphaLayer, 0, n26, true);
                                bl7 = n33 == 65535;
                            } else {
                                n33 = GLLibPlayer.Tileset_GetLayerData(s_TilesetAlphaLayer, 0, n26);
                                boolean bl8 = bl7 = n33 == 255;
                            }
                            if (!bl7) {
                                n9 = 0;
                                if (GLLibPlayer.Tileset_GetLayerBlock(s_TilesetAlphaLayer, 1, n26) != null) {
                                    n9 = GLLibPlayer.Tileset_GetLayerData(s_TilesetAlphaLayer, 1, n26);
                                }
                                if (s_TilesetSprite[s_TilesetAlphaLayer].GetFrameCount() != 0) {
                                    n33 = s_TilesetSprite[s_TilesetAlphaLayer].GetFrameModule(n33, 0);
                                }
                                if (s_TilesetEffectType == 2 || s_TilesetEffectType == 3) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].RenderTilesetEffect(graphics, n33, s_TilesetLayerImage[n][0], s_TilesetEffectType, n21, n22, n19, n20, n9);
                                } else if (s_TilesetEffectType == 1) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].PaintModule(graphics, n33, n21, n22, n9);
                                }
                            }
                        }
                        if (false) {
                            GLLib.SetClip(graphics, n13, n14, n15, n16);
                        }
                    }
                }
                n21 += n19;
                if (++n25 >= n17) {
                    if (!bl2) break;
                    n25 = 0;
                }
                if (!bl || n21 < s_TilesetLayerInfo[n][7]) continue;
                n21 = 0;
            }
            n22 += n20;
            if (++n3 >= n18) {
                if (!bl3) break;
                n3 = 0;
            }
            if (!bl || n22 < s_TilesetLayerInfo[n][8]) continue;
            n22 = 0;
        }
        if (false && GLLibPlayer.isFlag(n, 64)) {
            int n34;
            if (n21 > n12) {
                n10 = n21;
                n9 = 0;
            } else {
                n10 = s_TilesetLayerInfo[n][7];
                n9 = n21;
            }
            if (n22 > n11) {
                n8 = n22;
                n34 = 0;
            } else {
                n8 = s_TilesetLayerInfo[n][8];
                n34 = n22;
            }
            for (int i = 0; i < 4; ++i) {
                if ((i == 1 || i == 3) && n9 == 0 || (i == 2 || i == 3) && n34 == 0) continue;
                int[] nArray = s_TilesetLayerLastUpdatedArea[n][s_TilesetLayerLastUpdatedAreaIndex];
                nArray[0] = i == 0 || i == 2 ? n12 : 0;
                nArray[1] = i == 0 || i == 1 ? n11 : 0;
                nArray[2] = i == 0 || i == 2 ? n10 - n12 : n9;
                nArray[3] = i == 0 || i == 1 ? n8 - n11 : n34;
                ++s_TilesetLayerLastUpdatedAreaIndex;
            }
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][6] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final void Tileset_SetCamera(int n, int n2, int n3) {
        GLLibPlayer.s_TilesetLayerInfo[n][13] = n2;
        GLLibPlayer.s_TilesetLayerInfo[n][14] = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (GLLibPlayer.isFlag(n, 16)) {
            if (s_TilesetLayerInfo[n][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
            } else if (s_TilesetLayerInfo[n][13] + s_TilesetInfo[0] >= s_TilesetLayerInfo[n][5]) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = s_TilesetLayerInfo[n][5] - s_TilesetInfo[0] - 1;
            }
        }
        if (GLLibPlayer.isFlag(n, 32)) {
            if (s_TilesetLayerInfo[n][14] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][14] = 0;
            } else if (s_TilesetLayerInfo[n][14] + s_TilesetInfo[1] >= s_TilesetLayerInfo[n][6]) {
                GLLibPlayer.s_TilesetLayerInfo[n][14] = s_TilesetLayerInfo[n][6] - s_TilesetInfo[1] - 1;
            }
        }
    }

    static final int Tileset_GetCameraY(int n) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][6] - s_TilesetInfo[1] - s_TilesetLayerInfo[n][14];
        }
        return s_TilesetLayerInfo[n][14];
    }

    static final int Tileset_GetTile(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (false) {
            int n4 = GLLibPlayer.Tileset_GetLayerData(n, 0, n2, n3, true);
            if (false && s_TilesetMultiSprites[n] != null) {
                n4 >>= s_TilesetLayerInfo[n][4];
            }
            return n4;
        }
        int n5 = GLLibPlayer.Tileset_GetLayerData(n, 0, n2, n3);
        if (false && s_TilesetMultiSprites[n] != null) {
            n5 >>= s_TilesetLayerInfo[n][4];
        }
        return n5;
    }

    private static final byte[] Tileset_GetLayerBlock(int n, int n2, int n3) {
        int n4 = s_TilesetLayerInfo[n][2];
        return GLLibPlayer.Tileset_GetLayerBlock(n, n2, n3 % n4, n3 / n4);
    }

    private static byte[] Tileset_GetLayerBlock(int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n3;
            int n6 = n4;
            int n7 = n5 / s_TilesetMultiBlockHeadInfo[2];
            int n8 = n6 / s_TilesetMultiBlockHeadInfo[3];
            int n9 = n7 + n8 * s_TilesetMultiBlockHeadInfo[0];
            return s_TilesetMultiBlockLayerData[n][n9][n2];
        }
        return s_TilesetLayerData[n][n2];
    }

    private static final int Tileset_GetLayerData(int n, int n2, int n3) {
        return GLLibPlayer.Tileset_GetLayerData(n, n2, n3, false);
    }

    private static int Tileset_GetLayerData(int n, int n2, int n3, boolean bl) {
        if (false) {
            int n4 = s_TilesetLayerInfo[n][2];
            return GLLibPlayer.Tileset_GetLayerData(n, n2, n3 % n4, n3 / n4, bl);
        }
        if (bl) {
            return GLLib.Mem_GetShort(s_TilesetLayerData[n][n2], n3 << 1) & 0xFFFF;
        }
        return s_TilesetLayerData[n][n2][n3] & 0xFF;
    }

    private static final int Tileset_GetLayerData(int n, int n2, int n3, int n4) {
        return GLLibPlayer.Tileset_GetLayerData(n, n2, n3, n4, false);
    }

    private static int Tileset_GetLayerData(int n, int n2, int n3, int n4, boolean bl) {
        if (false) {
            int n5 = n3;
            int n6 = n4;
            int n7 = n5 / s_TilesetMultiBlockHeadInfo[2];
            int n8 = n6 / s_TilesetMultiBlockHeadInfo[3];
            int n9 = n5 % s_TilesetMultiBlockHeadInfo[2];
            int n10 = n6 % s_TilesetMultiBlockHeadInfo[3];
            int n11 = n7 + n8 * s_TilesetMultiBlockHeadInfo[0];
            int n12 = n9 + n10 * s_TilesetMultiBlockBlockInfo[n11 << 1];
            if (bl) {
                return GLLib.Mem_GetShort(s_TilesetMultiBlockLayerData[n][n11][n2], n12 << 1) & 0xFFFF;
            }
            return s_TilesetMultiBlockLayerData[n][n11][n2][n12] & 0xFF;
        }
        int n13 = s_TilesetLayerInfo[n][2];
        return GLLibPlayer.Tileset_GetLayerData(n, n2, n4 * n13 + n3, bl);
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = 4;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

