/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Ball {
    int _x;
    int _y;
    int _dx;
    int _dy;
    int _size;
    int _size_div2;
    int _speed;
    SpriteInstance _instance;
    boolean _inboss = false;
    boolean _lost;
    int _break;
    int counterFrames = 0;
    boolean _bFakeBall;
    int prev_x;
    int prev_y;

    Ball(int n, int n2, int n3, int n4) {
        this._x = n;
        this.prev_x = n;
        this._y = n2;
        this.prev_y = n2;
        this._dx = n3;
        this._dy = n4;
        this._size = 2304;
        this._size_div2 = this._size / 2;
        if (!cGame._bPong && !Level._bIsRandom) {
            if (cGame.firstBall) {
                this._speed = 960 + 5 * cGame._current_level;
                cGame.firstBall = false;
            } else {
                this._speed = cGame.returnSpeed();
            }
        } else {
            this._speed = 1536;
        }
        this._bFakeBall = false;
        if (this._dx != 0 || this._dy != 0) {
            this.computeSpeed();
        }
        this._instance = new SpriteInstance(cGame._ball_sprite);
    }

    Ball(Ball ball, int n) {
        this._x = ball._x;
        this._y = ball._y;
        this.prev_x = this._x;
        this.prev_y = this._y;
        this._dx = ball._dx;
        this._dy = ball._dy;
        this._size = ball._size;
        this._size_div2 = ball._size_div2;
        this._speed = ball._speed;
        this._instance = new SpriteInstance(cGame._ball_sprite);
    }

    boolean collideRacket(int n, int n2, boolean bl) {
        if (this._dy < 0 && bl) {
            return false;
        }
        if (this._dy > 0 && !bl) {
            return false;
        }
        this._dx = n * 5 / 4;
        this._dy = -this._dy;
        if (cGame._ballMustAccelerateCounter == 0) {
            cGame._ballMustAccelerateCounter = 1;
        }
        this._speed += 12 + cGame._current_level / 2;
        this.computeSpeed();
        return true;
    }

    void collide(int n, int n2, int n3) {
        if (this._size == 3073) {
            return;
        }
        byte by = this.getDirection();
        this._x -= 2816;
        this._y -= 5632;
        this._break = 0;
        this.counterFrames = 6;
        if (cGame._ballMustAccelerateCounter == 0) {
            cGame._ballMustAccelerateCounter = 1;
        }
        this._speed += 16 + cGame._current_level / 2;
        block0 : switch (n) {
            case 12: {
                switch (by) {
                    case 1: 
                    case 2: {
                        this._dx = -this._dx;
                        break;
                    }
                    case 4: 
                    case 8: {
                        this._dy = -this._dy;
                    }
                }
                break;
            }
            case 3: {
                switch (by) {
                    case 4: 
                    case 8: {
                        this._dx = -this._dx;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this._dy = -this._dy;
                    }
                }
                break;
            }
            case 10: {
                switch (by) {
                    case 1: 
                    case 4: {
                        this._dy = -this._dy;
                        break;
                    }
                    case 2: 
                    case 8: {
                        this._dx = -this._dx;
                    }
                }
                break;
            }
            case 5: {
                switch (by) {
                    case 2: 
                    case 8: {
                        this._dy = -this._dy;
                        break;
                    }
                    case 1: 
                    case 4: {
                        this._dx = -this._dx;
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                this._dx = -this._dx;
                this._dy = -this._dy;
                break;
            }
            case 1: {
                switch (by) {
                    case 1: {
                        int n4 = this.left() % n2;
                        int n5 = this.top() % n3;
                        if (n4 >= n5) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 2: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 4: {
                        this._dx = -this._dx;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (by) {
                    case 1: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 2: {
                        int n6 = this.right() % n2;
                        int n7 = this.top() % n3;
                        if (n6 >= n7) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        this._dx = -this._dx;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (by) {
                    case 1: {
                        this._dx = -this._dx;
                        break block0;
                    }
                    case 4: {
                        int n8 = this.left() % n2;
                        int n9 = this.bottom() % n3;
                        if (n8 >= n9) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        this._dy = -this._dy;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (by) {
                    case 2: {
                        this._dx = -this._dx;
                        break block0;
                    }
                    case 4: {
                        this._dy = -this._dy;
                        break block0;
                    }
                    case 8: {
                        int n10 = this.right() % n2;
                        int n11 = this.bottom() % n3;
                        if (n10 >= n11) {
                            this._dx = -this._dx;
                            break block0;
                        }
                        this._dy = -this._dy;
                        break block0;
                    }
                }
            }
        }
        this.computeSpeed();
        this._x += 2816;
        this._y += 5632;
    }

    void computeSpeed() {
        if (this._speed < 512) {
            this._speed = 512;
        }
        if (this._dy == 0) {
            this._dy = 960;
        }
        if (Math.abs((this._dx << 8) / this._dy) > 1024) {
            this._dx = cGame.SGN(this._dx) * (Math.abs(this._dy) * 1024 >> 8);
        }
        int n = cGame.squareRoot(this._dx * this._dx + this._dy * this._dy);
        if (this._size == 3072 || this._size == 3073) {
            this._dx = (this._speed + 256) * this._dx / n;
            this._dy = (this._speed + 256) * this._dy / n;
        } else {
            this._dx = this._speed * this._dx / n;
            this._dy = this._speed * this._dy / n;
        }
    }

    void update() {
        if (Racket.yoyo_status > 0 || Racket._yoyo) {
            if (Racket._yoyo_call) {
                this._instance.setAnim(5);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(5);
                }
            } else {
                this._instance.setAnim(1);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(1);
                }
            }
            this.counterFrames = 0;
        } else {
            Racket._yoyo = false;
            if (this._size == 3072 || this._size == 3073) {
                if (this._size == 3072) {
                    this._instance.setAnim(2);
                    if (cGame._racket._ball != null) {
                        cGame._racket._ball._instance.setAnim(2);
                    }
                } else {
                    this._instance.setAnim(6);
                    if (cGame._racket._ball != null) {
                        cGame._racket._ball._instance.setAnim(6);
                    }
                }
                this.counterFrames = 0;
            } else if (this._bFakeBall) {
                this._instance.setAnim(7);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(7);
                }
                this.counterFrames = 0;
            } else if (this.counterFrames == 0) {
                this._instance.setAnim(0);
                if (cGame._racket._ball != null) {
                    cGame._racket._ball._instance.setAnim(0);
                }
            } else {
                if (this.counterFrames == 6) {
                    this._instance.setAnim(4);
                } else if (this.counterFrames == 3) {
                    this._instance.setAnim(3);
                }
                --this.counterFrames;
            }
        }
        if (!cGame._bPong) {
            if (this._dy == 0) {
                this._dy += 10;
                System.out.println("_dy=0");
                return;
            }
            if (this._dx == 0) {
                this._dx += 10;
                System.out.println("_dx=0");
                return;
            }
        }
        if (this._speed > 2048 || Racket.yoyo_status > 0) {
            this._speed = 2048;
        }
        this._y += cGame.SGN(this._y) * this._dy;
        this._x += cGame.SGN(this._x) * this._dx;
        if (this._x - this._size_div2 <= 2816) {
            this.counterFrames = 6;
            this._x = 2816 + this._size_div2;
            this._dx = -this._dx;
            this._speed += 12 + cGame._current_level / 2;
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        } else if (this._x + this._size_div2 >= 42752) {
            this.counterFrames = 6;
            this._x = 42752 - this._size_div2;
            this._dx = -this._dx;
            this._speed += 12 + cGame._current_level / 2;
            if (cGame._ballMustAccelerateCounter == 0) {
                cGame._ballMustAccelerateCounter = 1;
            }
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        } else if (this._y - this._size_div2 <= 5632) {
            this.counterFrames = 6;
            this._y = 5632 + this._size_div2;
            this._dy = -this._dy;
            this._speed += 12 + cGame._current_level / 2;
            if (cGame._ballMustAccelerateCounter == 0) {
                cGame._ballMustAccelerateCounter = 1;
            }
            if (!this._bFakeBall) {
                cGame._pong_counter = cGame._pong_param_time[cGame._pong_arena];
            }
            this.computeSpeed();
        }
    }

    void draw(Graphics graphics) {
        if (this._y >> 8 < 193) {
            this._instance.setPosition(this._x, this._y);
            this._instance.draw(0, 0, 0, true, false);
        }
    }

    public final byte getDirection() {
        if (this._dx > 0) {
            if (this._dy > 0) {
                return 1;
            }
            return 4;
        }
        if (this._dy > 0) {
            return 2;
        }
        return 8;
    }

    public final int left() {
        return this._x - this._size_div2;
    }

    public final int right() {
        return this._x + this._size_div2;
    }

    public final int top() {
        return this._y - this._size_div2;
    }

    public final int bottom() {
        return this._y + this._size_div2;
    }

    public boolean isColliding(Racket racket) {
        int n = Math.max(this.left(), racket.left());
        int n2 = Math.max(this.top(), racket.top());
        int n3 = Math.min(this.right(), racket.right());
        int n4 = Math.min(this.bottom(), racket.bottom());
        if (n > n3) {
            return false;
        }
        if (n2 > n4) {
            return false;
        }
        cGame.playSound(11, 1);
        return true;
    }
}

