/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Sprite3D {
    int B;
    int G;
    int H;
    int L;
    int R;
    int S;
    static boolean bSwitchColor;
    static long baseDist;
    byte[] buf;
    int[][] clipPos;
    static int[] col;
    static int currCol;
    static long[] dist;
    Image img;
    int pal_len;

    static {
        col = new int[]{120, 20, 90};
        bSwitchColor = true;
        dist = new long[]{MathFP.toFP("121.090"), MathFP.toFP("89.796"), MathFP.toFP("45.0"), MathFP.toFP("20.7"), MathFP.toFP("16.5"), MathFP.toFP("10.5"), MathFP.toFP("6.2"), MathFP.toFP("2.5"), MathFP.toFP("1.5")};
        baseDist = MathFP.toFP("5.5");
    }

    Sprite3D(String name, int[][] clipPos) {
        this.clipPos = clipPos;
        try {
            this.img = Image.createImage((String)("/" + name + "tile.png"));
        }
        catch (Exception e) {
        }
    }

    Sprite3D() {
    }

    final void HLS(int h, int l, int s) {
        int k = this.pal_len / 3;
        int i = 0;
        while (i < k) {
            this.R = this.buf[41 + i * 3];
            this.G = this.buf[42 + i * 3];
            this.B = this.buf[43 + i * 3];
            this.RGBToHLS(this.R, this.G, this.B);
            this.HLSToRGB(this.H + h, this.L + l, this.S + s);
            this.buf[41 + i * 3] = (byte)this.R;
            this.buf[42 + i * 3] = (byte)this.G;
            this.buf[43 + i * 3] = (byte)this.B;
            ++i;
        }
    }

    final void HLSToRGB(int H, int L, int S) {
        int ib;
        int ig;
        int ir;
        if (L > 255) {
            L = 255;
        }
        if (S > 255) {
            S = 255;
        }
        int il = L;
        int is = S;
        int ih = H;
        int m2 = il < 128 ? il * (255 + is) : 255 * (il + is) - il * is;
        int m1 = 2 * il * 255 - m2;
        if (S == 0) {
            ir = il;
            ig = il;
            ib = il;
        } else {
            ir = Sprite3D.XRGB(ih + 120, m1, m2);
            ig = Sprite3D.XRGB(ih, m1, m2);
            ib = Sprite3D.XRGB(ih - 120, m1, m2);
        }
        this.R = ir / 255;
        this.G = ig / 255;
        this.B = ib / 255;
    }

    final void RGBToHLS(int R, int G, int B) {
        int m2;
        int m1;
        if (R < 0) {
            R += 256;
        }
        if (G < 0) {
            G += 256;
        }
        if (B < 0) {
            B += 256;
        }
        if (G > (m1 = R)) {
            m1 = G;
        }
        if (B > m1) {
            m1 = B;
        }
        if (G < (m2 = R)) {
            m2 = G;
        }
        if (B < m2) {
            m2 = B;
        }
        int ih = 0;
        int il = 0;
        int is = 0;
        il = (m1 + m2) / 2;
        if (m1 == m2) {
            is = 0;
            ih = 0;
        } else {
            is = il <= 128 ? 255 * (m1 - m2) / (m1 + m2) : 255 * (m1 - m2) / (510 - m1 - m2);
            int cr = 1000 * (m1 - R) / (m1 - m2);
            int cg = 1000 * (m1 - G) / (m1 - m2);
            int cb = 1000 * (m1 - B) / (m1 - m2);
            if (R == m1) {
                ih = cb - cg;
            }
            if (G == m1) {
                ih = 2000 + cr - cb;
            }
            if (B == m1) {
                ih = 4000 + cg - cr;
            }
        }
        this.H = ih * 60 / 1000;
        if (this.H < 0) {
            this.H += 360;
        }
        this.L = il;
        this.S = is;
    }

    static final int XRGB(int hh, int mm1, int mm2) {
        int xrgb = 0;
        if (hh < 0) {
            hh += 360;
        }
        if (hh > 360) {
            hh -= 360;
        }
        xrgb = hh < 60 ? mm1 + (mm2 - mm1) * hh / 60 : (hh < 180 ? mm2 : (hh < 240 ? mm1 + (mm2 - mm1) * (240 - hh) / 60 : mm1));
        return xrgb;
    }

    void drawBottom(Graphics g, int x, int y, long dist) {
        int ii = Sprite3D.getIndex(dist);
        g.setClip(x - (this.clipPos[ii][2] >> 1), y - this.clipPos[ii][3], this.clipPos[ii][2], this.clipPos[ii][3]);
        g.clipRect(x - (this.clipPos[ii][2] >> 1), y - this.clipPos[ii][3], this.clipPos[ii][2], this.clipPos[ii][3]);
        if (this.img != null) {
            g.drawImage(this.img, x - this.clipPos[ii][0] - (this.clipPos[ii][2] >> 1), y - this.clipPos[ii][1] - this.clipPos[ii][3], 0x10 | 4);
        }
        g.setClip(0, 0, 240, 320);
        g.clipRect(0, 0, 240, 320);
    }

    void drawCenter(Graphics g, int x, int y, long dist) {
        int ii = Sprite3D.getIndex(dist);
        g.setClip(x - (this.clipPos[ii][2] >> 1), y - (this.clipPos[ii][3] >> 1), this.clipPos[ii][2], this.clipPos[ii][3]);
        g.clipRect(x - (this.clipPos[ii][2] >> 1), y - (this.clipPos[ii][3] >> 1), this.clipPos[ii][2], this.clipPos[ii][3]);
        if (this.img != null) {
            g.drawImage(this.img, x - this.clipPos[ii][0] - (this.clipPos[ii][2] >> 1), y - this.clipPos[ii][1] - (this.clipPos[ii][3] >> 1), 0x10 | 4);
        }
        g.setClip(0, 0, 240, 320);
        g.clipRect(0, 0, 240, 320);
    }

    void drawFall(Graphics g, int x, int y) {
        if (this.img != null) {
            g.drawImage(this.img, x, y, 0x10 | 4);
        }
    }

    static int getIndex(long distance) {
        distance -= baseDist;
        int i = 0;
        while (i < dist.length) {
            if (distance > dist[i]) {
                return dist.length - i;
            }
            ++i;
        }
        return 0;
    }
}

