/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SaveGame {
    static String gameData;
    static boolean gameHaveBeenInit;
    static RecordStore myGame;

    static {
        gameHaveBeenInit = false;
    }

    private SaveGame() {
    }

    static void close() {
        if (myGame != null) {
            try {
                myGame.closeRecordStore();
            }
            catch (RecordStoreException frse) {
                // empty catch block
            }
            myGame = null;
        }
    }

    static String getGameData() {
        if (!gameHaveBeenInit) {
            SaveGame.open();
            SaveGame.close();
        }
        return gameData;
    }

    private static void initialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                throw new RecordStoreException();
            }
            myGame.addRecord(b, 0, b.length);
        }
        catch (RecordStoreException rse) {
            SaveGame.close();
            System.out.println((Object)rse);
        }
    }

    static void open() {
        try {
            myGame = RecordStore.openRecordStore((String)"SavedGame", (boolean)true);
            if (gameHaveBeenInit) {
                return;
            }
            if (myGame.getNumRecords() == 0) {
                SaveGame.initialize();
            } else {
                byte[] data = myGame.getRecord(1);
                if (data != null) {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        gameData = dis.readUTF();
                        dis.close();
                        if (gameData.equals("")) {
                            gameData = "";
                            SaveGame.saveGame(gameData);
                        }
                    }
                    catch (IOException ioe) {
                    }
                }
            }
            gameHaveBeenInit = true;
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
        }
    }

    static void saveGame(String gamedata) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeUTF(gamedata);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            if (myGame == null) {
                SaveGame.open();
                myGame.setRecord(1, data, 0, data.length);
                SaveGame.close();
            } else {
                myGame.setRecord(1, data, 0, data.length);
            }
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        gameData = gamedata;
    }
}

