/*
 * Decompiled with CFR 0.152.
 */
public abstract class MathFP {
    public static long E;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;
    public static long PI;
    private static int _digits;
    private static long _dmul;
    private static int _fbits;
    private static long _flt;
    private static long _fmask;
    private static long _one;
    private static long _pi;
    private static long[] e;

    static {
        _fbits = 24;
        _digits = 8;
        _fmask = 0xFFFFFFL;
        _dmul = 100000000L;
        _flt = 0L;
        _one = 0x1000000L;
        _pi = 52707178L;
        e = new long[]{_one, 45605201L, 123967790L, 336979391L, 916004956L};
        PI = _pi;
        E = e[1];
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static long acos(long l) {
        return PI / 2L - MathFP.asin(l);
    }

    public static long add(long l, long l1) {
        return l + l1;
    }

    public static long asin(long l) {
        if (MathFP.abs(l) > _one) {
            throw new ArithmeticException("Bad Input");
        }
        boolean flag = l < 0L;
        l = MathFP.abs(l);
        long l1 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(145103 >> (int)_flt, l) - (long)(599880 >> (int)_flt), l) + (long)(1420468 >> (int)_flt), l) - (long)(3592413 >> (int)_flt), l) + (long)(26353447 >> (int)_flt);
        long l2 = PI / 2L - MathFP.mul(MathFP.sqrt(_one - l), l1);
        return flag ? -l2 : l2;
    }

    public static long atan(long l) {
        return MathFP.asin(MathFP.div(l, MathFP.sqrt(_one + MathFP.mul(l, l))));
    }

    public static long atan2(long l, long l1) {
        long l2 = 0L;
        if (l1 > 0L) {
            l2 = MathFP.atan(MathFP.div(l, l1));
        } else if (l1 < 0L) {
            l2 = (l1 >= 0L ? PI : -PI) - MathFP.atan(MathFP.abs(MathFP.div(l, l1)));
        } else {
            if (l1 == 0L && l == 0L) {
                throw new ArithmeticException("Bad Input");
            }
            l2 = (l >= 0L ? PI : -PI) / 2L;
        }
        return l2;
    }

    public static long convert(long l, int i) {
        long l1;
        long l2 = l1 = l >= 0L ? 1L : -1L;
        if (MathFP.abs(i) < 25L) {
            l = _fbits < i ? l + l1 * (1L << (i - _fbits >> 1)) >> i - _fbits : (l <<= _fbits - i);
        }
        return l;
    }

    public static long cos(long l) {
        return MathFP.sin(PI / 2L - l);
    }

    public static long cot(long l) {
        return MathFP.div(MathFP.cos(l), MathFP.sin(l));
    }

    public static long div(long l, long l1) {
        boolean flag = false;
        int i = _fbits;
        if (l1 == _one) {
            return l;
        }
        if ((l1 & _fmask) == 0L) {
            return l / (l1 >> i);
        }
        if (l < 0L && l1 > 0L || l > 0L && l1 < 0L) {
            flag = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l1 < 0L) {
            l1 = -l1;
        }
        while (MathFP.max(l, l1) >= 1L << 63 - i) {
            l >>= 1;
            l1 >>= 1;
            --i;
        }
        long l2 = (l << i) / l1 << _fbits - i;
        return flag ? -l2 : l2;
    }

    public static long exp(long l) {
        if (l == 0L) {
            return _one;
        }
        boolean flag = l < 0L;
        l = MathFP.abs(l);
        int i = (int)(l >> _fbits);
        long l1 = _one;
        int j = 0;
        while (j < i / 4) {
            l1 = MathFP.mul(l1, e[4] >> (int)_flt);
            ++j;
        }
        if (i % 4 > 0) {
            l1 = MathFP.mul(l1, e[i % 4] >> (int)_flt);
        }
        if ((l &= _fmask) > 0L) {
            long l2 = _one;
            long l3 = 0L;
            long l4 = 1L;
            int k = 0;
            while (k < 16) {
                l3 += l2 / l4;
                if ((l4 *= (long)(k + 1)) > (l2 = MathFP.mul(l2, l)) || l2 <= 0L || l4 <= 0L) break;
                ++k;
            }
            l1 = MathFP.mul(l1, l3);
        }
        if (flag) {
            l1 = MathFP.div(_one, l1);
        }
        return l1;
    }

    public static int getPrecision() {
        return _fbits;
    }

    public static long log(long l) {
        if (l <= 0L) {
            throw new ArithmeticException("Bad Input");
        }
        long l1 = 0L;
        long l2 = 0L;
        int i = 0;
        while (l >= _one << 1) {
            l >>= 1;
            ++i;
        }
        long l4 = (long)i * (long)(11629080 >> (int)_flt);
        long l5 = 0L;
        if (l < _one) {
            return -MathFP.log(MathFP.div(_one, l));
        }
        l -= _one;
        int j = 1;
        while (j < 20) {
            long l3 = l1 == 0L ? l : MathFP.mul(l1, l);
            if (l3 == 0L) break;
            l5 += (j % 2 != 0 ? 1L : -1L) * l3 / (long)j;
            l1 = l3;
            ++j;
        }
        return l4 + l5;
    }

    public static long max(long l, long l1) {
        return l >= l1 ? l : l1;
    }

    public static long min(long l, long l1) {
        return l1 >= l ? l : l1;
    }

    public static long mul(long l, long l1) {
        boolean flag = false;
        int i = _fbits;
        long l2 = _fmask;
        if ((l & l2) == 0L) {
            return (l >> i) * l1;
        }
        if ((l1 & l2) == 0L) {
            return l * (l1 >> i);
        }
        if (l < 0L && l1 > 0L || l > 0L && l1 < 0L) {
            flag = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l1 < 0L) {
            l1 = -l1;
        }
        while (MathFP.max(l, l1) >= 1L << 63 - i) {
            l >>= 1;
            l1 >>= 1;
            l2 >>= 1;
            --i;
        }
        long l3 = (l >> i) * (l1 >> i) << i;
        long l4 = (l & l2) * (l1 & l2) >> i;
        if ((l3 = l3 + (l4 += (l & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) * (l1 & l2) >> i) + ((l & l2) * (l1 & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) >> i) << _fbits - i) < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return flag ? -l3 : l3;
    }

    public static long pow(long l, long l1) {
        boolean flag = l1 < 0L;
        long l2 = _one;
        l1 = MathFP.abs(l1);
        int i = (int)l1 >> _fbits;
        while (i-- > 0) {
            l2 = MathFP.mul(l2, l);
        }
        if (l2 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        l2 = l != 0L ? MathFP.mul(l2, MathFP.exp(MathFP.mul(MathFP.log(l), l1 & _fmask))) : 0L;
        if (flag) {
            return MathFP.div(_one, l2);
        }
        return l2;
    }

    public static long round(long l, int i) {
        long l1 = 10L;
        int j = 0;
        while (j < i) {
            l1 *= 10L;
            ++j;
        }
        l1 = MathFP.div(MathFP.toFP(5L), MathFP.toFP(l1));
        if (l < 0L) {
            l1 = -l1;
        }
        return l + l1;
    }

    public static int setPrecision(int i) {
        if (i > 24 || i < 0) {
            return _digits;
        }
        _fbits = i;
        _one = 1L << i;
        _flt = 24 - i;
        _digits = 0;
        _dmul = 1L;
        _fmask = _one - 1L;
        PI = _pi >> (int)_flt;
        E = e[1] >> (int)_flt;
        long l = _one;
        while (l != 0L) {
            l /= 10L;
            ++_digits;
            _dmul *= 10L;
        }
        return _digits;
    }

    public static long sin(long l) {
        long l1 = MathFP.mul(l, MathFP.div(MathFP.toFP(180L), PI));
        if ((l1 %= MathFP.toFP(360L)) < 0L) {
            l1 = MathFP.toFP(360L) + l1;
        }
        long l2 = l1;
        if (l1 >= MathFP.toFP(90L) && l1 < MathFP.toFP(270L)) {
            l2 = MathFP.toFP(180L) - l1;
        } else if (l1 >= MathFP.toFP(270L) && l1 < MathFP.toFP(360L)) {
            l2 = -(MathFP.toFP(360L) - l1);
        }
        long l3 = l2 / 90L;
        long l4 = MathFP.mul(l3, l3);
        long l5 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-73190L >> (int)_flt, l4) + (1333581L >> (int)_flt), l4) - (10836755L >> (int)_flt), l4) + (long)(26353564 >> (int)_flt), l3);
        return l5;
    }

    public static long sqrt(long l) {
        return MathFP.sqrt(l, 24);
    }

    public static long sqrt(long l, int i) {
        if (l < 0L) {
            throw new ArithmeticException("Bad Input");
        }
        if (l == 0L) {
            return 0L;
        }
        long l1 = l + _one >> 1;
        int j = 0;
        while (j < i) {
            l1 = l1 + MathFP.div(l, l1) >> 1;
            ++j;
        }
        if (l1 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return l1;
    }

    public static long sub(long l, long l1) {
        return l - l1;
    }

    public static long tan(long l) {
        return MathFP.div(MathFP.sin(l), MathFP.cos(l));
    }

    public static long toFP(String s) {
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        String s1 = "-1";
        int j = s.indexOf(46);
        if (j >= 0) {
            s1 = s.substring(j + 1, s.length());
            while (s1.length() < _digits) {
                s1 = s1 + "0";
            }
            if (s1.length() > _digits) {
                s1 = s1.substring(0, _digits);
            }
        } else {
            j = s.length();
        }
        long l = 0L;
        if (i != j) {
            l = Long.parseLong(s.substring(i, j));
        }
        long l1 = Long.parseLong(s1) + 1L;
        long l2 = (l << _fbits) + (l1 << _fbits) / _dmul;
        if (i == 1) {
            l2 = -l2;
        }
        return l2;
    }

    public static long toFP(long l) {
        return l << _fbits;
    }

    public static long toLong(long l) {
        if (l < 0L) {
            return -(MathFP.round(-l, 0) >> _fbits);
        }
        return MathFP.round(l, 0) >> _fbits;
    }

    public static String toString(long l, int i) {
        if (i > _digits) {
            i = _digits;
        }
        String s = MathFP.toString(MathFP.round(l, i));
        return s.substring(0, s.length() - _digits + i);
    }

    public static String toString(long l) {
        boolean flag = false;
        if (l < 0L) {
            flag = true;
            l = -l;
        }
        long l1 = l >> _fbits;
        long l2 = _dmul * (l & _fmask) >> _fbits;
        String s = Long.toString(l2);
        while (s.length() < _digits) {
            s = "0" + s;
        }
        return (flag ? "-" : "") + Long.toString(l1) + "." + s;
    }
}

