/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameSettings {
    static RecordStore mySettings;
    static String settings;
    static boolean settingsHaveBeenInit;

    static {
        settingsHaveBeenInit = false;
    }

    private GameSettings() {
    }

    static void closeSettings() {
        if (mySettings != null) {
            try {
                mySettings.closeRecordStore();
            }
            catch (RecordStoreException frse) {
                // empty catch block
            }
            mySettings = null;
        }
    }

    static String getSettings() {
        if (!settingsHaveBeenInit) {
            GameSettings.openSettings();
            GameSettings.closeSettings();
        }
        return settings;
    }

    private static void initializeSettings() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                settings = "Easy*On:On";
                dos.writeUTF(settings);
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                throw new RecordStoreException();
            }
            mySettings.addRecord(b, 0, b.length);
        }
        catch (RecordStoreException rse) {
            GameSettings.closeSettings();
            System.out.println((Object)rse);
        }
    }

    static void openSettings() {
        try {
            mySettings = RecordStore.openRecordStore((String)"GameSettings", (boolean)true);
            if (settingsHaveBeenInit) {
                return;
            }
            if (mySettings.getNumRecords() == 0) {
                GameSettings.initializeSettings();
            } else {
                byte[] data = mySettings.getRecord(1);
                if (data != null) {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        DataInputStream dis = new DataInputStream(bais);
                        settings = dis.readUTF();
                        dis.close();
                        if (settings.equals("")) {
                            settings = "Easy*On:On";
                            GameSettings.saveSettings(settings);
                        }
                    }
                    catch (IOException ioe) {
                    }
                }
            }
            settingsHaveBeenInit = true;
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
        }
    }

    static void saveSettings(String gameSettings) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeUTF(gameSettings);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            if (mySettings == null) {
                GameSettings.openSettings();
                mySettings.setRecord(1, data, 0, data.length);
                GameSettings.closeSettings();
            } else {
                mySettings.setRecord(1, data, 0, data.length);
            }
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        settings = gameSettings;
    }
}

