/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

class RoomObject {
    public static final int TYPE_GFX = 1;
    public static final int TYPE_ZONE = 2;
    public static final int TYPE_ZONE_BATTLE = 3;
    public static final int TYPE_ZONE_COLOR = 4;
    public static final int TYPE_ZONE_TEXT = 5;
    public static final int TYPE_ZONE_TILES = 6;
    public static final int GFX_ID_TYPE_STRING = 1;
    public static final int GFX_ID_TYPE_INTEGER = 2;
    public static final int ANIMATION_IDLE = 0;
    public static final int ANIMATION_ENEMYATTACK1 = 1;
    public static final int ANIMATION_ENEMYATTACK2 = 2;
    public static final int ANIMATION_ENEMYATTACK3 = 3;
    public static final int ANIMATION_HEROATTACK1 = 4;
    public static final int ANIMATION_HEROATTACK2 = 5;
    public static final int ANIMATION_SINGLE = 6;
    public static final int ANIMATION_COUNT = 7;
    public static final int ANIMATION_VALUES_PER_PART = 4;
    public static final int ANIMATION_OFFSET_GFX = 0;
    public static final int ANIMATION_OFFSET_DURATION = 1;
    public static final int ANIMATION_OFFSET_OFFSET_X = 2;
    public static final int ANIMATION_OFFSET_OFFSET_Y = 3;
    public int type;
    public int x;
    public int y;
    public int width;
    public int height;
    public int regPointX;
    public int regPointY;
    public int left;
    public int right;
    public int top;
    public int bottom;
    private int transform;
    private Object gfxID;
    private String scriptID;
    public Script script;
    public boolean visible;
    public boolean active;
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private int color = 0xFFFFFF;
    private String text = null;
    private int textAlignment;
    private Object[][] animationData;
    private int[] animationParts;
    private int[] animationDuration;
    private int[][] animationImagePoints;
    public long animationTime;
    public static long paintingAnimationTime = -1L;
    public static boolean noVibraYet = true;
    public long idleAnimationTime;
    public int runAnimLoops;
    private int runAnimPausedTime = -1;
    public int battlePanelID;
    public static int BATTLE_PANEL_ID_HERO_HEALTH = 1;
    public static int BATTLE_PANEL_ID_ENEMY_HEALTH = 2;
    public static int BATTLE_PANEL_ID_TIMEBAR = 3;
    public static int BATTLE_PANEL_ID_HARD_ATTACK = 4;
    public static int BATTLE_PANEL_ID_FAST_ATTACK = 5;
    public static int BATTLE_PANEL_ID_INVENTORY = 6;
    public static int BATTLE_PANEL_ID_ESCAPE = 7;
    public int[] battlePanel;
    private static int BATTLE_PANEL_MAX_HEALTH = 0;
    private static int BATTLE_PANEL_HEALTH = 1;
    private static int BATTLE_PANEL_BAR_SIZE = 2;
    private static int BATTLE_PANEL_TIME = 3;
    private static int BATTLE_PANEL_SIZE = 4;
    private static final int ZONE_TEXT_DEFAULT_WIDTH = 30;

    RoomObject(DataInputStream dataInputStream, String[] stringArray) {
        try {
            int n;
            this.idleAnimationTime = 0L;
            this.visible = true;
            this.active = false;
            this.type = dataInputStream.readUnsignedByte();
            switch (this.type) {
                case 1: {
                    this.x = dataInputStream.readShort();
                    this.y = dataInputStream.readShort();
                    this.transform = dataInputStream.readUnsignedByte();
                    n = dataInputStream.readUnsignedByte();
                    switch (n) {
                        case 1: {
                            this.gfxID = stringArray[dataInputStream.readUnsignedByte() - 1];
                            break;
                        }
                        case 2: {
                            this.gfxID = new Integer(dataInputStream.readUnsignedShort());
                        }
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.x = dataInputStream.readShort();
                    this.y = dataInputStream.readShort();
                    this.width = dataInputStream.readUnsignedByte();
                    this.height = dataInputStream.readUnsignedByte();
                }
            }
            n = dataInputStream.readUnsignedByte();
            if (n != 0) {
                this.scriptID = stringArray[n - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void battlePanelNew(int n) {
        this.battlePanelID = n;
        this.battlePanel = new int[BATTLE_PANEL_SIZE];
    }

    public void bpSetMaxHealth(int n) {
        this.battlePanel[RoomObject.BATTLE_PANEL_MAX_HEALTH] = n;
    }

    public void bpSetHealth(int n) {
        this.battlePanel[RoomObject.BATTLE_PANEL_HEALTH] = n;
    }

    public void bpSetBarSize(int n) {
        this.battlePanel[RoomObject.BATTLE_PANEL_BAR_SIZE] = n;
    }

    public void bpSetTime(int n) {
        this.battlePanel[RoomObject.BATTLE_PANEL_TIME] = n;
    }

    public Object executeEvent(int n, Object object, boolean bl) {
        if (this.script == null) {
            if (this.scriptID == null) {
                return object;
            }
            this.script = (Script)Script.list.get(this.scriptID);
            if (this.script == null) {
                // empty if block
            }
        }
        return this.script.executeEvent(n, object, this, bl);
    }

    public boolean update() {
        Object object;
        Object object2;
        Object object3;
        int n;
        boolean bl;
        if (this.scriptID == null) {
            this.getBounds();
            return false;
        }
        String string = M.loadRequest_getResourcePath(1, this.scriptID);
        M.resourceGet(string);
        this.active = M.toBoolean(this.executeEvent(6, new Integer(1), false));
        boolean bl2 = M.toBoolean(this.executeEvent(5, new Integer(1), false));
        boolean bl3 = bl = (this.type == 1 || this.type == 4 || this.type == 5 || this.type == 6) && this.visible != bl2;
        if (this.type == 3) {
            if (ExtBase.battleMode && this.gfxID == null) {
                n = M.toInt(this.executeEvent(40, new Integer(-1), false));
                if (n >= BATTLE_PANEL_ID_HARD_ATTACK && n <= BATTLE_PANEL_ID_ESCAPE) {
                    this.x = 0;
                    this.y = M.canvasHeight > 160 ? M.canvasCenterY + (this.y - (M.roomHeight >> 1)) : M.canvasCenterY + (this.y - this.height - this.height - (M.roomHeight >> 1));
                }
                if ((object3 = this.executeEvent(3, null, false)) != null) {
                    if (this.gfxID == null) {
                        this.gfxID = object3;
                    } else if (!this.gfxID.equals(object3)) {
                        this.right = 0;
                        this.getBounds();
                    }
                }
            } else if (!ExtBase.battleMode) {
                if (this.gfxID != null) {
                    bl = true;
                }
                bl2 = false;
            }
            bl2 = false;
        }
        this.visible = bl2;
        if (this.type == 1) {
            Object object4 = this.executeEvent(3, null, false);
            if (object4 != null) {
                if (this.gfxID == null) {
                    this.gfxID = object4;
                    bl = true;
                } else if (!this.gfxID.equals(object4)) {
                    this.gfxID = object4;
                    bl = true;
                    this.right = 0;
                    this.getBounds();
                }
            }
            if (!M.roomRepaintNeeded && !bl && M.toBoolean(this.executeEvent(38, new Integer(0), false))) {
                bl = true;
            }
        } else if (this.type == 4 || this.type == 5) {
            n = 0xFFFFFF;
            object3 = this.executeEvent(36, null, false);
            if (object3 != null) {
                n = M.toInt(object3);
            }
            if (this.color != n) {
                this.color = n;
                bl = true;
            }
            if (this.type == 5) {
                Object object5 = this.executeEvent(37, null, false);
                object2 = object5 == null ? null : (object5 instanceof String ? (String)object5 : (object5 instanceof Integer ? ((Integer)object5).toString() : null));
                boolean bl4 = false;
                if (this.text == null) {
                    if (object2 != null) {
                        bl4 = true;
                    }
                } else if (!this.text.equals(object2)) {
                    bl4 = true;
                }
                if (bl4) {
                    this.text = object2;
                    bl = true;
                }
                object = this.executeEvent(47, null, false);
                int n2 = 0;
                if (object != null) {
                    n2 = M.toInt(object);
                }
                if (this.textAlignment != n2) {
                    this.textAlignment = n2;
                    bl = true;
                }
            }
        }
        Object[][] objectArray = this.animationData;
        object3 = this.animationImagePoints;
        this.animationData = new Object[7][];
        this.animationParts = new int[7];
        this.animationDuration = new int[7];
        this.animationImagePoints = new int[7][];
        object2 = new int[]{18, 19, 20, 21, 22, 23, 53};
        for (int i = 0; i < 7; ++i) {
            Object[] objectArray2 = objectArray == null ? null : objectArray[i];
            object = this.executeEvent((int)object2[i], null, false);
            if (object != null) {
                int n3;
                int n4;
                this.animationData[i] = (Object[])object;
                Object[] objectArray3 = this.animationData[i];
                int n5 = this.animationParts[i] = objectArray3.length / 4;
                int n6 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    n6 += Math.abs(M.toInt(objectArray3[n4 * 4 + 1]));
                }
                this.animationDuration[i] = n6;
                if (ExtBase.regPointSystemActive) {
                    this.animationImagePoints[i] = new int[n5 << 1];
                } else {
                    this.animationImagePoints = null;
                    object3 = null;
                }
                n4 = 0;
                if (objectArray2 == null) {
                    bl = true;
                } else if (objectArray2.length != objectArray3.length) {
                    bl = true;
                } else {
                    for (n3 = 0; n3 < objectArray3.length && n4 == 0; ++n3) {
                        n4 = !objectArray3[n3].equals(objectArray2[n3]) ? 1 : 0;
                    }
                    boolean bl5 = bl = bl || n4 != 0;
                }
                if (this.animationImagePoints == null) continue;
                if (n4 == 0 || object3 == null) {
                    n3 = 0;
                    int n7 = 0;
                    while (n7 < objectArray3.length) {
                        if (!objectArray3[n7].equals("") && (n7 > 0 && !objectArray3[n7].equals(objectArray3[n7 - 4]) || n7 == 0)) {
                            Resource resource = Resource.getImage(objectArray3[n7], this.transform);
                            this.animationImagePoints[i][n3] = this.x + this.regPointX - resource.imageRegPointX;
                            this.animationImagePoints[i][n3 + 1] = this.y - this.regPointY + resource.imageRegPointY;
                        } else if (!objectArray3[n7].equals("")) {
                            this.animationImagePoints[i][n3] = this.animationImagePoints[i][n3 - 2];
                            this.animationImagePoints[i][n3 + 1] = this.animationImagePoints[i][n3 - 1];
                        } else {
                            this.animationImagePoints[i][n3] = 0;
                            this.animationImagePoints[i][n3 + 1] = 0;
                        }
                        n7 += 4;
                        n3 += 2;
                    }
                    continue;
                }
                this.animationImagePoints[i] = (int[])object3[i];
                continue;
            }
            bl = bl || objectArray2 != null;
        }
        if (this.visible) {
            this.getBounds();
        }
        if (!M.roomEntered) {
            this.executeEvent(7, null, false);
            bl = true;
            Ext.enemySoundPlayed = false;
        }
        if (ExtBase.roomObjectTick == null && this.script.hasEvent(56)) {
            ExtBase.roomObjectTick = this;
            ExtBase.tickTimerUpdateInterval = ExtBase.EVENT_TICK_UPDATE_TIME;
        }
        if (!M.setupDone) {
            if (this.scriptID.equals("setupScript")) {
                M.gameChangedSinceLastSave = false;
                ExtBase.roomPaint();
                ExtBase.drawBigScreenAddOn();
            } else {
                M.setupDone = true;
            }
        } else if (this.scriptID.equals("setupScript")) {
            if (M.roomGetCurrent().length() > 0) {
                ExtBase.roomInit(M.roomGetCurrent(), false);
            }
            M.gameChangedSinceLastSave = false;
        }
        return bl;
    }

    public void getBounds() {
        if (this.right > 0) {
            return;
        }
        if (this.type == 1) {
            Resource.getImageInfo(this, this.gfxID, this.transform);
            this.left = M.getLeft(this.x, this.width, this.height, this.regPointX, this.regPointY, this.transform);
            this.top = M.getTop(this.y, this.width, this.height, this.regPointX, this.regPointY, this.transform);
            if ((this.transform & 2) == 0) {
                this.right = this.left + this.width;
                this.bottom = this.top + this.height;
            } else {
                this.right = this.left + this.height;
                this.bottom = this.top + this.width;
            }
        } else if (this.type == 6) {
            this.left = 0;
            this.top = 0;
            this.right = 255;
            this.bottom = 255;
        } else {
            this.left = this.x;
            this.top = this.y;
            this.right = this.x + this.width;
            this.bottom = this.y + this.height;
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        block28: {
            block30: {
                int n5;
                int n6;
                block29: {
                    block27: {
                        if (this.type == 2) {
                            return;
                        }
                        if (!this.visible) {
                            return;
                        }
                        if (this.scriptID != null) {
                            for (n6 = 0; n6 < 7; ++n6) {
                                if (this.animationData[n6] == null || this.runAnimLoops <= 0 && n6 != 0) continue;
                                return;
                            }
                        }
                        if (this.right < n) {
                            return;
                        }
                        if (this.bottom < n2) {
                            return;
                        }
                        if (this.left > n + n3) {
                            return;
                        }
                        if (this.top > n2 + n4) {
                            return;
                        }
                        if (this.type != 4) break block27;
                        graphics.setColor(this.color);
                        graphics.fillRect(this.x - n, this.y - n2, this.width, this.height);
                        break block28;
                    }
                    if (this.type != 6) break block29;
                    Object object = this.executeEvent(49, null, false);
                    Object object2 = this.executeEvent(50, null, false);
                    Object object3 = this.executeEvent(48, null, false);
                    Object object4 = this.executeEvent(51, null, false);
                    Object object5 = this.executeEvent(52, null, false);
                    if (object == null || object2 == null || object3 == null || object4 == null || object5 == null) break block28;
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    Object[] objectArray3 = (Object[])object3;
                    Object[] objectArray4 = (Object[])object4;
                    Object[] objectArray5 = (Object[])object5;
                    int n7 = M.min(objectArray.length, objectArray2.length);
                    n7 = M.min(n7, objectArray3.length);
                    n7 = M.min(n7, objectArray4.length);
                    n7 = M.min(n7, objectArray5.length);
                    for (int i = 0; i < n7; ++i) {
                        if (!M.toBoolean(objectArray3[i])) continue;
                        Resource resource = Resource.getImage(objectArray[i], M.toInt(objectArray2[i]));
                        resource.paint(graphics, M.toInt(objectArray4[i]) - n, M.toInt(objectArray5[i]) - n2, M.toInt(objectArray2[i]));
                    }
                    break block28;
                }
                if (this.type != 5) break block30;
                if (this.text == null) break block28;
                n6 = this.x - n;
                if (this.textAlignment == 2) {
                    n5 = 24;
                    n6 += 30;
                } else if (this.textAlignment == 1) {
                    n5 = 17;
                    n6 += 15;
                } else {
                    n5 = 20;
                }
                graphics.setColor(this.color);
                graphics.drawString(this.text, n6, this.y - n2 + (this.height - ExtBase.ingameFontHeight >> 1), n5);
                break block28;
            }
            Resource resource = Resource.getImage(this.gfxID, this.transform);
            resource.paint(graphics, this.x - n, this.y - n2, this.transform);
            Object object = this.executeEvent(38, null, false);
            if (object != null && M.toBoolean(object)) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                Object object6;
                Object object7;
                Object object8;
                Object object9 = this.executeEvent(39, null, false);
                boolean bl = true;
                if (object9 != null) {
                    bl = M.toBoolean(object9);
                }
                if ((object8 = this.executeEvent(41, null, false)) != null) {
                    object7 = (Object[])object8;
                    object6 = object7[0];
                    int n13 = M.toInt(object7[1]);
                    n12 = M.toInt(object7[2]);
                    Resource resource2 = Resource.getImage(object6, 0);
                    if (resource2 != null && n13 > 0 && n12 >= 0) {
                        int n14 = resource2.imageWidth;
                        n11 = resource2.imageHeight;
                        n10 = this.x - n;
                        n9 = this.y - n2;
                        if (bl) {
                            n10 += (n13 - 1) * n14;
                        } else {
                            n9 += (n13 - 1) * n11;
                        }
                        for (n8 = n12; n8 > 0; --n8) {
                            graphics.drawImage(resource2.image, n10, n9, 20);
                            if (bl) {
                                n10 += n14;
                                continue;
                            }
                            n9 += n11;
                        }
                    }
                }
                if ((object7 = this.executeEvent(42, null, false)) != null) {
                    object6 = object7;
                    String string = (String)object6[0];
                    n12 = M.toInt(object6[1]);
                    int n15 = M.toInt(object6[2]);
                    Resource resource3 = Resource.getImage(string, 0);
                    if (resource3 != null && n12 > 0 && n15 >= 0) {
                        n11 = resource3.imageWidth;
                        n10 = resource3.imageHeight;
                        n9 = this.x - n;
                        n8 = this.y - n2;
                        if (bl) {
                            n9 += (n12 - 1) * n11;
                        } else {
                            n8 += (n12 - 1) * n10;
                        }
                        for (int i = n15; i > 0; --i) {
                            graphics.drawImage(resource3.image, n9, n8, 20);
                            if (bl) {
                                n9 += n11;
                                continue;
                            }
                            n8 += n10;
                        }
                    }
                }
            }
        }
    }

    public void battlePanelUpdate(Graphics graphics, int n, int n2) {
        if (this.battlePanelID != 0) {
            if (this.battlePanelID == BATTLE_PANEL_ID_HERO_HEALTH) {
                int n3 = M.min(M.canvasHeight, M.roomHeight) - (this.height >> 1);
                int n4 = M.canvasCenterX - (this.width >> 1);
                if (this.gfxID != null) {
                    int n5;
                    this.bpPaint(graphics, n4, n3);
                    int n6 = ExtBase.healthBarFillImg.getWidth();
                    for (n5 = this.battlePanel[BATTLE_PANEL_HEALTH]; n5 < this.battlePanel[BATTLE_PANEL_MAX_HEALTH]; ++n5) {
                        graphics.drawImage(ExtBase.healthBarFillImg, n4 + n5 * n6, n3, 0x10 | 4);
                    }
                    for (n5 = this.battlePanel[BATTLE_PANEL_MAX_HEALTH]; n5 < this.battlePanel[BATTLE_PANEL_BAR_SIZE]; ++n5) {
                        graphics.drawImage(ExtBase.healthOverlapImg, n4 + n5 * n6, n3, 0x10 | 4);
                    }
                } else {
                    int n7 = (this.width << 7) / this.battlePanel[BATTLE_PANEL_BAR_SIZE];
                    graphics.setColor(0);
                    graphics.fillRect(n4 - 1, n3 - 1, this.width + 2, this.height + 2);
                    graphics.setColor(0xFF0000);
                    graphics.fillRect(n4, n3, n7 * this.battlePanel[BATTLE_PANEL_HEALTH] >> 7, this.height);
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(n4 + (n7 * this.battlePanel[BATTLE_PANEL_MAX_HEALTH] >> 7), n3, n7 * (this.battlePanel[BATTLE_PANEL_BAR_SIZE] - this.battlePanel[BATTLE_PANEL_MAX_HEALTH]) >> 7, this.height);
                }
            } else if (this.battlePanelID == BATTLE_PANEL_ID_ENEMY_HEALTH) {
                int n8 = M.canvasCenterX - (this.width >> 1);
                int n9 = -(this.height >> 1);
                if (this.gfxID != null) {
                    int n10;
                    this.bpPaint(graphics, n8, n9);
                    int n11 = ExtBase.healthBarFillImg.getWidth();
                    for (n10 = this.battlePanel[BATTLE_PANEL_HEALTH]; n10 < this.battlePanel[BATTLE_PANEL_MAX_HEALTH]; ++n10) {
                        graphics.drawImage(ExtBase.healthBarFillImg, n8 + n10 * n11, n9, 0x10 | 4);
                    }
                    for (n10 = this.battlePanel[BATTLE_PANEL_MAX_HEALTH]; n10 < this.battlePanel[BATTLE_PANEL_BAR_SIZE]; ++n10) {
                        graphics.drawImage(ExtBase.healthOverlapImg, n8 + n10 * n11, n9, 0x10 | 4);
                    }
                } else {
                    int n12 = (this.width << 7) / this.battlePanel[BATTLE_PANEL_BAR_SIZE];
                    graphics.setColor(0);
                    graphics.fillRect(n8 - 1, n9 - 1, this.width + 2, this.height + 2);
                    graphics.setColor(0xFF0000);
                    graphics.fillRect(n8, n9, n12 * this.battlePanel[BATTLE_PANEL_HEALTH] >> 7, this.height);
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(n8 + (n12 * this.battlePanel[BATTLE_PANEL_MAX_HEALTH] >> 7), n9, n12 * (this.battlePanel[BATTLE_PANEL_BAR_SIZE] - this.battlePanel[BATTLE_PANEL_MAX_HEALTH]) >> 7, this.height);
                }
            } else if (this.battlePanelID == BATTLE_PANEL_ID_TIMEBAR) {
                int n13 = 0;
                n13 = M.canvasHeight > 160 ? M.canvasCenterY : M.canvasCenterY - (this.height >> 1);
                if (this.gfxID != null) {
                    this.bpPaint(graphics, M.min(M.canvasWidth, M.roomWidth) - this.width, n13);
                } else {
                    graphics.setColor(255);
                    graphics.fillRect(M.min(M.canvasWidth, M.roomWidth) - this.width - 1, n13 - 1, this.width + 2, this.height + 2);
                }
                graphics.setColor(0);
                int n14 = (this.height << 7) / this.battlePanel[BATTLE_PANEL_BAR_SIZE] * this.battlePanel[BATTLE_PANEL_TIME] >> 7;
                graphics.fillRect(M.min(M.canvasWidth, M.roomWidth) - this.width, n13, this.width, this.height - n14);
            } else if (this.battlePanelID == BATTLE_PANEL_ID_HARD_ATTACK) {
                if (this.gfxID != null) {
                    this.bpPaint(graphics, this.x, this.y);
                } else {
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                    graphics.setColor(0);
                    graphics.drawRect(this.x, this.y, this.width, this.height);
                }
                if (ExtBase.battlePanelMode == 0) {
                    M.overRoomObject = this;
                }
            } else if (this.battlePanelID == BATTLE_PANEL_ID_FAST_ATTACK) {
                if (this.gfxID != null) {
                    this.bpPaint(graphics, this.x, this.y);
                } else {
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                    graphics.setColor(0);
                    graphics.drawRect(this.x, this.y, this.width, this.height);
                }
                if (ExtBase.battlePanelMode == 1) {
                    M.overRoomObject = this;
                }
            } else if (this.battlePanelID == BATTLE_PANEL_ID_INVENTORY) {
                if (this.gfxID != null) {
                    this.bpPaint(graphics, this.x, this.y);
                } else {
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                    graphics.setColor(0);
                    graphics.drawRect(this.x, this.y, this.width, this.height);
                }
                if (ExtBase.battlePanelMode == 2) {
                    M.overRoomObject = this;
                }
            } else if (this.battlePanelID == BATTLE_PANEL_ID_ESCAPE) {
                if (this.gfxID != null) {
                    this.bpPaint(graphics, this.x, this.y);
                } else {
                    graphics.setColor(0xEEEEEE);
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                    graphics.setColor(0);
                    graphics.drawRect(this.x, this.y, this.width, this.height);
                }
                if (ExtBase.battlePanelMode == 3) {
                    M.overRoomObject = this;
                }
            } else {
                this.bpPaint(graphics, this.x, this.y);
            }
        } else {
            this.bpPaint(graphics, this.x - n, this.y - n2);
        }
    }

    public void bpPaint(Graphics graphics, int n, int n2) {
        if (this.scriptID == null) {
            return;
        }
        if (this.type != 3) {
            return;
        }
        Resource resource = Resource.getImage(this.gfxID, this.transform);
        resource.paint(graphics, n, n2, this.transform);
    }

    public void animPaint(Graphics graphics, int n, int n2) {
        if (this.scriptID == null) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (this.animationData == null || this.animationData[0] == null) {
            return;
        }
        int n3 = 0;
        if (this.idleAnimationTime == 0L) {
            this.idleAnimationTime = M.tickBasedTime();
        } else {
            n3 = (int)((long)M.tickBasedTime() - this.idleAnimationTime);
            if (n3 >= this.animationDuration[0]) {
                this.idleAnimationTime = M.tickBasedTime();
                n3 = 0;
            }
        }
        this.animRoutine(graphics, n3, n, n2, 0);
    }

    public void fightAnimation(Graphics graphics, int n, int n2, int n3) {
        if (this.scriptID == null) {
            return;
        }
        if (this.animationData == null || this.animationData[n3] == null) {
            return;
        }
        int n4 = 0;
        if (this.animationTime == 0L) {
            ExtBase.attackAnim = true;
            this.animationTime = System.currentTimeMillis();
        } else {
            n4 = (int)(System.currentTimeMillis() - this.animationTime);
            if (n4 >= this.animationDuration[n3]) {
                ExtBase.attackAnim = false;
                ExtBase.battleFightTypeActive = 0;
                this.animationTime = 0L;
                return;
            }
        }
        this.animRoutine(graphics, n4, n, n2, n3);
    }

    public void runAnimation(Graphics graphics, int n, int n2) {
        if (this.scriptID == null) {
            return;
        }
        if (this.animationData == null || this.animationData[6] == null) {
            return;
        }
        int n3 = 0;
        if (this.animationTime == 0L) {
            this.animationTime = M.tickBasedTime();
        } else {
            n3 = (int)((long)M.tickBasedTime() - this.animationTime);
            if (n3 >= this.animationDuration[6]) {
                if (--this.runAnimLoops > 0) {
                    this.animationTime = M.tickBasedTime();
                } else {
                    this.animationTime = 0L;
                    if (this.visible) {
                        Resource resource = Resource.getImage(this.gfxID, this.transform);
                        resource.paint(graphics, this.x - n, this.y - n2, this.transform);
                    }
                    M.roomRepaintNeeded = true;
                    return;
                }
            }
        }
        this.animRoutine(graphics, n3, n, n2, 6);
    }

    public void animRoutine(Graphics graphics, int n, int n2, int n3, int n4) {
        Object[] objectArray = this.animationData[n4];
        int n5 = 0;
        int n6 = this.animationParts[n4];
        Object object = this.gfxID;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n6; ++i) {
            Object object2;
            int n9 = i * 4;
            int n10 = M.toInt(objectArray[n9 + 1]);
            if (n >= (n5 += Math.abs(n10))) continue;
            if (noVibraYet && n10 < 0) {
                if (n5 + n10 < n + 400) {
                    // empty if block
                }
                noVibraYet = false;
            }
            if ((object2 = objectArray[n9 + 0]).equals("")) {
                return;
            }
            if (!object2.equals(object)) {
                object = object2;
                if (this.animationImagePoints != null && this.animationImagePoints[n4] != null) {
                    this.x = this.animationImagePoints[n4][i << 1];
                    this.y = this.animationImagePoints[n4][(i << 1) + 1];
                }
            }
            n7 = M.toInt(objectArray[n9 + 2]);
            n8 = M.toInt(objectArray[n9 + 3]);
            break;
        }
        Resource resource = Resource.getImage(object, this.transform);
        resource.paint(graphics, this.x - n2 + n7, this.y - n3 + n8, this.transform);
    }

    public boolean isOver(int n, int n2) {
        if (!this.visible) {
            return false;
        }
        if (!this.active) {
            return false;
        }
        if (n < this.left) {
            return false;
        }
        if (n > this.right) {
            return false;
        }
        if (n2 < this.top) {
            return false;
        }
        return n2 <= this.bottom;
    }

    public String getName() {
        return (String)this.executeEvent(1, "?", false);
    }

    public String getMoveDir() {
        return (String)this.executeEvent(30, null, false);
    }

    public RoomObject hooverIn() {
        if (this.script != null && this.script.hasEvent(54)) {
            this.executeEvent(54, null, false);
            return this;
        }
        return null;
    }
}

