/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Resource {
    static final int TYPE_GFX = 1;
    static final int TYPE_SFX = 2;
    public int type;
    public Object ID;
    public Image image;
    public int imageWidth;
    public int imageHeight;
    public int imageRegPointX;
    public int imageRegPointY;
    public int imageTransform;
    static Vector imagesLRE = new Vector();
    public static Vector imagesImportants = new Vector();

    public Resource(int n, Object object, int n2) {
        this.type = n;
        this.ID = object;
        this.imageTransform = n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)object;
        return resource.type == this.type && resource.ID.equals(this.ID) && resource.imageTransform == this.imageTransform;
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        if (this.image == null) {
            return;
        }
        int n4 = M.getLeft(n, this.imageWidth, this.imageHeight, this.imageRegPointX, this.imageRegPointY, n3);
        int n5 = M.getTop(n2, this.imageWidth, this.imageHeight, this.imageRegPointX, this.imageRegPointY, n3);
        if (n3 == 0) {
            graphics.drawImage(this.image, n4, n5, 20);
        } else {
            graphics.drawRegion(this.image, 0, 0, this.imageWidth, this.imageHeight, MyCanvas.transformTable[n3], n4, n5, 20);
        }
    }

    public void paintSimple(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.image, n, n2, n3);
    }

    public static void getImageInfo(RoomObject roomObject, Object object, int n) {
        Resource resource = Resource.getImage(object, n);
        roomObject.width = resource.imageWidth;
        roomObject.height = resource.imageHeight;
        roomObject.regPointX = resource.imageRegPointX;
        roomObject.regPointY = resource.imageRegPointY;
    }

    public static Resource getImageFromSetup(String string, String string2) {
        Resource resource = new Resource(1, string2, 0);
        try {
            DataInputStream dataInputStream = new DataInputStream(M.resourceGet(string));
            M.find(dataInputStream, "IHDR");
            resource.imageWidth = dataInputStream.readInt();
            resource.imageHeight = dataInputStream.readInt();
            M.find(dataInputStream, "oFFs");
            resource.imageRegPointX = dataInputStream.readInt();
            resource.imageRegPointY = dataInputStream.readInt();
            resource.image = Image.createImage((InputStream)M.resourceGet(string));
            dataInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return resource;
    }

    public static Resource getImage(Object object, int n) {
        Resource resource = new Resource(1, object, n);
        int n2 = imagesLRE.indexOf(resource);
        if (n2 > -1) {
            resource = (Resource)imagesLRE.elementAt(n2);
            imagesLRE.removeElement(resource);
        }
        if (resource.image == null) {
            try {
                String string = M.loadRequest_getResourcePath(object, n);
                DataInputStream dataInputStream = new DataInputStream(M.resourceGet(string));
                M.find(dataInputStream, "IHDR");
                resource.imageWidth = dataInputStream.readInt();
                resource.imageHeight = dataInputStream.readInt();
                M.find(dataInputStream, "oFFs");
                resource.imageRegPointX = dataInputStream.readInt();
                resource.imageRegPointY = dataInputStream.readInt();
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dataInputStream = new DataInputStream(M.resourceGet(string));
                int n3 = M.max(M.minFreeMemory, resource.imageWidth * resource.imageHeight << 2);
                int n4 = 0;
                while (M.freeMemory() < (long)n3 && !imagesLRE.isEmpty()) {
                    imagesLRE.removeElement(imagesLRE.lastElement());
                    ++n4;
                }
                resource.image = Image.createImage((InputStream)dataInputStream);
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        imagesLRE.insertElementAt(resource, 0);
        return resource;
    }
}

