/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

class LoadRequest {
    public static final int TYPE_SCRIPT = 1;
    public static final int TYPE_GFX_STRING = 2;
    public static final int TYPE_GFX_INTEGER = 3;
    public static final int TYPE_SFX = 4;
    public static final int TYPE_ROOM = 5;
    public int type;
    public int integerID;
    public String stringID;
    public int imageTransform;

    LoadRequest(int n, String string) {
        this.type = n;
        this.stringID = string;
    }

    LoadRequest(Object object, int n) {
        try {
            this.integerID = (Integer)object;
            this.type = 3;
        }
        catch (Exception exception) {
            this.stringID = (String)object;
            this.type = 2;
        }
    }

    public Object getID() {
        if (this.type == 3) {
            return new Integer(this.integerID);
        }
        return this.stringID;
    }

    public String getDescription() {
        return null;
    }

    public boolean equals(Object object) {
        try {
            LoadRequest loadRequest = (LoadRequest)object;
            if (this.type != loadRequest.type) {
                return false;
            }
            if (this.stringID != loadRequest.stringID && !this.stringID.equals(loadRequest.stringID)) {
                return false;
            }
            if (this.integerID != loadRequest.integerID) {
                return false;
            }
            return this.imageTransform == loadRequest.imageTransform;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static LoadRequest createFromInputStream(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readUnsignedByte();
            switch (n) {
                case 2: {
                    String string = M.readString(dataInputStream);
                    int n2 = dataInputStream.readUnsignedByte();
                    return new LoadRequest(string, n2);
                }
                case 3: {
                    int n3 = dataInputStream.readUnsignedByte();
                    int n4 = dataInputStream.readUnsignedByte();
                    return new LoadRequest(new Integer(n3), n4);
                }
            }
            String string = M.readString(dataInputStream);
            return new LoadRequest(n, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getResourcePath() {
        switch (this.type) {
            case 2: {
                return M.gameId + "/gfx/transform" + this.imageTransform + "/" + this.stringID + ".png";
            }
            case 3: {
                return M.gameId + "/gfx/transform" + this.imageTransform + "/" + this.integerID + ".png";
            }
            case 5: {
                return M.gameId + "/rom/" + this.stringID + ".bin";
            }
            case 1: {
                return M.gameId + "/scr/" + this.stringID + ".bin";
            }
            case 4: {
                return M.gameId + "/sfx/" + "mid" + "/" + this.stringID + "." + "mid";
            }
        }
        return null;
    }

    public String toString() {
        return this.getResourcePath();
    }
}

