/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MyCanvas
extends GameCanvas {
    static final int[] transformTable = new int[]{0, 2, 5, 7, 3, 1, 6, 4};
    static Player gPlayer;
    static String soundID;
    static int loopCount;
    static final String SOUND_FORMAT = "mid";
    static final String AUDIO_TYPE = "audio/midi";
    static InputStream shotSound;
    static final int KEY_NOT_SPECIFIED = 0;
    static final int KEY_UP = -1;
    static final int KEY_DOWN = -2;
    static final int KEY_LEFT = -3;
    static final int KEY_RIGHT = -4;
    static final int KEY_MIDDLE_SOFT = -5;
    static final int KEY_LEFT_SOFT = -6;
    static final int KEY_RIGHT_SOFT = -7;
    static final int KEY_ERASE = -8;
    static final int KEY_SEND = -10;
    static final int KEY_RETURN = -11;
    static int keySoftkeyLeft;
    static int keySoftkeyRight;
    static int keySend;
    static int keyReturn;
    static int keySoftkeyCenter;
    static int keyArrowUp;
    static int keyArrowDown;
    static int keyArrowLeft;
    static int keyArrowRight;
    static int keyErase;

    protected MyCanvas() {
        super(false);
        this.setFullScreenMode(true);
    }

    public void paint(Graphics graphics) {
        M.paint(graphics);
    }

    protected void hideNotify() {
        M.keyDown = 0;
        M.keyLastPressed = 0;
        M.keyNew = false;
        M.keyPressed = false;
        M.setHide(true);
        MyCanvas.stopSound();
        if (ExtBase.textFadePausedTime == -1L) {
            ExtBase.textFadePausedTime = System.currentTimeMillis() - ExtBase.textFadeStartTime;
        }
    }

    protected void showNotify() {
        M.setHide(false);
        MyCanvas.resumeSound();
    }

    protected void keyPressed(int n) {
        if (M.loadingMode == -1 && !M.loadBarActive && M.gotoDissolveFXCounter <= -3) {
            M.setKeyStatus(MyCanvas.keyConvertToKeyId(n), true);
        }
    }

    protected void keyReleased(int n) {
        if (M.loadingMode == -1 && !M.loadBarActive && M.gotoDissolveFXCounter <= -3) {
            M.setKeyStatus(MyCanvas.keyConvertToKeyId(n), false);
        }
    }

    static void playSound(String string, int n) {
        if (ExtBase.FirstLoad && string.equals("ls")) {
            ExtBase.FirstLoad = !ExtBase.FirstLoad;
            return;
        }
        if (!M.curSoundMode) {
            return;
        }
        try {
            InputStream inputStream;
            soundID = null;
            loopCount = 0;
            MyCanvas.stopSound();
            if (string.equals("sh_shot")) {
                if (shotSound == null) {
                    shotSound = M.resourceGet(M.gameId + "/sfx/" + SOUND_FORMAT + "/" + string + "." + SOUND_FORMAT);
                }
                shotSound.reset();
                inputStream = new DataInputStream(shotSound);
            } else {
                inputStream = M.resourceGet(M.gameId + "/sfx/" + SOUND_FORMAT + "/" + string + "." + SOUND_FORMAT);
            }
            gPlayer = Manager.createPlayer((InputStream)inputStream, (String)AUDIO_TYPE);
            gPlayer.setLoopCount(n);
            try {
                gPlayer.prefetch();
                gPlayer.realize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 1 && n == -1) {
                soundID = string;
                loopCount = -1;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void resumeSound() {
        if (M.curSoundMode && loopCount == -1) {
            MyCanvas.playSound(soundID, loopCount);
        }
    }

    static void stopSound() {
        if (gPlayer != null) {
            try {
                gPlayer.stop();
                gPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            gPlayer = null;
        }
    }

    static void keyInit() {
        keySoftkeyLeft = M.toInt(ExtBase.settingsHash.get("KEY_SOFTKEY_LEFT"));
        keySoftkeyRight = M.toInt(ExtBase.settingsHash.get("KEY_SOFTKEY_RIGHT"));
        keySend = M.toInt(ExtBase.settingsHash.get("KEY_SEND"));
        keyReturn = M.toInt(ExtBase.settingsHash.get("KEY_END"));
        keySoftkeyCenter = M.toInt(ExtBase.settingsHash.get("KEY_SOFTKEY_THUMBSTICK"));
        keyArrowUp = M.toInt(ExtBase.settingsHash.get("KEY_UP_ARROW"));
        keyArrowDown = M.toInt(ExtBase.settingsHash.get("KEY_DOWN_ARROW"));
        keyArrowLeft = M.toInt(ExtBase.settingsHash.get("KEY_LEFT_ARROW"));
        keyArrowRight = M.toInt(ExtBase.settingsHash.get("KEY_RIGHT_ARROW"));
        keyErase = M.toInt(ExtBase.settingsHash.get("KEY_CLEAR"));
    }

    private static int keyJadEntryAsInt(String string) {
        try {
            return Integer.parseInt(M.midlet.getAppProperty(string));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int keyConvertToKeyId(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == keySoftkeyLeft) {
            return -6;
        }
        if (n == keySoftkeyRight) {
            return -7;
        }
        if (n == keySoftkeyCenter || n == 53) {
            return -5;
        }
        if (n == keyArrowUp || n == 121 || n == 116 || n == 50) {
            return -1;
        }
        if (n == keyArrowDown || n == 98 || n == 118 || n == 56) {
            return -2;
        }
        if (n == keyArrowLeft || n == 102 || n == 100 || n == 52) {
            return -3;
        }
        if (n == keyArrowRight || n == 106 || n == 107 || n == 54) {
            return -4;
        }
        if (n == keyReturn) {
            return 0;
        }
        if (n == keyErase) {
            return 0;
        }
        if (n == keySend) {
            return -10;
        }
        if (n >= 48 && n <= 57 || n == 42 || n == 35) {
            return n;
        }
        return 0;
    }
}

