/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    int curAnim;
    int curFrame;
    public int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private static int k_animBaseFrameTime = 1000 / 10;
    private static final int k_snd_nbChannel = 2;
    static int s_snd_masterVolume;
    static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static int[] s_snd_sndDuration;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static long[] s_snd_playTime;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static GLLibPlayer s_pSoundPlayerIns;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    private static int[] s_TilesetInfo;
    private static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static ASprite[] s_TilesetSprite;

    GLLibPlayer() {
        this.Reset();
    }

    void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = -1;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.animIsOver = true;
    }

    void SetAnim(int anim, int nbLoop) {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().sprite is not set");
        }
        if (anim >= this.GetNbanim()) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().anim out of range");
        }
        if (nbLoop == 0) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().nbLoop is invalid");
        }
        if (this.animIsOver || anim != this.curAnim) {
            this.curAnim = anim;
            this.SetFrame(0);
            this.nbLoop = nbLoop - 1;
            this.animIsOver = false;
        }
    }

    int SetFrame(int frame) {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.SetFrame().sprite is not set");
        }
        if (frame < 0) {
            GLLib.Assert(false, "GLLibPlayer.SetFrame().frame is negative");
        }
        if (this.curAnim < 0) {
            return -1;
        }
        int nbFrame = this.GetNbFrame();
        while (frame > nbFrame) {
            frame -= nbFrame;
        }
        this.curFrame = frame;
        this.curTime = 0;
        return frame;
    }

    int GetNbanim() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetNbanim().sprite is not set");
        }
        return this.sprite._anims_naf.length;
    }

    int GetNbFrame() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetNbFrame().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    final int GetDuration() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetDuration().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    boolean IsAnimOver() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.isAnimOver().sprite is not set");
        }
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    void Render() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.render().sprite is not set");
        }
        if (this.curAnim < 0) {
            return;
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
    }

    void Update(int DT) {
        block18: {
            int duration;
            block17: {
                if (DT < 0) {
                    GLLib.Assert(false, "GLLibPlayer.Update.DT is negative");
                }
                if (10 == 1000) {
                    if (DT > 1) {
                        GLLib.Warning("GLLibPlayer.Update was called with DT larger than 1, the player is currently working as Frame Based Player");
                    }
                } else if (DT == 1) {
                    GLLib.Warning("GLLibPlayer.Update was called with DT equal 1, the player is currently working as a Time Based Player, it should be more than 1 ms ?");
                }
                if (this.animIsOver || this.curAnim < 0) {
                    return;
                }
                this.curTime += DT;
                duration = this.GetDuration();
                if (duration == 0) {
                    GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                }
                if (!false) break block17;
                if (this.curTime < duration) break block18;
                this.curTime -= duration;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else if (this.nbLoop == 0) {
                    this.animIsOver = true;
                } else {
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                duration = this.GetDuration();
                if (duration != 0) break block18;
                GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                break block18;
            }
            while (this.curTime >= duration) {
                this.curTime -= duration;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else {
                    if (this.nbLoop == 0) {
                        this.animIsOver = true;
                        break;
                    }
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                if ((duration = this.GetDuration()) != 0) continue;
                GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
            }
        }
    }

    private static int SndQueue_NormalizeIndex(int index) {
        while (index >= 7) {
            index -= 7;
        }
        while (index < 0) {
            index += 7;
        }
        return index;
    }

    private static int SndQueue_GetIndex(int channel, int index) {
        return channel * 7 * 5 + index * 5;
    }

    private static int SndQueue_GetData(int channel, int index) {
        return s_snd_queue[GLLibPlayer.SndQueue_GetIndex(channel, s_snd_queue_pointer[channel]) + index];
    }

    private static void SndQueue_Push(int channel, int command, int index, int priority, int volume, int loop) {
        int idx;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (s_snd_queue_size[channel] >= 7) {
            GLLib.Assert(false, "SndQueue_Push: Too many sound requests given before Snd_Update!");
        }
        int start = s_snd_queue_pointer[channel];
        int size = s_snd_queue_size[channel];
        int end = GLLibPlayer.SndQueue_NormalizeIndex(start + size);
        for (int i = 0; i < size; ++i) {
            idx = GLLibPlayer.SndQueue_NormalizeIndex(end - i - 1);
            if (s_snd_queue[(idx = GLLibPlayer.SndQueue_GetIndex(channel, idx)) + 0] != command || (command == 3 || command == 1) && s_snd_queue[idx + 2] < priority) continue;
            GLLibPlayer.s_snd_queue[idx + 0] = 0;
        }
        idx = GLLibPlayer.SndQueue_GetIndex(channel, end);
        GLLibPlayer.s_snd_queue[idx + 0] = command;
        GLLibPlayer.s_snd_queue[idx + 1] = index;
        GLLibPlayer.s_snd_queue[idx + 2] = priority;
        GLLibPlayer.s_snd_queue[idx + 3] = volume;
        GLLibPlayer.s_snd_queue[idx + 4] = loop;
        int n = channel;
        s_snd_queue_size[n] = s_snd_queue_size[n] + 1;
    }

    private static void SndQueue_Push(int channel, int command) {
        GLLibPlayer.SndQueue_Push(channel, command, -1, -1, -1, -1);
    }

    private static void SndQueue_Pop(int channel) {
        GLLibPlayer.s_snd_queue_pointer[channel] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[channel] + 1);
        int n = channel;
        s_snd_queue_size[n] = s_snd_queue_size[n] - 1;
    }

    static void Snd_Init(int nbSoundSlot) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_init");
            if (k_snd_nbChannel > 1) {
                GLLib.Dbg("    WARNING nb of sound channel is set to more than one");
                GLLib.Dbg("    - this is your responsability to make sure that phone with lower");
                GLLib.Dbg("     nb of sound channel will play the important sound (BGM, SFX...)");
            }
        }
        GLLib.Dbg("SOUND : Init : JSR135");
        if (false) {
            GLLib.Dbg("microedition.media.version is :" + System.getProperty("microedition.media.version"));
            GLLib.Dbg("phone support mixing : " + System.getProperty("supports.mixing"));
            if (System.getProperty("supports.mixing").equals("true")) {
                GLLib.Dbg("    WARNING this phone support mixing, that ONLY means: ");
                GLLib.Dbg("    - Manager.playTone can play 2 tones simultaneously");
                GLLib.Dbg("    - Manager.playTone and one Player can be used at the same time");
                GLLib.Dbg("    - At least 2 Players can playback audio simultaneously");
            }
        }
        s_snd_Player = new Player[k_snd_nbChannel];
        if (true) {
            s_snd_PlayerSlot = new Player[nbSoundSlot];
        }
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.s_snd_index[i] = -1;
            GLLibPlayer.s_snd_queue_pointer[i] = 0;
            GLLibPlayer.s_snd_queue_size[i] = 0;
        }
        s_snd_maxNbSoundSlot = nbSoundSlot;
        s_snd_sndSlot = new byte[s_snd_maxNbSoundSlot][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        if (false) {
            s_snd_sndDuration = new int[s_snd_maxNbSoundSlot];
            s_snd_playTime = new long[k_snd_nbChannel];
        }
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
        if (true) {
            s_pSoundPlayerIns = new GLLibPlayer();
            s_pThread = new Thread(s_pSoundPlayerIns);
            s_pThread.start();
        }
    }

    static void Snd_LoadSound(String dataFileName, int resourceIndex) throws Exception {
        GLLibPlayer.Snd_LoadSound(dataFileName, resourceIndex, true);
    }

    static void Snd_LoadSound(String dataFileName, int resourceIndex, boolean bCacheThisSound) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (resourceIndex >= s_snd_sndSlot.length) {
            GLLib.Assert(false, "resourceIndex is larger that slot count. Read the Warning in the doc.");
        }
        if (false) {
            GLLib.Dbg("Snd_LoadSound : " + resourceIndex);
        }
        if (resourceIndex < 0) {
            return;
        }
        if (s_snd_sndSlot == null) {
            GLLib.Assert(false, "Snd_LoadSound.snd not correctly initialized");
        }
        GLLib.Pack_Open(dataFileName);
        byte[] pData = GLLib.Pack_ReadData(resourceIndex);
        GLLibPlayer.Snd_LoadSound(pData, GLLib.s_pack_lastDataReadMimeType, resourceIndex, bCacheThisSound);
    }

    static void Snd_LoadSound(byte[] soundData, int nMIME, int index, boolean bCacheThisSound) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (index >= s_snd_sndSlot.length) {
            GLLib.Assert(false, "index is larger that slot count. Read the Warning in the doc.");
        }
        if (false) {
            GLLib.Dbg("    slot : " + index);
        }
        GLLibPlayer.s_snd_sndSlot[index] = soundData;
        GLLibPlayer.s_snd_sndType[index] = nMIME;
        if (false) {
            GLLib.Dbg("    mime : " + GLLib.GetMIME(s_snd_sndType[index]));
        }
        if (true && bCacheThisSound) {
            if (false) {
                GLLib.Dbg("    create player (" + GLLib.GetMIME(s_snd_sndType[index]) + ")");
            }
            GLLibPlayer.s_snd_PlayerSlot[index] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[index]), (String)GLLib.GetMIME(s_snd_sndType[index]));
            if (true) {
                if (false) {
                    GLLib.Dbg("    realize player");
                }
                s_snd_PlayerSlot[index].realize();
                if (true) {
                    if (false) {
                        GLLib.Dbg("    prefetch player");
                    }
                    s_snd_PlayerSlot[index].prefetch();
                }
            }
        }
    }

    static void Snd_Play(int channel, int index, int loop, int volume, int priority) {
        if (!true) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_play " + channel + " " + index + " " + loop + " " + volume + " " + priority);
        }
        if (loop < 0) {
            GLLib.Assert(false, "Snd_play.invalid loop number");
        }
        if (index < 0 || volume == 0) {
            if (false) {
                GLLib.Dbg("    dummy sound skiping");
            }
            return;
        }
        GLLibPlayer.SndQueue_Push(channel, 3, index, priority, volume, loop);
    }

    static final void Snd_Stop(int channel) {
        if (!true) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_stop");
        }
        GLLibPlayer.SndQueue_Push(channel, 4);
    }

    private static void Snd_PrepareExec(int channel) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_PrepareExec");
        }
        int index = GLLibPlayer.SndQueue_GetData(channel, 1);
        int priority = GLLibPlayer.SndQueue_GetData(channel, 2);
        if (s_snd_state[channel] == 2 && s_snd_priority[channel] < priority) {
            return;
        }
        if (s_snd_index[channel] == index && s_snd_state[channel] != 0) {
            return;
        }
        GLLibPlayer.Snd_FreeChannelExec(channel);
        if (true) {
            GLLibPlayer.s_snd_Player[channel] = s_snd_PlayerSlot[index];
            if (s_snd_Player[channel] == null) {
                if (false) {
                    GLLib.Dbg("    create player (" + GLLib.GetMIME(s_snd_sndType[index]) + ")");
                }
                GLLibPlayer.s_snd_Player[channel] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[index]), (String)GLLib.GetMIME(s_snd_sndType[index]));
            }
        } else {
            if (false) {
                GLLib.Dbg("    create player (" + GLLib.GetMIME(s_snd_sndType[index]) + ")");
            }
            GLLibPlayer.s_snd_Player[channel] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[index]), (String)GLLib.GetMIME(s_snd_sndType[index]));
        }
        if (s_snd_Player[channel] == null) {
            GLLib.Dbg("    ERROR.player is null 1090");
            return;
        }
        if (!true) {
            if (false) {
                GLLib.Dbg("    realize player");
            }
            s_snd_Player[channel].realize();
        }
        if (!true) {
            if (false) {
                GLLib.Dbg("    prefetch player");
            }
            s_snd_Player[channel].prefetch();
        }
        GLLibPlayer.s_snd_state[channel] = 1;
        GLLibPlayer.s_snd_index[channel] = index;
    }

    private static void Snd_PlayExec(int channel) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_playExec");
        }
        GLLibPlayer.Snd_PrepareExec(channel);
        if (s_snd_state[channel] != 1 || s_snd_Player[channel] == null) {
            if (false) {
                GLLib.Dbg("Snd_playExec : Cant play, state not ready or player is null");
            }
            return;
        }
        int index = GLLibPlayer.SndQueue_GetData(channel, 1);
        int priority = GLLibPlayer.SndQueue_GetData(channel, 2);
        int loop = GLLibPlayer.SndQueue_GetData(channel, 4);
        int volume = GLLibPlayer.SndQueue_GetData(channel, 3);
        if (false) {
            GLLib.Dbg("    set loop count");
        }
        if (loop == 0) {
            s_snd_Player[channel].setLoopCount(-1);
        } else {
            s_snd_Player[channel].setLoopCount(loop);
        }
        if (false) {
            GLLib.Dbg("    set volume");
        }
        if (true) {
            ((VolumeControl)s_snd_Player[channel].getControl("VolumeControl")).setLevel(volume * s_snd_masterVolume * 100 / 10000);
        }
        if (false) {
            GLLib.Dbg("    start player");
        }
        if (true) {
            s_snd_Player[channel].setMediaTime(0L);
        }
        s_snd_Player[channel].start();
        GLLibPlayer.s_snd_state[channel] = 2;
        GLLibPlayer.s_snd_volume[channel] = volume;
        GLLibPlayer.s_snd_loop[channel] = loop;
        GLLibPlayer.s_snd_priority[channel] = priority;
        GLLibPlayer.s_snd_index[channel] = index;
        if (false) {
            GLLibPlayer.s_snd_playTime[channel] = System.currentTimeMillis();
        }
    }

    private static void Snd_StopExec(int channel) throws Exception {
        if (false) {
            GLLib.Dbg("Snd_stopExec");
        }
        if (s_snd_Player[channel] == null) {
            return;
        }
        s_snd_Player[channel].stop();
        GLLibPlayer.s_snd_state[channel] = 1;
        if (false) {
            GLLibPlayer.Snd_FreeChannelExec(channel);
        }
        if (false) {
            GLLibPlayer.s_snd_playTime[channel] = 0L;
        }
    }

    private static void Snd_PauseExec(int channel) throws Exception {
        if (false) {
            GLLib.Dbg("Snd_pauseExec");
        }
        if (s_snd_state[channel] != 2) {
            return;
        }
        if (s_snd_Player[channel] == null) {
            GLLib.Assert(false, "Snd_pauseExec.player is null 1411");
        }
        if (s_snd_Player[channel] == null) {
            return;
        }
        if (s_snd_Player[channel].getState() != 400) {
            GLLib.Assert(false, "Snd_pauseExec.player wasn't playing");
        }
        s_snd_Player[channel].stop();
        GLLibPlayer.s_snd_state[channel] = 3;
    }

    private static void Snd_ResumeExec(int channel) throws Exception {
        if (false) {
            GLLib.Dbg("Snd_resumeExec");
        }
        if (s_snd_state[channel] != 3) {
            return;
        }
        if (s_snd_Player[channel] == null) {
            GLLib.Assert(false, "Snd_resumeExec.player is null 1455");
        }
        if (s_snd_Player[channel] == null) {
            return;
        }
        s_snd_Player[channel].start();
        GLLibPlayer.s_snd_state[channel] = 2;
    }

    static void Snd_Update() {
        if (true) {
            if (s_pThread != null && !s_pThread.isAlive()) {
                s_pThread.start();
            }
        } else {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    private static void Snd_Update_Exec() {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        for (int channel = 0; channel < k_snd_nbChannel; ++channel) {
            if (s_snd_queue_size[channel] > 0 && s_snd_state[channel] == 2) {
                boolean isPlaying;
                try {
                    isPlaying = GLLibPlayer.Snd_IsPlaying(channel);
                }
                catch (Exception e) {
                    GLLib.Dbg("Snd_update.error on channel (" + channel + ")." + e);
                    isPlaying = false;
                }
                if (!isPlaying) {
                    GLLibPlayer.s_snd_state[channel] = 1;
                }
            }
            while (s_snd_queue_size[channel] > 0) {
                try {
                    if (false) {
                        GLLib.Dbg("Snd_update");
                    }
                    int command = GLLibPlayer.SndQueue_GetData(channel, 0);
                    switch (command) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(channel);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(channel);
                            break;
                        }
                        case 3: {
                            GLLibPlayer.Snd_PlayExec(channel);
                            break;
                        }
                        case 4: {
                            GLLibPlayer.Snd_StopExec(channel);
                            break;
                        }
                        case 5: {
                            GLLibPlayer.Snd_PauseExec(channel);
                            break;
                        }
                        case 6: {
                            GLLibPlayer.Snd_ResumeExec(channel);
                        }
                    }
                }
                catch (Exception e) {
                    GLLib.Dbg("Snd_update.error on channel (" + channel + ")." + e);
                    e.printStackTrace();
                }
                GLLibPlayer.SndQueue_Pop(channel);
            }
        }
    }

    public void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                Thread.sleep(1000 / 16);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int channel) throws Exception {
        if (!true) {
            return false;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (false) {
            GLLib.Dbg("Snd_isPlaying");
        }
        if (s_snd_Player[channel] == null) {
            return false;
        }
        if (false) {
            int index = GLLibPlayer.Snd_GetCurrentSoundIndex(channel);
            if (index < 0) {
                return false;
            }
            if (System.currentTimeMillis() - s_snd_playTime[channel] > (long)(s_snd_sndDuration[index] * s_snd_loop[channel])) {
                return false;
            }
        } else if (s_snd_Player[channel].getState() != 400) {
            return false;
        }
        return true;
    }

    private static void Snd_FreeChannelExec(int channel) throws Exception {
        if (!true) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            GLLib.Dbg("Snd_FreeChannelExec = " + channel);
        }
        if (s_snd_Player[channel] != null) {
            s_snd_Player[channel].stop();
            if (!true) {
                s_snd_Player[channel].deallocate();
            }
            if (!true) {
                s_snd_Player[channel].close();
            } else {
                int index = GLLibPlayer.SndQueue_GetData(channel, 1);
                if (index < 0 || s_snd_PlayerSlot[index] == null) {
                    s_snd_Player[channel].close();
                }
            }
            GLLibPlayer.s_snd_Player[channel] = null;
            if (false) {
                System.gc();
            }
        }
        GLLibPlayer.s_snd_state[channel] = 0;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        if (!true) {
            GLLibPlayer.Snd_Update();
        } else if (GLLib.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static int Snd_GetCurrentSoundIndex(int nChannel) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[nChannel];
        }
        return -1;
    }

    static void Snd_ForceExecOnThreadOnGamePause() {
        if (true && GLLib.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static void Tileset_Init(int nDestWidth, int nDestHeight, int nTileWidth, int nTileHeight) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][15];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        GLLibPlayer.s_TilesetInfo[0] = nDestWidth;
        GLLibPlayer.s_TilesetInfo[1] = nDestHeight;
        if (false) {
            int w = nTileWidth;
            int h = nTileHeight;
            nTileWidth = GLLib.Math_Log2(nTileWidth);
            nTileHeight = GLLib.Math_Log2(nTileHeight);
            if (1 << nTileWidth != w) {
                GLLib.Assert(false, "Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile width" + nTileWidth);
            }
            if (1 << nTileHeight != h) {
                GLLib.Assert(false, "Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile height" + nTileHeight);
            }
            GLLibPlayer.s_TilesetInfo[3] = nTileWidth;
            GLLibPlayer.s_TilesetInfo[2] = 1 << nTileWidth;
            GLLibPlayer.s_TilesetInfo[4] = s_TilesetInfo[2] - 1;
            GLLibPlayer.s_TilesetInfo[6] = nTileHeight;
            GLLibPlayer.s_TilesetInfo[5] = 1 << nTileHeight;
            GLLibPlayer.s_TilesetInfo[7] = s_TilesetInfo[5] - 1;
        } else {
            GLLibPlayer.s_TilesetInfo[2] = nTileWidth;
            GLLibPlayer.s_TilesetInfo[4] = 0;
            GLLibPlayer.s_TilesetInfo[5] = nTileHeight;
            GLLibPlayer.s_TilesetInfo[7] = 0;
        }
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int nLayer, int flag) {
        return (s_TilesetLayerInfo[nLayer][14] & flag) != 0;
    }

    private static final void setFlag(int nLayer, int flag, boolean value) {
        if (value) {
            int[] nArray = s_TilesetLayerInfo[nLayer];
            nArray[14] = nArray[14] | flag;
        } else {
            int[] nArray = s_TilesetLayerInfo[nLayer];
            nArray[14] = nArray[14] & ~flag;
        }
    }

    static void Tileset_LoadLayer(int nLayer, byte[] MapSizes, byte[] MapData, byte[] MapFlip, ASprite MapSprite, int iUseCB, int origin, int wrappingX, int wrappingY) {
        if (MapSizes == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapSizes is null");
        }
        if (MapData == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapData is null");
        }
        if (MapSprite == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapSprite is null");
        }
        if (wrappingX != 0 && wrappingX != 1) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. X wrapping is not valid");
        }
        if (wrappingY != 0 && wrappingY != 1) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. Y wrapping is not valid");
        }
        if (origin != 16 && origin != 32) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. origin is not valid");
        }
        if (MapFlip == null) {
            GLLib.Dbg("WARNING GLLibPlayer.Tileset_LoadLayer.MapFlip is null, no flip will occur");
        }
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.Tileset_Destroy(nLayer, false);
        GLLibPlayer.s_TilesetLayerData[nLayer][0] = MapData;
        GLLibPlayer.s_TilesetLayerData[nLayer][1] = MapFlip;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][2] = GLLib.Mem_GetShort(MapSizes, 0);
        GLLibPlayer.s_TilesetLayerInfo[nLayer][3] = GLLib.Mem_GetShort(MapSizes, 2);
        GLLibPlayer.s_TilesetLayerInfo[nLayer][4] = s_TilesetLayerInfo[nLayer][2] * s_TilesetInfo[2];
        GLLibPlayer.s_TilesetLayerInfo[nLayer][5] = s_TilesetLayerInfo[nLayer][3] * s_TilesetInfo[5];
        GLLibPlayer.s_TilesetSprite[nLayer] = MapSprite;
        if (iUseCB > -1) {
            try {
                if (false) {
                    GLLibPlayer.s_TilesetLayerInfo[nLayer][6] = (s_TilesetInfo[0] & ~s_TilesetInfo[4]) + 1 * s_TilesetInfo[2];
                    GLLibPlayer.s_TilesetLayerInfo[nLayer][7] = (s_TilesetInfo[1] & ~s_TilesetInfo[7]) + 1 * s_TilesetInfo[5];
                    if (s_TilesetLayerInfo[nLayer][6] - s_TilesetInfo[0] < s_TilesetInfo[2]) {
                        int[] nArray = s_TilesetLayerInfo[nLayer];
                        nArray[6] = nArray[6] + s_TilesetInfo[2];
                    }
                    if (s_TilesetLayerInfo[nLayer][7] - s_TilesetInfo[1] < s_TilesetInfo[5]) {
                        int[] nArray = s_TilesetLayerInfo[nLayer];
                        nArray[7] = nArray[7] + s_TilesetInfo[5];
                    }
                } else {
                    int nRestX = s_TilesetInfo[0] % s_TilesetInfo[2];
                    int nAddX = 1 + (nRestX != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[nLayer][6] = s_TilesetInfo[0] - nRestX + nAddX * s_TilesetInfo[2];
                    int nRestY = s_TilesetInfo[1] % s_TilesetInfo[5];
                    int nAddY = 1 + (nRestY != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[nLayer][7] = s_TilesetInfo[1] - nRestY + nAddY * s_TilesetInfo[5];
                }
                if (iUseCB == nLayer) {
                    if (s_TilesetLayerImage[nLayer][0] == null || s_TilesetLayerImage[nLayer][0].getWidth() != s_TilesetLayerInfo[nLayer][6] || s_TilesetLayerImage[nLayer][0].getHeight() != s_TilesetLayerInfo[nLayer][7]) {
                        GLLibPlayer.s_TilesetLayerImage[nLayer][0] = Image.createImage((int)s_TilesetLayerInfo[nLayer][6], (int)s_TilesetLayerInfo[nLayer][7]);
                        GLLibPlayer.s_TilesetLayerGraphics[nLayer][0] = s_TilesetLayerImage[nLayer][0].getGraphics();
                    }
                } else {
                    if (s_TilesetLayerImage[iUseCB][0] == null) {
                        GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. layer " + iUseCB + " has no circular buffer allocated");
                    }
                    GLLibPlayer.s_TilesetLayerImage[nLayer][0] = s_TilesetLayerImage[iUseCB][0];
                    GLLibPlayer.s_TilesetLayerGraphics[nLayer][0] = s_TilesetLayerGraphics[iUseCB][0];
                }
                GLLibPlayer.setFlag(nLayer, 4, true);
            }
            catch (Exception e) {
                GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.pb while ceating circular buffer : " + e.toString());
            }
        }
        GLLibPlayer.s_TilesetLayerInfo[nLayer][8] = -1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][11] = -1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][0] = 1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][1] = 1;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][12] = 0;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][13] = 0;
        GLLibPlayer.setFlag(nLayer, 1, wrappingX == 1);
        GLLibPlayer.setFlag(nLayer, 2, wrappingY == 1);
        GLLibPlayer.setFlag(nLayer, 8, origin == 32);
    }

    static void Tileset_Destroy(int nLayer, boolean bFreeBufferImage) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[nLayer] = new int[15];
        if (bFreeBufferImage) {
            GLLibPlayer.s_TilesetLayerImage[nLayer] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[nLayer] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[nLayer] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[nLayer] = null;
    }

    static void Tileset_Draw(Graphics g, int nLayer) {
        GLLibPlayer.Tileset_Draw(g, 0, 0, nLayer);
    }

    static void Tileset_Draw(Graphics g, int dx, int dy, int nLayer) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        int cx = 0;
        int cy = 0;
        int cw = 0;
        int ch = 0;
        if (g != null) {
            cx = g.getClipX();
            cy = g.getClipY();
            cw = g.getClipWidth();
            ch = g.getClipHeight();
        }
        int destWidth = s_TilesetInfo[0];
        int destHeight = s_TilesetInfo[1];
        if (nLayer == -1) {
            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                if (false) {
                    if (i == s_TilesetAlphaLayer) continue;
                    GLLibPlayer.Tileset_Draw(g, i);
                    continue;
                }
                GLLibPlayer.Tileset_Draw(g, i);
            }
            return;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            return;
        }
        GLLib.Profiler_BeginNamedEvent("Tileset_Draw");
        int originX = s_TilesetLayerInfo[nLayer][12];
        int originY = s_TilesetLayerInfo[nLayer][13];
        if (GLLibPlayer.isFlag(nLayer, 4)) {
            int end;
            int start;
            int lastTileY;
            int lastTileX;
            int firstTileY;
            int firstTileX;
            if (false) {
                firstTileX = originX >> s_TilesetInfo[3];
                firstTileY = originY >> s_TilesetInfo[6];
                lastTileX = originX + s_TilesetInfo[0] >> s_TilesetInfo[3];
                lastTileY = originY + s_TilesetInfo[1] >> s_TilesetInfo[6];
            } else {
                int nTmpStartX = originX;
                int nTmpStartY = originY;
                if (nTmpStartX < 0) {
                    nTmpStartX -= s_TilesetInfo[2];
                }
                if (nTmpStartY < 0) {
                    nTmpStartY -= s_TilesetInfo[5];
                }
                firstTileX = nTmpStartX / s_TilesetInfo[2];
                firstTileY = nTmpStartY / s_TilesetInfo[5];
                lastTileX = firstTileX + s_TilesetLayerInfo[nLayer][6] / s_TilesetInfo[2] - 1;
                lastTileY = firstTileY + s_TilesetLayerInfo[nLayer][7] / s_TilesetInfo[5] - 1;
            }
            if (s_TilesetLayerInfo[nLayer][8] != firstTileX || s_TilesetLayerInfo[nLayer][10] != lastTileX) {
                if (s_TilesetLayerInfo[nLayer][8] < firstTileX || s_TilesetLayerInfo[nLayer][10] < lastTileX) {
                    if (s_TilesetLayerInfo[nLayer][10] < firstTileX) {
                        start = firstTileX;
                        end = lastTileX;
                    } else {
                        start = s_TilesetLayerInfo[nLayer][10] + 1;
                        end = lastTileX;
                    }
                } else if (s_TilesetLayerInfo[nLayer][8] > lastTileX) {
                    start = firstTileX;
                    end = lastTileX;
                } else {
                    start = firstTileX;
                    end = s_TilesetLayerInfo[nLayer][8] - 1;
                }
                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[nLayer][0], nLayer, start, firstTileY, end - start, lastTileY - firstTileY, 0, 0);
                GLLibPlayer.s_TilesetLayerInfo[nLayer][8] = firstTileX;
                GLLibPlayer.s_TilesetLayerInfo[nLayer][10] = lastTileX;
            }
            if (s_TilesetLayerInfo[nLayer][9] != firstTileY || s_TilesetLayerInfo[nLayer][11] != lastTileY) {
                if (s_TilesetLayerInfo[nLayer][9] < firstTileY || s_TilesetLayerInfo[nLayer][11] < lastTileY) {
                    if (s_TilesetLayerInfo[nLayer][11] < firstTileY) {
                        start = firstTileY;
                        end = lastTileY;
                    } else {
                        start = s_TilesetLayerInfo[nLayer][11] + 1;
                        end = lastTileY;
                    }
                } else if (s_TilesetLayerInfo[nLayer][9] > lastTileY) {
                    start = firstTileY;
                    end = lastTileY;
                } else {
                    start = firstTileY;
                    end = s_TilesetLayerInfo[nLayer][9] - 1;
                }
                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[nLayer][0], nLayer, firstTileX, start, lastTileX - firstTileX, end - start, 0, 0);
                GLLibPlayer.s_TilesetLayerInfo[nLayer][9] = firstTileY;
                GLLibPlayer.s_TilesetLayerInfo[nLayer][11] = lastTileY;
            }
            if (g != null) {
                while (originX < 0) {
                    originX += s_TilesetLayerInfo[nLayer][6];
                }
                while (originY < 0) {
                    originY += s_TilesetLayerInfo[nLayer][7];
                }
                int modX0 = originX % s_TilesetLayerInfo[nLayer][6];
                int modY0 = originY % s_TilesetLayerInfo[nLayer][7];
                int modX1 = (originX + destWidth) % s_TilesetLayerInfo[nLayer][6];
                int modY1 = (originY + destHeight) % s_TilesetLayerInfo[nLayer][7];
                if (modX1 > modX0) {
                    if (modY1 > modY0) {
                        GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, modY0, destWidth, destHeight, 0 + dx, 0 + dy);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, modY0, destWidth, destHeight - modY1, 0 + dx, 0 + dy);
                        GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, 0, destWidth, modY1, 0 + dx, destHeight - modY1 + dy);
                    }
                } else if (modY1 > modY0) {
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, modY0, destWidth - modX1, destHeight, 0 + dx, 0 + dy);
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, 0, modY0, modX1, destHeight, destWidth - modX1 + dx, 0 + dy);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, modY0, destWidth - modX1, destHeight - modY1, 0 + dx, 0 + dy);
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, modX0, 0, destWidth - modX1, modY1, 0 + dx, destHeight - modY1 + dy);
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, 0, modY0, modX1, destHeight - modY1, destWidth - modX1 + dx, 0 + dy);
                    GLLibPlayer.Tileset_Draw2Screen(g, nLayer, 0, 0, modX1, modY1, destWidth - modX1 + dx, destHeight - modY1 + dy);
                }
            }
        } else {
            int offsetY;
            int offsetX;
            int nbTileY;
            int nbTileX;
            int tileY0;
            int tileX0;
            if (false) {
                tileX0 = originX >> s_TilesetInfo[3];
                tileY0 = originY >> s_TilesetInfo[6];
                nbTileX = destWidth >> s_TilesetInfo[3];
                if (nbTileX << s_TilesetInfo[3] < destWidth) {
                    ++nbTileX;
                }
                if ((nbTileY = destHeight >> s_TilesetInfo[6]) << s_TilesetInfo[6] < destHeight) {
                    ++nbTileY;
                }
                offsetX = (tileX0 << s_TilesetInfo[3]) - originX;
                offsetY = (tileY0 << s_TilesetInfo[6]) - originY;
            } else {
                int nTmpStartX = originX;
                int nTmpStartY = originY;
                if (nTmpStartX < 0) {
                    nTmpStartX -= s_TilesetInfo[2];
                }
                if (nTmpStartY < 0) {
                    nTmpStartY -= s_TilesetInfo[5];
                }
                tileX0 = nTmpStartX / s_TilesetInfo[2];
                tileY0 = nTmpStartY / s_TilesetInfo[5];
                nbTileX = destWidth / s_TilesetInfo[2];
                if (nbTileX * s_TilesetInfo[2] < destWidth) {
                    ++nbTileX;
                }
                if ((nbTileY = destHeight / s_TilesetInfo[5]) * s_TilesetInfo[5] < destHeight) {
                    ++nbTileY;
                }
                offsetX = tileX0 * s_TilesetInfo[2] - originX;
                offsetY = tileY0 * s_TilesetInfo[5] - originY;
            }
            GLLibPlayer.Tileset_UpdateBuffer(g, nLayer, tileX0, tileY0, nbTileX, nbTileY, offsetX + dx, offsetY + dy);
        }
        if (g != null) {
            g.setClip(cx, cy, cw, ch);
        }
        GLLib.Profiler_EndNamedEvent();
    }

    private static void Tileset_Draw2Screen(Graphics g, int nLayer, int srcX, int srcY, int width, int height, int destX, int destY) {
        g.setClip(destX, destY, width, height);
        g.drawImage(s_TilesetLayerImage[nLayer][0], destX - srcX, destY - srcY, 0);
    }

    private static void Tileset_UpdateBuffer(Graphics gDest, int nLayer, int tileX0, int tileY0, int nbTileX, int nbTileY, int offsetX, int offsetY) {
        int destY;
        int originDestX;
        boolean useCB = GLLibPlayer.isFlag(nLayer, 4);
        boolean repeatX = GLLibPlayer.isFlag(nLayer, 1);
        boolean repeatY = GLLibPlayer.isFlag(nLayer, 2);
        int tileMapWidth = s_TilesetLayerInfo[nLayer][2];
        int tileMapHeight = s_TilesetLayerInfo[nLayer][3];
        byte[] dataArray = s_TilesetLayerData[nLayer][0];
        byte[] flagArray = s_TilesetLayerData[nLayer][1];
        int tileWidth = s_TilesetInfo[2];
        int tileHeight = s_TilesetInfo[5];
        if (useCB) {
            if (false) {
                originDestX = (tileX0 << s_TilesetInfo[3]) % s_TilesetLayerInfo[nLayer][6] + offsetX;
                destY = (tileY0 << s_TilesetInfo[6]) % s_TilesetLayerInfo[nLayer][7] + offsetY;
            } else {
                originDestX = tileX0 * s_TilesetInfo[2] % s_TilesetLayerInfo[nLayer][6] + offsetX;
                destY = tileY0 * s_TilesetInfo[5] % s_TilesetLayerInfo[nLayer][7] + offsetY;
            }
            if (originDestX < 0) {
                originDestX += s_TilesetLayerInfo[nLayer][6];
            }
            if (destY < 0) {
                destY += s_TilesetLayerInfo[nLayer][7];
            }
        } else {
            originDestX = offsetX;
            destY = offsetY;
        }
        if (repeatX) {
            while (tileX0 < 0) {
                tileX0 += tileMapWidth;
            }
            while (tileX0 >= tileMapWidth) {
                tileX0 -= tileMapWidth;
            }
        } else {
            if (tileX0 < 0) {
                nbTileX += tileX0;
                tileX0 = 0;
            }
            if (tileX0 + nbTileX >= tileMapWidth) {
                nbTileX = tileMapWidth - tileX0;
            }
        }
        if (repeatY) {
            while (tileY0 < 0) {
                tileY0 += tileMapHeight;
            }
            while (tileY0 >= tileMapHeight) {
                tileY0 -= tileMapHeight;
            }
        } else {
            if (tileY0 < 0) {
                nbTileY += tileY0;
                tileY0 = 0;
            }
            if (tileY0 + nbTileY >= tileMapHeight && (nbTileY = tileMapHeight - tileY0) == 0) {
                return;
            }
        }
        byte[] alphaDataArray = null;
        byte[] alphaFlagArray = null;
        if (false && nLayer == s_TilesetEffectLayer && s_TilesetAlphaLayer > 0) {
            alphaDataArray = s_TilesetLayerData[s_TilesetAlphaLayer][0];
            alphaFlagArray = s_TilesetLayerData[s_TilesetAlphaLayer][1];
        }
        while (nbTileY-- >= 0) {
            int destX = originDestX;
            int nbX = nbTileX;
            int tileX = tileX0;
            while (nbX-- >= 0) {
                int offsetCur = tileX + tileY0 * tileMapWidth;
                if (!false && offsetCur < dataArray.length || false && offsetCur << 1 < dataArray.length) {
                    boolean emptyIndex;
                    int data;
                    if (false) {
                        data = GLLib.Mem_GetShort(dataArray, offsetCur << 1) & 0xFFFF;
                        emptyIndex = data == 65535;
                    } else {
                        data = dataArray[offsetCur] & 0xFF;
                        boolean bl = emptyIndex = data == 255;
                    }
                    if (!emptyIndex) {
                        int flag = flagArray == null ? 0 : flagArray[offsetCur] & 0xFF;
                        if (s_TilesetSprite[nLayer].GetFrameCount() == 0) {
                            s_TilesetSprite[nLayer].PaintModule(gDest, data, destX, destY, flag);
                        } else {
                            int tx = destX;
                            int ty = destY;
                            if (true) {
                                if ((flag & 1) != 0) {
                                    tx += s_TilesetInfo[2];
                                }
                                if ((flag & 2) != 0) {
                                    ty += s_TilesetInfo[5];
                                }
                            }
                            s_TilesetSprite[nLayer].PaintFrame(gDest, data, tx, ty, flag);
                        }
                        if (false && nLayer == s_TilesetEffectLayer && s_TilesetAlphaLayer > 0) {
                            boolean alphaEmpty;
                            int alphaData;
                            if (false) {
                                alphaData = GLLib.Mem_GetShort(alphaDataArray, offsetCur << 1) & 0xFFFF;
                                alphaEmpty = alphaData == 65535;
                            } else {
                                alphaData = alphaDataArray[offsetCur] & 0xFF;
                                boolean bl = alphaEmpty = alphaData == 255;
                            }
                            if (!alphaEmpty) {
                                int alphaFlag = 0;
                                if (alphaFlagArray != null) {
                                    alphaFlag = alphaFlagArray[offsetCur] & 0xFF;
                                }
                                if (s_TilesetSprite[s_TilesetAlphaLayer].GetFrameCount() != 0) {
                                    alphaData = s_TilesetSprite[s_TilesetAlphaLayer].GetFrameModule(alphaData, 0);
                                }
                                if (s_TilesetEffectType == 2 || s_TilesetEffectType == 3) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].RenderTilesetEffect(gDest, alphaData, s_TilesetLayerImage[nLayer][0], s_TilesetEffectType, destX, destY, tileWidth, tileHeight, alphaFlag);
                                } else if (s_TilesetEffectType == 1) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].PaintModule(gDest, alphaData, destX, destY, alphaFlag);
                                }
                            }
                        }
                    }
                }
                if (++tileX >= tileMapWidth) {
                    if (!repeatX) break;
                    tileX = 0;
                }
                if (!useCB || (destX += tileWidth) < s_TilesetLayerInfo[nLayer][6]) continue;
                destX = 0;
            }
            if (++tileY0 >= tileMapHeight) {
                if (!repeatY) break;
                tileY0 = 0;
            }
            if (!useCB || (destY += tileHeight) < s_TilesetLayerInfo[nLayer][7]) continue;
            destY = 0;
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int nLayer, int y) {
        if (GLLibPlayer.isFlag(nLayer, 8)) {
            return s_TilesetLayerInfo[nLayer][5] - s_TilesetInfo[1] - y;
        }
        return y;
    }

    static final void Tileset_SetCamera(int nLayer, int x, int y) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_SetCamera: Tileset player is not initialized");
            return;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_SetCamera: nLayer invalid : " + nLayer);
            return;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_SetCamera: nLayer in not initialized or not enabled.");
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[nLayer][12] = x;
        GLLibPlayer.s_TilesetLayerInfo[nLayer][13] = GLLibPlayer.Tileset_GetTranslatedOriginY(nLayer, y);
        if (!GLLibPlayer.isFlag(nLayer, 1)) {
            if (s_TilesetLayerInfo[nLayer][12] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[nLayer][12] = 0;
            } else if (s_TilesetLayerInfo[nLayer][12] + s_TilesetInfo[0] > s_TilesetLayerInfo[nLayer][4]) {
                GLLibPlayer.s_TilesetLayerInfo[nLayer][12] = s_TilesetLayerInfo[nLayer][4] - s_TilesetInfo[0];
            }
        }
        if (!GLLibPlayer.isFlag(nLayer, 2)) {
            if (s_TilesetLayerInfo[nLayer][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[nLayer][13] = 0;
            } else if (s_TilesetLayerInfo[nLayer][13] + s_TilesetInfo[1] > s_TilesetLayerInfo[nLayer][5]) {
                GLLibPlayer.s_TilesetLayerInfo[nLayer][13] = s_TilesetLayerInfo[nLayer][5] - s_TilesetInfo[1];
            }
        }
    }

    static final int Tileset_GetLayerWidth(int nLayer) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[nLayer][4];
    }

    static final int Tileset_GetLayerHeight(int nLayer) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[nLayer][5];
    }

    static final int Tileset_GetLayerTileCountWidth(int nLayer) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[nLayer][2];
    }

    static final int Tileset_GetLayerTileCountHeight(int nLayer) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[nLayer][3];
    }

    static final int Tileset_GetTile(int nLayer, int x, int y) {
        y = GLLibPlayer.Tileset_GetTranslatedOriginY(nLayer, y);
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetTile: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetTile: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetTile: nLayer in not initialized or not enabled.");
            return -1;
        }
        if (x < 0 || x > s_TilesetLayerInfo[nLayer][2]) {
            GLLib.Assert(false, "Tileset_GetTile: x value out of bound [" + x + "]  0 <= x < " + s_TilesetLayerInfo[nLayer][2]);
            return -1;
        }
        if (y < 0 || y > s_TilesetLayerInfo[nLayer][3]) {
            GLLib.Assert(false, "Tileset_GetTile: y value out of bound [" + y + "]  0 <= y < " + s_TilesetLayerInfo[nLayer][3]);
            return -1;
        }
        if (false) {
            return GLLib.Mem_GetShort(s_TilesetLayerData[nLayer][0], y * s_TilesetLayerInfo[nLayer][2] + x << 1) & 0xFFFF;
        }
        return s_TilesetLayerData[nLayer][0][y * s_TilesetLayerInfo[nLayer][2] + x] & 0xFF;
    }

    static final int Tileset_GetTileFlags(int nLayer, int x, int y) {
        y = GLLibPlayer.Tileset_GetTranslatedOriginY(nLayer, y);
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetTileFlags: Tileset player is not initialized");
            return -1;
        }
        if (nLayer < 0 || nLayer >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetTileFlags: nLayer invalid : " + nLayer);
            return -1;
        }
        if (s_TilesetLayerInfo[nLayer][0] != 1 || s_TilesetLayerInfo[nLayer][1] != 1) {
            GLLib.Assert(false, "Tileset_GetTileFlags: nLayer in not initialized or not enabled.");
            return -1;
        }
        if (x < 0 || x > s_TilesetLayerInfo[nLayer][2]) {
            GLLib.Assert(false, "Tileset_GetTileFlags: x value out of bound [" + x + "]  0 <= x < " + s_TilesetLayerInfo[nLayer][2]);
            return -1;
        }
        if (y < 0 || y > s_TilesetLayerInfo[nLayer][3]) {
            GLLib.Assert(false, "Tileset_GetTileFlags: y value out of bound [" + y + "]  0 <= y < " + s_TilesetLayerInfo[nLayer][3]);
            return -1;
        }
        if (s_TilesetLayerData[nLayer][1] == null) {
            return 0;
        }
        return s_TilesetLayerData[nLayer][1][y * s_TilesetLayerInfo[nLayer][2] + x] & 0xFF;
    }

    static {
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = 4;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

