/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.InspectorAccusation;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Palette;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class ValidationScene
extends BaseScene {
    public Sprite[] mStarSprites = null;
    public Sprite[] mSprites = null;
    public int mState = 0;
    public Viewport[] mResultViewport = null;
    public GE_Ticker mTicker;
    public TimeSystem mTimeSystem;
    public int mTimeAcc;
    public Text[] mTexts = null;
    public int mCurrentStar;

    public ValidationScene() {
        super(38, 3178593);
        this.AddType(4);
    }

    public final void Initialize() {
        super.Initialize();
        this.mState = 0;
        this.mCurrentStar = 0;
        this.mTicker.Init(this.mViewport);
        this.mTicker.SetTickerMessage(ClueUtils.GetGameString(2));
        this.RegisterInGlobalTime();
        Utilities.StartTimeSystem(this.mTimeSystem);
        this.mTimeAcc = 0;
        this.UpdateText();
        this.UpdateViewports();
        Utilities.PositionComponentInParent(Sprite.Cast$46e644cd(this.mPackage.GetEntryPoint(4)), 7);
    }

    public final void Load() {
        int n;
        super.Load();
        this.mTicker = new GE_Ticker(this);
        this.mTicker.Load();
        this.mTexts = new Text[3];
        for (n = 0; n < this.mTexts.length; ++n) {
            this.mTexts[n] = null;
        }
        this.mSprites = new Sprite[3];
        for (n = 0; n < this.mSprites.length; ++n) {
            this.mSprites[n] = null;
        }
        this.mStarSprites = new Sprite[4];
        for (n = 0; n < this.mStarSprites.length; ++n) {
            this.mStarSprites[n] = null;
        }
        this.mResultViewport = new Viewport[4];
        for (n = 0; n < this.mResultViewport.length; ++n) {
            this.mResultViewport[n] = null;
        }
    }

    public final boolean OnCommand(int n) {
        if (n == 4) {
            GameApp.Get().GetScenarioProcess().Step(11);
        }
        return super.OnCommand(n);
    }

    public final void Unload() {
        int n;
        this.UnRegisterInGlobalTime();
        this.mTicker.Unload();
        this.mTicker = null;
        for (n = 0; n < 3; ++n) {
            this.mTexts[n] = null;
            this.mSprites[n] = null;
        }
        this.mTexts = null;
        this.mSprites = null;
        for (n = 0; n < 4; ++n) {
            this.mStarSprites[n] = null;
        }
        this.mStarSprites = null;
        for (n = 0; n < 4; ++n) {
            this.mResultViewport = null;
        }
        Utilities.StopTimeSystem(this.mTimeSystem);
        super.Unload();
        GameApp.Get().GetMediaPlayer().Terminate();
    }

    public final boolean IsLoaded() {
        return super.IsLoaded();
    }

    private void OnRoomAccusation() {
        if (GameApp.Get().GetScenarioContext().IsCorrectRoom()) {
            this.GiveStar();
        } else {
            ValidationScene.StartVibration();
        }
        this.mState = 2;
    }

    public final void GetEntryPoints() {
        int n;
        super.GetEntryPoints();
        this.mTicker.GetEntryPoints();
        for (int i = 0; i < 3; ++i) {
            this.mSprites[i] = Sprite.Cast$46e644cd(this.mPackage.GetEntryPoint(4 + i));
            if (i == 0) {
                byte[] byArray = Palette.Cast$2ce84be5(this.mPackage.GetEntryPoint(3));
                this.mSprites[i].mBitmap.SetPalette(byArray);
            }
            this.mSprites[i].SetSize(this.mSprites[i].mBitmap.mDataWidth, this.mSprites[i].mBitmap.mDataHeight);
            this.mTexts[i] = Text.Cast$21bacd23(this.mPackage.GetEntryPoint(7 + i));
        }
        for (n = 0; n < 4; ++n) {
            this.mStarSprites[n] = Sprite.Cast$46e644cd(this.mPackage.GetEntryPoint(11 + n));
        }
        this.mTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.GetEntryPoint(10));
        for (n = 0; n < 4; ++n) {
            this.mResultViewport[n] = Viewport.Cast$7c352e71(this.mPackage.GetEntryPoint(25 + n));
        }
    }

    private void OnSuspectAccusation() {
        if (GameApp.Get().GetScenarioContext().IsCorrectSuspect()) {
            this.GiveStar();
        } else {
            this.ChangeBitmap(this.mSprites, 0, 17);
            ValidationScene.StartVibration();
        }
        this.mState = 1;
    }

    private void OnTimeAccusation() {
        if (GameApp.Get().GetScenarioContext().GetOutcome() == 6) {
            this.GiveStar();
        } else {
            ValidationScene.StartVibration();
        }
        this.mState = 4;
    }

    private void OnWeaponAccusation() {
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        if (scenarioContext.IsCorrectWeapon()) {
            this.GiveStar();
        } else {
            this.ChangeBitmap(this.mSprites, 2, 18);
            ValidationScene.StartVibration();
        }
        if (scenarioContext.GetOutcome() == 6) {
            for (int i = 0; i < 3; ++i) {
                Text.Cast$21bacd23(this.mPackage.GetEntryPoint(19 + i)).SetCaption(ValidationScene.GetString(3 + i));
            }
        } else if (scenarioContext.GetOutcome() != 5) {
            for (int i = 0; i < 3; ++i) {
                Text.Cast$21bacd23(this.mPackage.GetEntryPoint(19 + i)).SetCaption(ValidationScene.GetString(0 + i));
            }
        }
        this.mState = 3;
    }

    private void OnQuit() {
        this.OnCommand(this.mSelectSoftKey.GetCommand());
    }

    private void UpdateText() {
        InspectorAccusation inspectorAccusation = GameApp.Get().GetScenarioContext().mAccusations;
        this.mTexts[1].SetCaption(ClueUtils.GetStringForRoom(inspectorAccusation.GetRoomId()));
        this.mTexts[0].SetCaption(ClueUtils.GetStringForSuspect(inspectorAccusation.GetSuspectId()));
        this.mTexts[2].SetCaption(ClueUtils.GetStringForWeapon(inspectorAccusation.GetWeaponId()));
    }

    private void UpdateViewports() {
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        this.UpdateViewport(this.mResultViewport[0], scenarioContext.IsCorrectSuspect());
        this.UpdateViewport(this.mResultViewport[1], scenarioContext.IsCorrectRoom());
        this.UpdateViewport(this.mResultViewport[2], scenarioContext.IsCorrectWeapon());
        Viewport viewport = this.mResultViewport[3];
        boolean bl = scenarioContext.GetOutcome() == 6;
        this.UpdateViewport(viewport, bl);
    }

    public final void SerializeObjects() {
        GameApp.Get().GetScenarioProcess().OnSerialize();
    }

    private void UpdateViewport(Viewport viewport, boolean bl) {
        IndexedSprite indexedSprite = (IndexedSprite)viewport.GetChild(0);
        IndexedSprite indexedSprite2 = (IndexedSprite)viewport.GetChild(1);
        IndexedSprite indexedSprite3 = (IndexedSprite)viewport.GetChild(2);
        Text text = (Text)viewport.GetChild(3);
        if (bl) {
            FlString flString = ValidationScene.GetString(17);
            short s = (short)FlFont.Cast$be01453(((BaseScene)((Object)flString)).mPackage.GetEntryPoint(23)).GetLineWidth(flString);
            text.SetSize(s, text.GetLineHeight());
            text.SetCaption(flString);
            indexedSprite2.SetSize(s, indexedSprite2.mRect_height);
            indexedSprite3.SetTopLeft((short)(indexedSprite.mRect_width + indexedSprite2.mRect_width), indexedSprite3.mRect_top);
        } else {
            FlString flString;
            FlFont flFont = FlFont.Cast$be01453(((BaseScene)((Object)flString)).mPackage.GetEntryPoint(24));
            FlBitmapMap flBitmapMap = FlBitmapMap.Cast$4864501b(((BaseScene)((Object)flString)).mPackage.GetEntryPoint(22));
            indexedSprite.SetBitmapMap(flBitmapMap);
            indexedSprite.SetCurrentFrame(0);
            short s = Vector2_short.GetY_(indexedSprite.GetSize());
            short s2 = Vector2_short.GetX_(indexedSprite.GetSize());
            indexedSprite.SetSize(s2, s);
            indexedSprite.SetTopLeft((short)0, (short)0);
            flString = ValidationScene.GetString(18);
            short s3 = (short)flFont.GetLineWidth(flString);
            text.SetFont(flFont);
            text.SetSize(s3, text.GetLineHeight());
            text.SetCaption(flString);
            indexedSprite2.SetBitmapMap(flBitmapMap);
            indexedSprite2.SetCurrentFrame(1);
            s3 = text.mRect_width;
            indexedSprite2.mTileInX = true;
            indexedSprite2.SetSize(s3, s);
            indexedSprite2.SetTopLeft(s2, (short)0);
            indexedSprite3.SetBitmapMap(flBitmapMap);
            indexedSprite3.SetCurrentFrame(2);
            indexedSprite3.SetSize(Vector2_short.GetX_(indexedSprite3.GetSize()), s);
            indexedSprite3.SetTopLeft((short)(s2 + s3), (short)0);
        }
        viewport.SetSize((short)(indexedSprite.mRect_width + indexedSprite2.mRect_width + indexedSprite3.mRect_width), viewport.mRect_height);
    }

    private static void StartVibration() {
        GameApp.Get().GetMediaPlayer().StartVibration(500);
    }

    private void GiveStar() {
        int n;
        int n2 = this.mCurrentStar;
        this.mCurrentStar = n = n2 + 1;
        this.ChangeBitmap(this.mStarSprites, n2, 15);
        int n3 = 6 + this.mCurrentStar - 1;
        GameApp.Get().GetMediaPlayer().PlayMusic(n3);
    }

    private void ChangeBitmap(Sprite[] spriteArray, int n, int n2) {
        FlBitmap flBitmap = FlBitmap.Cast$5822fcd3(this.mPackage.GetEntryPoint(n2));
        spriteArray[n].SetBitmap(flBitmap);
    }

    private static FlString GetString(int n) {
        MetaPackage metaPackage = GameLibrary.GetPackage(-2131853131);
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public final void OnTime(int n, int n2) {
        this.mTimeAcc += n2;
        switch (this.mState) {
            case 0: {
                if (this.mTimeAcc < 4600) break;
                this.OnSuspectAccusation();
                break;
            }
            case 1: {
                if (this.mTimeAcc < 11700) break;
                this.OnRoomAccusation();
                break;
            }
            case 2: {
                if (this.mTimeAcc < 18600) break;
                this.OnWeaponAccusation();
                break;
            }
            case 3: {
                if (this.mTimeAcc < 24000) break;
                this.OnTimeAccusation();
                break;
            }
            case 4: {
                if (this.mTimeAcc < 27000) break;
                this.OnQuit();
                this.UnRegisterInGlobalTime();
            }
        }
        super.OnTime(n, n2);
    }
}

