/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.RoomVisibility;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.SuspectVisibility;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Viewport;
import ca.jamdat.flight.WeaponVisibility;

public final class Utilities {
    public static void TrimString(FlString flString) {
        while (flString.GetLength() > 0 && flString.GetCharAt(0) == 32) {
            flString.RemoveCharAt(0);
        }
        Utilities.RightTrim(flString);
    }

    private static void RightTrim(FlString flString) {
        new FlString(flString);
        for (int i = flString.GetLength(); i > 0 && flString.GetCharAt(i - 1) == 32; --i) {
            flString.RemoveCharAt(i - 1);
        }
    }

    public static void StartTimeSystem(TimeSystem timeSystem) {
        timeSystem.RegisterInGlobalTime();
        timeSystem.mTotalTime = 0;
        timeSystem.SetTimeFlowSpeed(F32.FromInt(1, 16));
        timeSystem.Start();
        timeSystem.OnTime(0, 0);
        timeSystem.RefreshAllControllersIncluded();
    }

    public static void StopTimeSystem(TimeSystem timeSystem) {
        if (timeSystem != null) {
            timeSystem.Stop();
            timeSystem.UnRegisterInGlobalTime();
        }
    }

    public static void StartTimeSystemInverse(TimeSystem timeSystem, int n) {
        timeSystem.RegisterInGlobalTime();
        timeSystem.mTotalTime = n;
        timeSystem.SetTimeFlowSpeed(F32.FromInt(-1, 16));
        timeSystem.Start();
        timeSystem.OnTime(0, 0);
        timeSystem.RefreshAllControllersIncluded();
    }

    public static int MinMaxLimit(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static int Max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static void SetCaption(Text text, FlString flString) {
        text.SetCaption(new FlString(flString));
    }

    public static void SetCheckboxFrame(Selection selection, IndexedSprite indexedSprite, boolean bl) {
        int n = 1;
        if (bl) {
            n = 0;
        }
        if (selection.DescendentOrSelfHasFocus()) {
            n += 2;
        }
        indexedSprite.SetCurrentFrame(n);
    }

    public static boolean IsSelectionChecked(Selection selection) {
        SuspectVisibility suspectVisibility = GameApp.Get().GetScenarioContext().mSuspectVisibility;
        WeaponVisibility weaponVisibility = GameApp.Get().GetScenarioContext().mWeaponVisibility;
        RoomVisibility roomVisibility = GameApp.Get().GetScenarioContext().mRoomVisibility;
        short s = selection.mCommand;
        int n = Utilities.GetSelectionIndexFromCommmand((Selector)selection.m_pViewport.m_pViewport, s);
        boolean bl = false;
        if (s >= 56 && s <= 61) {
            bl = suspectVisibility.GetSuspectVisibility(n);
        } else if (s >= 62 && s <= 70) {
            bl = weaponVisibility.GetWeaponVisibility(n - 6);
        } else if (s >= 71 && s <= 78) {
            bl = roomVisibility.GetRoomVisibility(n - 6 - 9);
        }
        return !bl;
    }

    public static Viewport GetSceneViewportFromChild(Component component) {
        component = component.m_pViewport;
        do {
            if (((Viewport)component).mSubtype != -12) continue;
            return component;
        } while ((component = component.m_pViewport) != null);
        return null;
    }

    private static Selector GetParentSelectorFromSelection(Selection viewport) {
        while (viewport != null) {
            if (viewport instanceof Selector) {
                return (Selector)viewport;
            }
            viewport = viewport.m_pViewport;
        }
        return null;
    }

    public static void UpdateArrowsVisualState(Selection viewport, Viewport viewport2) {
        if ((viewport = Utilities.GetParentSelectorFromSelection((Selection)viewport)) != null) {
            int n;
            int n2 = -1;
            int n3 = -1;
            int n4 = ((Selector)viewport).GetNumSelections() - 1;
            for (n = 0; n < n4; ++n) {
                if (n3 == -1 && ((Selector)viewport).GetSelectionAt((int)n).mEnabled) {
                    n3 = n;
                }
                if (n2 == -1 && ((Selector)viewport).GetSelectionAt((int)(n4 - n)).mEnabled) {
                    n2 = n4 - n;
                }
                if ((n3 | n2) != -1) break;
            }
            n = ((Selector)viewport).mCurrentSelectionIndex != n3 && n3 != n2 ? 1 : 0;
            viewport2.GetChild(0).SetVisible(n != 0);
            n = ((Selector)viewport).mCurrentSelectionIndex != n2 && n3 != n2 ? 1 : 0;
            viewport2.GetChild(1).SetVisible(n != 0);
        }
    }

    private static void PositionComponent(Component component, int n, int n2) {
        Viewport viewport = component.m_pViewport;
        short s = component.mRect_width;
        short s2 = component.mRect_height;
        short s3 = viewport.mRect_width;
        short s4 = viewport.mRect_height;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = s4 / 2 - s2 / 2;
                break;
            }
            case 1: {
                n4 = s4 - s2;
            }
        }
        switch (n2) {
            case 3: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = s3 / 2 - s / 2;
                break;
            }
            case 4: {
                n3 = s3 - s;
            }
        }
        component.SetTopLeft((short)n3, (short)n4);
    }

    public static int GetComponentIndex(Component component) {
        int n = -1;
        Viewport viewport = component.m_pViewport;
        if (viewport != null) {
            int n2 = viewport.GetChildCount();
            for (int i = 0; i < n2 && n == -1; ++i) {
                if (viewport.GetChild(i) != component) continue;
                n = i;
            }
        }
        return n;
    }

    public static int GetKeyValue(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        return -1;
    }

    public static int GetSelectionIndexFromCommmand(Selector selector, int n) {
        int n2 = selector.GetNumSelections();
        for (int i = 0; i < n2; ++i) {
            if (selector.GetSelectionAt((int)i).mCommand != n) continue;
            return i;
        }
        return -1;
    }

    public static void AddSelection(Selector selector, Selection selection, int n) {
        int n2;
        selection.SetVisible(true);
        selector.mNumElements = n2 = selector.GetNumSelections() + 1;
        short s = selection.mRect_height;
        for (n2 = v52786; n2 > n; --n2) {
            selector.SetElementAt(n2, selector.GetElementAt(n2 - 1));
            selector.GetElementAt(n2).SetTopLeft((short)0, (short)(n2 * s));
        }
        selector.SetElementAt(n, selection);
        selection.SetTopLeft((short)0, (short)(n * s));
        selector.UpdateScroller();
    }

    public static void RemoveSelection(Selector selector, int n) {
        selector.GetElementAt(n).SetVisible(false);
        int n2 = selector.GetNumSelections();
        short s = selector.GetElementAt((int)n).mRect_height;
        while (n < n2 - 1) {
            selector.SetElementAt(n, selector.GetElementAt(n + 1));
            selector.GetElementAt(n).SetTopLeft((short)0, (short)(n * s));
            ++n;
        }
        selector.mNumElements = n2 - 1;
        selector.UpdateScroller();
    }

    public static void PositionComponentInParent(Component component, int n) {
        switch (n) {
            case 0: {
                Utilities.PositionComponent(component, 0, 3);
                return;
            }
            case 1: {
                Utilities.PositionComponent(component, 0, 2);
                return;
            }
            case 2: {
                Utilities.PositionComponent(component, 0, 4);
                return;
            }
            case 3: {
                Utilities.PositionComponent(component, 2, 3);
                return;
            }
            case 4: {
                Utilities.PositionComponent(component, 2, 2);
                return;
            }
            case 5: {
                Utilities.PositionComponent(component, 2, 4);
                return;
            }
            case 6: {
                Utilities.PositionComponent(component, 1, 3);
                return;
            }
            case 7: {
                Utilities.PositionComponent(component, 1, 2);
                return;
            }
            case 8: {
                Utilities.PositionComponent(component, 1, 4);
            }
        }
    }

    public static void Trunc(FlString flString, int n, FlFont flFont) {
        if (flFont.GetLineWidth(flString) > n) {
            Utilities.RightTrim(flString);
            if (flString.IsEmpty()) {
                flString.AddAssign(StringUtils.CreateString(" "));
                return;
            }
            flString.AddAssign(StringUtils.CreateString("..."));
            int n2 = flFont.GetLineWidth(flString);
            while (n2 >= n) {
                flString.RemoveCharAt(flString.GetLength() - 4);
                n2 = flFont.GetLineWidth(flString);
            }
            while (flString.GetCharAt(flString.GetLength() - 2) == 32) {
                flString.RemoveCharAt(flString.GetLength() - 2);
            }
        }
    }

    public static void Trunc(Text text, FlString object, int n) {
        FlString flString = new FlString((FlString)object);
        object = text.m_pViewport;
        int n2 = Utilities.GetComponentIndex(text);
        text.SetViewport(null);
        text.SetCaption(new FlString(flString));
        if (text.GetLineWidth() > n) {
            Utilities.RightTrim(flString);
            if (flString.IsEmpty()) {
                flString.AddAssign(StringUtils.CreateString(" "));
                return;
            }
            flString.AddAssign(StringUtils.CreateString("..."));
            text.SetCaption(new FlString(flString));
            short s = text.GetLineWidth();
            while (s >= n) {
                flString.RemoveCharAt(flString.GetLength() - 4);
                text.SetCaption(new FlString(flString));
                s = text.GetLineWidth();
            }
            while (flString.GetCharAt(flString.GetLength() - 2) == 32) {
                flString.RemoveCharAt(flString.GetLength() - 2);
            }
        }
        Utilities.SetCaption(text, flString);
        text.SetViewport((Viewport)object);
        if (n2 != -1 && n2 != ((Viewport)object).GetChildCount() - 1) {
            ((Viewport)object).PutComponentInFront(text, ((Viewport)object).GetChild(n2));
        }
    }

    public static void ToUpper(FlString flString) {
        int n = flString.GetLength();
        for (int i = 0; i < n; ++i) {
            byte by = flString.GetCharAt(i);
            if (by < 97 || by > 122) continue;
            flString.ReplaceCharAt(i, (byte)(by - 32));
        }
    }
}

