/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlPenManager;
import ca.jamdat.flight.Viewport;

public final class Scene
extends Viewport {
    public Scene mReturnScene;

    public final boolean OnDefaultMsg(Component component, int n, int n2) {
        switch (n) {
            case -111: {
                this.CompleteTransition();
                return true;
            }
            case -112: {
                component.SetViewport(null);
                return true;
            }
            case -110: {
                Scene scene = (Scene)component;
                while (scene != this) {
                    scene.mReturnScene = null;
                    scene.mReturnScene.SendMsg(scene, -112, -1);
                }
                return true;
            }
            case -109: {
                if (this.mReturnScene != null) {
                    this.DetachAndSkip(component, n, n2);
                } else {
                    FlApplication flApplication = FlApplication.GetInstance();
                    this.SendMsg(flApplication.mCurrentScene, -110, -1);
                    flApplication.mCurrentScene = this;
                    flApplication.mCurrentTransitionType = 0;
                    Scene.Dismiss(-3);
                }
                return true;
            }
        }
        return false;
    }

    private static void Dismiss(int n) {
        FlApplication flApplication = FlApplication.GetInstance();
        Scene scene = flApplication.mCurrentScene;
        Scene scene2 = scene.mReturnScene;
        if (scene2 != null) {
            Scene.StartTransition((byte)1, scene2, n);
            return;
        }
        flApplication.TakeFocus();
        FlPenManager.Get().Deactivate();
        flApplication.mCurrentScene = null;
        scene.SetViewport(null);
    }

    private void CompleteTransition() {
        FlApplication flApplication = FlApplication.GetInstance();
        byte by = flApplication.mCurrentTransitionType;
        Scene scene = by == 1 ? flApplication.mCurrentScene : this.mReturnScene;
        Scene scene2 = scene;
        Viewport viewport = null;
        if (scene != null) {
            if (this.m_pViewport == null) {
                viewport = scene.m_pViewport;
            }
            if (by == 1) {
                this.SendMsg(scene2, -110, -1);
                flApplication.mCurrentScene = this;
            } else if (by == 2) {
                scene2.SetViewport(null);
            }
            if (viewport != null) {
                this.SetViewport(viewport);
            }
        }
        flApplication.ResetDownKeys();
        this.TakeFocus();
        FlPenManager.Get().Activate();
        flApplication.mCurrentTransitionType = 0;
    }

    private void DetachAndSkip(Component component, int n, int n2) {
        this.SetViewport(null);
        this.mReturnScene.SendMsg(component, n, n2);
    }

    private static void StartTransition(byte by, Scene scene, int n) {
        FlApplication flApplication = FlApplication.GetInstance();
        if (n == -2) {
            scene.mReturnScene = flApplication.mCurrentScene;
            flApplication.mCurrentScene = scene;
        }
        flApplication.mCurrentTransitionType = by;
        flApplication.TakeFocus();
        FlPenManager.Get().Deactivate();
        scene.SendMsg(flApplication.mCurrentScene, -111, n);
    }
}

