/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IntroductionScene;
import ca.jamdat.flight.MainMenu;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.ProgressionScene;
import ca.jamdat.flight.PublishScene;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.ScenarioLoader;
import ca.jamdat.flight.ScenarioLoadingScene;
import ca.jamdat.flight.ScenarioMediator;
import ca.jamdat.flight.ScenarioSelectMenu;
import ca.jamdat.flight.ScenarioUtils;
import ca.jamdat.flight.TutorialSteps;
import ca.jamdat.flight.TutorialStepsFactory;
import ca.jamdat.flight.ValidationScene;

public final class ScenarioProcess {
    public int mState = 0;
    public ScenarioMediator mMediator;
    public ScenarioLoader mScenarioLoader;

    private void ReleaseScenarioResources() {
        if (this.HasValidScenarioId()) {
            GameApp.Get().GetSharedResourcesHandler().ReleaseScenarioRessources();
        }
    }

    public ScenarioProcess() {
        this.mMediator = new ScenarioMediator(GameApp.Get().GetSettings().mProgress, GameApp.Get().GetSettings().mStarReward);
    }

    public final void OnDelete() {
        this.ReleaseScenarioLoader();
        this.mMediator.OnDelete();
        this.mMediator = null;
    }

    public final void ResetMediator() {
        this.mMediator.OnDelete();
        this.mMediator = null;
        this.mMediator = new ScenarioMediator(GameApp.Get().GetSettings().mProgress, GameApp.Get().GetSettings().mStarReward);
    }

    public final BaseScene GetNextScene() {
        BaseScene baseScene = null;
        if (this.mState == 1 || this.mState == 6) {
            baseScene = GameApp.Get().GetScenarioProcess().mMediator.GetTotalStars() <= 0 ? new MainMenu(8, 2654289) : new ScenarioSelectMenu(this.mMediator);
        } else if (this.mState == 2) {
            baseScene = new ScenarioLoadingScene();
        } else if (this.mState == 3) {
            baseScene = new IntroductionScene();
        } else if (this.mState == 4) {
            baseScene = GameApp.Get().GetScenarioContext().HasMoreTime() ? new RTActionScene() : new PublishScene();
        } else if (this.mState == 5) {
            baseScene = new ValidationScene();
        } else if (this.mState == 7) {
            baseScene = new ProgressionScene();
        }
        return baseScene;
    }

    public final void QuitScenario() {
        this.mState = 0;
        GameApp.Get().GetScenarioContext().OnQuit();
        this.ReleaseScenarioResources();
    }

    private void CreateScenarioLoader() {
        this.mScenarioLoader = new ScenarioLoader(this.GetScenarioId(), this.GetVariation());
    }

    private static void InvalidateScenarioSave() {
        GameApp.Get().GetFileManager().GetOutputSegmentStream(4).SetValidDataFlag(false);
    }

    private void Introduced$255f295() {
        this.mState = 4;
        GameApp.Get().GetScenarioContext().OnEvent(16);
    }

    private void Loaded$255f295() {
        TutorialSteps tutorialSteps = TutorialStepsFactory.BuildTutorialSteps(this.GetScenarioId());
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        scenarioContext.Initialize(this.mScenarioLoader.GetScenario(), tutorialSteps);
        this.ReadScenario();
        if (scenarioContext.mState == 6) {
            this.mState = 3;
            return;
        }
        if (scenarioContext.mState == 0) {
            this.mState = 5;
            return;
        }
        if (scenarioContext.mState == 7) {
            this.mState = 7;
            return;
        }
        this.mState = 4;
    }

    private void Play$255f295(int n) {
        if (n == 7) {
            this.mMediator.OnCompleted();
        }
        if (n == 8) {
            this.mState = 6;
            return;
        }
        if (n == 10) {
            this.mState = 5;
            GameApp.Get().GetScenarioContext().OnEvent(1);
            return;
        }
        if (n == 11) {
            this.mState = 7;
            GameApp.Get().GetScenarioContext().OnEvent(20);
            return;
        }
        if (n != 9 && n != 10) {
            this.QuitScenario();
        }
    }

    private void Abandon$255f295() {
        if (GameApp.Get().GetScenarioProcess().mMediator.GetTotalStars() <= 0) {
            ScenarioProcess.InvalidateScenarioSave();
            this.QuitScenario();
            this.mMediator.OnCancel();
            return;
        }
        this.mState = 1;
        GameApp.Get().GetScenarioContext().OnEvent(0);
        GameApp.Get().GetScenarioContext().OnQuit();
        ScenarioProcess.InvalidateScenarioSave();
        this.ReleaseScenarioResources();
    }

    private void Select$255f295(int n) {
        if (n == 3) {
            this.mMediator.OnCancel();
            this.mState = 0;
            return;
        }
        this.mState = 2;
        this.CreateScenarioLoader();
    }

    private void Start$255f295(int n) {
        if (n == 0) {
            this.mMediator.OnNewGame();
            ScenarioProcess.InvalidateScenarioSave();
            if (this.mMediator.GetTotalStars() == 0) {
                this.mMediator.SetCurrentElement(0);
                this.Select$255f295(2);
                return;
            }
            this.mState = 1;
            return;
        }
        this.Select$255f295(2);
    }

    private void Validation$255f295(int n) {
        if (n == 11) {
            this.mState = 7;
            GameApp.Get().GetScenarioContext().OnEvent(20);
        }
    }

    private void Progression$255f295(int n) {
        if (n == 7) {
            GameApp.Get().GetScenarioContext().OnEvent(2);
            GameApp.Get().GetScenarioContext().OnQuit();
            ScenarioProcess.InvalidateScenarioSave();
            this.ReleaseScenarioResources();
            this.mMediator.OnCompleted();
            this.mState = 0;
        }
    }

    private int GetScenarioId() {
        return this.mMediator.mCurrentId;
    }

    private int GetVariation() {
        return this.mMediator.GetVariation();
    }

    private void ReleaseScenarioLoader() {
        if (this.mScenarioLoader != null) {
            this.mScenarioLoader = null;
        }
    }

    private void ReadScenario() {
        FileSegmentStream fileSegmentStream = GameApp.Get().GetFileManager().GetInputSegmentStream(4);
        if (fileSegmentStream.mValidData) {
            GameApp.Get().GetScenarioContext().Read(fileSegmentStream);
            GameApp.Get().GetScenarioContext().OnEvent(24);
            return;
        }
        GameApp.Get().GetScenarioContext().OnEvent(17);
    }

    private void WriteScenario() {
        FileSegmentStream fileSegmentStream = GameApp.Get().GetFileManager().GetOutputSegmentStream(4);
        GameApp.Get().GetScenarioContext().Write(fileSegmentStream);
        fileSegmentStream.SetValidDataFlag(true);
        fileSegmentStream.FillSegmentToCapacity();
    }

    public final void Step(int n) {
        this.Step$255f295(n);
    }

    public final void UnloadScenarioLoader() {
        this.mScenarioLoader.Unload();
        this.ReleaseScenarioLoader();
    }

    public final void Step$255f295(int n) {
        switch (this.mState) {
            case 0: {
                this.Start$255f295(n);
                return;
            }
            case 1: {
                this.Select$255f295(n);
                return;
            }
            case 2: {
                this.Loaded$255f295();
                return;
            }
            case 3: {
                this.Introduced$255f295();
                return;
            }
            case 4: {
                this.Play$255f295(n);
                return;
            }
            case 6: {
                this.Abandon$255f295();
                return;
            }
            case 5: {
                this.Validation$255f295(n);
                return;
            }
            case 7: {
                this.Progression$255f295(n);
            }
        }
    }

    public final boolean HasValidScenarioId() {
        return this.GetScenarioId() != -1;
    }

    public final void OnSerialize() {
        this.WriteScenarioId();
        this.WriteScenario();
    }

    public final void ReadScenarioId() {
        FileSegmentStream fileSegmentStream = GameApp.Get().GetFileManager().GetInputSegmentStream(2);
        if (fileSegmentStream.mValidData) {
            this.mMediator.Read(fileSegmentStream);
        }
    }

    public final void WriteScenarioId() {
        if (this.mState == 1) {
            this.mMediator.OnCancel();
        }
        FileSegmentStream fileSegmentStream = GameApp.Get().GetFileManager().GetOutputSegmentStream(2);
        this.mMediator.Write(fileSegmentStream);
        fileSegmentStream.SetValidDataFlag(true);
    }

    public final MetaPackage GetStringPackage() {
        return GameLibrary.GetPackage(ScenarioUtils.GetStringPackageId(this.GetScenarioId(), this.GetVariation()));
    }

    public final void AcquireScenarioResources() {
        GameApp.Get().GetSharedResourcesHandler().AcquireScenarioRessources(ScenarioUtils.GetStringPackageId(this.GetScenarioId(), this.GetVariation()));
    }
}

