/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.TimeControlled;

public abstract class RTActionSceneState
extends TimeControlled {
    public int mSubState;
    public int mNextState;
    public GE_DialogBox mDialogBox;
    public GE_Ticker mTicker;
    public RTActionScene mRTActionScene;
    public GE_Room mRoom;
    public GE_NavTab mNavTab;

    public RTActionSceneState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_NavTab gE_NavTab) {
        this.mDialogBox = gE_DialogBox;
        this.mRoom = gE_Room;
        this.mTicker = gE_Ticker;
        this.mNavTab = gE_NavTab;
        this.mNextState = 12;
        this.mSubState = 0;
        this.mRTActionScene = rTActionScene;
    }

    public void OnDelete() {
        this.UnRegisterInGlobalTime();
    }

    public final boolean CanTreatKeyEvents() {
        return this.mSubState == 3;
    }

    public void OnNavTabAccess() {
    }

    public boolean HasOpeningAnims() {
        return true;
    }

    public final void OnOpeningAnimsEnded() {
        this.NextState();
    }

    public void StartClosingAnims(int n) {
        this.mNextState = n;
        this.StartClosingAnimsCommon();
    }

    public void EndClosingAnims() {
        this.UnRegisterInGlobalTime();
        this.Leave();
    }

    public final void StartClosingAnimsCommon() {
        this.UpdateSoftkeys(4, 0, 8, -14);
        if (this.HasClosingAnims()) {
            this.RegisterInGlobalTime();
            this.mSubState = 4;
            return;
        }
        this.Leave();
    }

    public boolean HasClosingAnims() {
        return false;
    }

    public void Leave() {
        if (this.mNextState != 12) {
            this.mRTActionScene.SetRTActionSceneState(this.mNextState);
        }
    }

    public abstract void SetDefaultSoftkeys();

    public void Execute() {
        this.SetDefaultSoftkeys();
    }

    public void EndOpeningAnims() {
        this.UnRegisterInGlobalTime();
        this.OnOpeningAnimsEnded();
    }

    public void ShowEditor() {
    }

    public static FlString GetStringFromRTActionScenePackage(int n) {
        MetaPackage metaPackage = GameLibrary.GetPackage(3080286);
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public final void NextState() {
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        if (scenarioContext.GetNotifier() != -1) {
            this.mRTActionScene.ShowNotification(scenarioContext.GetNotifier());
            this.mRoom.SetPassThroughTouchShields(true);
            return;
        }
        this.OnIdle();
        this.SetDefaultSoftkeys();
        this.mRoom.SetPassThroughTouchShields(false);
    }

    public final void OnIdle() {
        this.mSubState = 3;
        this.Execute();
    }

    public boolean OnPenUp(byte by, short[] sArray) {
        return false;
    }

    public final void ConfigureSceneFor(int n) {
        if (n == 2) {
            this.mNavTab.SetActive(true);
            this.ShowEditor();
        }
        this.mSubState = 2;
        this.mRoom.ActiveSetVisibleShadow(true);
    }

    public void OnHideNotification() {
        this.mRoom.ActiveSetVisibleShadow(true);
        this.NextState();
    }

    public boolean OnPenDown(byte by, short[] sArray) {
        return false;
    }

    public void OnTime(int n, int n2) {
        super.OnTime(n, n2);
        switch (this.mSubState) {
            case 1: {
                if (!this.IsOpeningAnimsEnded()) break;
                this.EndOpeningAnims();
                return;
            }
            case 4: {
                if (!this.IsClosingAnimsEnded()) break;
                this.EndClosingAnims();
            }
        }
    }

    public boolean OnPenMove(byte by, short[] sArray, short[] sArray2, short[] sArray3) {
        return false;
    }

    public void Init() {
    }

    public boolean OnCommand(int n) {
        return false;
    }

    public void StartOpeningAnims() {
        this.UpdateSoftkeys(4, 0, 8, -14);
        this.RegisterInGlobalTime();
        this.mSubState = 1;
    }

    public boolean IsOpeningAnimsEnded() {
        return this.mRoom.IsTransitionFinished();
    }

    public final void ReceiveFocus() {
        if (this.HasOpeningAnims()) {
            this.StartOpeningAnims();
            return;
        }
        this.NextState();
    }

    public void StartClosingAnims() {
        this.StartClosingAnimsCommon();
    }

    public boolean IsClosingAnimsEnded() {
        return true;
    }

    public final void UpdateSoftkeys(int n, int n2, int n3, int n4) {
        this.mRTActionScene.UpdateSoftkeys(n, n2, n3, n4);
    }

    public boolean OnKeyDown(int n) {
        return false;
    }

    public boolean OnKeyUp(int n) {
        return false;
    }

    public boolean OnKeyDownOrRepeat(int n) {
        return false;
    }
}

