/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_Clock;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_SelectionPopUp;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;
import ca.jamdat.flight.Suspect;

public final class RTA_ConfrontState
extends RTActionSceneState {
    public int[] mConfrontChoices = null;
    public GE_Clock mClock;
    public GE_SelectionPopUp mSelectionPopUp;

    public final boolean OnPenDown(byte by, short[] sArray) {
        return this.mSelectionPopUp.OnPenDown(by, sArray) || super.OnPenDown(by, sArray);
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2, short[] sArray3) {
        return this.mSelectionPopUp.OnPenMove(by, sArray, sArray2, sArray3) || super.OnPenMove(by, sArray, sArray2, sArray3);
    }

    public final void OnDelete() {
        this.mConfrontChoices = null;
        super.OnDelete();
    }

    public final void Init() {
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(13));
        ClueUtils.ReplaceAllSuspectIDInString(flString, GameApp.Get().GetScenarioContext().GetSuspect().GetSuspectId());
        this.mTicker.SetTickerMessage(flString);
        this.InitSelectionPopUp();
        super.Init();
        if (GameApp.Get().GetScenarioContext().GetSuspect().GetConfrontSpeech() == 2) {
            GameApp.Get().GetMediaPlayer().PlayMusic(17);
        }
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        if (n == 30) {
            suspect.NextSpeech();
            this.OnExit(4, suspect.GetSuspectId());
        } else if (n == 11) {
            if (suspect.GetConfrontSpeech() == 5) {
                suspect.NextSpeech();
            }
            this.StartClosingAnims(4);
        } else if (n == 9) {
            suspect.NextSpeech();
            this.OnExit(5, suspect.GetSuspectId());
        } else if (n == 31) {
            suspect.NextSpeech();
            this.Confront();
        } else if (n == 29) {
            this.OnNextConfront();
        } else {
            bl = false;
        }
        return bl || super.OnCommand(n);
    }

    public final void Leave() {
        this.mDialogBox.Hide();
        this.mSelectionPopUp.Hide();
        this.mTicker.StopTicker();
        this.mConfrontChoices = null;
        super.Leave();
    }

    public final void Execute() {
        super.Execute();
        this.Confront();
    }

    public final void SetDefaultSoftkeys() {
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        if (suspect.GetConfrontSpeech() == 3) {
            this.UpdateSoftkeys(7, 31, 8, -14);
            return;
        }
        if (suspect.GetConfrontSpeech() == 5 && suspect.HasMoreSpeech()) {
            this.UpdateSoftkeys(7, 9, 8, -14);
            return;
        }
        if (suspect.GetConfrontSpeech() == 2) {
            this.UpdateSoftkeys(7, 26, 1, 11);
            return;
        }
        if (suspect.HasMoreSpeech()) {
            this.UpdateSoftkeys(7, 29, 8, -14);
            return;
        }
        if (suspect.GetConfrontSpeech() == 5) {
            this.UpdateSoftkeys(7, 30, 8, -14);
            return;
        }
        this.UpdateSoftkeys(7, 11, 8, -14);
    }

    public RTA_ConfrontState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_SelectionPopUp gE_SelectionPopUp, GE_NavTab gE_NavTab, GE_Clock gE_Clock) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        this.mSelectionPopUp = gE_SelectionPopUp;
        this.mClock = gE_Clock;
        GameApp.Get().GetScenarioContext().OnEvent(7, GameApp.Get().GetScenarioContext().GetSuspect().GetSuspectId());
        this.mConfrontChoices = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.mConfrontChoices[i] = GameApp.Get().GetScenarioContext().GetSuspect().GetConfrontChoice(i);
        }
        this.mRoom.SetState(8);
    }

    private void Confront() {
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        switch (suspect.GetConfrontSpeech()) {
            case 2: {
                this.InitSelectionPopUp();
                this.mDialogBox.Hide();
                this.mRoom.SetState(8);
                this.mSelectionPopUp.Show(suspect.GetConfrontString(0), suspect.GetConfrontString(RTA_ConfrontState.GetConfrontStringId(this.mConfrontChoices[0], false)), suspect.GetConfrontString(RTA_ConfrontState.GetConfrontStringId(this.mConfrontChoices[1], false)), suspect.GetConfrontString(RTA_ConfrontState.GetConfrontStringId(this.mConfrontChoices[2], false)));
                break;
            }
            case 3: {
                this.mSelectionPopUp.Hide();
                FlString flString = suspect.GetConfrontString(RTA_ConfrontState.GetConfrontStringId(GameApp.Get().GetScenarioContext().GetSuspect().GetAnswer(), true));
                this.mRoom.SetState(5);
                this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
                break;
            }
            case 4: {
                this.mSelectionPopUp.Hide();
                FlString flString = suspect.GetConfrontString(6);
                this.mRoom.SetState(5);
                this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
                break;
            }
            case 5: {
                GameApp.Get().GetMediaPlayer().PlayMusic(20);
                this.mSelectionPopUp.Hide();
                FlString flString = suspect.GetConfrontString(7);
                this.mRoom.SetState(5);
                this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
            }
        }
        this.SetDefaultSoftkeys();
    }

    private void InitSelectionPopUp() {
        this.mSelectionPopUp.IsInConfrontationState(true);
        for (int i = 0; i < 3; ++i) {
            boolean bl = GameApp.Get().GetScenarioContext().GetSuspect().IsAnswerUsed(this.mConfrontChoices[i]);
            GE_SelectionPopUp gE_SelectionPopUp = this.mSelectionPopUp;
            int n = i;
            int n2 = bl ? 0 : 1;
            gE_SelectionPopUp.SetSelectionState(n, n2);
            GE_SelectionPopUp gE_SelectionPopUp2 = this.mSelectionPopUp;
            n = i;
            int n3 = bl ? 0 : 29;
            gE_SelectionPopUp2.SetSelectionCommand(n, n3);
        }
    }

    private void OnExit(int n, int n2) {
        GameApp.Get().GetScenarioContext().OnEvent(5, n2);
        this.StartClosingAnims(n);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        return this.mSelectionPopUp.OnKeyDownOrRepeat(n) || super.OnKeyDownOrRepeat(n);
    }

    private void OnNextConfront() {
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        if (suspect.GetConfrontSpeech() != 2) {
            suspect.NextSpeech();
            this.Confront();
            return;
        }
        int n = this.mSelectionPopUp.mSelectedTab;
        int n2 = this.mConfrontChoices[n];
        if (suspect.IsAnswerUsed(n2)) {
            if (this.GetVisibleSelectionTabCount() == 2) {
                n2 = this.mConfrontChoices[2];
            } else if (this.GetVisibleSelectionTabCount() == 1) {
                n = 0;
                while (suspect.IsAnswerUsed(n2)) {
                    n2 = this.mConfrontChoices[++n];
                }
            }
        }
        suspect.SetAnswer(n2);
        this.mSelectionPopUp.SetSelectionState(n, 0);
        this.mSelectionPopUp.SetSelectionCommand(n, 0);
        this.mSelectionPopUp.UpdateTabs();
        n2 = n2 == 2 ? 18 : 19;
        GameApp.Get().GetMediaPlayer().PlayMusic(n2);
        GameApp.Get().GetScenarioContext().OnEvent(6);
        this.mClock.Update();
        suspect.NextSpeech();
        this.Confront();
    }

    private int GetVisibleSelectionTabCount() {
        int n = 3;
        for (int i = 0; i < 3; ++i) {
            if (!GameApp.Get().GetScenarioContext().GetSuspect().IsAnswerUsed(this.mConfrontChoices[i])) continue;
            --n;
        }
        return n;
    }

    private static int GetConfrontStringId(int n, boolean bl) {
        int n2 = 0;
        if (n == 0) {
            n2 = bl ? 2 : 1;
        } else if (n == 1) {
            n2 = bl ? 4 : 3;
        } else if (n == 2 && !bl) {
            n2 = 5;
        }
        return n2;
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        return this.mSelectionPopUp.OnPenUp(by, sArray) || super.OnPenUp(by, sArray);
    }
}

