/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.HorizontalSelector;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.MoreGames15;
import ca.jamdat.flight.MoreGames15Product;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.SelectorMenu;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.VerticalSelector;
import ca.jamdat.flight.Viewport;

public final class MoreGames15ProductsMenu
extends SelectorMenu {
    public Selector mActionSelector;
    public MoreGames15Product[] mProducts = null;
    public int mProductCount;

    public final void Initialize() {
        super.Initialize();
        this.mActionSelector = Selector.Cast$10974a41(this.mPackage.GetEntryPoint(5));
        this.InitializeProducts();
        this.InitializeSelectors();
    }

    public MoreGames15ProductsMenu(int n, int n2) {
        super(n, n2);
        this.mUseTitleAnimation = false;
    }

    public final void Unload() {
        this.FreeProductArray();
        super.Unload();
    }

    public final boolean OnCommand(int n) {
        int n2 = 0;
        Selection selection = Selection.Cast$2754fb85(this.mPackage.GetEntryPoint(6));
        Selection selection2 = Selection.Cast$2754fb85(this.mPackage.GetEntryPoint(7));
        if (n != 0 && (n == -45 || n == selection.mCommand || n == selection2.mCommand)) {
            GameApp.Get().GetMoreGames().SetSelectedProductId(this.mProducts[this.mSelector.mCurrentSelectionIndex].mId);
            if (this.mActionSelector.GetNumSelections() > 0) {
                n2 = this.mActionSelector.mCurrentSelectionIndex;
                n2 = super.OnCommand(this.mActionSelector.GetSelectionAt((int)n2).mCommand) ? 1 : 0;
            }
        } else {
            switch (n) {
                case 102: {
                    this.mActionSelector.OnDefaultMsg(this.mActionSelector, -119, 1);
                    break;
                }
                case 103: {
                    this.mActionSelector.OnDefaultMsg(this.mActionSelector, -119, 2);
                }
            }
            n2 = super.OnCommand(n);
        }
        return n2 != 0;
    }

    public final void OnSubtype(Component component, int n, int n2) {
        super.OnSubtype(component, n, n2);
        if (this.mActionSelector != null) {
            MetaPackage metaPackage = GameLibrary.GetPackage(65538);
            Viewport viewport = Viewport.Cast$7c352e71(metaPackage.mPackage.GetEntryPoint(27));
            if (this.mActionSelector.GetNumSelections() <= 1) {
                viewport.SetVisible(false);
            } else {
                viewport.SetVisible(true);
            }
            GameLibrary.ReleasePackage(metaPackage);
        }
    }

    private static MoreGames15Product[] CreateProductArray(int n) {
        return new MoreGames15Product[n];
    }

    private void FreeProductArray() {
        if (this.mProducts != null) {
            for (int i = 0; i < this.mProductCount; ++i) {
                this.mProducts[i] = null;
            }
        }
        this.mProducts = null;
        this.mProductCount = 0;
        this.mActionSelector = null;
    }

    private void InitializeProducts() {
        Package package_ = this.mPackage;
        int n = package_.GetEntryPoint$487101af(11);
        this.mProducts = MoreGames15ProductsMenu.CreateProductArray(n);
        this.mProductCount = n;
        int n2 = Settings.GetUserSelectedLanguage() == 14 ? Constants.frenchLanguageResourcesOffsetFct() : 0;
        int n3 = n2;
        FlString flString = new FlString();
        for (int i = 0; i < n; ++i) {
            FlString flString2 = FlString.Cast$50263e8f(package_.GetEntryPoint(12 + i));
            FlString flString3 = FlString.Cast$50263e8f(package_.GetEntryPoint(16 + i));
            FlString flString4 = FlString.Cast$50263e8f(package_.GetEntryPoint(20 + i));
            FlBitmap flBitmap = Sprite.Cast$46e644cd((Object)package_.GetEntryPoint((int)(24 + i + n3))).mBitmap;
            short[] sArray = Color888.Cast$4e210a13(package_.GetEntryPoint(32 + i));
            this.mProducts[i] = new MoreGames15Product(flString2, flString, flString4, flString, sArray, flString3, flBitmap);
        }
        this.SetProductInConfigurationOrder();
    }

    public final void ReceiveFocus() {
        super.ReceiveFocus();
        this.mActionSelector.TakeFocus();
    }

    private void SetProductInConfigurationOrder() {
        MoreGames15 moreGames15 = GameApp.Get().GetMoreGames();
        FlString[] flStringArray = moreGames15.mConfiguredProductIds;
        int n = moreGames15.mConfiguredProductCount;
        MoreGames15Product[] moreGames15ProductArray = MoreGames15ProductsMenu.CreateProductArray(this.mProductCount);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            MoreGames15Product moreGames15Product = this.FindProduct(this.mProducts, this.mProductCount, flStringArray[i]);
            if (moreGames15Product == null) continue;
            moreGames15ProductArray[n2++] = moreGames15Product;
        }
        for (int i = 0; i < this.mProductCount; ++i) {
            if (this.FindProduct(moreGames15ProductArray, this.mProductCount, this.mProducts[i].mId) != null) continue;
            this.mProducts[i] = null;
        }
        this.mProducts = null;
        this.mProducts = moreGames15ProductArray;
        this.mProductCount = n2;
    }

    private MoreGames15Product FindProduct(MoreGames15Product[] moreGames15ProductArray, int n, FlString flString) {
        for (int i = 0; i < n; ++i) {
            MoreGames15Product moreGames15Product = moreGames15ProductArray[i];
            if (moreGames15Product == null || !moreGames15Product.mId.Equals(flString)) continue;
            return moreGames15Product;
        }
        return null;
    }

    private void UpdateSelectedProduct(int n) {
        short s;
        short s2;
        MoreGames15Product moreGames15Product = this.mProducts[n];
        Object object = this.mPackage;
        Shape.Cast$2392dbe5(((Package)object).GetEntryPoint(36)).SetColor(moreGames15Product.mTagColor);
        Text.Cast$21bacd23(((Package)object).GetEntryPoint(9)).SetCaption(new FlString(moreGames15Product.mTagLine));
        Text.Cast$21bacd23(((Package)object).GetEntryPoint(10)).SetCaption(new FlString(moreGames15Product.mMoreGenre));
        Selection selection = Selection.Cast$2754fb85(((Package)object).GetEntryPoint(6));
        Selection selection2 = Selection.Cast$2754fb85(((Package)object).GetEntryPoint(7));
        object = GameApp.Get().GetMoreGames();
        if (selection.mVisible) {
            Utilities.RemoveSelection(this.mActionSelector, 0);
        }
        if (selection2.mVisible) {
            Utilities.RemoveSelection(this.mActionSelector, 0);
        }
        int n2 = ((MoreGames15)object).GetBuyCommand(moreGames15Product.mId);
        selection.mCommand = s2 = (short)((byte)n2);
        s2 = 0;
        if (n2 != 0) {
            s2 = 1;
            Utilities.AddSelection(this.mActionSelector, selection, 0);
        }
        int n3 = ((MoreGames15)object).GetCatCommand(moreGames15Product.mId);
        selection2.mCommand = s = (short)((byte)n3);
        if (n3 != 0) {
            Utilities.AddSelection(this.mActionSelector, selection2, s2);
        }
        if (this.mActionSelector.GetNumSelections() > 0) {
            this.mActionSelector.SetSingleSelection(0, true);
            this.mActionSelector.GetSelectionAt(0).SetSelectedState(true);
            if (this.mActionSelector.GetNumSelections() > 1) {
                this.mActionSelector.GetSelectionAt(1).SetSelectedState(false);
            }
            this.mSelectSoftKey.SetEnabled(true);
        } else {
            this.mSelectSoftKey.SetEnabled(false);
        }
        this.OnSubtype(this.mActionSelector.GetSelectionAt(0), 0, 0);
    }

    private void InitializeSelectors() {
        Selector selector = this.mSelector;
        int n = this.mProductCount;
        int n2 = selector.GetNumSelections();
        int n3 = FlMath.Maximum(n, n2);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i < n) {
                ((Sprite)((Viewport)selector.GetSelectionAt(i).GetChild(0)).GetChild(0)).SetBitmap(this.mProducts[i].mImage);
                continue;
            }
            Utilities.RemoveSelection(selector, n2 - n4 - 1);
            ++n4;
        }
        selector.SetNumSelections(n);
        VerticalSelector.Initialize(this.mActionSelector, 0, 0);
        HorizontalSelector.Initialize(selector, this.mFocusedSelectionIndex);
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        boolean bl = super.OnMsg(component, n, n2);
        if (n == -127 && n2 == 1 && (n2 = this.mSelector.mCurrentSelectionIndex) != -1 && component == this.mSelector.GetSelectionAt(n2)) {
            this.UpdateSelectedProduct(n2);
        }
        return bl;
    }
}

