/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.PathCalculator;

public final class Mansion {
    public int[] mMansion = null;
    public int mNbInfo;
    public int[][] mGraph = null;
    public int mIdSpawnRoom;
    public int mWidth;
    public byte[][] mDoorCoordinateX = null;
    public byte[][] mDoorStartCoordinateY = null;
    public int mHeight;
    public byte[][] mDoorStartCoordinateX = null;
    public byte[][] mDoorCoordinateY = null;

    private void BuildMansionGraph() {
        int n;
        int n2;
        this.mGraph = new int[12][12];
        for (n2 = 0; n2 < this.mGraph.length; ++n2) {
            for (n = 0; n < this.mGraph[n2].length; ++n) {
                this.mGraph[n2][n] = -1;
            }
        }
        this.mDoorCoordinateX = new byte[12][12];
        for (n = 0; n < this.mDoorCoordinateX.length; ++n) {
            for (n2 = 0; n2 < this.mDoorCoordinateX[n].length; ++n2) {
                this.mDoorCoordinateX[n][n2] = -1;
            }
        }
        this.mDoorCoordinateY = new byte[12][12];
        for (n = 0; n < this.mDoorCoordinateY.length; ++n) {
            for (n2 = 0; n2 < this.mDoorCoordinateY[n].length; ++n2) {
                this.mDoorCoordinateY[n][n2] = -1;
            }
        }
        this.mDoorStartCoordinateX = new byte[12][12];
        for (n = 0; n < this.mDoorStartCoordinateX.length; ++n) {
            for (n2 = 0; n2 < this.mDoorStartCoordinateX[n].length; ++n2) {
                this.mDoorStartCoordinateX[n][n2] = -1;
            }
        }
        this.mDoorStartCoordinateY = new byte[12][12];
        for (n = 0; n < this.mDoorStartCoordinateY.length; ++n) {
            for (n2 = 0; n2 < this.mDoorStartCoordinateY[n].length; ++n2) {
                this.mDoorStartCoordinateY[n][n2] = -1;
            }
        }
        for (n = 0; n < this.mWidth - 1; ++n) {
            for (n2 = 0; n2 < this.mHeight - 1; ++n2) {
                if (this.IsDoorInRoom(n, n2)) {
                    if (this.IsDoorInRoom(n + 1, n2) && !this.IsInSameRoom(n, n2, n + 1, n2) && this.GetRoomId(n + 1, n2) > -1 && this.GetRoomId(n, n2) > -1) {
                        this.ConstructGraph(n, n2, n + 1, n2);
                    }
                    if (this.IsDoorInRoom(n, n2 + 1) && !this.IsInSameRoom(n, n2, n, n2 + 1) && this.GetRoomId(n, n2 + 1) > -1 && this.GetRoomId(n, n2) > -1) {
                        this.ConstructGraph(n, n2 + 1, n, n2);
                    }
                }
                if (this.IsSpawnInRoom(n, n2)) {
                    this.mIdSpawnRoom = this.GetRoomId(n, n2);
                }
                if (this.IsInHall(n, n2) && this.IsInHall(n + 1, n2) && !this.IsInSameRoom(n, n2, n + 1, n2) && this.GetRoomId(n + 1, n2) > -1 && this.GetRoomId(n, n2) > -1) {
                    this.ConstructGraph(n, n2, n + 1, n2);
                }
                if (!this.IsInHall(n, n2) || !this.IsInHall(n, n2 + 1) || this.IsInSameRoom(n, n2, n, n2 + 1) || this.GetRoomId(n, n2 + 1) <= -1 || this.GetRoomId(n, n2) <= -1) continue;
                this.ConstructGraph(n, n2, n, n2 + 1);
            }
        }
        for (n = 0; n < 12; ++n) {
            this.mGraph[n][n] = 0;
            for (n2 = 0; n2 < 12; ++n2) {
                if (this.mDoorStartCoordinateX[n][n2] != -1) {
                    this.mDoorCoordinateX[n][n2] = (byte)((this.mDoorStartCoordinateX[n][n2] + this.mDoorCoordinateX[n][n2]) / 2);
                }
                if (this.mDoorStartCoordinateY[n][n2] == -1) continue;
                this.mDoorCoordinateY[n][n2] = (byte)((this.mDoorStartCoordinateY[n][n2] + this.mDoorCoordinateY[n][n2]) / 2);
            }
        }
    }

    private void ConstructGraph(int n, int n2, int n3, int n4) {
        int n5 = this.GetRoomId(n, n2);
        int n6 = this.GetRoomId(n3, n4);
        this.mGraph[n5][n6] = 1;
        this.mGraph[n6][n5] = 1;
        if (this.mDoorStartCoordinateX[n5][n6] == -1) {
            this.mDoorStartCoordinateX[n5][n6] = (byte)n;
        }
        if (this.mDoorStartCoordinateX[n6][n5] == -1) {
            this.mDoorStartCoordinateX[n6][n5] = (byte)n3;
        }
        this.mDoorCoordinateX[n5][n6] = (byte)n;
        this.mDoorCoordinateX[n6][n5] = (byte)n3;
        if (this.mDoorStartCoordinateY[n5][n6] == -1) {
            this.mDoorStartCoordinateY[n5][n6] = (byte)n2;
        }
        if (this.mDoorStartCoordinateY[n6][n5] == -1) {
            this.mDoorStartCoordinateY[n6][n5] = (byte)n4;
        }
        this.mDoorCoordinateY[n5][n6] = (byte)n2;
        this.mDoorCoordinateY[n6][n5] = (byte)n4;
    }

    public final void OnDelete() {
        this.mMansion = null;
        if (this.mGraph != null) {
            for (int i = 0; i < 12; ++i) {
                this.mGraph[i] = null;
                this.mDoorCoordinateX[i] = null;
                this.mDoorCoordinateY[i] = null;
                this.mDoorStartCoordinateX[i] = null;
                this.mDoorStartCoordinateY[i] = null;
            }
            this.mGraph = null;
            this.mDoorCoordinateX = null;
            this.mDoorCoordinateY = null;
            this.mDoorStartCoordinateX = null;
            this.mDoorStartCoordinateY = null;
        }
    }

    public Mansion(int[] nArray, int n, int n2, int n3) {
        this.mMansion = nArray;
        this.mNbInfo = n;
        this.mHeight = n3;
        this.mWidth = n2;
        this.mIdSpawnRoom = -1;
        this.BuildMansionGraph();
    }

    public final int GetRoomId(int n, int n2) {
        if ((n2 = this.mMansion[this.mNbInfo * (n2 * this.mWidth + n)]) == 0) {
            return -1;
        }
        return n2 - 1;
    }

    public final boolean IsDoorInRoom(int n, int n2) {
        if (n2 < 0 || n2 >= this.mHeight) {
            return false;
        }
        if (n < 0 || n >= this.mWidth) {
            return false;
        }
        return this.mMansion[this.mNbInfo * (n2 * this.mWidth + n) + 1] == 1;
    }

    private boolean IsSpawnInRoom(int n, int n2) {
        if (n2 < 0 || n2 >= this.mHeight) {
            return false;
        }
        if (n < 0 || n >= this.mWidth) {
            return false;
        }
        return this.mMansion[this.mNbInfo * (n2 * this.mWidth + n) + 1] == 2;
    }

    private boolean IsInSameRoom(int n, int n2, int n3, int n4) {
        return this.GetRoomId(n, n2) == this.GetRoomId(n3, n4);
    }

    public final boolean IsInHall(int n, int n2) {
        return this.GetRoomId(n, n2) == 8 || this.GetRoomId(n, n2) == 9 || this.GetRoomId(n, n2) == 10 || this.GetRoomId(n, n2) == 11;
    }

    public final int[] FindShortestPath(int n, int n2) {
        PathCalculator pathCalculator = new PathCalculator(this.mGraph, 12);
        int[] nArray = pathCalculator.GetPath(n, n2);
        pathCalculator.OnDelete();
        return nArray;
    }

    public final int DistanceShortestPath(int n, int n2) {
        PathCalculator pathCalculator = new PathCalculator(this.mGraph, 12);
        if ((n2 = pathCalculator.GetCost(n, n2)) >= 100) {
            n2 -= 99;
        }
        pathCalculator.OnDelete();
        return n2;
    }

    public final void LockRoom(int n) {
        for (int i = 0; i < 12; ++i) {
            if (this.mGraph[n][i] != 1) continue;
            this.mGraph[n][i] = 100;
        }
    }

    public final void UnLockRoom(int n) {
        for (int i = 0; i < 12; ++i) {
            if (this.mGraph[n][i] != 100) continue;
            this.mGraph[n][i] = 1;
        }
    }

    public final byte GetDoorCoordinateX(int n, int n2) {
        return this.mDoorCoordinateX[n][n2];
    }

    public final byte GetDoorCoordinateY(int n, int n2) {
        return this.mDoorCoordinateY[n][n2];
    }
}

