/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Achievements;
import ca.jamdat.flight.BaseSpeechStrategy;
import ca.jamdat.flight.CheatActivationController;
import ca.jamdat.flight.CheatContainer;
import ca.jamdat.flight.ClueParser;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FileManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GameAppImpl;
import ca.jamdat.flight.GameCommandHandler;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Hourglass;
import ca.jamdat.flight.InputMapper;
import ca.jamdat.flight.LanguageManager;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.MoreGames15;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.ScenarioProcess;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.SharedResourcesHandler;
import ca.jamdat.flight.SpeechStrategyFactory;
import ca.jamdat.flight.Statistics;
import ca.jamdat.flight.TimeData;
import ca.jamdat.flight.TimeDiff;
import ca.jamdat.flight.TimeUtils;

public final class GameApp
extends FlApplication {
    public GameAppImpl mImpl;
    public Constants mCurrentConstants;

    public final ScenarioProcess GetScenarioProcess() {
        return this.mImpl.mScenarioProcess;
    }

    public GameApp() {
        GameApp.InitializeRandomSeed();
        this.mImpl = new GameAppImpl();
        this.mImpl.Initialize();
        InputMapper.ChangeMapping();
        this.RegisterInGlobalTime();
    }

    public final ScenarioContext GetScenarioContext() {
        return this.mImpl.mScenarioContext;
    }

    public final ClueParser GetClueParser() {
        return this.mImpl.mClueParser;
    }

    public final BaseSpeechStrategy GetSpeechStrategy(int n) {
        if (this.mImpl.mScenarioContext.IsTutorial()) {
            n = 2;
        }
        if (this.mImpl.mSpeechStrategy == null) {
            this.mImpl.mSpeechStrategy = SpeechStrategyFactory.Create(n);
        } else if (this.mImpl.mSpeechStrategy.GetType() != n) {
            this.mImpl.mSpeechStrategy = null;
            this.mImpl.mSpeechStrategy = SpeechStrategyFactory.Create(n);
        }
        return this.mImpl.mSpeechStrategy;
    }

    public final TimeDiff GetRunningTime() {
        int n;
        Object object = new TimeData();
        TimeDiff timeDiff = new TimeDiff(TimeUtils.GetElapsedDays((TimeData)object), ((TimeData)object).GetHour(), ((TimeData)object).GetMin(), ((TimeData)object).GetSec());
        object = this.mImpl.mRunningTime;
        ((TimeDiff)object).mTicks = n = timeDiff.mTicks;
        return this.mImpl.mRunningTime;
    }

    public final int GetPreviousSceneID() {
        return this.mImpl.mSceneTransitionController.mPreviousSceneID;
    }

    public final SharedResourcesHandler GetSharedResourcesHandler() {
        return this.mImpl.mSceneTransitionController.mSharedResourcesHandler;
    }

    public final LanguageManager GetLanguageManager() {
        return this.mImpl.mLanguageManager;
    }

    public final CheatActivationController GetCheatActivationController() {
        return this.mImpl.mCheatActivationController;
    }

    public final CheatContainer GetCheatContainer() {
        return this.mImpl.mCheatContainer;
    }

    public final MoreGames15 GetMoreGames() {
        return this.mImpl.mMoreGames15;
    }

    public final void SetConstants(Constants constants) {
        this.mCurrentConstants = null;
        this.mCurrentConstants = constants;
    }

    private static int InitializeRandomSeed() {
        int n = (int)FlApplication.GetRealTime();
        FlMath.Seed(n);
        return n;
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        n2 = 0;
        if (n == -56) {
            this.Quit();
            n2 = 1;
        }
        return n2 != 0;
    }

    public final void Reset() {
        this.mImpl.Reset();
    }

    public final void OnTime(int n, int n2) {
        if (this.mImpl.mBootProcess.OnTime()) {
            this.UnRegisterInGlobalTime();
            this.mImpl.mBootProcess = null;
        }
    }

    public final void SaveGame() {
        this.mImpl.mCommandHandler.Execute(-64);
        this.mImpl.mFileManager.WriteApplicationObjects();
        GameApp.Get().GetFileManager().OnSave();
    }

    public final void Suspend() {
        this.mImpl.mCommandHandler.Execute(-61);
    }

    public final void Resume() {
        this.mImpl.mCommandHandler.Execute(-62);
    }

    public final void Quit() {
        this.TakeFocus();
        this.SaveGame();
        FlApplication.Exit();
    }

    public static GameApp Get() {
        return (GameApp)FlApplication.GetInstance();
    }

    public final Settings GetSettings() {
        return this.mImpl.mSettings;
    }

    public final Hourglass GetHourglass() {
        return this.mImpl.mHourglass;
    }

    public final MediaPlayer GetMediaPlayer() {
        return this.mImpl.mMediaPlayer;
    }

    public final GameLibrary GetLibrary() {
        return this.mImpl.mGameLibrary;
    }

    public final FileManager GetFileManager() {
        return this.mImpl.mFileManager;
    }

    public final Statistics GetStatistics() {
        return this.mImpl.mStatistics;
    }

    public final Achievements GetAchievements() {
        return this.mImpl.mAchievements;
    }

    public final GameCommandHandler GetCommandHandler() {
        return this.mImpl.mCommandHandler;
    }
}

