/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.DoubleClickDetector;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GE_Shadow;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Palette;
import ca.jamdat.flight.RepalettizedBitmap;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_DialogBox
extends GE_GameEntity {
    public int mDialogBoxType = 11;
    public Text mDialogBoxText;
    public RepalettizedBitmap mDialogBoxBottomRepalettizedBitmap;
    public Selection mLeftTouchShield;
    public Selection mBottomTouchShield;
    public Selection mRightTouchShield;
    public Viewport mTitleBlackShapeViewport;
    public GE_Shadow mShadow;
    public DoubleClickDetector mDoubleClickDetector;
    public RepalettizedBitmap mDialogBoxRepalettizedBitmap;
    public boolean mIsActive;
    public int mSuspectID = -1;
    public Scroller mDialogTextScroller;
    public Selection mTopTouchShield;

    private void ResizeDialogBoxComponent(int n) {
        n = this.GetDialogWidth(n);
        int n2 = Constants.dialogBoxLeftBorderBitmapWidthFct();
        int n3 = Constants.dialogBoxRightBorderBitmapWidthFct();
        int n4 = n - 3 * (n2 + n3) / 2;
        int n5 = Constants.dialogBoxTitleBlackShapeOffsetYFct();
        int n6 = n - Constants.dialogBoxBottomBitmapWidthFct() + Constants.dialogBoxBottomSpriteAnchorOffsetXFct();
        Component component = this.mComponentViewport.GetChild(2);
        Component component2 = this.mComponentViewport.GetChild(3);
        Viewport viewport = (Viewport)this.mComponentViewport.GetChild(0);
        short s = (short)(n - (n2 + n3));
        component.SetSize(s, component.mRect_height);
        component.SetTopLeft((short)n2, component.mRect_top);
        component2.SetTopLeft(component.GetRight(), component.mRect_top);
        viewport.SetTopLeft((short)n6, (short)(component.mRect_height + n5));
        int n7 = n - Constants.dialogBoxArrowsViewportWidthFct();
        viewport = (Viewport)this.mComponentViewport.GetChild(5);
        component2 = (Viewport)this.mComponentViewport.GetChild(4);
        component = (Viewport)((Viewport)component2).GetChild(0);
        this.mComponentViewport.SetSize((short)n, this.mComponentViewport.mRect_height);
        s = (short)n7;
        viewport.SetTopLeft(s, viewport.mRect_top);
        component2.SetSize((short)n4, component2.mRect_height);
        component2.SetTopLeft((short)((n2 + n3) / 2), (short)(component2.mRect_top + n5));
        component.SetSize((short)n4, component.mRect_height);
        this.mDialogBoxText = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(1));
        this.mDialogBoxText.SetSize((short)n4, (short)Constants.dialogLineHeightFct());
    }

    private void InitializeDialogBoxPosition(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = Constants.dialogBoxViewportOffsetXFct();
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                n2 = (this.mComponentViewport.m_pViewport.mRect_width - this.GetDialogWidth(2)) / 2;
                break;
            }
            case 4: {
                n2 = this.mComponentViewport.m_pViewport.mRect_width - this.GetDialogWidth(4) - Constants.dialogBoxViewportOffsetXFct();
            }
        }
        this.mComponentViewport.SetTopLeft((short)n2, this.mComponentViewport.mRect_top);
    }

    private void UpdateTitleShapeTextAndSize(int n, int n2) {
        Component component = this.mTitleBlackShapeViewport.GetChild(0);
        Text text = (Text)this.mTitleBlackShapeViewport.GetChild(1);
        this.mTitleBlackShapeViewport.SetVisible(true);
        switch (n) {
            case 1: 
            case 4: 
            case 5: {
                text.SetCaption(ClueUtils.GetStringForSuspect(n2));
                break;
            }
            case 6: 
            case 7: {
                text.SetCaption(ClueUtils.GetGameString(114));
                break;
            }
            case 8: {
                text.SetCaption(FlString.Cast$50263e8f(this.mPackage.mPackage.GetEntryPoint(6)));
                break;
            }
            case 0: {
                text.SetVisible(false);
                component.SetVisible(false);
                break;
            }
            case 10: {
                text.SetCaption(FlString.Cast$50263e8f(this.mPackage.mPackage.GetEntryPoint(8)));
                break;
            }
            case 9: {
                text.SetCaption(FlString.Cast$50263e8f(this.mPackage.mPackage.GetEntryPoint(9)));
                break;
            }
            case 2: 
            case 3: {
                this.mTitleBlackShapeViewport.SetVisible(false);
            }
        }
        n2 = Constants.dialogBoxTitleBlackShapeOffsetWFct();
        text.SetSize(text.GetLineWidth(), text.mRect_height);
        text.SetTopLeft((short)(n2 / 2), text.mRect_top);
        component.SetSize((short)(n2 + text.GetLineWidth()), (short)(text.mRect_height + Constants.dialogBoxTitleBlackShapeOffsetHFct()));
        this.mTitleBlackShapeViewport.SetSize(component.mRect_width, component.mRect_height);
        this.mTitleBlackShapeViewport.SetTopLeft((short)Constants.dialogBoxTextScrollerDefaultPositionXFct(), this.mTitleBlackShapeViewport.mRect_top);
    }

    private int GetDialogWidth(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                n2 = Constants.dialogBoxTalkWidthFct();
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                n2 = Constants.dialogBoxSearchWidthFct();
                break;
            }
            case 4: 
            case 5: {
                n2 = Constants.dialogBoxFlashbackWidthFct();
            }
        }
        return n2;
    }

    private void ResizeTouchShields() {
        Viewport viewport = this.mComponentViewport;
        this.ResizeTouchShields(viewport.mRect_top, viewport.mRect_left, viewport.mRect_width, viewport.mRect_height);
    }

    private void ResizeTouchShields(short s, short s2, short s3, short s4) {
        this.mTopTouchShield.SetRect((short)0, (short)0, (short)Constants.screenWidthFct(), s);
        this.mLeftTouchShield.SetRect((short)0, s, s2, s4);
        s3 = (short)(s2 + s3);
        s2 = (short)(Constants.screenWidthFct() - s3);
        this.mRightTouchShield.SetRect(s3, s, s2, s4);
        s4 = (short)(s + s4);
        s3 = (short)(Constants.screenHeightFct() - s4 - Constants.softkeyHeightFct());
        this.mBottomTouchShield.SetRect((short)0, s4, (short)Constants.screenWidthFct(), s3);
    }

    private void ActivateTouchShield() {
        this.SetPassThroughTouchShields(false);
    }

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(229383);
        this.mShadow = new GE_Shadow(this.mBaseScene);
        this.mShadow.Load();
        this.mTopTouchShield = new Selection();
        this.mLeftTouchShield = new Selection();
        this.mRightTouchShield = new Selection();
        this.mBottomTouchShield = new Selection();
        this.DeactivateTouchShield();
        this.mDoubleClickDetector = new DoubleClickDetector(this.mBaseScene, 100);
    }

    private void DeactivateTouchShield() {
        this.SetPassThroughTouchShields(true);
    }

    private void SetPassThroughTouchShields(boolean bl) {
        this.mTopTouchShield.mPassThrough = bl;
        this.mLeftTouchShield.mPassThrough = bl;
        this.mRightTouchShield.mPassThrough = bl;
        this.mBottomTouchShield.mPassThrough = bl;
    }

    public final void Unload() {
        if (this.mTopTouchShield != null) {
            this.mTopTouchShield.SetViewport(null);
            this.mTopTouchShield = null;
        }
        if (this.mLeftTouchShield != null) {
            this.mLeftTouchShield.SetViewport(null);
            this.mLeftTouchShield = null;
        }
        if (this.mRightTouchShield != null) {
            this.mRightTouchShield.SetViewport(null);
            this.mRightTouchShield = null;
        }
        if (this.mBottomTouchShield != null) {
            this.mBottomTouchShield.SetViewport(null);
            this.mBottomTouchShield = null;
        }
        if (this.mDoubleClickDetector != null) {
            this.mDoubleClickDetector = null;
        }
        if (this.mShadow != null) {
            this.mShadow.Unload();
            this.mShadow = null;
        }
        FlFont.Cast$be01453((Object)this.mPackage.mPackage.GetEntryPoint((int)13)).mBackground = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded() && this.mShadow.IsLoaded();
    }

    private void UpdateTouchBottomSprite() {
        FlBitmap flBitmap = FlBitmap.Cast$5822fcd3(this.mPackage.mPackage.GetEntryPoint(4));
        ((Sprite)((Viewport)this.mComponentViewport.GetChild(0)).GetChild(0)).SetBitmap(flBitmap);
        int n = 20 + this.mSuspectID;
        if (this.mDialogBoxType == 4 || this.mDialogBoxType == 5 || this.mDialogBoxType == 6 || this.mDialogBoxType == 7) {
            n = 26;
        }
        flBitmap.SetPalette(Palette.Cast$2ce84be5(this.mPackage.mPackage.GetEntryPoint(n)));
    }

    public final void Show(FlString flString) {
        this.Show(flString, 2);
    }

    public final void Show(FlString flString, int n) {
        this.Show(flString, n, 6);
    }

    public final void Show(FlString flString, int n, int n2) {
        this.Show(flString, n, n2, 0);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mIsActive) {
            if (this.mDialogBoxType != 6) {
                this.mDoubleClickDetector.OnPenUp$4af90b10(sArray);
            }
            bl = true;
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mIsActive) {
            bl = true;
        }
        return bl || super.OnPenDown(by, sArray);
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2, short[] sArray3) {
        boolean bl = false;
        if (this.mIsActive) {
            ClueUtils.ScrollOnDrag(this.mDialogTextScroller, this.mDialogBoxText.m_pViewport, sArray2, sArray3);
            bl = true;
        }
        return bl || super.OnPenMove(by, sArray, sArray2, sArray3);
    }

    public final void BringToFront() {
        this.mShadow.BringToFront();
        this.mComponentViewport.BringToFront();
    }

    public GE_DialogBox(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        this.mTopTouchShield.SetViewport(viewport);
        this.mLeftTouchShield.SetViewport(viewport);
        this.mRightTouchShield.SetViewport(viewport);
        this.mBottomTouchShield.SetViewport(viewport);
        this.mShadow.Init(viewport, 0);
        super.Init(viewport);
        this.mComponentViewport.SetVisible(false);
        this.mDialogTextScroller = (Scroller)this.mComponentViewport;
    }

    public final void GetEntryPoints() {
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mDoubleClickDetector.mZoneComponent = this.mComponentViewport;
        this.mDoubleClickDetector.AddExcludedZoneComponent(this.mComponentViewport.GetChild(5));
        this.mDialogBoxRepalettizedBitmap = RepalettizedBitmap.Cast$7baaffc5(this.mPackage.mPackage.GetEntryPoint(2));
        this.mDialogBoxBottomRepalettizedBitmap = RepalettizedBitmap.Cast$7baaffc5(this.mPackage.mPackage.GetEntryPoint(3));
        this.mTitleBlackShapeViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(5));
        super.GetEntryPoints();
        this.mShadow.GetEntryPoints();
    }

    public final void Show(FlString flString, int n, int n2, int n3) {
        this.mSuspectID = n2;
        this.mDialogBoxType = n;
        this.SetActive(true);
        if (this.mDialogBoxType == 0) {
            this.mShadow.UpdateSimpleShadow();
        } else if (this.mDialogBoxType == 3 || this.mDialogBoxType == 8 || this.mDialogBoxType == 10 || this.mDialogBoxType == 9) {
            Viewport viewport = this.mComponentViewport.m_pViewport;
            int n4 = viewport.mRect_height;
            int n5 = Constants.dialogBoxNotificationFooterHeightFct();
            switch (n3) {
                case 0: {
                    n4 = viewport.mRect_height - n5;
                    break;
                }
                case 1: {
                    n4 = viewport.mRect_height - n5;
                    break;
                }
                case 2: {
                    n4 = viewport.mRect_height - (n5 + Constants.navTabMinimizedViewportHeightFct());
                }
            }
            this.mShadow.SetVisible(true);
            this.mShadow.UpdateSimpleShadow((short)0, (short)0, viewport.mRect_width, (short)n4);
        }
        this.InitializeDialogBoxPosition(n);
        this.ResizeDialogBoxComponent(n);
        this.SetContentText(flString, n2);
        this.SetDialogBoxPalette(n, n2);
        this.UpdateTitleShapeTextAndSize(n, n2);
        this.ResizeTouchShields();
        this.ActivateTouchShield();
    }

    public final void Hide() {
        this.SetActive(false);
        this.mDialogBoxType = 11;
        this.DeactivateTouchShield();
    }

    public final void ReduceBottomTouchShield(short s) {
        Viewport viewport = this.mComponentViewport;
        this.ResizeTouchShields(viewport.mRect_top, viewport.mRect_left, viewport.mRect_width, (short)(viewport.mRect_height + s));
    }

    private void SetActive(boolean bl) {
        GE_Shadow gE_Shadow = this.mShadow;
        boolean bl2 = bl && (this.mDialogBoxType == 8 || this.mDialogBoxType == 10 || this.mDialogBoxType == 9 || this.mDialogBoxType == 0);
        gE_Shadow.SetVisible(bl2);
        this.mIsActive = bl;
        this.mComponentViewport.SetVisible(bl);
    }

    public final boolean OnKeyDown(int n) {
        boolean bl = false;
        if (this.mIsActive) {
            bl = n == 1 || n == 2 || n == 5 || n == 6 ? this.mDialogTextScroller.OnDefaultMsg(this.mComponentViewport, -120, n) : true;
        }
        return bl;
    }

    public final boolean OnKeyUp(int n) {
        boolean bl = false;
        if (this.mIsActive && (n == 1 || n == 2 || n == 5 || n == 6)) {
            bl = this.mDialogTextScroller.OnDefaultMsg(this.mComponentViewport, -121, n);
        }
        return bl;
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        if (this.mIsActive) {
            bl = n == 1 || n == 2 || n == 5 || n == 6 ? this.mDialogTextScroller.OnDefaultMsg(this.mComponentViewport, -119, n) : true;
        }
        return bl;
    }

    private void UpdateTextFonts(int n) {
        FlFont flFont;
        FlFont flFont2;
        if (this.mDialogBoxType != 1) {
            flFont2 = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(10));
            flFont = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(12));
        } else {
            flFont2 = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(11));
            flFont = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(13));
            flFont.mBackground = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(14 + n));
        }
        this.mDialogBoxText.SetFont(flFont2);
        this.mDialogBoxText.SetFont(flFont, 1);
    }

    private void SetDialogBoxPalette(int n, int n2) {
        n2 = 20 + n2;
        if (n == 4 || n == 5 || n == 6 || n == 7) {
            n2 = 26;
        }
        byte[] byArray = Palette.Cast$2ce84be5(this.mPackage.mPackage.GetEntryPoint(n2));
        this.mDialogBoxRepalettizedBitmap.SetPalette(byArray);
        this.mDialogBoxBottomRepalettizedBitmap.SetPalette(byArray);
    }

    private void SetContentText(FlString flString, int n) {
        Utilities.SetCaption(this.mDialogBoxText, flString);
        this.SetTextCenterToDialogBox();
        this.UpdateTextFonts(n);
        this.mDialogTextScroller.ResetScroller();
        Selection selection = this.mDialogTextScroller.mPreviousArrow;
        boolean bl = !this.mDialogTextScroller.mPreviousArrow.mEnabled;
        selection.SetEnabledState(bl);
        selection = this.mDialogTextScroller.mPreviousArrow;
        bl = !this.mDialogTextScroller.mPreviousArrow.mEnabled;
        selection.SetEnabledState(bl);
    }

    private void SetTextCenterToDialogBox() {
        Viewport viewport = (Viewport)this.mComponentViewport.GetChild(4);
        Viewport viewport2 = (Viewport)viewport.GetChild(0);
        int n = Constants.dialogBoxUsableAreaHeightFct();
        short s = this.mDialogBoxText.mLineCount;
        int n2 = Constants.dialogLineHeightFct();
        int n3 = Constants.dialogBoxTextScrollerDefaultPositionYFct();
        int s2 = Constants.dialogBoxTextViewportHeightFct();
        if (s * n2 < n) {
            int n4 = (n - s * n2) / 2 + n3;
            viewport.SetSize(viewport.mRect_width, (short)(s * n2));
            short s3 = (short)n4;
            viewport.SetTopLeft(viewport.mRect_left, s3);
            viewport2.SetSize(viewport2.mRect_width, (short)(s * n2));
            this.UpdateTouchBottomSprite();
            return;
        }
        viewport.SetTopLeft(viewport.mRect_left, (short)n3);
        viewport.SetSize(viewport.mRect_width, (short)s2);
        viewport2.SetSize(viewport2.mRect_width, (short)s2);
    }
}

