/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.PtrArray_Component;

public final class FlPenManager {
    public PtrArray_Component mListeners = new PtrArray_Component();
    public short[] mLastTouchedPosition = new short[2];
    public Component[] mLastTouchedComponent = new Component[1];
    public boolean mEventForwardingToTopComponentEnabled = true;
    public boolean mActived;

    private void OnPenDrag(short s, short s2, byte by) {
        if (this.mActived) {
            int n = by + 1;
            if (this.mLastTouchedPosition[by] != s || this.mLastTouchedPosition[n] != s2) {
                this.mLastTouchedPosition[by] = s;
                this.mLastTouchedPosition[n] = s2;
                Component component = FlApplication.GetInstance().GetHitTestComponent(s, s2);
                Component component2 = this.mLastTouchedComponent[by];
                s2 = (short)FlPenManager.EncodeParam(s, s2, by);
                if (component != component2) {
                    this.SendPenMsg(component2, (byte)-115, s2, (byte)2);
                    this.mLastTouchedComponent[by] = component;
                }
                this.SendPenMsg(component, (byte)-116, s2);
            }
        }
    }

    public static short GetPenPositionX(int n) {
        return (short)(n >> 18 & 0x3FFF);
    }

    public static short GetPenPositionY(int n) {
        return (short)(n >> 4 & 0x3FFF);
    }

    public static byte GetPenIndex(int n) {
        return (byte)(n >> 0 & 0xF);
    }

    public final void OnAppResumed() {
        this.Reset();
    }

    private static int EncodeParam(short s, short s2, byte by) {
        return s << 18 | s2 << 4 | by << 0;
    }

    public FlPenManager() {
        for (int i = 0; i < 1; ++i) {
            this.mLastTouchedComponent[i] = null;
        }
    }

    private void SendDeactivationMsg(byte by) {
        for (int i = 0; i < 1; ++i) {
            this.SendPenMsg(this.mLastTouchedComponent[i], (byte)-114, FlPenManager.EncodeParam((short)-1, (short)-1, (byte)i), by);
            if (by != 0 && by != 2) continue;
            this.mLastTouchedComponent[i] = null;
        }
    }

    private void SendPenMsg(Component component, byte by, int n, byte by2) {
        if ((by2 == 0 || by2 == 2) && component != null && this.mEventForwardingToTopComponentEnabled) {
            component.SendMsg(component, by, n);
        }
        if (by2 == 0 || by2 == 1) {
            for (by2 = (byte)PtrArray_Component.Start(); by2 < this.mListeners.End(); by2 = (byte)(by2 + 1)) {
                this.mListeners.GetAt(by2).SendMsg(component, by, n);
            }
        }
    }

    public final void OnPenDown(short s, short s2) {
        this.OnPenDown(s, s2, (byte)0);
    }

    public final void OnPenUp(short s, short s2) {
        this.OnPenUp(s, s2, (byte)0);
    }

    public final void OnPenDrag(short s, short s2) {
        this.OnPenDrag(s, s2, (byte)0);
    }

    private void SendPenMsg(Component component, byte by, int n) {
        this.SendPenMsg(component, by, n, (byte)0);
    }

    public static FlPenManager Get() {
        FrameworkGlobals frameworkGlobals = FrameworkGlobals.GetInstance();
        if (frameworkGlobals.mFlPenManager == null) {
            frameworkGlobals.mFlPenManager = new FlPenManager();
        }
        return frameworkGlobals.mFlPenManager;
    }

    private void Reset() {
        if (this.mActived) {
            this.Deactivate();
            this.Activate();
        }
    }

    public final void Deactivate() {
        this.mActived = false;
        this.SendDeactivationMsg((byte)0);
    }

    public final void Activate() {
        this.mActived = true;
    }

    private void OnPenDown(short s, short s2, byte by) {
        int n = FlPenManager.EncodeParam(s, s2, by);
        if (this.mActived) {
            this.mLastTouchedPosition[by] = s;
            this.mLastTouchedPosition[by + 1] = s2;
            this.mLastTouchedComponent[by] = FlApplication.GetInstance().GetHitTestComponent(s, s2);
            this.SendPenMsg(this.mLastTouchedComponent[by], (byte)-117, n);
        }
    }

    private void OnPenUp(short s, short s2, byte by) {
        if (this.mActived) {
            this.SendPenMsg(this.mLastTouchedComponent[by], (byte)-118, FlPenManager.EncodeParam(s, s2, by));
            this.mLastTouchedComponent[by] = null;
        }
    }
}

