/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseController;
import ca.jamdat.flight.Cheat;
import ca.jamdat.flight.CheatContainer;
import ca.jamdat.flight.Controllable;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.Utilities;

public final class CheatActivationController
extends BaseController {
    public Controllable mTimeControlled = new Controllable();
    public int[] mActivationKeySequence = null;
    public int mKeySequenceLength;
    public int mInputCount;
    public int[] mInputKeys = null;
    public boolean mCheatInputActivated;
    public int mInputCheatDeactivationTimerMs;

    public CheatActivationController() {
        this.mTimeControlled.mController = this;
        this.mInputKeys = new int[13];
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean OnKey$486912e3(int n, boolean bl) {
        boolean bl2 = false;
        if (bl) return bl2;
        if (this.mCheatInputActivated) {
            this.mInputCheatDeactivationTimerMs = 0;
            this.DetectCheatActivation(n);
            return true;
        }
        if (this.mActivationKeySequence != null) {
            int n2;
            int n3 = this.mInputCount;
            this.mInputCount = n2 = n3 + 1;
            if (n == this.mActivationKeySequence[n3]) {
                this.mInputCheatDeactivationTimerMs = 0;
                this.mTimeControlled.RegisterInGlobalTime();
                if (this.mInputCount != this.mKeySequenceLength) return bl2;
                this.ActivateInput();
                this.mInputCount = 0;
                return bl2;
            }
        }
        this.mInputCount = 0;
        this.mTimeControlled.UnRegisterInGlobalTime();
        return bl2;
    }

    public final void Initialize(int[] nArray, int n) {
        this.mActivationKeySequence = null;
        this.mActivationKeySequence = new int[n];
        this.mKeySequenceLength = n;
        for (int i = 0; i < n; ++i) {
            this.mActivationKeySequence[i] = nArray[i];
        }
    }

    private void ActivateInput() {
        this.mCheatInputActivated = true;
        this.mInputCount = 0;
        this.mInputCheatDeactivationTimerMs = 0;
    }

    private void DeactivateInput() {
        if (this.mCheatInputActivated) {
            this.mCheatInputActivated = false;
        }
        this.mInputCount = 0;
        this.mTimeControlled.UnRegisterInGlobalTime();
    }

    private void DetectCheatActivation(int n) {
        boolean bl = true;
        if (n >= 48 && n <= 57) {
            int n2;
            int n3 = this.mInputCount;
            this.mInputCount = n2 = n3 + 1;
            this.mInputKeys[n3] = n;
            CheatContainer cheatContainer = GameApp.Get().GetCheatContainer();
            for (int i = 0; i < 19; ++i) {
                Cheat cheat = cheatContainer.GetCheat(i);
                if (cheat == null) continue;
                n2 = CheatActivationController.GetMatchStatus(cheat, this.mInputKeys, this.mInputCount);
                if (n2 == 2) {
                    if (cheat.mActivated) {
                        cheat.Deactivate();
                    } else {
                        cheat.Activate(CheatActivationController.ExtractCheatParam(cheat, this.mInputKeys, this.mInputCount));
                    }
                    this.DeactivateInput();
                    return;
                }
                if (n2 != 1) continue;
                bl = false;
            }
        }
        if (bl) {
            this.DeactivateInput();
        }
    }

    public final void OnTime$255f295(int n) {
        this.mInputCheatDeactivationTimerMs += n;
        if (this.mInputCheatDeactivationTimerMs >= 3000) {
            this.DeactivateInput();
        }
    }

    private static int GetMatchStatus(Cheat cheat, int[] nArray, int n) {
        int[] nArray2 = cheat.mCode;
        int n2 = cheat.mCodeLength;
        int n3 = cheat.mParamLength;
        int n4 = FlMath.Minimum(n, n2);
        for (int i = 0; i < n4; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return 0;
        }
        if (n == n2 + n3) {
            return 2;
        }
        return 1;
    }

    private static int ExtractCheatParam(Cheat cheat, int[] nArray, int n) {
        int n2 = 0;
        for (int i = cheat.mParamLength - 1; i >= 0; --i) {
            n2 = n2 * 10 + Utilities.GetKeyValue(nArray[n - 1 - i]);
        }
        return n2;
    }
}

