/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Time;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.I_Notifier;

public final class CO_Clock
extends I_Notifier {
    public int mCurrentTime;
    public CO_Time mTime;
    public boolean mHasNotification;
    public int mClockPhase;

    public final void OnCheat(int n) {
        if (n == 15) {
            this.mCurrentTime = 0;
            return;
        }
        if (n == 17) {
            this.mClockPhase = 3;
        }
    }

    public final void OnEvent(int n, int n2, int n3) {
        if (n == 6) {
            this.Decrease(2);
            return;
        }
        if (n == 12) {
            this.Update();
            return;
        }
        if (n == 22) {
            this.Decrease(4);
            return;
        }
        if (n == 28) {
            this.Decrease(2);
            return;
        }
        if (n == 31) {
            this.TravelTo(n2, n3);
        }
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mCurrentTime = fileSegmentStream.ReadLong();
        this.mClockPhase = fileSegmentStream.ReadByte();
        this.mHasNotification = fileSegmentStream.ReadBoolean();
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteLong(this.mCurrentTime);
        fileSegmentStream.WriteByte((byte)this.mClockPhase);
        fileSegmentStream.WriteBoolean(this.mHasNotification);
    }

    public final int GetCurrentTime() {
        if (this.mCurrentTime < 0) {
            return 0;
        }
        return this.mCurrentTime;
    }

    public final FlString GetNotification() {
        int n = this.mClockPhase == 0 ? 44 : 45;
        return ClueUtils.GetGameString(n);
    }

    public CO_Clock(CO_Time cO_Time) {
        this.mTime = cO_Time;
        this.mClockPhase = 0;
        this.mCurrentTime = this.mTime.GetTotalTime();
    }

    public final boolean HasNotification() {
        return this.mHasNotification;
    }

    public final int GetId() {
        return 2;
    }

    public final void OnDisplayed() {
        this.mHasNotification = false;
        if (this.mClockPhase == 0) {
            this.mClockPhase = 1;
            this.mCurrentTime = this.mTime.GetExtensionTime();
            GameApp.Get().GetScenarioContext().OnEvent(21);
            return;
        }
        this.mClockPhase = 2;
        GameApp.Get().GetScenarioContext().OnEvent(10);
    }

    private void Update() {
        boolean bl = (this.mClockPhase == 0 || this.mClockPhase == 1) && this.mCurrentTime <= 0;
        this.mHasNotification = bl;
    }

    private void Decrease(int n) {
        n = this.mCurrentTime - n < 0 ? 0 : this.mCurrentTime - n;
        this.mCurrentTime = n;
    }

    private void TravelTo(int n, int n2) {
        this.Decrease(GameApp.Get().GetScenarioContext().GetMansion().DistanceShortestPath(n, n2) * 1);
    }
}

