/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.PtrArray_TimeControlled;
import ca.jamdat.flight.TimeControlled;
import java.util.Vector;

public final class TimeSystem
extends TimeControlled {
    public Vector mTimeControlleds;
    public boolean mPaused;
    public boolean mDirty;
    public int mTotalTime;
    public int mTimeFlowSpeed = F32.c_init_F32(F32.One(16));
    public int mDeltaError = F32.c_init_F32(F32.Zero$134621());

    public final void Stop() {
        this.mTotalTime = 0;
        this.mPaused = true;
    }

    public TimeSystem() {
        this.mTimeControlleds = PtrArray_TimeControlled.c_init_();
    }

    public final boolean IsRegistered(TimeControlled timeControlled) {
        return PtrArray_TimeControlled.Find_TimeControlled(timeControlled, this.mTimeControlleds) >= 0;
    }

    public final boolean IsPaused() {
        block3: {
            block2: {
                if (this.mPaused) break block2;
                int n = this.mTimeFlowSpeed;
                if (!F32.Equals_F32(F32.Zero$134621(), n)) break block3;
            }
            return true;
        }
        return false;
    }

    public final void RefreshAllControllersIncluded() {
        for (int i = PtrArray_TimeControlled.Start_$4eb0df6c(); i < PtrArray_TimeControlled.End_(this.mTimeControlleds); ++i) {
            TimeControlled timeControlled = PtrArray_TimeControlled.GetAt_i(i, this.mTimeControlleds);
            if (timeControlled == null) continue;
            if (timeControlled instanceof Controller) {
                ((Controller)timeControlled).Refresh();
                continue;
            }
            if (!(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).RefreshAllControllersIncluded();
        }
    }

    private void CleanUpTimeTable() {
        if (this.mDirty) {
            int n;
            Vector vector = this.mTimeControlleds;
            while ((n = PtrArray_TimeControlled.Find_TimeControlled(null, vector)) != -1) {
                PtrArray_TimeControlled.SetAt_TimeControlledi(PtrArray_TimeControlled.GetAt_i(PtrArray_TimeControlled.End_(vector) - 1, vector), n, vector);
                PtrArray_TimeControlled.RemoveAt_i(PtrArray_TimeControlled.End_(vector) - 1, vector);
            }
            this.mDirty = false;
        }
    }

    private void SendOnTime(int n, int n2) {
        int n3 = PtrArray_TimeControlled.End_(this.mTimeControlleds);
        for (int i = 0; i < PtrArray_TimeControlled.End_(this.mTimeControlleds); ++i) {
            TimeControlled timeControlled = PtrArray_TimeControlled.GetAt_i(i, this.mTimeControlleds);
            if (timeControlled == null) continue;
            if (i >= n3) {
                n2 = 0;
            }
            timeControlled.OnTime(n, n2);
        }
    }

    public final void OnSerialize(Package package_) {
        this.mTotalTime = package_.SerializeIntrinsic$134621();
        this.mPaused = package_.SerializeIntrinsic$138603();
        this.mTimeFlowSpeed = package_.SerializeIntrinsic$285a253f();
        PtrArray_TimeControlled.OnSerialize_Package(package_, this.mTimeControlleds);
        this.mDirty = false;
    }

    public final void SetTimeFlowSpeed(int n) {
        this.mTimeFlowSpeed = F32.DecreasePrecision_i(0, n);
    }

    public static TimeSystem Cast$3b277f7b(Object object) {
        return (TimeSystem)object;
    }

    public final void OnTime(int n, int n2) {
        if (!this.IsPaused()) {
            n = this.mTimeFlowSpeed;
            if (!F32.Equals_F32(F32.One(16), n)) {
                n2 = F32.FromInt(n2, 16);
                n2 = F32.Mul_F32i(this.mTimeFlowSpeed, 16, n2);
                n = F32.c_init_F32(F32.Add_F32(this.mDeltaError, n2));
                n2 = F32.ToInt_i(16, n);
                this.mDeltaError = F32.Sub_F32(F32.FromInt(n2, 16), n);
            }
            this.mTotalTime += n2;
            this.SendOnTime(this.mTotalTime, n2);
        }
        this.CleanUpTimeTable();
    }

    public final void Start() {
        this.mPaused = false;
    }

    public final void Register(TimeControlled timeControlled) {
        if (!this.IsRegistered(timeControlled)) {
            PtrArray_TimeControlled.Insert_TimeControlled(timeControlled, this.mTimeControlleds);
        }
    }

    public final void UnRegister(TimeControlled timeControlled) {
        int n = PtrArray_TimeControlled.Find_TimeControlled(timeControlled, this.mTimeControlleds);
        if (n >= 0) {
            PtrArray_TimeControlled.SetAt_TimeControlledi(null, n, this.mTimeControlleds);
            this.mDirty = true;
        }
    }
}

