/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.RoomVisibility;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.Scrollbar;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.SuspectVisibility;
import ca.jamdat.flight.ToolScene;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;
import ca.jamdat.flight.WeaponVisibility;

public final class SuspicionsScene
extends ToolScene {
    public Selector mVerticalSelector;
    public int mRoomCount;
    public int mFirstSuspectIndex;
    public int mFirstRoomIndex;
    public int mSuspectCount;
    public int mWeaponCount;
    public Scrollbar mScrollbar;
    public int mFirstWeaponIndex;

    public SuspicionsScene() {
        super(37, 0x300060);
        this.AddType(4);
        GameApp.Get().GetScenarioContext().OnEvent(27);
    }

    public final void Load() {
        super.Load();
    }

    public final void Unload() {
        this.mScrollbar = null;
        super.Unload();
    }

    public final void SetDefaultSoftkeys() {
        this.UpdateSoftkeys(7, 56, 1, -60);
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        if (n == -105 && !this.mDialogBox.mIsActive) {
            this.UpdateCheckboxStatus();
            this.UpdateTicker();
            this.mScrollbar.UpdateKnobPosition();
            GameApp.Get().GetScenarioContext().mCurrentSuspicionIndex = (byte)this.mVerticalSelector.mCurrentSelectionIndex;
        }
        return super.OnMsg(component, n, n2);
    }

    private void ResetSuspectCount() {
        int n = -1;
        this.mSuspectCount = 0;
        for (int i = 0; i < 6; ++i) {
            boolean bl = GameApp.Get().GetScenarioContext().IsSuspectExist(i);
            int n2 = Utilities.GetSelectionIndexFromCommmand(this.mVerticalSelector, 56 + i);
            if (n == -1 && bl) {
                n = n2;
            }
            if (bl) {
                ++this.mSuspectCount;
            }
            this.mVerticalSelector.GetSelectionAt(n2).SetEnabledState(bl);
        }
        this.mFirstSuspectIndex = n;
    }

    private void ResetWeaponCount() {
        int n = -1;
        this.mWeaponCount = 0;
        for (int i = 0; i < 9; ++i) {
            boolean bl = GameApp.Get().GetScenarioContext().IsWeaponExist(i);
            int n2 = Utilities.GetSelectionIndexFromCommmand(this.mVerticalSelector, 62 + i);
            if (n == -1 && bl) {
                n = n2;
            }
            if (bl) {
                ++this.mWeaponCount;
            }
            this.mVerticalSelector.GetSelectionAt(n2).SetEnabledState(bl);
        }
        this.mFirstWeaponIndex = n;
    }

    private void ResetRoomCount() {
        int n = -1;
        this.mRoomCount = 0;
        for (int i = 0; i <= 7; ++i) {
            boolean bl = GameApp.Get().GetScenarioContext().IsRoomExist(i);
            int n2 = Utilities.GetSelectionIndexFromCommmand(this.mVerticalSelector, 71 + i);
            if (n == -1 && bl) {
                n = n2;
            }
            if (bl) {
                ++this.mRoomCount;
            }
            this.mVerticalSelector.GetSelectionAt(n2).SetEnabledState(bl);
        }
        this.mFirstRoomIndex = n;
    }

    private void ResetSelector() {
        this.UpdateComponentPosition();
        int n = GameApp.Get().GetScenarioContext().mCurrentSuspicionIndex;
        if (n == -1) {
            n = this.mFirstSuspectIndex;
        }
        this.mVerticalSelector.SetSingleSelection(n);
        this.mScrollbar.UpdateBar();
    }

    private void UpdateComponentPosition() {
        Viewport viewport = (Viewport)this.mVerticalSelector.GetChild(0);
        Component component = viewport.GetChild(Constants.suspicionSceneSuspectBackgroundIndexFct());
        Viewport viewport2 = (Viewport)viewport.GetChild(Constants.suspicionSceneWeaponHeaderViewportIndexFct());
        Component component2 = viewport.GetChild(Constants.suspicionSceneWeaponBackgroundIndexFct());
        Viewport viewport3 = (Viewport)viewport.GetChild(Constants.suspicionSceneRoomHeaderViewportIndexFct());
        Component component3 = viewport.GetChild(Constants.suspicionSceneRoomBackgroundIndexFct());
        component.SetSize(component.mRect_width, (short)(this.mSuspectCount * Constants.suspicionsSceneSelectionHFct() + Constants.suspicionSceneFooterSpriteHFct()));
        viewport2.SetTopLeft(viewport2.mRect_left, (short)(Constants.suspicionsSceneBtwSelectionGroupOffsetFct() + component.mRect_top + component.mRect_height));
        component2.SetSize(component2.mRect_width, (short)(this.mWeaponCount * Constants.suspicionsSceneSelectionHFct() + Constants.suspicionSceneFooterSpriteHFct()));
        component2.SetTopLeft(component2.mRect_left, (short)(viewport2.mRect_top + viewport2.mRect_height));
        viewport2 = this.mVerticalSelector.GetSelectionAt(this.mFirstWeaponIndex);
        viewport2.SetTopLeft(viewport2.mRect_left, (short)(viewport2.mRect_top + Constants.suspicionsSceneSelectionHFct()));
        viewport3.SetTopLeft(viewport3.mRect_left, (short)(Constants.suspicionsSceneBtwSelectionGroupOffsetFct() + component2.mRect_top + component2.mRect_height));
        component3.SetSize(component3.mRect_width, (short)(this.mRoomCount * Constants.suspicionsSceneSelectionHFct() + Constants.suspicionSceneFooterSpriteHFct()));
        component3.SetTopLeft(component3.mRect_left, (short)(viewport3.mRect_top + viewport3.mRect_height));
        component3 = this.mVerticalSelector.GetSelectionAt(this.mFirstRoomIndex);
        component3.SetTopLeft(component3.mRect_left, (short)(component3.mRect_top + Constants.suspicionsSceneSelectionHFct()));
        Selection selection = (Selection)viewport.GetChild(Constants.suspicionSceneWeaponTitleTouchShieldIndexFct());
        viewport3 = (Selection)viewport.GetChild(Constants.suspicionSceneRoomTitleTouchShieldIndexFct());
        selection.SetTopLeft(selection.mRect_left, viewport2.mRect_top);
        viewport3.SetTopLeft(viewport3.mRect_left, component3.mRect_top);
    }

    private void UpdateCheckboxStatus() {
        int n = this.mVerticalSelector.GetNumSelections();
        for (int i = 0; i < n; ++i) {
            Selection selection = this.mVerticalSelector.GetSelectionAt(i);
            boolean bl = !Utilities.IsSelectionChecked(selection);
            Utilities.SetCheckboxFrame(selection, (IndexedSprite)selection.GetChild(Constants.suspicionsSceneCheckBoxSpriteIndexFct()), bl);
        }
    }

    private void UpdateSuspectTickerText(int n) {
        int n2 = 9;
        if (!GameApp.Get().GetScenarioContext().mSuspectVisibility.GetSuspectVisibility(n)) {
            n2 = 8;
        }
        FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(n2)));
        ClueUtils.ReplaceAllSuspectIDInString(flString, n);
        this.mTicker.SetTickerMessage(flString);
    }

    private void UpdateWeaponTickerText(int n) {
        int n2 = 11;
        if (!GameApp.Get().GetScenarioContext().mWeaponVisibility.GetWeaponVisibility(n)) {
            n2 = 10;
        }
        FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(n2)));
        ClueUtils.ReplaceAllWeaponIDInString(flString, n);
        this.mTicker.SetTickerMessage(flString);
    }

    private void UpdateRoomTickerText(int n) {
        int n2 = 13;
        if (!GameApp.Get().GetScenarioContext().mRoomVisibility.GetRoomVisibility(n)) {
            n2 = 12;
        }
        FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(n2)));
        ClueUtils.ReplaceAllRoomIDInString(flString, n);
        this.mTicker.SetTickerMessage(flString);
    }

    private void ResizeSelectionOnTwoLines(int n) {
        Selection selection = this.mVerticalSelector.GetSelectionAt(n);
        selection.SetSize(selection.mRect_width, (short)(Constants.suspicionsSceneSelectionHFct() * 2));
        selection.SetTopLeft(selection.mRect_left, (short)(selection.mRect_top - Constants.suspicionsSceneSelectionHFct()));
        for (int i = 0; i < selection.GetChildCount(); ++i) {
            Component component = selection.GetChild(i);
            component.SetTopLeft(component.mRect_left, (short)(component.mRect_top + Constants.suspicionsSceneSelectionHFct()));
        }
    }

    public final void OnHideNotification() {
        super.OnHideNotification();
        this.SetSelectionsPassThrough(false);
    }

    private void SetSelectionsPassThrough(boolean bl) {
        this.mVerticalSelector.mPreviousArrow.mPassThrough = bl;
        this.mVerticalSelector.mNextArrow.mPassThrough = bl;
        int n = this.mVerticalSelector.GetNumSelections();
        for (int i = 0; i < n; ++i) {
            this.mVerticalSelector.GetSelectionAt((int)i).mPassThrough = bl;
        }
    }

    public final void Initialize() {
        super.Initialize();
        this.ResetSuspectCount();
        this.ResetWeaponCount();
        this.ResetRoomCount();
        this.mNavTab.Init(this.mViewport, 2);
        this.mTicker.Init(this.mViewport);
        this.mDialogBox.Init(this.mViewport);
        this.ResizeSelectionOnTwoLines(this.mFirstSuspectIndex);
        this.ResizeSelectionOnTwoLines(this.mFirstWeaponIndex);
        this.ResizeSelectionOnTwoLines(this.mFirstRoomIndex);
        int n = this.mVerticalSelector.GetNumSelections();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Selection selection = this.mVerticalSelector.GetSelectionAt(i);
            selection.SetTopLeft((short)0, (short)n2);
            if (selection.mEnabled) {
                if (i == this.mFirstWeaponIndex || i == this.mFirstRoomIndex) {
                    n2 += Constants.suspicionsSceneSelectionHFct();
                }
                n2 += this.mVerticalSelector.GetSelectionAt((int)i).mRect_height;
            }
            selection.SetVisible(selection.mEnabled);
        }
        this.mScrollbar.SetScroller(this.mVerticalSelector);
        this.ResetSelector();
        this.UpdateTicker();
        this.Refresh();
    }

    public final boolean OnCommand(int n) {
        int n2 = 0;
        SuspectVisibility suspectVisibility = GameApp.Get().GetScenarioContext().mSuspectVisibility;
        Object object = GameApp.Get().GetScenarioContext().mWeaponVisibility;
        RoomVisibility roomVisibility = GameApp.Get().GetScenarioContext().mRoomVisibility;
        int n3 = this.mVerticalSelector.mCurrentSelectionIndex;
        IndexedSprite indexedSprite = (IndexedSprite)this.mVerticalSelector.GetSelectionAt(n3).GetChild(Constants.suspicionsSceneCheckBoxSpriteIndexFct());
        int n4 = Utilities.GetSelectionIndexFromCommmand(this.mVerticalSelector, n);
        int n5 = 1;
        if (n >= 56 && n <= 78) {
            if (n >= 56 && n <= 61) {
                n2 = !suspectVisibility.GetSuspectVisibility(n4) ? 1 : 0;
                n5 = n2;
                suspectVisibility.SetSuspectVisibility(n4, n2 != 0);
            }
            if (n >= 62 && n <= 70) {
                int n6 = !((WeaponVisibility)object).GetWeaponVisibility(n4 - Constants.suspectMaxCountFct()) ? 1 : 0;
                n5 = n6;
                ((WeaponVisibility)object).SetWeaponVisibility(n4 - Constants.suspectMaxCountFct(), n6 != 0);
                object = GameApp.Get().GetScenarioContext();
                n2 = n4 - Constants.suspectMaxCountFct();
                n6 = n6 != 0 ? 1 : 0;
                ((ScenarioContext)object).OnEvent(34, n2, n6);
                this.Refresh();
                this.RefreshNotifier();
            }
            if (n >= 71 && n <= 78) {
                int n7 = !roomVisibility.GetRoomVisibility(n4 - Constants.suspectMaxCountFct() - Constants.weaponMaxCountFct()) ? 1 : 0;
                n5 = n7;
                roomVisibility.SetRoomVisibility(n4 - Constants.suspectMaxCountFct() - Constants.weaponMaxCountFct(), n7 != 0);
            }
            n5 = n5 == 1 ? Constants.focusedUncheckedBoxFrameIndexFct() : Constants.focusedCheckedBoxFrameIndexFct();
            indexedSprite.SetCurrentFrame(n5);
            n2 = 1;
        }
        this.UpdateTicker();
        return n2 != 0 || super.OnCommand(n);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mViewport = Viewport.Cast$7c352e71(this.mMetaPackage.mPackage.GetEntryPoint(0));
        this.mVerticalSelector = Selector.Cast$10974a41(this.mMetaPackage.mPackage.GetEntryPoint(3));
        this.mScrollbar = new Scrollbar((Viewport)this.mVerticalSelector.GetChild(2));
        this.mScrollbar.GetEntryPoints();
    }

    public final void ReceiveFocus() {
        super.ReceiveFocus();
        this.UpdateCheckboxStatus();
        if (!this.mDialogBox.mIsActive) {
            this.SetComponentFocus();
        }
    }

    public final void SetComponentFocus() {
        this.mVerticalSelector.TakeFocus();
    }

    private void UpdateTicker() {
        this.mTicker.StopTicker();
        int n = this.mVerticalSelector.mCurrentSelectionIndex;
        short s = this.mVerticalSelector.GetSelectionAt((int)n).mCommand;
        if (s >= 56 && s <= 61) {
            this.UpdateSuspectTickerText(n);
            return;
        }
        if (s >= 62 && s <= 70) {
            this.UpdateWeaponTickerText(n - Constants.suspectMaxCountFct());
            return;
        }
        if (s >= 71 && s <= 78) {
            this.UpdateRoomTickerText(n - Constants.suspectMaxCountFct() - Constants.weaponMaxCountFct());
        }
    }

    public final void OnShowNotification() {
        super.OnShowNotification();
        this.SetSelectionsPassThrough(true);
    }
}

