/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.ScenarioMediator;
import ca.jamdat.flight.ScenarioProcess;
import ca.jamdat.flight.TimeDiff;

public final class Statistics {
    public TimeDiff mTimeDiffBeginning;
    public ScenarioContext mScenarioContext;
    public int mCurrentGameTime;
    public ScenarioProcess mScenarioProcess;
    public TimeDiff mTimeDiff;
    public int[] mStats = null;
    public byte mTotalityStars;

    public Statistics(ScenarioProcess scenarioProcess, ScenarioContext scenarioContext) {
        this.mScenarioProcess = scenarioProcess;
        this.mScenarioContext = scenarioContext;
        this.mTimeDiff = new TimeDiff(0);
        this.mTimeDiffBeginning = new TimeDiff(0);
        this.mStats = new int[8];
        this.Reset();
    }

    public final int GetStat(int n) {
        return this.mStats[n];
    }

    public final void Increment(int n) {
        if (n == 5) {
            this.mStats[5] = n = this.mStats[5] + 1;
            return;
        }
        if (n == 6) {
            this.mStats[6] = n = this.mStats[6] + 1;
            return;
        }
        if (n == 7) {
            this.mStats[7] = n = this.mStats[7] + 1;
        }
    }

    public final void UpdateStat(int n) {
        if (n == 1) {
            ScenarioMediator scenarioMediator = this.mScenarioProcess.mMediator;
            int n2 = scenarioMediator.mCurrentId;
            byte by = 0;
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; !bl && i < 12; ++i) {
                scenarioMediator.SetCurrentElement(i);
                if (!scenarioMediator.IsLocked()) {
                    int n4 = scenarioMediator.GetScenarioStars();
                    n3 += n4;
                    if (n4 <= 0) continue;
                    by = (byte)(by + 4);
                    continue;
                }
                bl = true;
            }
            this.mStats[1] = n3;
            this.mTotalityStars = by;
            this.mStats[0] = this.mStats[1] * 100 / 48;
            scenarioMediator.SetCurrentElement(n2);
            return;
        }
        if (n == 4) {
            int n5 = this.mScenarioContext.GetCurrentTime();
            if (this.mCurrentGameTime > n5) {
                int n6;
                this.mStats[4] = n6 = this.mStats[4] + (this.mCurrentGameTime - n5);
            }
            this.mCurrentGameTime = n5;
        }
    }

    public final void StartTimeDiff() {
        this.mTimeDiffBeginning.mTicks = GameApp.Get().GetRunningTime().mTicks;
    }

    private void InvalidateTimeDiff() {
        this.mTimeDiffBeginning.mTicks = -1;
    }

    public final void StopTimeDiff() {
        if (this.mTimeDiffBeginning.mTicks > 0) {
            TimeDiff timeDiff = new TimeDiff(GameApp.Get().GetRunningTime().mTicks);
            timeDiff.Substract(this.mTimeDiffBeginning);
            this.mTimeDiff.Add(timeDiff);
            this.InvalidateTimeDiff();
        }
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        if (fileSegmentStream.mValidData) {
            this.mTotalityStars = fileSegmentStream.ReadByte();
            this.mTimeDiff.mTicks = fileSegmentStream.ReadLong();
            for (int i = 0; i < 8; ++i) {
                this.mStats[i] = fileSegmentStream.ReadLong();
            }
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        this.StopTimeDiff();
        fileSegmentStream.WriteByte(this.mTotalityStars);
        fileSegmentStream.WriteLong(this.mTimeDiff.mTicks);
        for (int i = 0; i < 8; ++i) {
            fileSegmentStream.WriteLong(this.mStats[i]);
        }
        fileSegmentStream.SetValidDataFlag(true);
    }

    private void Reset() {
        for (int i = 0; i < this.mStats.length; ++i) {
            this.mStats[i] = 0;
        }
        this.mTimeDiff.mTicks = 0;
    }
}

