/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameTipState;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.ScenarioProgress;
import ca.jamdat.flight.ScenarioStarReward;

public final class Settings {
    public GameTipState mGameTipState = new GameTipState();
    public ScenarioProgress mProgress;
    public int mPublishCount;
    public int mRandomRoomID = -1;
    public boolean mIsGameTipsEnabled = true;
    public ScenarioStarReward mStarReward = new ScenarioStarReward();
    public int[] mRandomWeaponID = null;
    public int[] mRandomSuspectID = null;

    public static void SetUserSelectedLanguage(short s) {
        GameApp.Get().GetLanguageManager().mUserSelectedLanguage = s;
    }

    public Settings() {
        int n;
        this.mProgress = new ScenarioProgress();
        this.mRandomSuspectID = new int[3];
        for (n = 0; n < this.mRandomSuspectID.length; ++n) {
            this.mRandomSuspectID[n] = -1;
        }
        this.mRandomWeaponID = new int[3];
        for (n = 0; n < this.mRandomWeaponID.length; ++n) {
            this.mRandomWeaponID[n] = -1;
        }
        this.InitRandomIntro();
    }

    public static short GetUserSelectedLanguage() {
        return GameApp.Get().GetLanguageManager().mUserSelectedLanguage;
    }

    public final int IncreasePublishCount() {
        int n;
        this.mPublishCount = n = this.mPublishCount + 1;
        return n;
    }

    private void InitRandomIntro() {
        if (this.mRandomSuspectID[0] == -1) {
            this.mRandomSuspectID[0] = FlMath.Rand() % 6;
            do {
                this.mRandomSuspectID[1] = FlMath.Rand() % 6;
                this.mRandomSuspectID[2] = FlMath.Rand() % 6;
            } while (this.mRandomSuspectID[0] == this.mRandomSuspectID[1] || this.mRandomSuspectID[0] == this.mRandomSuspectID[2] || this.mRandomSuspectID[1] == this.mRandomSuspectID[2]);
        }
        if (this.mRandomWeaponID[0] == -1) {
            this.mRandomWeaponID[0] = FlMath.Rand() % 9;
            do {
                this.mRandomWeaponID[1] = FlMath.Rand() % 9;
                this.mRandomWeaponID[2] = FlMath.Rand() % 9;
            } while (this.mRandomWeaponID[0] == this.mRandomWeaponID[1] || this.mRandomWeaponID[0] == this.mRandomWeaponID[2] || this.mRandomWeaponID[1] == this.mRandomWeaponID[2]);
        }
        this.mRandomRoomID = FlMath.Rand() % 8;
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        if (fileSegmentStream.mValidData) {
            int n;
            boolean bl = fileSegmentStream.ReadBoolean();
            fileSegmentStream.ReadShort();
            fileSegmentStream.ReadByte();
            fileSegmentStream.ReadBoolean();
            fileSegmentStream.ReadShort();
            fileSegmentStream.ReadShort();
            boolean bl2 = fileSegmentStream.ReadBoolean();
            int n2 = n = fileSegmentStream.ReadLong();
            this.mIsGameTipsEnabled = fileSegmentStream.ReadBoolean();
            this.mGameTipState.Read(fileSegmentStream);
            this.mStarReward.Read(fileSegmentStream);
            this.mProgress.Read(fileSegmentStream);
            GameApp.Get().GetMediaPlayer().SetSoundEnabled_(bl);
            MediaPlayer.SetVibrationEnabled_(bl2);
            Settings.SetApplicationLanguage((short)n2);
            Settings.SetUserSelectedLanguage((short)n);
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        MediaPlayer mediaPlayer = GameApp.Get().GetMediaPlayer();
        short s = mediaPlayer.GetSoundVolume_();
        short s2 = Settings.GetApplicationLanguage();
        short s3 = Settings.GetUserSelectedLanguage();
        boolean bl = MediaPlayer.IsVibrationEnabled_();
        fileSegmentStream.WriteBoolean(mediaPlayer.mSoundEnabled);
        fileSegmentStream.WriteShort(s);
        fileSegmentStream.WriteByte((byte)0);
        fileSegmentStream.WriteBoolean(false);
        fileSegmentStream.WriteShort((short)0);
        fileSegmentStream.WriteShort((short)0);
        fileSegmentStream.WriteBoolean(bl);
        fileSegmentStream.WriteLong(s2);
        fileSegmentStream.WriteLong(s3);
        fileSegmentStream.WriteBoolean(this.mIsGameTipsEnabled);
        this.mGameTipState.Write(fileSegmentStream);
        this.mStarReward.Write(fileSegmentStream);
        this.mProgress.Write(fileSegmentStream);
        fileSegmentStream.SetValidDataFlag(true);
    }

    public final int GetRandomCharacter(int n) {
        return this.mRandomSuspectID[n];
    }

    public final int GetRandomWeapon(int n) {
        return this.mRandomWeaponID[n];
    }

    public static void SetSoundEnabled(boolean bl) {
        GameApp.Get().GetMediaPlayer().SetSoundEnabled_(bl);
    }

    public static boolean IsSoundEnabled() {
        return GameApp.Get().GetMediaPlayer().mSoundEnabled;
    }

    public static void SetVibrationEnabled(boolean bl) {
        MediaPlayer.SetVibrationEnabled_(bl);
    }

    public static boolean IsVibrationEnabled() {
        return MediaPlayer.IsVibrationEnabled_();
    }

    public static void SetApplicationLanguage(short s) {
        GameApp.Get().GetLanguageManager().SetLanguage(s);
    }

    public static short GetApplicationLanguage() {
        return GameApp.Get().GetLanguageManager().mLanguage;
    }
}

