/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Array_int;
import ca.jamdat.flight.CO_Annotation;
import ca.jamdat.flight.CO_Confront;
import ca.jamdat.flight.CO_Gossip;
import ca.jamdat.flight.CO_Item;
import ca.jamdat.flight.CO_Room;
import ca.jamdat.flight.CO_SpeechGroup;
import ca.jamdat.flight.CO_Suspect;
import ca.jamdat.flight.CO_Time;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.I_Resource;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Scenario;
import ca.jamdat.flight.ScenarioUtils;
import ca.jamdat.flight.Suspect;

public final class ScenarioLoader
extends I_Resource {
    public int mScenarioId;
    public MetaPackage mPackage;
    public int mScenarioVariation;

    private int LoadItems(CO_Room cO_Room, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cO_Room.AddItem(this.BuildItem(n));
            n += 3;
        }
        return n;
    }

    private CO_Confront BuildConfront(int n) {
        CO_Confront cO_Confront = new CO_Confront();
        for (int i = 0; i < 8; ++i) {
            cO_Confront.Set(i, this.mPackage.mPackage.GetEntryPoint$487101af(n + i));
        }
        return cO_Confront;
    }

    private int LoadConfronts(CO_SpeechGroup cO_SpeechGroup, int n) {
        for (int i = 0; i < 2; ++i) {
            cO_SpeechGroup.AddConfront(this.BuildConfront(n), i);
            n += 8;
        }
        return n;
    }

    private CO_Gossip BuildGossip(int n, boolean bl, int n2) {
        CO_Gossip cO_Gossip = new CO_Gossip();
        int n3 = -1;
        int n4 = -1;
        while (++n3 < n2 && ++n4 < 7) {
            int n5 = this.mPackage.mPackage.GetEntryPoint$487101af(n + n3);
            if (bl) {
                if (n4 == 1) {
                    n4 = 2;
                }
            } else if (n4 == 4) {
                n4 = 6;
            }
            cO_Gossip.SetEntryPoint(n4, n5);
        }
        return cO_Gossip;
    }

    private int LoadGossips(CO_SpeechGroup cO_SpeechGroup, int n) {
        int n2 = cO_SpeechGroup.mSize == 2 ? 2 : 1;
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            n2 = cO_SpeechGroup.mSize == 2 ? 5 : 6;
            int n4 = n;
            boolean bl = n3 == 1;
            cO_SpeechGroup.AddGossip(this.BuildGossip(n4, bl, n2), i);
            n += n2;
        }
        return n;
    }

    private Mansion BuildMansion(int n) {
        int n2 = ((ScenarioLoader)object).mPackage.mPackage.GetEntryPoint$487101af(n);
        int n3 = n + 1;
        int n4 = ((ScenarioLoader)object).mPackage.mPackage.GetEntryPoint$487101af(n3);
        Array_int array_int = Array_int.Cast$7e11f265(((ScenarioLoader)object).mPackage.mPackage.GetEntryPoint(n3 + 1));
        n = n2 * n4 * 2;
        Object object = new int[n];
        for (n3 = 0; n3 < ((Object)object).length; ++n3) {
            object[n3] = -1;
        }
        for (n3 = 0; n3 < n; ++n3) {
            object[n3] = array_int.GetAt(n3);
        }
        return new Mansion((int[])object, 2, n4, n2);
    }

    private int LoadStory(Scenario scenario, int n) {
        scenario.mBackStoryID = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        return n + 1;
    }

    public final void Load() {
        this.mPackage = GameLibrary.GetPackage(ScenarioUtils.GetPackageId(this.mScenarioId, this.mScenarioVariation));
    }

    private void AssignSpeechForPairGroups(Scenario scenario) {
        for (int i = 0; i < scenario.mGroups.Size(); ++i) {
            CO_SpeechGroup cO_SpeechGroup = scenario.mGroups.Get(i);
            if (cO_SpeechGroup.mSize != 2) continue;
            CO_Suspect[] cO_SuspectArray = cO_SpeechGroup.mSuspects;
            for (int j = 0; j < 2; ++j) {
                cO_SpeechGroup.AssignConfront(cO_SuspectArray[j].mSuspectId, j);
                cO_SpeechGroup.AssignGossip(cO_SuspectArray[j].mSuspectId, j);
            }
        }
    }

    public ScenarioLoader(int n, int n2) {
        this.mScenarioId = n;
        this.mScenarioVariation = n2;
    }

    public final void Unload() {
        GameLibrary.ReleasePackage(this.mPackage);
        this.mPackage = null;
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    private void CreateInspectorAnnotations(Scenario scenario) {
        for (int i = 0; i < scenario.mRooms.Size(); ++i) {
            scenario.mRooms.Get((int)i).mInspectorAnnotation = this.CreateAnnotation(6, 9);
        }
    }

    private void CreateMurderAnnotations(Scenario scenario) {
        for (int i = 0; i < scenario.mRooms.Size(); ++i) {
            CO_Room cO_Room = scenario.mRooms.Get(i);
            cO_Room.mMurderAnnotation = this.CreateAnnotation(cO_Room.mSuspectId, cO_Room.mWeaponId);
        }
    }

    private CO_Annotation CreateAnnotation(int n, int n2) {
        Object object = new CO_Annotation();
        ((CO_Annotation)object).mSuspectId = n;
        ((CO_Annotation)object).mWeaponId = n2;
        return object;
    }

    public final Scenario GetScenario() {
        Scenario scenario = new Scenario();
        scenario.mTime = this.BuildTime(0);
        int n = this.LoadRooms(scenario, this.LoadStory(scenario, 2));
        scenario.mMansion = this.BuildMansion(n);
        this.LoadGroups(scenario, n + 3);
        this.CreateInspectorAnnotations(scenario);
        this.CreateMurderAnnotations(scenario);
        if (this.mScenarioId == 0) {
            ClueUtils.SetTutorialControlSettings(scenario.mRooms);
        } else if (this.mScenarioId == 1) {
            ClueUtils.SetTutorialToolSettings(scenario.mRooms);
        } else {
            ClueUtils.ShuffleSuspects(scenario.mRooms);
        }
        if (this.mScenarioId == 2 || this.mScenarioId == 3 || this.mScenarioId == 4) {
            int n2 = -1;
            int n3 = scenario.mRooms.Size();
            n = FlMath.Rand() % n3;
            while (n2 == -1) {
                n = (n + 1) % n3;
                if (scenario.mRooms.Get((int)n).mSuspectId == 6) continue;
                n2 = scenario.mRooms.Get((int)n).mRoomId;
            }
            scenario.SetInspectorRoom(n2);
        } else {
            scenario.SetInspectorRoom(scenario.mMansion.mIdSpawnRoom);
        }
        scenario.GetInspectorRoom().mVisited = true;
        this.AssignSpeechForPairGroups(scenario);
        return scenario;
    }

    private CO_Time BuildTime(int n) {
        CO_Time cO_Time = new CO_Time();
        int n2 = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        n = this.mPackage.mPackage.GetEntryPoint$487101af(n + 1);
        cO_Time.SetTotalTime(n2);
        cO_Time.SetExtensionTime(n);
        return cO_Time;
    }

    private int BuildGroup(Scenario scenario, int n) {
        CO_SpeechGroup cO_SpeechGroup = new CO_SpeechGroup(this.mPackage.mPackage.GetEntryPoint$487101af(n));
        scenario.mGroups.Insert(cO_SpeechGroup);
        return this.LoadConfronts(cO_SpeechGroup, this.LoadSuspects(scenario, cO_SpeechGroup, this.LoadGossips(cO_SpeechGroup, n + 1)));
    }

    private int LoadGroups(Scenario scenario, int n) {
        int n2 = n + 1;
        int n3 = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        for (n = 0; n < n3; ++n) {
            n2 = this.BuildGroup(scenario, n2);
        }
        return n2;
    }

    private CO_Suspect BuildSuspect$32ce4fae(int n) {
        CO_Suspect cO_Suspect = new CO_Suspect();
        int n2 = n + 1;
        cO_Suspect.mSuspectId = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        for (n = 0; n < 4; ++n) {
            cO_Suspect.SetStringId(this.mPackage.mPackage.GetEntryPoint$487101af(n2 + n), n);
        }
        return cO_Suspect;
    }

    private int LoadSuspects(Scenario scenario, CO_SpeechGroup cO_SpeechGroup, int n) {
        for (int i = 0; i < cO_SpeechGroup.mSize; ++i) {
            CO_Suspect cO_Suspect = this.BuildSuspect$32ce4fae(n);
            cO_SpeechGroup.AddSuspect(cO_Suspect, i);
            Suspect suspect = new Suspect(cO_SpeechGroup, cO_Suspect);
            scenario.mSuspects.Insert(suspect);
            n += 5;
        }
        return n;
    }

    private int LoadRoom(CO_Room cO_Room, int n) {
        block6: for (int i = 0; i < 4; ++i) {
            int n2 = this.mPackage.mPackage.GetEntryPoint$487101af(n);
            ++n;
            switch (i) {
                case 0: {
                    cO_Room.mRoomId = n2;
                    continue block6;
                }
                case 1: {
                    cO_Room.mWeaponId = n2;
                    continue block6;
                }
                case 2: {
                    cO_Room.mSuspectId = n2;
                    continue block6;
                }
                case 3: {
                    if (n2 == 0) continue block6;
                    n = this.LoadItems(cO_Room, n, n2);
                }
            }
        }
        return n;
    }

    private int LoadRooms(Scenario scenario, int n) {
        int n2 = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        int n3 = n + 1;
        int n4 = n3 + 1;
        scenario.mMurderRoom = this.mPackage.mPackage.GetEntryPoint$487101af(n3);
        for (n = 0; n < n2; ++n) {
            CO_Room cO_Room = new CO_Room();
            n4 = this.LoadRoom(cO_Room, n4);
            scenario.mRooms.Insert(cO_Room);
        }
        return n4;
    }

    private CO_Item BuildItem(int n) {
        CO_Item cO_Item = new CO_Item();
        cO_Item.mItemId = this.mPackage.mPackage.GetEntryPoint$487101af(n);
        boolean bl = this.mPackage.mPackage.GetEntryPoint$487101af(n + 1) == 1;
        cO_Item.mClueItem = bl;
        cO_Item.mStringId = this.mPackage.mPackage.GetEntryPoint$487101af(n + 2);
        return cO_Item;
    }
}

