/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Annotation;
import ca.jamdat.flight.CO_Clock;
import ca.jamdat.flight.CO_Item;
import ca.jamdat.flight.CO_Room;
import ca.jamdat.flight.ClueInfo;
import ca.jamdat.flight.ClueMementoState;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Clues;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.I_Listener;
import ca.jamdat.flight.InspectorAccusation;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.NotificationMediator;
import ca.jamdat.flight.RoomVisibility;
import ca.jamdat.flight.SA_Array_CO_Item;
import ca.jamdat.flight.SA_Array_CO_Room;
import ca.jamdat.flight.Scenario;
import ca.jamdat.flight.StatisticsListener;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Suspect;
import ca.jamdat.flight.SuspectVisibility;
import ca.jamdat.flight.TutorialSteps;
import ca.jamdat.flight.WeaponVisibility;

public final class ScenarioContext {
    public Scenario mScenario;
    public ClueMementoState mMementoState;
    public RoomVisibility mRoomVisibility;
    public byte mCurrentSuspicionIndex;
    public SuspectVisibility mSuspectVisibility;
    public I_Listener[] mListeners = null;
    public int mRoomIDResult = -1;
    public ClueInfo mClueInfo;
    public WeaponVisibility mWeaponVisibility;
    public InspectorAccusation mAccusations;
    public int mState = 6;
    public I_Listener mStatisticsListener;
    public byte mCurrentRoomIndex;
    public int mSuspectIDResult = -1;
    public TutorialSteps mTutorialSteps;
    public NotificationMediator mNotifyMediator;
    public int mWeaponIDResult = -1;
    public byte mCurrentNoteIndex = (byte)-1;
    public CO_Clock mClock;

    public final boolean IsItemInSelectedRoomSearched(int n, int n2) {
        SA_Array_CO_Item sA_Array_CO_Item = this.mScenario.GetRoom((int)n).mItems;
        boolean bl = false;
        if (sA_Array_CO_Item.Size() > n2) {
            bl = sA_Array_CO_Item.Get((int)n2).mSearched;
        }
        return bl;
    }

    public ScenarioContext() {
        this.mCurrentSuspicionIndex = (byte)-1;
        this.mCurrentRoomIndex = (byte)-1;
        this.OnNewGame();
    }

    public final void SetAccusations(int n, int n2, int n3) {
        this.mAccusations.SetRoomId(n2);
        this.mAccusations.SetWeaponId(n);
        this.mAccusations.SetSuspectId(n3);
    }

    private boolean GetHintsContext(int n) {
        this.mWeaponIDResult = -1;
        this.mRoomIDResult = -1;
        this.mSuspectIDResult = -1;
        for (int i = 0; i < this.mScenario.mRooms.Size(); ++i) {
            CO_Room cO_Room = this.mScenario.mRooms.Get(i);
            int n2 = cO_Room.mSuspectId;
            if (n2 != 6) {
                if (n == 0) {
                    if (!this.IsSuspectTalked(n2)) {
                        return true;
                    }
                } else if (n == 1 && this.CanConfrontSuspect(n2)) {
                    this.mSuspectIDResult = n2;
                    return true;
                }
            }
            if (n == 2) {
                if (this.IsAllItemClueFound(cO_Room.mRoomId)) continue;
                return true;
            }
            if (n == 3) {
                n2 = this.GetWeaponAnnotationsRoom(cO_Room.mRoomId, 0);
                int n3 = this.GetSuspectAnnotationsRoom(cO_Room.mRoomId, 0);
                if ((n2 == 9 || n2 == -1) && (n3 == 6 || n3 == -1)) continue;
                return true;
            }
            if (n != 4) continue;
            n2 = this.GetWeaponAnnotationsRoom(cO_Room.mRoomId, 0);
            int n4 = this.GetSuspectAnnotationsRoom(cO_Room.mRoomId, 0);
            if (n2 != 9 && n2 != -1 && n2 != this.GetWeaponAnnotationsRoom(cO_Room.mRoomId, 1)) {
                this.mWeaponIDResult = n2;
                this.mRoomIDResult = cO_Room.mRoomId;
                return true;
            }
            if (n4 == 6 || n4 == -1 || n4 == this.GetSuspectAnnotationsRoom(cO_Room.mRoomId, 1)) continue;
            this.mSuspectIDResult = n4;
            this.mRoomIDResult = cO_Room.mRoomId;
            return true;
        }
        return false;
    }

    private void InitClues() {
        Object object = new Clues(7);
        this.mClueInfo.AddClues((Clues)object);
        object = this.mScenario.mRooms;
        for (int i = 0; i < ((SA_Array_CO_Room)object).Size(); ++i) {
            if (((SA_Array_CO_Room)object).Get((int)i).mSuspectId == 6) continue;
            Clues clues = new Clues(((SA_Array_CO_Room)object).Get((int)i).mSuspectId);
            this.mClueInfo.AddClues(clues);
        }
    }

    private void OnEnterRoom() {
        this.mScenario.GetInspectorRoom().mVisited = true;
    }

    private void OnSearchedItem(int n) {
        this.GetCurrentRoom().GetItem((int)n).mSearched = true;
    }

    private void Abandonning() {
        this.mState = 6;
    }

    private void Accusing() {
        this.mState = 0;
    }

    private void AccusationValidated() {
        this.mState = 6;
    }

    private void Calling() {
        this.mState = 1;
    }

    private void Confronting() {
        this.mState = 2;
    }

    private void Gossiping() {
        this.mState = 5;
    }

    private void FreeRoaming() {
        this.mState = 4;
    }

    private void Searching() {
        this.mState = 9;
    }

    private void Talking() {
        this.mState = 10;
    }

    private void Travelling() {
        this.mState = 11;
    }

    private void IntroductionFinished() {
        this.mState = 4;
    }

    private void CareerProgression() {
        this.mState = 7;
    }

    private void OnNewGame() {
        this.mState = 6;
    }

    private void SetRoomsVisited(boolean bl) {
        SA_Array_CO_Room sA_Array_CO_Room = ((ScenarioContext)((Object)sA_Array_CO_Room)).mScenario.mRooms;
        for (int i = 0; i < sA_Array_CO_Room.Size(); ++i) {
            sA_Array_CO_Room.Get((int)i).mVisited = bl;
        }
    }

    private void TravelTo$255f295(int n) {
        this.SetCurrentRoom(n);
    }

    private void UnlockAllClues() {
        SA_Array_CO_Room sA_Array_CO_Room = this.mScenario.mRooms;
        for (int i = 0; i < sA_Array_CO_Room.Size(); ++i) {
            CO_Room cO_Room = sA_Array_CO_Room.Get(i);
            int n = cO_Room.mSuspectId;
            if (n != 6) {
                this.UnlockSuspectClues(n);
            }
            this.UnlockRoomClues(cO_Room);
        }
    }

    private void UnlockRoomClues(CO_Room object) {
        object = ((CO_Room)object).mItems;
        for (int i = 0; i < ((SA_Array_CO_Item)object).Size(); ++i) {
            if (!((SA_Array_CO_Item)object).Get((int)i).mClueItem) continue;
            ((SA_Array_CO_Item)object).Get(i).GetString();
        }
    }

    private void UnlockSuspectClues(int n) {
        this.mScenario.GetSuspect(n).UnlockIntroClue();
        if (!this.IsTutorial()) {
            this.mScenario.GetSuspect(n).UnlockConfrontClue();
        }
    }

    public final void OnEvent(int n) {
        this.OnEvent(n, 0);
    }

    public final void OnEvent(int n, int n2) {
        this.OnEvent(n, n2, 0);
    }

    public final void OnDelete() {
        if (this.mScenario != null) {
            this.mScenario.OnDelete();
            this.mScenario = null;
        }
        if (this.mClock != null) {
            this.mClock = null;
        }
        if (this.mSuspectVisibility != null) {
            this.mSuspectVisibility.OnDelete();
            this.mSuspectVisibility = null;
        }
        if (this.mWeaponVisibility != null) {
            this.mWeaponVisibility.OnDelete();
            this.mWeaponVisibility = null;
        }
        if (this.mRoomVisibility != null) {
            this.mRoomVisibility.OnDelete();
            this.mRoomVisibility = null;
        }
        if (this.mClueInfo != null) {
            this.mClueInfo.OnDelete();
            this.mClueInfo = null;
        }
        if (this.mMementoState != null) {
            this.mMementoState.OnDelete();
            this.mMementoState = null;
        }
        if (this.mNotifyMediator != null) {
            this.mNotifyMediator.OnDelete();
            this.mNotifyMediator = null;
        }
        if (this.mStatisticsListener != null) {
            this.mStatisticsListener = null;
        }
        this.mListeners = null;
        if (this.mAccusations != null) {
            this.mAccusations = null;
        }
        if (this.mTutorialSteps != null) {
            this.mTutorialSteps = null;
        }
    }

    public final void UnlockTutorialClues() {
        this.UnlockAllClues();
    }

    public final boolean CanConfront() {
        if (this.mScenario.GetSuspect() == null) {
            return false;
        }
        return this.mScenario.GetSuspect().GetSpeechState() == 2;
    }

    private boolean CanConfrontSuspect(int n) {
        return this.mScenario.GetSuspect(n).GetSpeechState() == 2;
    }

    public final boolean CanTalk() {
        if (this.mScenario.GetSuspect() == null) {
            return false;
        }
        return this.mScenario.GetSuspect().GetSpeechState() != 2;
    }

    public final boolean CanTalk(int n) {
        n = this.mScenario.GetRoom((int)n).mSuspectId;
        if (n != 6) {
            return this.mScenario.GetSuspect(n).HasMoreSpeech();
        }
        return false;
    }

    public final CO_Room GetCurrentRoom() {
        return this.mScenario.GetInspectorRoom();
    }

    public final int GetCurrentTime() {
        return this.mClock.GetCurrentTime();
    }

    public final FlString GetNotification() {
        return this.mNotifyMediator.GetNotification();
    }

    public final Mansion GetMansion() {
        return this.mScenario.mMansion;
    }

    public final Suspect GetSuspect(int n) {
        return this.mScenario.GetSuspect(n);
    }

    public final Suspect GetSuspect() {
        return this.mScenario.GetSuspect();
    }

    public final FlString GetStringItemRoom(int n, int n2) {
        SA_Array_CO_Item sA_Array_CO_Item = this.mScenario.GetRoom((int)n).mItems;
        if (sA_Array_CO_Item.Size() > n2) {
            return ClueUtils.GetStringForItem(sA_Array_CO_Item.Get((int)n2).mItemId);
        }
        return StringUtils.CreateStringPtr("");
    }

    public final FlString GetHintsInstruction() {
        FlString flString = ClueUtils.GetGameString(58);
        int n = GameApp.Get().GetScenarioProcess().mMediator.mCurrentId;
        if (n == 0) {
            flString = ClueUtils.GetGameString(159);
        } else if (n == 1) {
            flString = ClueUtils.GetGameString(181);
        } else if (this.GetHintsContext(0)) {
            flString = ClueUtils.GetGameString(53);
        } else if (this.GetHintsContext(1)) {
            FlString flString2;
            flString = flString2 = new FlString(ClueUtils.GetGameString(54));
            ClueUtils.ReplaceAllSuspectIDInString(flString2, this.mSuspectIDResult);
        } else if (this.GetHintsContext(2)) {
            flString = ClueUtils.GetGameString(55);
        } else if (!this.GetHintsContext(3)) {
            flString = ClueUtils.GetGameString(56);
        } else if (this.GetHintsContext(4)) {
            FlString flString3;
            flString = flString3 = new FlString(ClueUtils.GetGameString(57));
            ClueUtils.ReplaceAllRoomIDInString(flString3, this.mRoomIDResult);
            if (this.mWeaponIDResult != -1) {
                ClueUtils.ReplaceAllElementIDInStringIntoWeapon(flString3, this.mWeaponIDResult);
            } else if (this.mSuspectIDResult != -1) {
                ClueUtils.ReplaceAllElementIDInStringIntoSuspect(flString3, this.mSuspectIDResult);
            }
        }
        return flString;
    }

    public final int GetSuspectAnnotationsRoom(int n, int n2) {
        CO_Room cO_Room = this.mScenario.GetRoom(n);
        if (n2 == 1) {
            return cO_Room.mMurderAnnotation.mSuspectId;
        }
        return cO_Room.mInspectorAnnotation.mSuspectId;
    }

    public final int GetWeaponAnnotationsRoom(int n, int n2) {
        CO_Room cO_Room = this.mScenario.GetRoom(n);
        if (n2 == 1) {
            return cO_Room.mMurderAnnotation.mWeaponId;
        }
        return cO_Room.mInspectorAnnotation.mWeaponId;
    }

    public final int GetNotifier() {
        return this.mNotifyMediator.GetNotifierId();
    }

    public final int GetOutcome() {
        boolean bl = this.IsCorrectRoom();
        boolean bl2 = this.IsCorrectSuspect();
        boolean bl3 = this.IsCorrectWeapon();
        int n = 0;
        if (bl && bl2 && bl3) {
            n = this.IsWithinTime() ? 6 : 5;
        } else if (bl && bl2) {
            n = 3;
        } else if (bl && bl3) {
            n = 2;
        } else if (bl2 && bl3) {
            n = 4;
        } else if (bl || bl2 || bl3) {
            n = 1;
        }
        return n;
    }

    public final boolean IsRoomExist(int n) {
        for (int i = 0; i < this.mScenario.mRooms.Size(); ++i) {
            if (this.mScenario.mRooms.Get((int)i).mRoomId != n) continue;
            return true;
        }
        return false;
    }

    public final boolean IsRoomVisited(int n) {
        return this.mScenario.GetRoom((int)n).mVisited;
    }

    public final int GetSuspectInRoom(int n) {
        return this.mScenario.GetRoom((int)n).mSuspectId;
    }

    public final boolean IsSuspectExist(int n) {
        return this.mScenario.GetSuspect(n) != null;
    }

    public final boolean IsWeaponExist(int n) {
        for (int i = 0; i < this.mScenario.mRooms.Size(); ++i) {
            if (this.mScenario.mRooms.Get((int)i).mWeaponId != n) continue;
            return true;
        }
        return false;
    }

    public final void ModifyAnnotationsRoom(int n, int n2, int n3) {
        CO_Annotation cO_Annotation = this.mScenario.GetRoom((int)n).mInspectorAnnotation;
        cO_Annotation.mSuspectId = n2;
        cO_Annotation.mWeaponId = n3;
        this.mScenario.GetRoom((int)n).mInspectorAnnotation = cO_Annotation;
    }

    public final void OnCheat(int n) {
        if (this.mScenario != null) {
            if (n == 14) {
                this.UnlockAllClues();
            } else if (n == 16) {
                this.SetRoomsVisited(true);
            }
            this.mClock.OnCheat(n);
        }
    }

    public final void OnEvent(int n, int n2, int n3) {
        if (n == 17) {
            this.OnNewGame();
            this.OnEvent(24);
        } else if (n == 0) {
            this.Abandonning();
        } else if (n == 3) {
            this.Calling();
        } else if (n == 1) {
            this.Accusing();
        } else if (n == 2) {
            this.AccusationValidated();
        } else if (n == 20) {
            this.CareerProgression();
        } else if (n == 7) {
            this.Confronting();
        } else if (n == 9) {
            this.OnEnterRoom();
        } else if (n == 12) {
            this.FreeRoaming();
        } else if (n == 15) {
            this.Gossiping();
        } else if (n == 22) {
            this.OnSearchedItem(n2);
        } else if (n == 23) {
            this.Searching();
        } else if (n == 29) {
            this.Talking();
        } else if (n == 30) {
            this.Travelling();
        } else if (n == 31) {
            this.TravelTo$255f295(n3);
        } else if (n == 16) {
            this.IntroductionFinished();
        }
        for (int i = 0; i < 2; ++i) {
            this.mListeners[i].OnEvent(n, n2, n3);
        }
    }

    public final void OnQuit() {
        this.OnDelete();
    }

    public final void Initialize(Scenario scenario, TutorialSteps tutorialSteps) {
        this.mScenario = scenario;
        this.mClock = new CO_Clock(this.mScenario.mTime);
        this.mSuspectVisibility = new SuspectVisibility();
        this.mWeaponVisibility = new WeaponVisibility();
        this.mRoomVisibility = new RoomVisibility();
        this.mClueInfo = new ClueInfo();
        this.InitClues();
        this.mMementoState = new ClueMementoState();
        this.mNotifyMediator = new NotificationMediator();
        this.mNotifyMediator.Add(2, this.mClock);
        this.mNotifyMediator.Add(0, this.mMementoState);
        this.mTutorialSteps = tutorialSteps;
        if (this.mTutorialSteps != null) {
            this.mNotifyMediator.Add(1, this.mTutorialSteps);
        } else {
            this.mNotifyMediator.Add(1, GameApp.Get().GetSettings().mGameTipState);
        }
        this.mListeners = new I_Listener[2];
        for (int i = 0; i < this.mListeners.length; ++i) {
            this.mListeners[i] = null;
        }
        this.mListeners[0] = this.mNotifyMediator;
        this.mListeners[1] = this.mStatisticsListener = new StatisticsListener();
        this.mAccusations = new InspectorAccusation();
        this.mCurrentNoteIndex = (byte)-1;
        this.mCurrentSuspicionIndex = (byte)-1;
        this.mCurrentRoomIndex = (byte)-1;
    }

    private void SetCurrentRoom(int n) {
        this.mScenario.SetInspectorRoom(n);
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mScenario.Read(fileSegmentStream);
        this.mState = fileSegmentStream.ReadByte();
        this.mCurrentNoteIndex = fileSegmentStream.ReadByte();
        this.mCurrentSuspicionIndex = fileSegmentStream.ReadByte();
        this.mCurrentRoomIndex = fileSegmentStream.ReadByte();
        this.mClock.Read(fileSegmentStream);
        this.mSuspectVisibility.Read(fileSegmentStream);
        this.mWeaponVisibility.Read(fileSegmentStream);
        this.mRoomVisibility.Read(fileSegmentStream);
        this.mClueInfo.Read(fileSegmentStream);
        this.mMementoState.Read(fileSegmentStream);
        this.mNotifyMediator.Read(fileSegmentStream);
        this.mAccusations.Read(fileSegmentStream);
        if (this.IsTutorial()) {
            this.mTutorialSteps.Read(fileSegmentStream);
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        this.mScenario.Write(fileSegmentStream);
        fileSegmentStream.WriteByte((byte)this.mState);
        fileSegmentStream.WriteByte(this.mCurrentNoteIndex);
        fileSegmentStream.WriteByte(this.mCurrentSuspicionIndex);
        fileSegmentStream.WriteByte(this.mCurrentRoomIndex);
        this.mClock.Write(fileSegmentStream);
        this.mSuspectVisibility.Write(fileSegmentStream);
        this.mWeaponVisibility.Write(fileSegmentStream);
        this.mRoomVisibility.Write(fileSegmentStream);
        this.mClueInfo.Write(fileSegmentStream);
        this.mMementoState.Write(fileSegmentStream);
        this.mNotifyMediator.Write(fileSegmentStream);
        this.mAccusations.Write(fileSegmentStream);
        if (this.IsTutorial()) {
            this.mTutorialSteps.Write(fileSegmentStream);
        }
    }

    public final boolean IsCorrectRoom() {
        return this.IsCorrectRoom(this.mAccusations.GetRoomId());
    }

    public final boolean IsCorrectSuspect() {
        return this.IsCorrectSuspect(this.mAccusations.GetSuspectId());
    }

    public final boolean IsCorrectWeapon() {
        return this.IsCorrectWeapon(this.mAccusations.GetWeaponId());
    }

    public final boolean IsCorrectRoom(int n) {
        return this.mScenario.GetMurderRoom().mRoomId == n;
    }

    public final boolean IsCorrectSuspect(int n) {
        return this.mScenario.GetMurderRoom().mMurderAnnotation.mSuspectId == n;
    }

    public final boolean IsCorrectWeapon(int n) {
        return this.mScenario.GetMurderRoom().mMurderAnnotation.mWeaponId == n;
    }

    public final boolean HasMoreTime() {
        return this.mClock.mClockPhase != 2;
    }

    public final boolean IsWithinTime() {
        return this.mClock.mClockPhase == 0 || this.mClock.mClockPhase == 3;
    }

    public final boolean IsInOverTime() {
        return this.mClock.mClockPhase == 1;
    }

    public final FlString GetStringStory() {
        return ClueUtils.GetScenarioString(this.mScenario.mBackStoryID);
    }

    private boolean IsAllItemClueFound(int n) {
        SA_Array_CO_Item sA_Array_CO_Item = this.mScenario.GetRoom((int)n).mItems;
        for (int i = 0; i < sA_Array_CO_Item.Size(); ++i) {
            CO_Item cO_Item = sA_Array_CO_Item.Get(i);
            if (cO_Item.mSearched || !cO_Item.mClueItem) continue;
            return false;
        }
        return true;
    }

    private boolean IsAllItemClueFound() {
        SA_Array_CO_Room sA_Array_CO_Room = this.mScenario.mRooms;
        for (int i = 0; i < sA_Array_CO_Room.Size(); ++i) {
            if (this.IsAllItemClueFound(sA_Array_CO_Room.Get((int)i).mRoomId)) continue;
            return false;
        }
        return true;
    }

    private boolean IsSuspectTalked(int n) {
        return this.mScenario.GetSuspect(n).GetIntroSpeech() == 2;
    }

    private boolean IsAllSuspectsTalked() {
        for (int i = 0; i < this.mScenario.mRooms.Size(); ++i) {
            int n = this.mScenario.mRooms.Get((int)i).mSuspectId;
            if (n == 6 || this.IsSuspectTalked(n)) continue;
            return false;
        }
        return true;
    }

    private boolean IsSuspectConfronted(int n) {
        return (n = this.mScenario.GetSuspect(n).GetConfrontSpeech()) == 1 || n == 6;
    }

    private boolean IsAllSuspectsConfronted() {
        for (int i = 0; i < this.mScenario.mRooms.Size(); ++i) {
            int n = this.mScenario.mRooms.Get((int)i).mSuspectId;
            if (n == 6 || this.IsSuspectConfronted(n)) continue;
            return false;
        }
        return true;
    }

    public final boolean HasMoreClues() {
        return !this.IsAllItemClueFound() || !this.IsAllSuspectsConfronted() || !this.IsAllSuspectsTalked();
    }

    public final boolean IsTutorial() {
        return this.mTutorialSteps != null;
    }
}

