/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public class Menu
extends BaseScene {
    public boolean mUseTitleAnimation = true;
    public MetaPackage mCommonPackage;
    public TimeSystem mTitleAnimationTimeSystem;
    public FlString mTitleString;
    public Viewport mTitleAnimationViewport;

    public void StartClosingAnims() {
        super.StartClosingAnims();
        if (this.mUseTitleAnimation) {
            Utilities.StartTimeSystemInverse(this.mTitleAnimationTimeSystem, 833);
        }
    }

    public boolean IsClosingAnimsEnded() {
        return (!this.mUseTitleAnimation || this.mTitleAnimationTimeSystem.mTotalTime <= 0) && super.IsClosingAnimsEnded();
    }

    public void Initialize() {
        super.Initialize();
        if (this.mUseTitleAnimation) {
            this.mTitleAnimationViewport.SetViewport(this.mViewport);
        }
        Text.Cast$21bacd23(this.mCommonPackage.mPackage.GetEntryPoint(16)).SetCaption(new FlString(this.mTitleString));
    }

    public void Load() {
        super.Load();
    }

    public Menu(int n, int n2) {
        super(n, n2);
        this.mType = 2;
    }

    public void Unload() {
        super.Unload();
        if (this.mTitleAnimationTimeSystem != null) {
            Utilities.StopTimeSystem(this.mTitleAnimationTimeSystem);
        }
        if (this.mTitleAnimationViewport != null) {
            this.mTitleAnimationViewport.SetViewport(null);
        }
        if (this.mCommonPackage != null) {
            GameLibrary.ReleasePackage(this.mCommonPackage);
        }
        MediaPlayer.StopVibration();
    }

    public boolean IsLoaded() {
        return super.IsLoaded();
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mTitleString = FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(-1));
        this.mCommonPackage = GameLibrary.GetPackage(65538);
        if (this.mUseTitleAnimation) {
            Viewport viewport;
            Package package_ = this.mCommonPackage.mPackage;
            this.mTitleAnimationViewport = viewport = Viewport.Cast$7c352e71(package_.GetEntryPoint(18));
            this.mTitleAnimationTimeSystem = TimeSystem.Cast$3b277f7b(package_.GetEntryPoint(19));
        }
    }

    public void StartOpeningAnims() {
        super.StartOpeningAnims();
        if (this.mUseTitleAnimation) {
            Utilities.StartTimeSystem(this.mTitleAnimationTimeSystem);
        }
    }

    public boolean IsOpeningAnimsEnded() {
        return (!this.mUseTitleAnimation || this.mTitleAnimationTimeSystem.mTotalTime >= 833) && super.IsOpeningAnimsEnded();
    }
}

